# Note this is NOT a relocatable thing :)
%define name		bonobo
%define ver		0.12
%define RELEASE		prw2
%define rel		%{?CUSTOM_RELEASE} %{!?CUSTOM_RELEASE:%RELEASE}
%define prefix		/usr
%define sysconfdir	/etc

Name:		%name
Summary:	Library for compound documents in GNOME
Version: 	%ver
Release: 	%rel
Copyright: 	GPL
Group:		System Environment/Libraries
Source: 	%{name}-%{ver}.tar.gz
URL: 		http://www.gnome.org/
BuildRoot:	/var/tmp/%{name}-%{ver}-root
Docdir: 	%{prefix}/doc

%description
Bonobo is a library that provides the necessary framework for GNOME
applications to deal with compound documents, i.e. those with a
spreadsheet and graphic embedded in a word-processing document.

%package devel
Summary:	Libraries and include files for the Bonobo document model
Group:		Development/Libraries
Requires:	%name = %{PACKAGE_VERSION}
Obsoletes:	%{name}-devel

%description devel
This package provides the necessary development libraries and include
files to allow you to develop programs using the Bonobo document model.

%changelog
* Tue Feb 22 2000 Jens Finke <jens.finke@informatik.uni-oldenburg.de>
- Added bonobo.h to the file list of devel package.

* Wed Nov 10 1999 Alexander Skwar <ASkwar@DigitalProjects.com>
- Updated to version 0.5
- fixed spec file
- Un-quiet things
- stripped binaries
- unsetted language environment variables

* Sat Oct 2 1999 Gregory McLean <gregm@comstar.net>
- Updated the spec for version 0.4
- Updated the files section.

* Sun Aug 1 1999 Gregory McLean <gregm@comstar.net>
- Some updates. sysconfdir stuff, quiet down the prep/configure stage.

* Sat May 1 1999 Erik Walthinsen <omega@cse.ogi.edu>
- created spec file

%prep
%setup

%build
%ifarch alpha
  MYARCH_FLAGS="--host=alpha-redhat-linux"
%endif

LC_ALL=""
LINGUAS=""
LANG=""
export LC_ALL LINGUAS LANG

CFLAGS="$RPM_OPT_FLAGS" ./configure $MYARCH_FLAGS --prefix=%{prefix} \
	--sysconfdir=%{sysconfdir}

if [ "$SMP" != "" ]; then
  (make "MAKE=make -k -j $SMP"; exit 0)
  make
else
  make
fi

%install
[ -n "$RPM_BUILD_ROOT" -a "$RPM_BUILD_ROOT" != / ] && rm -rf $RPM_BUILD_ROOT

make prefix=$RPM_BUILD_ROOT%{prefix} sysconfdir=$RPM_BUILD_ROOT%{sysconfdir} install

for FILE in "$RPM_BUILD_ROOT/bin/*"; do
	file "$FILE" | grep -q not\ stripped && strip $FILE
done

%clean
[ -n "$RPM_BUILD_ROOT" -a "$RPM_BUILD_ROOT" != / ] && rm -rf $RPM_BUILD_ROOT

%post
if ! grep %{prefix}/lib /etc/ld.so.conf > /dev/null ; then
  echo "%{prefix}/lib" >> /etc/ld.so.conf
fi
  
/sbin/ldconfig
  
%postun -p /sbin/ldconfig

%files
%defattr(0555, bin, bin)
%dir %{prefix}/share/gnome/bonobo

%doc AUTHORS COPYING COPYING.LIB ChangeLog NEWS README
%{prefix}/bin/bonobo-application-x-mines
%{prefix}/bin/bonobo-audio-ulaw
%{prefix}/bin/bonobo-image-x-png
%{prefix}/bin/bonobo-text-plain
%{prefix}/bin/efstool
%{prefix}/bin/paint-component-simple
%{prefix}/bin/sample-container
%{prefix}/lib/lib*.so.*

%defattr(0644, bin, bin)
#%{prefix}/share/gnome/apps/Games/*
%{prefix}/share/gnome/bonobo/docs/*

%defattr (0444, bin, bin)
%{prefix}/share/locale/*/LC_MESSAGES/*
%{prefix}/share/mime-info/bonobo.keys
%{sysconfdir}/CORBA/servers/*

%files devel

%defattr(0555, bin, bin)
%dir %{prefix}/include/bonobo
%{prefix}/lib/*.a
%{prefix}/lib/*.so
%{prefix}/lib/*.la

%defattr(0444, bin, bin)
%{prefix}/lib/*Conf.sh
%{prefix}/include/bonobo/*
%{prefix}/share/idl/*.idl

%defattr(0644, bin, bin)
%{prefix}/include/efs.h
%{prefix}/include/bonobo.h
