/*
 * preferences.h - header for properties dialog for Bombermaze
 * written by Sydney Tang <sydney.tang@computer.org>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * For more details see the file COPYING.
 */

#ifndef _BOMBER_PREFS_H_
#define _BOMBER_PREFS_H_

#include "map.hh"

bool preferences_initialize(void);
void preferences_uninitialize(void);

char *preferences_get_data_file(char *file);

const char *preferences_get_current_mapfile(void);
const char *preferences_get_continue_key_name(void);
bool preferences_is_continue_button_enabled(void);
bool preferences_is_inter_round_status_enabled(void);
bool preferences_case_sensitive(void);

void preferences_show_dialog(void);


struct NumberValue
{
  const int maximum;
  const int minimum;
  const int increment;
  int value;
};

struct Preferences
{
  NumberValue TimeoutInterval;
  NumberValue StepsToMiddleOfSquare;
  NumberValue InitialPlayerMoveDelay;

  NumberValue InitialMaxBombsPerPlayer;
  NumberValue InitialPlayerBombBlastRadius;
  NumberValue ProbabilityOfPowerup;
  NumberValue BombExplodeDelay;
  NumberValue BombChainReactionDelay;
  NumberValue FlameDuration;
  NumberValue BrickShatterFrameDuration;
  NumberValue PowerUpShatterFrameDuration;

  NumberValue PowerUpProbability [PowerUp::NUMBER_OF_CREATABLE_POWERUPS];

  NumberValue WinsPerMatch;

  NumberValue MatchStatusDelay;

  gchar *MapFile;
  gchar *Theme;

  bool ShowWallPerimeter;
  bool ShowWallPerimeterTopOnly;

  bool EnableContinueButton;
  bool EnableInterRoundMatchStatus;

  bool CaseSensitive;
  bool EnableAutoFire [Player::MAX_NUMBER_OF_LOCAL_PLAYERS];
};

#endif














