/*
 * input.h - header for input.cc for Bombermaze
 * written by Sydney Tang <sydney.tang@computer.org>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * For more details see the file COPYING.
 */


#ifndef _BOMBER_INPUT_H_
#define _BOMBER_INPUT_H_

#include <glib.h>
#include <gtk/gtk.h>
#include <gdk/gdk.h>

#include "map.hh"


typedef guint KeyValue;


struct PlayerActionKeyBinding
{
  int PlayerIndex;
  guint keyval;
  Player::PlayerAction ActionType;
};

class KeyMap
{
 public:

  GHashTable *LookupTable;
  PlayerActionKeyBinding PlayerAction
   [ Player::MAX_NUMBER_OF_LOCAL_PLAYERS ][ Player::NUMBER_OF_PLAYER_ACTIONS ];
  guint StartNPlayerGame[Player::MAX_NUMBER_OF_PLAYERS];
  guint Pause;
  guint Quit;
  guint Continue;

  KeyMap();
  ~KeyMap();

  KeyMap operator=(KeyMap op2);

  void rehash(void);
};

int input_set_keymap(KeyMap *key_map);

void input_set_autofire(int PlayerIndex, bool setting);

void handle_keypress( GtkWidget   *widget,
                      GdkEventKey *event,
                      gpointer     data );

void handle_keyrelease( GtkWidget   *widget,
                        GdkEventKey *event,
                        gpointer     data );

#endif























