using System;
using System.IO;
using System.Collections;
using System.ServiceModel.Syndication;
using System.Xml;
using System.Xml.Serialization;

namespace Imendio.Blam
{
    public class ItemStore
    {
        private Hashtable items;
        static ItemStore instance = null;
        static string itemfile = Defines.APP_HOMEDIR + "/" + Defines.APP_ITEMSTORE_FILE;
        static string itemfile_tmp = Defines.APP_HOMEDIR + "/" + Defines.APP_ITEMSTORE_FILE + ".tmp";
        private object db_lock = new object();

        public Item Get(string id)
        {
            Item item;

            if(id == null){
                Console.Error.WriteLine("Tried to access item with null key");
                return null;
            }

            lock(db_lock){
                item = items[id] as Item;
            }

            return item;
        }

        public void Add(Item item)
        {
            if(item.Id == null){
                Console.Error.WriteLine("Tried to add item with null key");
                return;
            }

            lock(db_lock){
                if(items.ContainsKey(item.Id)){
                    (items[item.Id] as Item).Grab();
                    return;
                } else {
                    item.Grab();
                    items.Add(item.Id, item);
                }
            }
        }

        public void Remove(Item item)
        {
            if(item == null){
                return;
            }

            lock(db_lock){
                item.Release();
                if(item.RefCount == 0){
                    items.Remove(item.Id);
                }
            }
        }

        public void Remove(string id)
        {
            lock(db_lock){
                Remove(items[id] as Item);
            }
        }

        public static ItemStore GetInstance()
        {
            if(instance == null){
                Load();
            }

            return instance;
        }

        private static void Load()
        {
            instance = new ItemStore();

            XmlReader reader;
            try{
                reader = new XmlTextReader(itemfile);
            } catch(Exception e){
                Console.WriteLine("Can't open item db: {0}", e.Message);
                return;
            }

            Console.WriteLine("about to format");
            SyndicationFeed feed = SyndicationFeed.Load(reader);
            foreach(SyndicationItem item in feed.Items){
                instance.items.Add(item.Id, new Item(item));
            }
        }

        public static void Save()
        {
            if(instance == null){
                return;
            }

            Item[] items;

            lock(instance.db_lock){
                foreach(Item item in instance.items.Values){
                    item.WriteExtensions();
                }
                items = new Item[instance.items.Count];
                instance.items.Values.CopyTo(items, 0);
            }
            XmlWriter writer = XmlWriter.Create(itemfile_tmp);
            SyndicationFeed sf = new SyndicationFeed(items);
            Atom10FeedFormatter fmtr = sf.GetAtom10Formatter();
            fmtr.WriteTo(writer);
            writer.Close();
            File.Delete(itemfile);
            File.Move(itemfile_tmp, itemfile);
        }

       private ItemStore ()
       {
            items = new Hashtable();
       }
    }
}
