//
// Author: 
//   Mikael Hallendal <micke@imendio.com>
//
// (C) 2004 Imendio HB
// 

using System;
using System.IO;
using System.Net;
using System.Xml;
using System.Xml.XPath;
using System.ServiceModel.Syndication;

//using System.Web;

namespace Imendio.Blam {
    class CertCheck : ICertificatePolicy
    {
        public CertCheck()
        {
        }

        public bool CheckValidationResult(ServicePoint sp,
            System.Security.Cryptography.X509Certificates.X509Certificate cert,
            WebRequest request, int problem)
        {
            bool ignore = Conf.Get(Preference.IGNORE_SSL_ERR, false);
            if(ignore){
                Console.Error.WriteLine("I was asked! allowed!");         
                return true;
            } else {
                Console.Error.WriteLine("not allowing");
                return false;
            }
        }
    }
    public class FeedUpdater {

        public static bool Update(Channel channel)
        {

            bool updated = false;

            channel.LastRefreshed = DateTime.Now;
            XmlTextReader reader = null;
            SyndicationFeed feed = null;
            try{
                reader = new XmlTextReader(channel.Url);
                feed = SyndicationFeed.Load(reader);
            } catch(XmlException e){
                Console.Error.WriteLine("Need to filter {0}", channel.Url);
                reader = Filter.FromUrl(channel.Url);
                try{
                    feed = SyndicationFeed.Load(reader);
                } catch(Exception ex){
                    System.Console.WriteLine("Filter didn't help: {0}", e.Message);
                    return false;
                }
            } catch(Exception e){
                System.Console.WriteLine("Ex caught: {0}", e.Message);
                return false;
            }

            return channel.Update(feed);
        }

    private static void set_credentials_from_uri(WebRequest req)
    {
        if (req.RequestUri.UserInfo != "") {
            int i = 0;
            string userInfo = req.RequestUri.UserInfo;
            string userName = "";

            while (i < userInfo.Length && userInfo[i] != ':')
                userName += Uri.HexUnescape(userInfo, ref i);

            if (i != userInfo.Length) {
                string password = "";

                i += 1;

                while (i < userInfo.Length && userInfo[i] != ':')
                    password += Uri.HexUnescape(userInfo, ref i);

                req.Credentials = new NetworkCredential(userName,
                                                        password);
            }
        }
    }
    }
}
