//
// Author:
//   Mikael Hallendal <micke@imendio.com>
//
// (C) 2004 Imendio AB
// (C) 2008 Nuanti Ltd.
//

using GConf;
using Gtk;
using System;
using GtkSharp;
using WebKit;
using Mono.Unix;
using System.Collections;
using System.Collections.Generic;
using System.Reflection;
using System.IO;
using System.Net;
using System.Text;
using System.ServiceModel.Syndication;

namespace Imendio.Blam {
    public class ItemView : Gtk.EventBox {
        private WebView webView;
#if ENABLE_FONTS
        private WebSettings webSettings;
#endif
	private Imendio.Blam.Item currentItem;
    private string baseDir = null;
	private string last_link = null;
	public bool PageLoaded;

        public event StringUpdatedHandler OnUrl;

	public Imendio.Blam.Item CurrentItem {
	    get {
		return currentItem;
	    }
	     
	    set {
		currentItem = value;
		Load ();
	    }
	}

        public WebView Widget {
            get {
                return webView;
            }
        }

	public ItemView () : base()
        {
            this.webView = new WebView ();
#if ENABLE_FONTS
            this.webSettings = new WebSettings ();
            webView.Settings = webSettings;
#endif
						ScrolledWindow sw = new ScrolledWindow ();
						sw.Add(webView);
            Add(sw);
	   
            Conf.AddNotify (Preference.FONT_PATH,
                                        new NotifyEventHandler (FontNotifyHandler));
            SetFonts ();

            ProxyUpdatedCb ();
            Proxy.Updated += ProxyUpdatedCb;

		webView.NavigationRequested += delegate (object sender, NavigationRequestedArgs args) {
        try {
			/*
			 * If last_link is the same as args.Request.Uri, the user clicked on a link
			 * (as we know he was hovering). Thus, try to open it on the browser
			 */
			if(args.Request.Uri.Equals(last_link)){
				GtkBeans.Global.ShowUri(null, args.Request.Uri);
				args.RetVal = NavigationResponse.Ignore;
			} else {
				/* Otherwise, it's part of the post, so accept it (like the facebook iframe) */
				args.RetVal = NavigationResponse.Accept;
			}
        }
        catch (Exception e) {
            Console.Error.WriteLine("Couldn't show URL: " + args.Request.Uri + e.Message);
        }
		};

            webView.HoveringOverLink += delegate (object sender, HoveringOverLinkArgs args) {
                if (OnUrl != null)
                  OnUrl (args.Link);
				  last_link = args.Link;
            };

            webView.Show ();
            PageLoaded = false;
        }
        
        private void Load()
        {
			Theme theme = Application.TheApp.ThemeManager.CurrentTheme;
            string author;
            if(currentItem.Authors.Count == 0){
                author = string.Empty;
            } else if(currentItem.Authors[0].Name != null){
                author = String.Format(Catalog.GetString("by {0}"), currentItem.Authors[0].Name);
            } else {
                author  = "&nbsp;";
            }
            string link    = Catalog.GetString("Show in browser");
            string pubdate = (!currentItem.LastUpdatedTime.Equals(DateTimeOffset.MinValue)) ?
			                    currentItem.LastUpdatedTime.ToString("D", System.Globalization.CultureInfo.CurrentUICulture) :
				(!currentItem.PublishDate.Equals(DateTimeOffset.MinValue)) ?
                  currentItem.PublishDate.ToString("D", System.Globalization.CultureInfo.CurrentUICulture) :
				  Catalog.GetString("[No date available]");
            string text = currentItem.Summary != null ? currentItem.Summary.Text
                : currentItem.Content != null ? (currentItem.Content as TextSyndicationContent).Text : null;
			string title = currentItem.Title.Text;
            string url = currentItem.Links.Count == 0 ? currentItem.Id :
                currentItem.Links[0].Uri.ToString();

            baseDir        = "file://" + theme.Path;

            var replaces = new Dictionary<string, string> {
                {"author", author},
                {"link", link},
                {"pubdate", pubdate},
                {"text", text},
                {"title", title},
                {"url", url},
                {"localbase", baseDir},
            };

			webView.LoadString(theme.Render(replaces), null, null, baseDir);
	}

        private void SetFonts ()
        {
            string varFont = Conf.Get (Preference.VARIABLE_FONT, "Sans 12");
            string fixedFont = Conf.Get (Preference.FIXED_FONT, "Mono 12");

            // Disabled for now since it's not clear that overriding the
            // default font settings makes sense.
#if ENABLE_FONTS
            Pango.FontDescription varDesc = Pango.FontDescription.FromString (varFont);
						webSettings.DefaultFontFamily = varDesc.Family;
						//webSettings.DefaultFontSize = varDesc.Size / 1024;

            Pango.FontDescription fixedDesc = Pango.FontDescription.FromString (fixedFont);
						webSettings.MonospaceFontFamily = fixedDesc.Family;
						//webSettings.MonospaceFontSize = fixedDesc.Size / 1024;
#endif
        }

        private void FontNotifyHandler (object sender, NotifyEventArgs args)
        {
            if (args.Key == Conf.GetFullKey (Preference.VARIABLE_FONT) ||
                args.Key == Conf.GetFullKey (Preference.FIXED_FONT)) {
                SetFonts ();
            }
        }

        private void ProxyUpdatedCb ()
        {
            //Utils.GeckoSetProxy (Proxy.UseProxy, Proxy.ProxyHost,
            //                     Proxy.ProxyPort);
        }
    }

#if ENABLE_FONTS
    class WebSettings : WebKit.WebSettings {
        public WebSettings() {}
        
        public string DefaultFontFamily {
            get { return (string)GetProperty("default-font-family").Val; }
            set { SetProperty("default-font-family", new GLib.Value(value)); }
        }

        public int DefaultFontSize {
            get { return (int)GetProperty("default-font-size").Val; }
            set { SetProperty("default-font-size", new GLib.Value(value)); }
        }

        public string MonospaceFontFamily {
            get { return (string)GetProperty("monospace-font-family").Val; }
            set { SetProperty("monospace-font-family", new GLib.Value(value)); }
        }
    }
#endif
}
