//
// Author: 
//   Mikael Hallendal <micke@imendio.com>
//
// (C) 2004 Imendio HB
// 

using System;
using System.IO;
using System.Net;
using System.Xml;
using System.Xml.XPath;
using System.ServiceModel.Syndication;

//using System.Web;

namespace Imendio.Blam {
    class CertCheck : ICertificatePolicy
    {
        public CertCheck()
        {
        }

        public bool CheckValidationResult(ServicePoint sp,
            System.Security.Cryptography.X509Certificates.X509Certificate cert,
            WebRequest request, int problem)
        {
            bool ignore = Conf.Get(Preference.IGNORE_SSL_ERR, false);
            if(ignore){
                Console.Error.WriteLine("I was asked! allowed!");         
                return true;
            } else {
                Console.Error.WriteLine("not allowing");
                return false;
            }
        }
    }
    public class FeedUpdater {

        public static bool Update(Channel channel)
        {

            bool updated = false;

            channel.LastRefreshed = DateTime.Now;
            XmlTextReader reader = null;
            SyndicationFeed feed = null;
            try{
                reader = new XmlTextReader(channel.Url);
                feed = SyndicationFeed.Load(reader);
            } catch(XmlException e){
                Console.Error.WriteLine("Need to filter {0}", channel.Url);
                reader = Filter.FromUrl(channel.Url);
                try{
                    feed = SyndicationFeed.Load(reader);
                } catch(Exception ex){
                    System.Console.WriteLine("Filter didn't help: {0}", ex.Message);
                    return false;
                }
            } catch(Exception e){
                System.Console.WriteLine("Ex caught: {0}", e.Message);
                return false;
            }

            return channel.Update(feed);
        }
    }
}
