//
// Author: 
//   Mikael Hallendal <micke@imendio.com>
//
// (C) 2004 Imendio HB
// 

using Rss;
using System;
using System.IO;
using System.Net;
//using System.Web;

namespace Imendio.Blam {
    public class FeedUpdater {
	public static bool Update (Channel channel)
	{
	    //Console.Write("Updating: " + channel.Url + " ...");
	    bool updated = false;

	    try {
		string lastModified;
		string eTag;

		WebRequest req = WebRequest.Create(channel.Url);
		req.Headers.Add("If-Modified-Since", channel.LastModified);
		req.Headers.Add("If-None-Match", channel.ETag);
	
		req.Timeout = 20000;
		WebResponse res = null;
		
		WebProxy proxy = Proxy.GetProxy ();
                if (proxy != null) {
		    req.Proxy = proxy;
		}

		try {
                    res = req.GetResponse();
		}
		catch (WebException wE) {
		    switch (wE.Status) {
		    case WebExceptionStatus.ProtocolError:
			if (((HttpWebResponse)wE.Response).StatusCode == HttpStatusCode.NotModified) {
                            //Console.WriteLine("No changes to feed");
			}
			break;
		    case WebExceptionStatus.Timeout:
                        //Console.WriteLine("Timed out");
                        //Console.WriteLine("Exception: " + wE.ToString());
			break;
		    default:
			//Console.WriteLine("Exception: " + wE.ToString());
			break;
		    }
		    return false;
		}
		
		RssReader reader = new RssReader (res.GetResponseStream ());
		RssChannel rssChannel = null;
		RssElement e;

		// FIXME: Handle multiple channels per feed? 
		do {
		    e = reader.Read();
		    if (e is RssChannel) {
			rssChannel = (RssChannel)e;
		    }
		} while (e != null);

		reader.Close ();
		
		if (rssChannel != null) {
		    /* Check if this channel is updated */
                    channel.StartRefresh ();

		    /*if (channel.Image.Equals ("") &&
			rssChannel.Image != null) {
			channel.Image = rssChannel.Image.Url.ToString ();
		    }*/

		    if (channel.Name.Equals ("") &&
			rssChannel.Title != null) {
			channel.Name = rssChannel.Title;
			updated = true;
		    }

		    foreach (RssItem item in rssChannel.Items) {
			string id;
			bool   itemUpdated;
		    
			id = GenerateItemId(item);
			if (item.Title == null || item.Title.Equals("")) {
			    if (!item.PubDate.Equals (DateTime.MinValue)) {
				item.Title = item.PubDate.ToString("d MMM yyyy");
			    } else {
				item.Title = channel.Name;
			    }
			}

			// FIXME: Don't use RssItem here when we want Atom.NET 
			// support.

			// Will add, update or do nothing.
                        itemUpdated = channel.UpdateItem (id, item);
			if (itemUpdated) {
                            updated = true;
			}
		    }
		    channel.FinishRefresh ();
		}
		
		if (res.Headers.Get("Last-Modified") != null) {
		    channel.LastModified = res.Headers.Get("Last-Modified"); 
		}
		if (res.Headers.Get("ETag") != null) {
		    channel.ETag = res.Headers.Get("ETag");
		}

		res.Close ();
	    } catch (Exception e) {
	    }

	    return updated;
	}

	public static string GenerateItemId (RssItem item)
	{
	    if (item.Guid != null) {
		return item.Guid.Name;
	    } 
	    else if (item.Link != null) {
		return item.Link.ToString ();
	    } else {
		return item.Title;
	    }
	}
    }
}
