//
// Snippet.cs
//
// Copyright (C) 2005 Novell, Inc.
//

//
// Permission is hereby granted, free of charge, to any person obtaining a
// copy of this software and associated documentation files (the "Software"),
// to deal in the Software without restriction, including without limitation
// the rights to use, copy, modify, merge, publish, distribute, sublicense,
// and/or sell copies of the Software, and to permit persons to whom the
// Software is furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
// AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
// FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
// DEALINGS IN THE SOFTWARE.
//

using System;
using System.Collections;
using System.Xml.Serialization;

using Beagle.Util;

namespace Beagle {

	public class SnippetRequest : RequestMessage {

		public Hit Hit;
		public string[] QueryTerms;

		public SnippetRequest () : base (false) { }

		public SnippetRequest (string[] query_terms, Hit hit) : base (false)
		{
			this.QueryTerms = query_terms;
			this.Hit = hit;
		}

		public SnippetRequest (ICollection query_terms, Hit hit) : base (false)
		{
			this.QueryTerms = new string [query_terms.Count];

			int i = 0;
			foreach (string term in query_terms) {
				this.QueryTerms [i] = term;
				++i;
			}

			this.Hit = hit;
		}
	}

	public class SnippetResponse : ResponseMessage {
		public string Snippet;

		public SnippetResponse () { }

		public SnippetResponse (string snippet)
		{
			this.Snippet = snippet;
		}
	}
}
