/* baobab-application.c generated by valac 0.17.4.2-5a035, the Vala compiler
 * generated from baobab-application.vala, do not modify */

/* -*- tab-width: 4; indent-tabs-mode: nil; c-basic-offset: 4 -*- */
/* Baobab - disk usage analyzer
 *
 * Copyright (C) 2012  Ryan Lortie <desrt@desrt.ca>
 * Copyright (C) 2012  Paolo Borelli <pborelli@gnome.org>
 * Copyright (C) 2012  Stefano Facchini <stefano.facchini@gmail.com>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <gtk/gtk.h>
#include <gio/gio.h>
#include <gdk/gdk.h>
#include <glib/gi18n-lib.h>
#include "config.h"


#define BAOBAB_TYPE_APPLICATION (baobab_application_get_type ())
#define BAOBAB_APPLICATION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), BAOBAB_TYPE_APPLICATION, BaobabApplication))
#define BAOBAB_APPLICATION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), BAOBAB_TYPE_APPLICATION, BaobabApplicationClass))
#define BAOBAB_IS_APPLICATION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), BAOBAB_TYPE_APPLICATION))
#define BAOBAB_IS_APPLICATION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), BAOBAB_TYPE_APPLICATION))
#define BAOBAB_APPLICATION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), BAOBAB_TYPE_APPLICATION, BaobabApplicationClass))

typedef struct _BaobabApplication BaobabApplication;
typedef struct _BaobabApplicationClass BaobabApplicationClass;
typedef struct _BaobabApplicationPrivate BaobabApplicationPrivate;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define BAOBAB_TYPE_WINDOW (baobab_window_get_type ())
#define BAOBAB_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), BAOBAB_TYPE_WINDOW, BaobabWindow))
#define BAOBAB_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), BAOBAB_TYPE_WINDOW, BaobabWindowClass))
#define BAOBAB_IS_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), BAOBAB_TYPE_WINDOW))
#define BAOBAB_IS_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), BAOBAB_TYPE_WINDOW))
#define BAOBAB_WINDOW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), BAOBAB_TYPE_WINDOW, BaobabWindowClass))

typedef struct _BaobabWindow BaobabWindow;
typedef struct _BaobabWindowClass BaobabWindowClass;
#define _g_variant_unref0(var) ((var == NULL) ? NULL : (var = (g_variant_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_variant_iter_free0(var) ((var == NULL) ? NULL : (var = (g_variant_iter_free (var), NULL)))
#define _g_hash_table_unref0(var) ((var == NULL) ? NULL : (var = (g_hash_table_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_option_context_free0(var) ((var == NULL) ? NULL : (var = (g_option_context_free (var), NULL)))

struct _BaobabApplication {
	GtkApplication parent_instance;
	BaobabApplicationPrivate * priv;
};

struct _BaobabApplicationClass {
	GtkApplicationClass parent_class;
};

struct _BaobabApplicationPrivate {
	GSettings* desktop_settings;
	GSettings* prefs_settings;
	GSettings* ui_settings;
};


static gpointer baobab_application_parent_class = NULL;
static BaobabApplication* baobab_application_baobab;
static BaobabApplication* baobab_application_baobab = NULL;
static gboolean baobab_application_print_version;
static gboolean baobab_application_print_version = FALSE;

#define BAOBAB_CSS_DATA ".cell.baobab-level-cell.fill-block,\n" \
".cell.baobab-level-cell.fill-block:selected,\n" \
".cell.baobab-level-cell.fill-block:selected:hover {\n" \
"    background-color: #edd400;\n" \
"}\n" \
"\n" \
".cell.baobab-level-cell.fill-block.level-low,\n" \
".cell.baobab-level-cell.fill-block.level-low:hover {\n" \
"    background-color: #73d216;\n" \
"}\n" \
"\n" \
".cell.baobab-level-cell.fill-block.level-high,\n" \
".cell.baobab-level-cell.fill-block.level-high:hover {\n" \
"    background-color: #cc0000;\n" \
"}\n" \
"\n" \
".cell.baobab-level-cell.fill-block:backdrop,\n" \
".cell.baobab-level-cell.fill-block:hover:backdrop,\n" \
".cell.baobab-level-cell.fill-block.level-low:backdrop,\n" \
".cell.baobab-level-cell.fill-block.level-high:backdrop {\n" \
"    background-color: @theme_unfocused_text_color;\n" \
"}"
GType baobab_application_get_type (void) G_GNUC_CONST;
#define BAOBAB_APPLICATION_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), BAOBAB_TYPE_APPLICATION, BaobabApplicationPrivate))
enum  {
	BAOBAB_APPLICATION_DUMMY_PROPERTY
};
static void baobab_application_on_quit_activate (BaobabApplication* self);
static void _baobab_application_on_quit_activate_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self);
static void baobab_application_real_activate (GApplication* base);
BaobabWindow* baobab_window_new (BaobabApplication* app);
BaobabWindow* baobab_window_construct (GType object_type, BaobabApplication* app);
GType baobab_window_get_type (void) G_GNUC_CONST;
static void baobab_application_real_open (GApplication* base, GFile** files, int files_length1, const gchar* hint);
void baobab_window_scan_directory (BaobabWindow* self, GFile* directory);
GHashTable* baobab_application_get_excluded_locations (void);
static guint _g_file_hash_ghash_func (gconstpointer key);
static gboolean _g_file_equal_gequal_func (gconstpointer a, gconstpointer b);
static void _g_object_unref0_ (gpointer var);
static gchar* _variant_get1 (GVariant* value);
static void baobab_application_real_startup (GApplication* base);
static gboolean baobab_application_real_local_command_line (GApplication* base, gchar*** arguments, gint* exit_status);
BaobabApplication* baobab_application_new (void);
BaobabApplication* baobab_application_construct (GType object_type);
GSettings* baobab_application_get_desktop_settings (void);
GSettings* baobab_application_get_prefs_settings (void);
GSettings* baobab_application_get_ui_settings (void);
static void baobab_application_finalize (GObject* obj);
static gint _vala_array_length (gpointer array);

static const GOptionEntry BAOBAB_APPLICATION_option_entries[2] = {{"version", 'v', 0, G_OPTION_ARG_NONE, &baobab_application_print_version, "Print version information and exit", NULL}, {NULL}};
static const GActionEntry BAOBAB_APPLICATION_action_entries[1] = {{"quit", _baobab_application_on_quit_activate_gsimple_action_activate_callback}};

static void _baobab_application_on_quit_activate_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self) {
	baobab_application_on_quit_activate (self);
}


static void baobab_application_real_activate (GApplication* base) {
	BaobabApplication * self;
	BaobabWindow* _tmp0_;
	BaobabWindow* _tmp1_;
	self = (BaobabApplication*) base;
	_tmp0_ = baobab_window_new (self);
	g_object_ref_sink (_tmp0_);
	_tmp1_ = _tmp0_;
	_g_object_unref0 (_tmp1_);
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static void baobab_application_real_open (GApplication* base, GFile** files, int files_length1, const gchar* hint) {
	BaobabApplication * self;
	GFile** _tmp0_;
	gint _tmp0__length1;
	self = (BaobabApplication*) base;
	g_return_if_fail (hint != NULL);
	_tmp0_ = files;
	_tmp0__length1 = files_length1;
	{
		GFile** file_collection = NULL;
		gint file_collection_length1 = 0;
		gint _file_collection_size_ = 0;
		gint file_it = 0;
		file_collection = _tmp0_;
		file_collection_length1 = _tmp0__length1;
		for (file_it = 0; file_it < _tmp0__length1; file_it = file_it + 1) {
			GFile* _tmp1_;
			GFile* file = NULL;
			_tmp1_ = _g_object_ref0 (file_collection[file_it]);
			file = _tmp1_;
			{
				BaobabWindow* _tmp2_;
				BaobabWindow* window;
				BaobabWindow* _tmp3_;
				GFile* _tmp4_;
				_tmp2_ = baobab_window_new (self);
				g_object_ref_sink (_tmp2_);
				window = _tmp2_;
				_tmp3_ = window;
				_tmp4_ = file;
				baobab_window_scan_directory (_tmp3_, _tmp4_);
				_g_object_unref0 (window);
				_g_object_unref0 (file);
			}
		}
	}
}


static guint _g_file_hash_ghash_func (gconstpointer key) {
	guint result;
	result = g_file_hash (key);
	return result;
}


static gboolean _g_file_equal_gequal_func (gconstpointer a, gconstpointer b) {
	gboolean result;
	result = g_file_equal (a, b);
	return result;
}


static void _g_object_unref0_ (gpointer var) {
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}


static gchar* _variant_get1 (GVariant* value) {
	return g_variant_dup_string (value, NULL);
}


GHashTable* baobab_application_get_excluded_locations (void) {
	GHashTable* result = NULL;
	BaobabApplication* _tmp0_;
	BaobabApplication* _tmp1_;
	BaobabApplication* app;
	GHashTable* _tmp2_;
	GHashTable* excluded_locations;
	GHashTable* _tmp3_;
	GFile* _tmp4_ = NULL;
	GHashTable* _tmp5_;
	GFile* _tmp6_ = NULL;
	GHashTable* _tmp7_;
	GFile* _tmp8_ = NULL;
	const gchar* _tmp9_ = NULL;
	GFile* _tmp10_ = NULL;
	GFile* home;
	GHashTable* _tmp11_;
	GFile* _tmp12_;
	GFile* _tmp13_ = NULL;
	GFile* _tmp14_ = NULL;
	GFile* root;
	_tmp0_ = baobab_application_baobab;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	app = _tmp1_;
	_tmp2_ = g_hash_table_new_full (_g_file_hash_ghash_func, _g_file_equal_gequal_func, _g_object_unref0_, NULL);
	excluded_locations = _tmp2_;
	_tmp3_ = excluded_locations;
	_tmp4_ = g_file_new_for_path ("/proc");
	g_hash_table_add (_tmp3_, _tmp4_);
	_tmp5_ = excluded_locations;
	_tmp6_ = g_file_new_for_path ("/sys");
	g_hash_table_add (_tmp5_, _tmp6_);
	_tmp7_ = excluded_locations;
	_tmp8_ = g_file_new_for_path ("/selinux");
	g_hash_table_add (_tmp7_, _tmp8_);
	_tmp9_ = g_get_home_dir ();
	_tmp10_ = g_file_new_for_path (_tmp9_);
	home = _tmp10_;
	_tmp11_ = excluded_locations;
	_tmp12_ = home;
	_tmp13_ = g_file_get_child (_tmp12_, ".gvfs");
	g_hash_table_add (_tmp11_, _tmp13_);
	_tmp14_ = g_file_new_for_path ("/");
	root = _tmp14_;
	{
		BaobabApplication* _tmp15_;
		GSettings* _tmp16_;
		GVariant* _tmp17_ = NULL;
		GVariant* _tmp18_;
		GVariantIter* _tmp19_ = NULL;
		GVariantIter* _tmp20_;
		GVariantIter* _uri_it;
		GVariant* uri = NULL;
		_tmp15_ = app;
		_tmp16_ = _tmp15_->priv->prefs_settings;
		_tmp17_ = g_settings_get_value (_tmp16_, "excluded-uris");
		_tmp18_ = _tmp17_;
		_tmp19_ = g_variant_iter_new (_tmp18_);
		_tmp20_ = _tmp19_;
		_g_variant_unref0 (_tmp18_);
		_uri_it = _tmp20_;
		while (TRUE) {
			GVariantIter* _tmp21_;
			GVariant* _tmp22_ = NULL;
			GVariant* _tmp23_;
			GVariant* _tmp24_;
			gchar* _tmp25_;
			gchar* _tmp26_;
			GFile* _tmp27_ = NULL;
			GFile* _tmp28_;
			GFile* file;
			GFile* _tmp29_;
			GFile* _tmp30_;
			gboolean _tmp31_ = FALSE;
			_tmp21_ = _uri_it;
			_tmp22_ = g_variant_iter_next_value (_tmp21_);
			_g_variant_unref0 (uri);
			uri = _tmp22_;
			_tmp23_ = uri;
			if (!(_tmp23_ != NULL)) {
				break;
			}
			_tmp24_ = uri;
			_tmp25_ = _variant_get1 (_tmp24_);
			_tmp26_ = _tmp25_;
			_tmp27_ = g_file_new_for_uri (_tmp26_);
			_tmp28_ = _tmp27_;
			_g_free0 (_tmp26_);
			file = _tmp28_;
			_tmp29_ = file;
			_tmp30_ = root;
			_tmp31_ = g_file_equal (_tmp29_, _tmp30_);
			if (!_tmp31_) {
				GHashTable* _tmp32_;
				GFile* _tmp33_;
				GFile* _tmp34_;
				_tmp32_ = excluded_locations;
				_tmp33_ = file;
				_tmp34_ = _g_object_ref0 (_tmp33_);
				g_hash_table_add (_tmp32_, _tmp34_);
			}
			_g_object_unref0 (file);
		}
		_g_variant_unref0 (uri);
		_g_variant_iter_free0 (_uri_it);
	}
	result = excluded_locations;
	_g_object_unref0 (root);
	_g_object_unref0 (home);
	_g_object_unref0 (app);
	return result;
}


static void baobab_application_real_startup (GApplication* base) {
	BaobabApplication * self;
	BaobabApplication* _tmp0_;
	GtkCssProvider* _tmp1_;
	GtkCssProvider* css_provider;
	GdkScreen* _tmp2_ = NULL;
	GSettings* _tmp3_;
	GSettings* _tmp4_;
	GSettings* _tmp5_;
	GtkSettings* _tmp6_ = NULL;
	GtkSettings* _tmp7_;
	GtkSettings* gtk_settings;
	GtkBuilder* _tmp8_;
	GtkBuilder* builder;
	GtkSettings* _tmp11_;
	gboolean _tmp12_ = FALSE;
	gboolean _tmp13_;
	GError * _inner_error_ = NULL;
	self = (BaobabApplication*) base;
	G_APPLICATION_CLASS (baobab_application_parent_class)->startup ((GApplication*) G_TYPE_CHECK_INSTANCE_CAST (self, GTK_TYPE_APPLICATION, GtkApplication));
	_tmp0_ = _g_object_ref0 (self);
	_g_object_unref0 (baobab_application_baobab);
	baobab_application_baobab = _tmp0_;
	_tmp1_ = gtk_css_provider_new ();
	css_provider = _tmp1_;
	gtk_css_provider_load_from_data (css_provider, BAOBAB_CSS_DATA, (gssize) (-1), &_inner_error_);
	if (_inner_error_ != NULL) {
		_g_object_unref0 (css_provider);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_tmp2_ = gdk_screen_get_default ();
	gtk_style_context_add_provider_for_screen (_tmp2_, (GtkStyleProvider*) css_provider, (guint) GTK_STYLE_PROVIDER_PRIORITY_APPLICATION);
	_tmp3_ = g_settings_new ("org.gnome.baobab.ui");
	_g_object_unref0 (self->priv->ui_settings);
	self->priv->ui_settings = _tmp3_;
	_tmp4_ = g_settings_new ("org.gnome.baobab.preferences");
	_g_object_unref0 (self->priv->prefs_settings);
	self->priv->prefs_settings = _tmp4_;
	_tmp5_ = g_settings_new ("org.gnome.desktop.interface");
	_g_object_unref0 (self->priv->desktop_settings);
	self->priv->desktop_settings = _tmp5_;
	_tmp6_ = gtk_settings_get_default ();
	_tmp7_ = _g_object_ref0 (_tmp6_);
	gtk_settings = _tmp7_;
	_tmp8_ = gtk_builder_new ();
	builder = _tmp8_;
	{
		GtkBuilder* _tmp9_;
		_tmp9_ = builder;
		gtk_builder_add_from_resource (_tmp9_, "/org/gnome/baobab/ui/baobab-menu.ui", &_inner_error_);
		if (_inner_error_ != NULL) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		const gchar* _tmp10_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp10_ = e->message;
		g_error ("baobab-application.vala:119: loading menu builder file: %s", _tmp10_);
		_g_error_free0 (e);
	}
	__finally0:
	if (_inner_error_ != NULL) {
		_g_object_unref0 (builder);
		_g_object_unref0 (gtk_settings);
		_g_object_unref0 (css_provider);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_tmp11_ = gtk_settings;
	g_object_get (_tmp11_, "gtk-shell-shows-app-menu", &_tmp12_, NULL);
	_tmp13_ = _tmp12_;
	if (_tmp13_) {
		GtkBuilder* _tmp14_;
		GObject* _tmp15_ = NULL;
		GMenuModel* _tmp16_;
		GMenuModel* app_menu;
		GMenuModel* _tmp17_;
		_tmp14_ = builder;
		_tmp15_ = gtk_builder_get_object (_tmp14_, "appmenu");
		_tmp16_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp15_, g_menu_model_get_type ()) ? ((GMenuModel*) _tmp15_) : NULL);
		app_menu = _tmp16_;
		_tmp17_ = app_menu;
		gtk_application_set_app_menu ((GtkApplication*) self, _tmp17_);
		_g_object_unref0 (app_menu);
	} else {
		GtkBuilder* _tmp18_;
		GObject* _tmp19_ = NULL;
		GMenuModel* _tmp20_;
		GMenuModel* menubar;
		GMenuModel* _tmp21_;
		_tmp18_ = builder;
		_tmp19_ = gtk_builder_get_object (_tmp18_, "menubar");
		_tmp20_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp19_, g_menu_model_get_type ()) ? ((GMenuModel*) _tmp19_) : NULL);
		menubar = _tmp20_;
		_tmp21_ = menubar;
		gtk_application_set_menubar ((GtkApplication*) self, _tmp21_);
		_g_object_unref0 (menubar);
	}
	_g_object_unref0 (builder);
	_g_object_unref0 (gtk_settings);
	_g_object_unref0 (css_provider);
}


static gboolean baobab_application_real_local_command_line (GApplication* base, gchar*** arguments, gint* exit_status) {
	BaobabApplication * self;
	gint _vala_exit_status = 0;
	gboolean result = FALSE;
	const gchar* _tmp0_ = NULL;
	GOptionContext* _tmp1_;
	GOptionContext* ctx;
	GOptionContext* _tmp2_;
	GOptionContext* _tmp3_;
	GOptionGroup* _tmp4_ = NULL;
	gchar** _tmp5_;
	gint _tmp5__length1;
	gchar** argv;
	gint argv_length1;
	gint _argv_size_;
	gboolean _tmp7_;
	gint _tmp9_ = 0;
	gboolean _tmp10_ = FALSE;
	GError * _inner_error_ = NULL;
	self = (BaobabApplication*) base;
	_tmp0_ = _ ("- Disk Usage Analyzer");
	_tmp1_ = g_option_context_new (_tmp0_);
	ctx = _tmp1_;
	_tmp2_ = ctx;
	g_option_context_add_main_entries (_tmp2_, BAOBAB_APPLICATION_option_entries, GETTEXT_PACKAGE);
	_tmp3_ = ctx;
	_tmp4_ = gtk_get_option_group (TRUE);
	g_option_context_add_group (_tmp3_, _tmp4_);
	_tmp5_ = *arguments;
	_tmp5__length1 = _vala_array_length (*arguments);
	argv = _tmp5_;
	argv_length1 = _tmp5__length1;
	_argv_size_ = argv_length1;
	{
		GOptionContext* _tmp6_;
		_tmp6_ = ctx;
		g_option_context_parse (_tmp6_, &argv_length1, &argv, &_inner_error_);
		if (_inner_error_ != NULL) {
			goto __catch1_g_error;
		}
	}
	goto __finally1;
	__catch1_g_error:
	{
		GError* e = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		_vala_exit_status = 1;
		result = TRUE;
		_g_error_free0 (e);
		_g_option_context_free0 (ctx);
		if (exit_status) {
			*exit_status = _vala_exit_status;
		}
		return result;
	}
	__finally1:
	if (_inner_error_ != NULL) {
		_g_option_context_free0 (ctx);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return FALSE;
	}
	_tmp7_ = baobab_application_print_version;
	if (_tmp7_) {
		const gchar* _tmp8_ = NULL;
		_tmp8_ = g_get_application_name ();
		g_print ("%s %s\n", _tmp8_, VERSION);
		_vala_exit_status = 0;
		result = TRUE;
		_g_option_context_free0 (ctx);
		if (exit_status) {
			*exit_status = _vala_exit_status;
		}
		return result;
	}
	_tmp10_ = G_APPLICATION_CLASS (baobab_application_parent_class)->local_command_line ((GApplication*) G_TYPE_CHECK_INSTANCE_CAST (self, GTK_TYPE_APPLICATION, GtkApplication), (gchar***) (arguments), &_tmp9_);
	_vala_exit_status = _tmp9_;
	result = _tmp10_;
	_g_option_context_free0 (ctx);
	if (exit_status) {
		*exit_status = _vala_exit_status;
	}
	return result;
}


BaobabApplication* baobab_application_construct (GType object_type) {
	BaobabApplication * self = NULL;
	self = (BaobabApplication*) g_object_new (object_type, "application-id", "org.gnome.baobab", "flags", G_APPLICATION_HANDLES_OPEN, NULL);
	g_action_map_add_action_entries ((GActionMap*) self, (const GActionEntry*) BAOBAB_APPLICATION_action_entries, G_N_ELEMENTS (BAOBAB_APPLICATION_action_entries), self);
	return self;
}


BaobabApplication* baobab_application_new (void) {
	return baobab_application_construct (BAOBAB_TYPE_APPLICATION);
}


GSettings* baobab_application_get_desktop_settings (void) {
	GSettings* result = NULL;
	BaobabApplication* _tmp0_;
	BaobabApplication* _tmp1_;
	BaobabApplication* app;
	GSettings* _tmp2_;
	GSettings* _tmp3_;
	_tmp0_ = baobab_application_baobab;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	app = _tmp1_;
	_tmp2_ = app->priv->desktop_settings;
	_tmp3_ = _g_object_ref0 (_tmp2_);
	result = _tmp3_;
	_g_object_unref0 (app);
	return result;
}


GSettings* baobab_application_get_prefs_settings (void) {
	GSettings* result = NULL;
	BaobabApplication* _tmp0_;
	BaobabApplication* _tmp1_;
	BaobabApplication* app;
	GSettings* _tmp2_;
	GSettings* _tmp3_;
	_tmp0_ = baobab_application_baobab;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	app = _tmp1_;
	_tmp2_ = app->priv->prefs_settings;
	_tmp3_ = _g_object_ref0 (_tmp2_);
	result = _tmp3_;
	_g_object_unref0 (app);
	return result;
}


GSettings* baobab_application_get_ui_settings (void) {
	GSettings* result = NULL;
	BaobabApplication* _tmp0_;
	BaobabApplication* _tmp1_;
	BaobabApplication* app;
	GSettings* _tmp2_;
	GSettings* _tmp3_;
	_tmp0_ = baobab_application_baobab;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	app = _tmp1_;
	_tmp2_ = app->priv->ui_settings;
	_tmp3_ = _g_object_ref0 (_tmp2_);
	result = _tmp3_;
	_g_object_unref0 (app);
	return result;
}


static void baobab_application_on_quit_activate (BaobabApplication* self) {
	g_return_if_fail (self != NULL);
	g_application_quit ((GApplication*) self);
}


static void baobab_application_class_init (BaobabApplicationClass * klass) {
	baobab_application_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (BaobabApplicationPrivate));
	G_APPLICATION_CLASS (klass)->activate = baobab_application_real_activate;
	G_APPLICATION_CLASS (klass)->open = baobab_application_real_open;
	G_APPLICATION_CLASS (klass)->startup = baobab_application_real_startup;
	G_APPLICATION_CLASS (klass)->local_command_line = baobab_application_real_local_command_line;
	G_OBJECT_CLASS (klass)->finalize = baobab_application_finalize;
}


static void baobab_application_instance_init (BaobabApplication * self) {
	self->priv = BAOBAB_APPLICATION_GET_PRIVATE (self);
}


static void baobab_application_finalize (GObject* obj) {
	BaobabApplication * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, BAOBAB_TYPE_APPLICATION, BaobabApplication);
	_g_object_unref0 (self->priv->desktop_settings);
	_g_object_unref0 (self->priv->prefs_settings);
	_g_object_unref0 (self->priv->ui_settings);
	G_OBJECT_CLASS (baobab_application_parent_class)->finalize (obj);
}


GType baobab_application_get_type (void) {
	static volatile gsize baobab_application_type_id__volatile = 0;
	if (g_once_init_enter (&baobab_application_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (BaobabApplicationClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) baobab_application_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (BaobabApplication), 0, (GInstanceInitFunc) baobab_application_instance_init, NULL };
		GType baobab_application_type_id;
		baobab_application_type_id = g_type_register_static (GTK_TYPE_APPLICATION, "BaobabApplication", &g_define_type_info, 0);
		g_once_init_leave (&baobab_application_type_id__volatile, baobab_application_type_id);
	}
	return baobab_application_type_id__volatile;
}


static gint _vala_array_length (gpointer array) {
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}



