//***********************************************************************
// *  $RCSfile$ - GConfPreferencesProvider.cs
// *
// *  Copyright (C) 2007 Novell, Inc.
// *
// *  This program is free software; you can redistribute it and/or
// *  modify it under the terms of the GNU General Public
// *  License as published by the Free Software Foundation; either
// *  version 2 of the License, or (at your option) any later version.
// *
// *  This program is distributed in the hope that it will be useful,
// *  but WITHOUT ANY WARRANTY; without even the implied warranty of
// *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// *  General Public License for more details.
// *
// *  You should have received a copy of the GNU General Public
// *  License along with this program; if not, write to the Free
// *  Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
// *
// **********************************************************************

using System;
using GConf;

namespace Banter
{
	public class GConfPreferencesProvider : IPreferencesProvider
	{
		public event PreferenceChangedEventHandler PreferenceChanged;
		static GConf.Client client;
		static GConf.NotifyEventHandler changed_handler;
		
		public GConfPreferencesProvider ()
		{
		}

		public void Set (string key, object value)
		{
			try {
				Client.Set (key, value);
			} catch {}
		}
		
		// <summary>
		// Returns the object setting for the specified key.  If the setting
		// does not exist, null will be returned.
		// </summary>
		public object Get (string key)
		{
			try {
				return Client.Get (key);
			} catch (GConf.NoSuchKeyException) {
				return null;
			}
		}

		private GConf.Client Client
		{
			get
			{
				if (client == null) {
					client = new GConf.Client ();
					
					changed_handler = new GConf.NotifyEventHandler (OnSettingChanged);
					client.AddNotify ("/apps/rtc", changed_handler);
				}
				
				return client;
			}
		}

		void OnSettingChanged (object sender, GConf.NotifyEventArgs args)
		{
			if (PreferenceChanged != null)
				PreferenceChanged (this, new PreferenceChangedEventArgs (args.Key, args.Value));
		}
	}
}
