/*************************************************************************** 
 *  PodcastItem.cs
 *
 *  Copyright (C) 2008 Michael C. Urbanski
 *  Written by Mike Urbanski <michael.c.urbanski@gmail.com>
 ****************************************************************************/

/*  THIS FILE IS LICENSED UNDER THE MIT LICENSE AS OUTLINED IMMEDIATELY BELOW: 
 *
 *  Permission is hereby granted, free of charge, to any person obtaining a
 *  copy of this software and associated documentation files (the "Software"),  
 *  to deal in the Software without restriction, including without limitation  
 *  the rights to use, copy, modify, merge, publish, distribute, sublicense,  
 *  and/or sell copies of the Software, and to permit persons to whom the  
 *  Software is furnished to do so, subject to the following conditions:
 *
 *  The above copyright notice and this permission notice shall be included in 
 *  all copies or substantial portions of the Software.
 *
 *  THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR 
 *  IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, 
 *  FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE 
 *  AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER 
 *  LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING 
 *  FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER 
 *  DEALINGS IN THE SOFTWARE.
 */

using System;
using System.Text;

using System.Collections.Generic;

using Hyena.Data.Sqlite;

using Banshee.MediaEngine;
using Banshee.ServiceStack;

using Banshee.Database;
using Banshee.Collection;
using Banshee.Collection.Database;

using Migo.Syndication;

namespace Banshee.Podcasting.Data 
{
    public enum PodcastItemActivity : int {
        Downloading = 0,
        DownloadPending = 1,        
        DownloadFailed = 2,
        DownloadPaused = 3,        
        NewPodcastItem = 4,
        Video = 5,
        Downloaded = 6,
        None = 7,
        Playing = 8,
        Paused = 9
    }

    public class PodcastItem : DatabaseTrackInfo
    {
        private static BansheeModelProvider<PodcastItem> provider = new DatabaseTrackModelProvider<PodcastItem> (ServiceManager.DbConnection);
        public static new BansheeModelProvider<PodcastItem> Provider {
            get { return provider; }
        }
        
        private bool @new;
        private int position;
        private long item_id;

        /*private static BansheeModelProvider<PodcastItem> provider;
        public new static BansheeModelProvider<PodcastItem> Provider {
            get { return provider; }
        }*/

#region Properties

        public Feed Feed {
            get { return item.Feed; }
        }
        
        private FeedItem item;
        public FeedItem Item {
            get {
                if (item == null && item_id > 0) {
                    item = FeedItem.Provider.FetchSingle (item_id);
                }
                return item;
            }
            set { item = value; item_id = value.DbId; }
        }
        
        public bool New {
            get { return @new; }
            set { @new = value; }
        }
        
        public int Position {
            get { return position; }
            set { position = value; }
         }
        
        [DatabaseColumn ("ExternalID")]
        public long ItemID {
            get { return item_id; }
            set { item_id = value; }
        }
        
        public FeedEnclosure Enclosure {
            get { return (item == null) ? null : item.Enclosure; }
        }

        public PodcastItemActivity Activity {
            get {
                PodcastItemActivity ret = PodcastItemActivity.None;
            
                /*if (Track != null) {
                    if (ServiceManager.PlayerEngine.CurrentTrack == Track) {
                        if (ServiceManager.PlayerEngine.CurrentState == PlayerEngineState.Playing) {
                            ret = PodcastItemActivity.Playing;
                        } else if (ServiceManager.PlayerEngine.CurrentState == PlayerEngineState.Paused) {
                            ret = PodcastItemActivity.Paused;
                        }
                    } else {                             
                        if (New) {
                            ret = PodcastItemActivity.NewPodcastItem;
                        } else if ((Track.MediaAttributes & TrackMediaAttributes.VideoStream) != 
                                    TrackMediaAttributes.None) {
                            ret = PodcastItemActivity.Video;
                         } else {
                            ret = PodcastItemActivity.Downloaded;
                         }
                    } 
                } else {
                    switch (item.Enclosure.DownloadStatus) {
                    case FeedDownloadStatus.Pending: 
                        ret = PodcastItemActivity.DownloadPending;
                        break;
                    case FeedDownloadStatus.Downloading: 
                        ret = PodcastItemActivity.Downloading;
                        break;
                    case FeedDownloadStatus.Downloaded: 
                        ret = PodcastItemActivity.Downloaded;
                        break;    
                    case FeedDownloadStatus.DownloadFailed: 
                        ret = PodcastItemActivity.DownloadFailed;
                        break;  
                    case FeedDownloadStatus.Paused: 
                        ret = PodcastItemActivity.DownloadPaused;
                        break;                        
                    }
                }*/
                
                return ret;
            }
        }

#endregion

#region Constructors
    
        public PodcastItem () : base ()
        {
        }
        
        public PodcastItem (FeedItem feed_item) : base ()
        {
            Item = feed_item;
        }

#endregion

        public void Delete ()
        {
            Provider.Delete (this);
            //feed.Delete ();
        }

        public static void DeleteWithFeedId (long feed_id)
        {
            /*PodcastItem item = Provider.FetchFirstMatching (String.Format (
                "primarysourceid = {0} and externalid = {1}", primary_id, feed_id
            ));

            if (item != null) {
                item.Delete ();
            }*/
        }

        /*public string Title {
            get { return item.Title; }
        }
        
        public string PodcastTitle {
            get { return item.Feed.Title; }
        }
        
        [VirtualDatabaseColumn ("PubDate", "PodcastItems", "TrackID", "TrackID")]
        public DateTime PubDate {
            get { return item.PubDate; }
            set { item.PubDate = value; }
        }
        
        [DatabaseColumn]
        public string Author {
            get { return item.Author; }
            set { item.Author = value; }
        }
        
        [DatabaseColumn ("FeedItemID", Constraints = DatabaseColumnConstraints.NotNull)]
        public long FeedItemID {
            get { return feedItemID; }
            private set { feedItemID = value; }
        }

        [DatabaseColumn ("New", Constraints = DatabaseColumnConstraints.NotNull)]   
        public bool New {
            get { return (_new != 0) ? true : false; }
            set { _new = (value) ? 1 : 0; }
        }
        
        [DatabaseColumn ("Position", Constraints = DatabaseColumnConstraints.NotNull)]
        public int Position {
            get { return position; }
            private set { 
                position = (value < 0) ? 0 : value;
            }
        }        */
    }
}
