/* -*- Mode: csharp; tab-width: 4; c-basic-offset: 4; indent-tabs-mode: t -*- */
/***************************************************************************
 *  Globals.cs
 *
 *  Copyright (C) 2005 Novell
 *  Written by Aaron Bockover (aaron@aaronbock.net)
 ****************************************************************************/

/*  THIS FILE IS LICENSED UNDER THE MIT LICENSE AS OUTLINED IMMEDIATELY BELOW: 
 *
 *  Permission is hereby granted, free of charge, to any person obtaining a
 *  copy of this software and associated documentation files (the "Software"),  
 *  to deal in the Software without restriction, including without limitation  
 *  the rights to use, copy, modify, merge, publish, distribute, sublicense,  
 *  and/or sell copies of the Software, and to permit persons to whom the  
 *  Software is furnished to do so, subject to the following conditions:
 *
 *  The above copyright notice and this permission notice shall be included in 
 *  all copies or substantial portions of the Software.
 *
 *  THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR 
 *  IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, 
 *  FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE 
 *  AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER 
 *  LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING 
 *  FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER 
 *  DEALINGS IN THE SOFTWARE.
 */
 
using System;
using System.IO;
using GConf;

namespace Banshee.Base
{
    public static class Globals
    {
        private static GConf.Client gconf_client;
        private static NetworkDetect network_detect;
        private static ActionManager action_manager;
        private static Library library;
        private static ArgumentQueue argument_queue;
        private static AudioCdCore audio_cd_core;
        private static Random random;
        private static DBusRemote dbus_remote;
        
        public static void Initialize()
        {
            if(!Directory.Exists(Paths.ApplicationData)) {
                Directory.CreateDirectory(Paths.ApplicationData);
            }
            
            Mono.Unix.Catalog.Init(ConfigureDefines.GETTEXT_PACKAGE, ConfigureDefines.LOCALE_DIR);
        
            gconf_client = new GConf.Client();
            network_detect = NetworkDetect.Instance;
            action_manager = new ActionManager();
            library = new Library();
            random = new Random();
            
            Gstreamer.Initialize();
            PlayerEngineCore.Initialize();
            
            try {
                audio_cd_core = new AudioCdCore();
            } catch(ApplicationException e) {
                LogCore.Instance.PushWarning("Audio CD support will be disabled for this instance", e.Message, false);
            }
            
            try {
                Banshee.Dap.DapCore.Initialize();
            } catch(ApplicationException e) {
                LogCore.Instance.PushWarning("DAP support will be disabled for this instance", e.Message, false);
            }
            
            Banshee.Plugins.PluginCore.Initialize();
        }
        
        public static void Dispose()
        {
            Banshee.Plugins.PluginCore.Dispose();
            network_detect.Dispose();
            library.Db.Close();
            Banshee.Dap.DapCore.Dispose();
            HalCore.Dispose();
        }
        
        public static GConf.Client Configuration {
            get {
                return gconf_client;
            }
        }

        public static NetworkDetect Network {
            get {
                return network_detect;
            }
        }
        
        public static ActionManager ActionManager {
            get {
                return action_manager;
            }
        }
        
        public static Library Library {
            get {
                return library;
            }
        }
        
        public static ArgumentQueue ArgumentQueue {
            set {
                argument_queue = value;
            }
            
            get {
                return argument_queue;
            }
        }
        
        public static AudioCdCore AudioCdCore {
            get {
                return audio_cd_core;
            }
        }
        
        public static Random Random {
            get {
                return random;
            }
        }
        
        public static DBusRemote DBusRemote {
            get {
                return dbus_remote;
            }
            
            set {
                dbus_remote = value;
            }
        }
    }
}
