AC_DEFUN([BANSHEE_CHECK_GTK_SHARP],
[
	GTKSHARP3_REQUIRED=2.99
	GTKSHARP2_REQUIRED=2.12.10

	dnl First check for gtk-sharp-3.0
	PKG_CHECK_MODULES(GTKSHARP, gtk-sharp-3.0 >= $GTKSHARP3_REQUIRED, have_gtk3=yes, have_gtk3=no)
	if test "x$have_gtk3" = "xyes"; then
		AC_SUBST(GTKSHARP_LIBS)

		PKG_CHECK_MODULES(GLIBSHARP, glib-sharp-3.0 >= $GTKSHARP3_REQUIRED)
		AC_SUBST(GLIBSHARP_LIBS)

		gtk_version=3
		AM_CONDITIONAL(HAVE_GTK3, true)
	else
		dnl Fall back to gtk-sharp-2.0

		PKG_CHECK_MODULES(GTKSHARP, gtk-sharp-2.0 >= $GTKSHARP2_REQUIRED)
		AC_SUBST(GTKSHARP_LIBS)

		PKG_CHECK_MODULES(GLIBSHARP, glib-sharp-2.0 >= $GTKSHARP2_REQUIRED)
		AC_SUBST(GLIBSHARP_LIBS)

		AM_CONDITIONAL(HAVE_GTK3, false)
		gtk_version="2"
	fi
])
