/* Atomixed -- the level-/themeeditor for atomix.
 * Copyright (C) 1999-2000 Jens Finke
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */
#ifndef _ATOMIXED_PLAYFIELD_EDITOR_H 
#define _ATOMIXED_PLAYFIELD_EDITOR_H 

#include "playfield.h"
#include "canvas_helper.h"
#include "theme.h"

typedef enum
{
	PFE_NORMAL,
	PFE_MOVE,
	PFE_INSERT
} PlayFieldEditorMode;

typedef struct _PlayFieldEditor  PlayFieldEditor;

struct _PlayFieldEditor
{
	gchar *canvas_name;
	Theme *theme;
	gboolean allow_non_moveables;
	PlayField *pf;
	GnomeCanvasGroup *moveables;
	GnomeCanvasGroup *obstacles;
	GnomeCanvasGroup *grid;
	gboolean show_grid;
	CanvasMap *map;
	CanvasMap *grid_map;
	gint last_clicked_row;
	gint last_clicked_col;

	PlayFieldEditorMode mode;
	gpointer mode_data;
};

PlayFieldEditor* playfield_editor_new(gchar *canvas_name, gboolean anm);

void playfield_editor_init(PlayFieldEditor *pfe);

void playfield_editor_clear(PlayFieldEditor *pfe);

void playfield_editor_resize(PlayFieldEditor *pfe, guint n_rows, guint n_cols);

void playfield_editor_set_playfield(PlayFieldEditor *pfe, PlayField *pf);

void playfield_editor_set_theme(PlayFieldEditor *pfe, Theme *theme, gboolean update);

void playfield_editor_destroy(PlayFieldEditor *pfe);

void playfield_editor_show_grid(PlayFieldEditor *pfe, gboolean show);

void playfield_editor_insert_pf(PlayFieldEditor *pfe, PlayField *pf);

#endif /* _ATOMIXED_PLAYFIELD_EDITOR_H */
