/* Atomixed -- the level-/themeeditor for atomix.
 * Copyright (C) 1999-2000 Jens Finke
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */
#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <gnome.h>
#include "main.h"
#include "interface.h"
#include "support.h"
#include "level.h"
#include "theme.h"
#include "playfield_editor.h"
#include "level_ctrl.h"
#include "image_win_ctrl.h"
#include "level_properties.h"
#include "theme_properties.h"
#include "theme_ctrl.h"
#include "callbacks.h"

static GtkWidget *app;
static PlayFieldEditor *level_editor;
static PlayFieldEditor *goal_editor;
static ThemeImgEditor *moveable_editor;
static ThemeImgEditor *obstacle_editor;
static ThemeImgEditor *connection_editor;
static GtkWidget *img_window = NULL;

void init(void);

GtkWidget* get_app()
{
	return app;
}

PlayFieldEditor* get_level_editor()
{
	return level_editor;
}

PlayFieldEditor* get_goal_editor(void)
{
	return goal_editor;
}

ThemeImgEditor* get_moveable_editor(void)
{
	return moveable_editor;
}

ThemeImgEditor* get_obstacle_editor(void)
{
	return obstacle_editor;
}

ThemeImgEditor* get_connection_editor(void)
{
	return connection_editor;
}

ThemeImgEditor* get_image_editor_by_ref(GnomeIconList *gil)
{
	if(gil == moveable_editor->gil)
	{
		return moveable_editor;
	}
	else if(gil == obstacle_editor->gil)
	{
		return obstacle_editor;
	}
	else if(gil == connection_editor->gil)
	{
		return connection_editor;
	}
	else
	{
		return NULL;
	}
}

Theme* get_theme_by_name(gchar *name)
{
	return NULL;
}

void theme_image_win_hide()
{
	if(img_window)
	{
		gtk_widget_hide(GTK_WIDGET(img_window));
	}
}

void theme_image_win_show()
{
	if(img_window)
	{
		gtk_widget_show(GTK_WIDGET(img_window));
	}
}

void theme_image_win_destroy()
{
	if(img_window)
	{
		gtk_widget_destroy(GTK_WIDGET(img_window));
	}
}


void init(void)
{
	Level *level;
	Theme *theme;
	level = level_ctrl_get_actual_level();
	if(level != NULL)
	{
		theme = theme_ctrl_get_theme_by_name(level->theme_name);	
		
		playfield_editor_set_theme(level_editor, theme, FALSE);
		playfield_editor_set_theme(goal_editor, theme, FALSE);
		playfield_editor_set_playfield(level_editor, level->playfield);
		playfield_editor_set_playfield(goal_editor, level->goal);
		level_properties_set_level(level);
		image_win_ctrl_set_theme(theme);

		theme = theme_ctrl_get_actual_theme();
		theme_img_editor_set_theme(moveable_editor, theme);
		theme_img_editor_set_theme(obstacle_editor, theme);
		theme_img_editor_set_theme(connection_editor, theme);
		theme_properties_set_theme(theme);
		
		update_menu_sensibility();
	}
}

int
main (int argc, char *argv[])
{
	GtkWidget *menu_item;

	bindtextdomain (PACKAGE, PACKAGE_LOCALE_DIR);
	textdomain (PACKAGE);
	
	gnome_init ("atomixed", VERSION, argc, argv);
	
	app = create_mainframe ();
	
	level_create_hash_table();
	theme_create_hash_table();
	
	level_ctrl_init();
	theme_ctrl_init();
	
	level_editor = playfield_editor_new("level_canvas", TRUE);
	goal_editor = playfield_editor_new("goal_canvas", FALSE);
	playfield_editor_init(level_editor);
	playfield_editor_init(goal_editor);

	moveable_editor = theme_img_editor_new("moveable_list", THEME_IMAGE_MOVEABLE);
	obstacle_editor = theme_img_editor_new("obstacle_list", THEME_IMAGE_OBSTACLE);
	connection_editor = theme_img_editor_new("connection_list", THEME_IMAGE_CONNECTION);
	
	img_window = create_theme_image_win();	
	image_win_ctrl_init(img_window);

	/* update button state */
	menu_item = GTK_WIDGET(lookup_widget(get_app(), "item_grid"));
	gtk_check_menu_item_set_active(GTK_CHECK_MENU_ITEM(menu_item), TRUE);

	init();
	
	gtk_widget_show (app);
	
	gtk_main ();
	return 0;
}


