// Generated by gmmproc 2.53.1 -- DO NOT MODIFY!
#ifndef _ATKMM_STATESET_H
#define _ATKMM_STATESET_H


#include <glibmm/ustring.h>
#include <sigc++/sigc++.h>

/* $Id: stateset.hg,v 1.3 2004/01/02 09:56:43 murrayc Exp $ */

/* Copyright (C) 1998-2002 The gtkmm Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */


#include <glibmm/object.h>
#include <glibmm/value.h>

#ifndef DOXYGEN_SHOULD_SKIP_THIS
using AtkStateSet = struct _AtkStateSet;
using AtkStateSetClass = struct _AtkStateSetClass;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace Atk
{ class StateSet_Class; } // namespace Atk
#endif //DOXYGEN_SHOULD_SKIP_THIS

namespace Atk
{


/** @addtogroup atkmmEnums atkmm Enums and Flags */

/** 
 *
 * @ingroup atkmmEnums
 */
enum StateType
{
  STATE_INVALID,
  STATE_ACTIVE,
  STATE_ARMED,
  STATE_BUSY,
  STATE_CHECKED,
  STATE_DEFUNCT,
  STATE_EDITABLE,
  STATE_ENABLED,
  STATE_EXPANDABLE,
  STATE_EXPANDED,
  STATE_FOCUSABLE,
  STATE_FOCUSED,
  STATE_HORIZONTAL,
  STATE_ICONIFIED,
  STATE_MODAL,
  STATE_MULTI_LINE,
  STATE_MULTISELECTABLE,
  STATE_OPAQUE,
  STATE_PRESSED,
  STATE_RESIZABLE,
  STATE_SELECTABLE,
  STATE_SELECTED,
  STATE_SENSITIVE,
  STATE_SHOWING,
  STATE_SINGLE_LINE,
  STATE_STALE,
  STATE_TRANSIENT,
  STATE_VERTICAL,
  STATE_VISIBLE,
  STATE_MANAGES_DESCENDANTS,
  STATE_INDETERMINATE,
  STATE_TRUNCATED,
  STATE_REQUIRED,
  STATE_INVALID_ENTRY,
  STATE_SUPPORTS_AUTOCOMPLETION,
  STATE_SELECTABLE_TEXT,
  STATE_DEFAULT,
  STATE_ANIMATED,
  STATE_VISITED,
  STATE_CHECKABLE,
  STATE_HAS_POPUP,
  STATE_HAS_TOOLTIP,
  STATE_READ_ONLY,
  STATE_LAST_DEFINED
};

} // namespace Atk

#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace Glib
{

template <>
class Value<Atk::StateType> : public Glib::Value_Enum<Atk::StateType>
{
public:
  static GType value_type() G_GNUC_CONST;
};

} // namespace Glib
#endif /* DOXYGEN_SHOULD_SKIP_THIS */

namespace Atk
{


/** An AtkStateSet determines a component's state set.
 * It is composed of a set of Atk::States.
 */

class StateSet : public Glib::Object
{
  
#ifndef DOXYGEN_SHOULD_SKIP_THIS

public:
  using CppObjectType = StateSet;
  using CppClassType = StateSet_Class;
  using BaseObjectType = AtkStateSet;
  using BaseClassType = AtkStateSetClass;

  // noncopyable
  StateSet(const StateSet&) = delete;
  StateSet& operator=(const StateSet&) = delete;

private:  friend class StateSet_Class;
  static CppClassType stateset_class_;

protected:
  explicit StateSet(const Glib::ConstructParams& construct_params);
  explicit StateSet(AtkStateSet* castitem);

#endif /* DOXYGEN_SHOULD_SKIP_THIS */

public:

  StateSet(StateSet&& src) noexcept;
  StateSet& operator=(StateSet&& src) noexcept;

  ~StateSet() noexcept override;

  /** Get the GType for this class, for use with the underlying GObject type system.
   */
  static GType get_type()      G_GNUC_CONST;

#ifndef DOXYGEN_SHOULD_SKIP_THIS


  static GType get_base_type() G_GNUC_CONST;
#endif

  ///Provides access to the underlying C GObject.
  AtkStateSet*       gobj()       { return reinterpret_cast<AtkStateSet*>(gobject_); }

  ///Provides access to the underlying C GObject.
  const AtkStateSet* gobj() const { return reinterpret_cast<AtkStateSet*>(gobject_); }

  ///Provides access to the underlying C instance. The caller is responsible for unrefing it. Use when directly setting fields in structs.
  AtkStateSet* gobj_copy();

private:


protected:
  StateSet();
  
public:
  
  static Glib::RefPtr<StateSet> create();


  /** Checks whether the state set is empty, i.e.\ has no states set.
   * 
   * @return <tt>true</tt> if @a set has no states set, otherwise <tt>false</tt>.
   */
  bool is_empty() const;

  //Note that we use Atk::StateType instead of StateType, because there is a Gtk::StateType too, and Doxygen gets confused.
  
  /** Adds the state of the specified type to the state set if it is not already
   * present.
   * 
   * Note that because an Atk::StateSet is a read-only object, this method should
   * be used to add a state to a newly-created set which will then be returned by
   * #atk_object_ref_state_set. It should not be used to modify the existing state
   * of an object. See also #atk_object_notify_state_change.
   * 
   * @param type An Atk::StateType.
   * @return <tt>true</tt> if  the state for @a type is not already in @a set.
   */
  bool add_state(Atk::StateType type);
  void add_states(const std::vector<Atk::StateType>& types);
  
  
  /** Removes all states from the state set.
   */
  void clear_states();
  
  /** Checks whether the state for the specified type is in the specified set.
   * 
   * @param type An Atk::StateType.
   * @return <tt>true</tt> if @a type is the state type is in @a set.
   */
  bool contains_state(Atk::StateType type);
   bool contains_states(const std::vector<Atk::StateType>& types) const;
  
  
  /** Removes the state for the specified type from the state set.
   * 
   * Note that because an Atk::StateSet is a read-only object, this method should
   * be used to remove a state to a newly-created set which will then be returned
   * by #atk_object_ref_state_set. It should not be used to modify the existing
   * state of an object. See also #atk_object_notify_state_change.
   * 
   * @param type An Atk::Type.
   * @return <tt>true</tt> if @a type was the state type is in @a set.
   */
  bool remove_state(Atk::StateType type);
  
  /** Constructs the intersection of the two sets, returning <tt>nullptr</tt> if the
   * intersection is empty.
   * 
   * @param compare_set Another Atk::StateSet.
   * @return A new Atk::StateSet which is the intersection of
   * the two sets.
   */
  Glib::RefPtr<StateSet> and_sets(const Glib::RefPtr<StateSet>& compare_set);
  
  /** Constructs the union of the two sets.
   * 
   * @param compare_set Another Atk::StateSet.
   * @return A new Atk::StateSet which is
   * the union of the two sets, returning <tt>nullptr</tt> is empty.
   */
  Glib::RefPtr<StateSet> or_sets(const Glib::RefPtr<StateSet>& compare_set);
  
  /** Constructs the exclusive-or of the two sets, returning <tt>nullptr</tt> is empty.
   * The set returned by this operation contains the states in exactly
   * one of the two sets.
   * 
   * @param compare_set Another Atk::StateSet.
   * @return A new Atk::StateSet which contains the states
   * which are in exactly one of the two sets.
   */
  Glib::RefPtr<StateSet> xor_sets(const Glib::RefPtr<StateSet>& compare_set);


public:

public:
  //C++ methods used to invoke GTK+ virtual functions:

protected:
  //GTK+ Virtual Functions (override these to change behaviour):

  //Default Signal Handlers::


};

} // namespace Atk


namespace Glib
{
  /** A Glib::wrap() method for this object.
   *
   * @param object The C instance.
   * @param take_copy False if the result should take ownership of the C instance. True if it should take a new copy or ref.
   * @result A C++ instance that wraps this C instance.
   *
   * @relates Atk::StateSet
   */
  Glib::RefPtr<Atk::StateSet> wrap(AtkStateSet* object, bool take_copy = false);
}


#endif /* _ATKMM_STATESET_H */

