/* -*- Mode: C; indent-tabs-mode: t; c-basic-offset: 4; tab-width: 4 -*- */
/*
 *  ianjuta-builder.c -- Autogenerated from libanjuta.idl
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

/**
 * SECTION:ianjuta-builder
 * @title: IAnjutaBuilder
 * @short_description: Implemented by plugins that can build
 * @see_also: 
 * @stability: Unstable
 * @include: libanjuta/interfaces/ianjuta-builder.h
 * 
 */

#include "ianjuta-builder.h"
#include "libanjuta-iface-marshallers.h"

GQuark 
ianjuta_builder_error_quark (void)
{
	static GQuark quark = 0;
	
	if (quark == 0) {
		quark = g_quark_from_static_string ("ianjuta-builder-quark");
	}
	
	return quark;
}

/** 
* ianjuta_builder_build:
* @obj: Self
* @uri: target uri
* @callback: callback called when command is finished
* @user_data: data passed to the callback
* @err: Error propagation and reporting.
*
* Build the specified target.
* When the command if finished, the callback function is called
* if defined.
*
* Returns: non null command handle if succeed
*/
IAnjutaBuilderHandle
ianjuta_builder_build (IAnjutaBuilder *obj, const gchar *uri,   IAnjutaBuilderCallback callback,   gpointer user_data, GError **err)
{
	g_return_val_if_fail (IANJUTA_IS_BUILDER(obj), 0);
	g_return_val_if_fail (user_data != NULL, 0);
	return IANJUTA_BUILDER_GET_IFACE (obj)->build (obj, uri, callback, user_data, err);
}

/* Default implementation */
static IAnjutaBuilderHandle
ianjuta_builder_build_default (IAnjutaBuilder *obj, const gchar *uri,   IAnjutaBuilderCallback callback,   gpointer user_data, GError **err)
{
	g_return_val_if_reached (0);
}

/**
* ianjuta_builder_cancel:
* @obj: Self
* @handle: handle of the command to cancel
* @err: Error propagation and reporting.
* 
* Cancel specified command. The callback function will not
* be called.
*
*/
void
ianjuta_builder_cancel (IAnjutaBuilder *obj, IAnjutaBuilderHandle handle, GError **err)
{
	g_return_if_fail (IANJUTA_IS_BUILDER(obj));
	IANJUTA_BUILDER_GET_IFACE (obj)->cancel (obj, handle, err);
}

/* Default implementation */
static void
ianjuta_builder_cancel_default (IAnjutaBuilder *obj, IAnjutaBuilderHandle handle, GError **err)
{
	g_return_if_reached ();
}

/**
* ianjuta_builder_get_uri_configuration:
* @obj: Self
* @uri: target uri
* @err: Error propagation and reporting.
* 
* Get the configuration corresponding to the target uri.
*
* Returns: The configuration name or NULL if the corresponding
* configuration cannot be found.
*/
const gchar*
ianjuta_builder_get_uri_configuration (IAnjutaBuilder *obj, const gchar *uri, GError **err)
{
	g_return_val_if_fail (IANJUTA_IS_BUILDER(obj), NULL);
	return IANJUTA_BUILDER_GET_IFACE (obj)->get_uri_configuration (obj, uri, err);
}

/* Default implementation */
static const gchar*
ianjuta_builder_get_uri_configuration_default (IAnjutaBuilder *obj, const gchar *uri, GError **err)
{
	g_return_val_if_reached (NULL);
}

/** 
* ianjuta_builder_is_built:
* @obj: Self
* @uri: target uri
* @callback: callback called when command is finished
* @user_data: data passed to the callback
* @err: Error propagation and reporting.
*
* Check if the corresponding target is up to date or not. This
* command doesn't display anything. If this command cannot be
* implemented, it is possible to return always TRUE.
* When the command is finished, the callback function is called
* if defined.
*
* Returns: non null command handle if succeed
*/
IAnjutaBuilderHandle
ianjuta_builder_is_built (IAnjutaBuilder *obj, const gchar *uri,   IAnjutaBuilderCallback callback,   gpointer user_data, GError **err)
{
	g_return_val_if_fail (IANJUTA_IS_BUILDER(obj), 0);
	g_return_val_if_fail (user_data != NULL, 0);
	return IANJUTA_BUILDER_GET_IFACE (obj)->is_built (obj, uri, callback, user_data, err);
}

/* Default implementation */
static IAnjutaBuilderHandle
ianjuta_builder_is_built_default (IAnjutaBuilder *obj, const gchar *uri,   IAnjutaBuilderCallback callback,   gpointer user_data, GError **err)
{
	g_return_val_if_reached (0);
}

/**
 * ianjuta_builder_list_configuration:
 * @obj: Self
 * @err: Error propagation and reporting.
 * 
 * List all defined configuration. These names returned are
 * the internal non localized names for the following 
 * predefined configuration: Debug, Profiling, Optimized.
 * The default configuration has no name and is not returned.
 *
 * Returns: (element-type utf8) (transfer container): a list configuration name. The names are owned
 * by the plugin, so only the list has to be free using
 * g_list_free.
 */
GList*
ianjuta_builder_list_configuration (IAnjutaBuilder *obj, GError **err)
{
	g_return_val_if_fail (IANJUTA_IS_BUILDER(obj), 0);
	return IANJUTA_BUILDER_GET_IFACE (obj)->list_configuration (obj, err);
}

/* Default implementation */
static GList*
ianjuta_builder_list_configuration_default (IAnjutaBuilder *obj, GError **err)
{
	g_return_val_if_reached (NULL);
}

static void
ianjuta_builder_base_init (IAnjutaBuilderIface* klass)
{
	static gboolean initialized = FALSE;

	klass->build = ianjuta_builder_build_default;
	klass->cancel = ianjuta_builder_cancel_default;
	klass->get_uri_configuration = ianjuta_builder_get_uri_configuration_default;
	klass->is_built = ianjuta_builder_is_built_default;
	klass->list_configuration = ianjuta_builder_list_configuration_default;
	
	if (!initialized) {

		initialized = TRUE;
	}
}

GType
ianjuta_builder_get_type (void)
{
	static GType type = 0;
	if (!type) {
		static const GTypeInfo info = {
			sizeof (IAnjutaBuilderIface),
			(GBaseInitFunc) ianjuta_builder_base_init,
			NULL, 
			NULL,
			NULL,
			NULL,
			0,
			0,
			NULL
		};
		type = g_type_register_static (G_TYPE_INTERFACE, "IAnjutaBuilder", &info, 0);
		g_type_interface_add_prerequisite (type, G_TYPE_OBJECT);
	}
	return type;			
}

GType
ianjuta_builder_error_get_type (void)
{
	static const GEnumValue values[] =
	{
		{ IANJUTA_BUILDER_SUCCEED, "IANJUTA_BUILDER_SUCCEED", "succeed" }, 
		{ IANJUTA_BUILDER_FAILED, "IANJUTA_BUILDER_FAILED", "failed" }, 
		{ IANJUTA_BUILDER_CANCELED, "IANJUTA_BUILDER_CANCELED", "canceled" }, 
		{ IANJUTA_BUILDER_ABORTED, "IANJUTA_BUILDER_ABORTED", "aborted" }, 
		{ IANJUTA_BUILDER_INTERRUPTED, "IANJUTA_BUILDER_INTERRUPTED", "interrupted" }, 
		{ IANJUTA_BUILDER_TERMINATED, "IANJUTA_BUILDER_TERMINATED", "terminated" }, 
		{ IANJUTA_BUILDER_UNKNOWN_TARGET, "IANJUTA_BUILDER_UNKNOWN_TARGET", "unknown-target" }, 
		{ IANJUTA_BUILDER_UNKNOWN_ERROR, "IANJUTA_BUILDER_UNKNOWN_ERROR", "unknown-error" }, 
		{ IANJUTA_BUILDER_OTHER_ERROR, "IANJUTA_BUILDER_OTHER_ERROR", "other-error" }, 
		{ 0, NULL, NULL }
	};

	static GType type = 0;

	if (! type)
	{
		type = g_enum_register_static ("IAnjutaBuilderError", values);
	}

	return type;
}
