/* -*- Mode: C; indent-tabs-mode: t; c-basic-offset: 4; tab-width: 4 -*- */
/*
 *  ianjuta-breakpoint-debugger.h -- Autogenerated from libanjuta.idl
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#ifndef _IANJUTA_BREAKPOINT_DEBUGGER_H_
#define _IANJUTA_BREAKPOINT_DEBUGGER_H_

#include <glib-object.h>
#include <libanjuta/interfaces/ianjuta-debug-manager.h>
#include <libanjuta/interfaces/ianjuta-debugger.h>
#include <sys/types.h>

G_BEGIN_DECLS

#define IANJUTA_TYPE_BREAKPOINT_DEBUGGER (ianjuta_breakpoint_debugger_get_type ())
#define IANJUTA_BREAKPOINT_DEBUGGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), IANJUTA_TYPE_BREAKPOINT_DEBUGGER, IAnjutaBreakpointDebugger))
#define IANJUTA_IS_BREAKPOINT_DEBUGGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), IANJUTA_TYPE_BREAKPOINT_DEBUGGER))
#define IANJUTA_BREAKPOINT_DEBUGGER_GET_IFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), IANJUTA_TYPE_BREAKPOINT_DEBUGGER, IAnjutaBreakpointDebuggerIface))

#define IANJUTA_BREAKPOINT_DEBUGGER_ERROR ianjuta_breakpoint_debugger_error_quark()

typedef struct _IAnjutaBreakpointDebugger IAnjutaBreakpointDebugger;
typedef struct _IAnjutaBreakpointDebuggerIface IAnjutaBreakpointDebuggerIface;

struct _IAnjutaBreakpointDebuggerIface {
	GTypeInterface g_iface;
	

	gboolean (*clear_breakpoint) (IAnjutaBreakpointDebugger *obj, guint id,  IAnjutaDebuggerCallback callback,  gpointer user_data, GError **err);
	gboolean (*condition_breakpoint) (IAnjutaBreakpointDebugger *obj, guint id,  const gchar* condition,  IAnjutaDebuggerCallback callback,  gpointer user_data, GError **err);
	gboolean (*enable_breakpoint) (IAnjutaBreakpointDebugger *obj, guint id,  gboolean enable,  IAnjutaDebuggerCallback callback,  gpointer user_data, GError **err);
	gboolean (*ignore_breakpoint) (IAnjutaBreakpointDebugger *obj, guint id,  guint ignore,  IAnjutaDebuggerCallback callback,  gpointer user_data, GError **err);
	gboolean (*set_breakpoint_at_address) (IAnjutaBreakpointDebugger *obj, guint address,  IAnjutaDebuggerCallback callback,  gpointer user_data, GError **err);
	gboolean (*set_breakpoint_at_function) (IAnjutaBreakpointDebugger *obj, const gchar* file,  const gchar* function,  IAnjutaDebuggerCallback callback,  gpointer user_data, GError **err);
	gboolean (*set_breakpoint_at_line) (IAnjutaBreakpointDebugger *obj, const gchar* file,  guint line,  IAnjutaDebuggerCallback callback,  gpointer user_data, GError **err);

};

GQuark ianjuta_breakpoint_debugger_error_quark     (void);
GType  ianjuta_breakpoint_debugger_get_type        (void);

gboolean ianjuta_breakpoint_debugger_clear_breakpoint (IAnjutaBreakpointDebugger *obj, guint id,  IAnjutaDebuggerCallback callback,  gpointer user_data, GError **err);

gboolean ianjuta_breakpoint_debugger_condition_breakpoint (IAnjutaBreakpointDebugger *obj, guint id,  const gchar* condition,  IAnjutaDebuggerCallback callback,  gpointer user_data, GError **err);

gboolean ianjuta_breakpoint_debugger_enable_breakpoint (IAnjutaBreakpointDebugger *obj, guint id,  gboolean enable,  IAnjutaDebuggerCallback callback,  gpointer user_data, GError **err);

gboolean ianjuta_breakpoint_debugger_ignore_breakpoint (IAnjutaBreakpointDebugger *obj, guint id,  guint ignore,  IAnjutaDebuggerCallback callback,  gpointer user_data, GError **err);

gboolean ianjuta_breakpoint_debugger_set_breakpoint_at_address (IAnjutaBreakpointDebugger *obj, guint address,  IAnjutaDebuggerCallback callback,  gpointer user_data, GError **err);

gboolean ianjuta_breakpoint_debugger_set_breakpoint_at_function (IAnjutaBreakpointDebugger *obj, const gchar* file,  const gchar* function,  IAnjutaDebuggerCallback callback,  gpointer user_data, GError **err);

gboolean ianjuta_breakpoint_debugger_set_breakpoint_at_line (IAnjutaBreakpointDebugger *obj, const gchar* file,  guint line,  IAnjutaDebuggerCallback callback,  gpointer user_data, GError **err);


G_END_DECLS

#endif
