/* -*- Mode: C; indent-tabs-mode: t; c-basic-offset: 4; tab-width: 4 -*- */
/*
 *  ianjuta-editor-assist.h -- Autogenerated from libanjuta.idl
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#ifndef _IANJUTA_EDITOR_ASSIST_H_
#define _IANJUTA_EDITOR_ASSIST_H_

#include <glib-object.h>
#include <libanjuta/interfaces/ianjuta-editor.h>

G_BEGIN_DECLS

#define IANJUTA_TYPE_EDITOR_ASSIST (ianjuta_editor_assist_get_type ())
#define IANJUTA_EDITOR_ASSIST(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), IANJUTA_TYPE_EDITOR_ASSIST, IAnjutaEditorAssist))
#define IANJUTA_IS_EDITOR_ASSIST(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), IANJUTA_TYPE_EDITOR_ASSIST))
#define IANJUTA_EDITOR_ASSIST_GET_IFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), IANJUTA_TYPE_EDITOR_ASSIST, IAnjutaEditorAssistIface))

#define IANJUTA_EDITOR_ASSIST_ERROR ianjuta_editor_assist_error_quark()

typedef struct _IAnjutaEditorAssist IAnjutaEditorAssist;
typedef struct _IAnjutaEditorAssistIface IAnjutaEditorAssistIface;


struct _IAnjutaEditorAssistIface {
	IAnjutaEditorIface g_iface;
	
	/* Signal */
	void (*assist_chosen) (IAnjutaEditorAssist *obj, gint selection);

	void (*cancel_tips) (IAnjutaEditorAssist *obj, GError **err);
	GList* (*get_suggestions) (IAnjutaEditorAssist *obj, const gchar *context, GError **err);
	void (*hide_suggestions) (IAnjutaEditorAssist *obj, GError **err);
	void (*show_tips) (IAnjutaEditorAssist *obj, GList* tips,  IAnjutaIterable *position,  gint char_alignment, GError **err);
	void (*suggest) (IAnjutaEditorAssist *obj, GList* choices,  IAnjutaIterable *position,  int char_alignment, GError **err);
	gboolean (*tip_shown) (IAnjutaEditorAssist *obj, GError **err);

};


GQuark ianjuta_editor_assist_error_quark     (void);
GType  ianjuta_editor_assist_get_type        (void);

void ianjuta_editor_assist_cancel_tips (IAnjutaEditorAssist *obj, GError **err);

GList* ianjuta_editor_assist_get_suggestions (IAnjutaEditorAssist *obj, const gchar *context, GError **err);

void ianjuta_editor_assist_hide_suggestions (IAnjutaEditorAssist *obj, GError **err);

void ianjuta_editor_assist_show_tips (IAnjutaEditorAssist *obj, GList* tips,  IAnjutaIterable *position,  gint char_alignment, GError **err);

void ianjuta_editor_assist_suggest (IAnjutaEditorAssist *obj, GList* choices,  IAnjutaIterable *position,  int char_alignment, GError **err);

gboolean ianjuta_editor_assist_tip_shown (IAnjutaEditorAssist *obj, GError **err);


G_END_DECLS

#endif
