/* -*- Mode: C; indent-tabs-mode: t; c-basic-offset: 4; tab-width: 4 -*- */
/*
 *  ianjuta-buildable.c -- Autogenerated from libanjuta.idl
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

/**
 * SECTION:ianjuta-buildable
 * @title: IAnjutaBuildable
 * @short_description: Implemented by plugins that can build
 * @see_also: 
 * @stability: Unstable
 * @include: libanjuta/interfaces/ianjuta-buildable.h
 * 
 */

#include "ianjuta-buildable.h"
#include "libanjuta-iface-marshallers.h"

GQuark 
ianjuta_buildable_error_quark (void)
{
	static GQuark quark = 0;
	
	if (quark == 0) {
		quark = g_quark_from_static_string ("ianjuta-buildable-quark");
	}
	
	return quark;
}

/** 
* ianjuta_buildable_build:
* @obj: Self
* @uri: fixme
* @err: Error propagation and reporting.
*
* fixme
*/
void
ianjuta_buildable_build (IAnjutaBuildable *obj, const gchar *uri, GError **err)
{
	g_return_if_fail (IANJUTA_IS_BUILDABLE(obj));
	IANJUTA_BUILDABLE_GET_IFACE (obj)->build (obj, uri, err);
}

/* Default implementation */
static void
ianjuta_buildable_build_default (IAnjutaBuildable *obj, const gchar *uri, GError **err)
{
	g_return_if_reached ();
}

/**
* ianjuta_buildable_clean:
* @obj: Self
* @uri: fixme
* @err: Error propagation and reporting.
* 
* fixme
*/
void
ianjuta_buildable_clean (IAnjutaBuildable *obj, const gchar *uri, GError **err)
{
	g_return_if_fail (IANJUTA_IS_BUILDABLE(obj));
	IANJUTA_BUILDABLE_GET_IFACE (obj)->clean (obj, uri, err);
}

/* Default implementation */
static void
ianjuta_buildable_clean_default (IAnjutaBuildable *obj, const gchar *uri, GError **err)
{
	g_return_if_reached ();
}

/**
* ianjuta_buildable_configure:
* @obj: Self
* @uri: fixme
* @err: Error propagation and reporting.
* 
* fixme
*/
void
ianjuta_buildable_configure (IAnjutaBuildable *obj, const gchar *uri, GError **err)
{
	g_return_if_fail (IANJUTA_IS_BUILDABLE(obj));
	IANJUTA_BUILDABLE_GET_IFACE (obj)->configure (obj, uri, err);
}

/* Default implementation */
static void
ianjuta_buildable_configure_default (IAnjutaBuildable *obj, const gchar *uri, GError **err)
{
	g_return_if_reached ();
}

/**
* ianjuta_buildable_execute:
* @obj: Self
* @uri: fixme
* @err: Error propagation and reporting.
* 
* fixme
*/
void
ianjuta_buildable_execute (IAnjutaBuildable *obj, const gchar *uri, GError **err)
{
	g_return_if_fail (IANJUTA_IS_BUILDABLE(obj));
	IANJUTA_BUILDABLE_GET_IFACE (obj)->execute (obj, uri, err);
}

/* Default implementation */
static void
ianjuta_buildable_execute_default (IAnjutaBuildable *obj, const gchar *uri, GError **err)
{
	g_return_if_reached ();
}

/**
* ianjuta_buildable_generate:
* @obj: Self
* @uri: fixme
* @err: Error propagation and reporting.
* 
* fixme
*/
void
ianjuta_buildable_generate (IAnjutaBuildable *obj, const gchar *uri, GError **err)
{
	g_return_if_fail (IANJUTA_IS_BUILDABLE(obj));
	IANJUTA_BUILDABLE_GET_IFACE (obj)->generate (obj, uri, err);
}

/* Default implementation */
static void
ianjuta_buildable_generate_default (IAnjutaBuildable *obj, const gchar *uri, GError **err)
{
	g_return_if_reached ();
}

/** 
* ianjuta_buildable_get_command:
* @obj: Self
* @command_id: Command to get override.
* @err: Error propagation and reporting.
*
* Retrieves the currently set command override.
* 
* Returns: The overridden command. NULL if no override set.
*/
const gchar*
ianjuta_buildable_get_command (IAnjutaBuildable *obj, IAnjutaBuildableCommand command_id, GError **err)
{
	g_return_val_if_fail (IANJUTA_IS_BUILDABLE(obj), NULL);
	return IANJUTA_BUILDABLE_GET_IFACE (obj)->get_command (obj, command_id, err);
}

/* Default implementation */
static const gchar*
ianjuta_buildable_get_command_default (IAnjutaBuildable *obj, IAnjutaBuildableCommand command_id, GError **err)
{
	g_return_val_if_reached (NULL);
}

/**
* ianjuta_buildable_install:
* @obj: Self
* @uri: fixme
* @err: Error propagation and reporting.
* 
* fixme
*/
void
ianjuta_buildable_install (IAnjutaBuildable *obj, const gchar *uri, GError **err)
{
	g_return_if_fail (IANJUTA_IS_BUILDABLE(obj));
	IANJUTA_BUILDABLE_GET_IFACE (obj)->install (obj, uri, err);
}

/* Default implementation */
static void
ianjuta_buildable_install_default (IAnjutaBuildable *obj, const gchar *uri, GError **err)
{
	g_return_if_reached ();
}

/** 
* ianjuta_buildable_reset_commands:
* @obj: Self
* @err: Error propagation and reporting.
*
* Resets the command overrides to defaults.
*/
void
ianjuta_buildable_reset_commands (IAnjutaBuildable *obj, GError **err)
{
	g_return_if_fail (IANJUTA_IS_BUILDABLE(obj));
	IANJUTA_BUILDABLE_GET_IFACE (obj)->reset_commands (obj, err);
}

/* Default implementation */
static void
ianjuta_buildable_reset_commands_default (IAnjutaBuildable *obj, GError **err)
{
	g_return_if_reached ();
}

/** 
* ianjuta_buildable_set_command:
* @obj: Self
* @command_id: Command to override.
* @command: Build command to override.
* @err: Error propagation and reporting.
*
* Overrides the default command for the given command.
*/
void
ianjuta_buildable_set_command (IAnjutaBuildable *obj, IAnjutaBuildableCommand command_id,   const gchar *command, GError **err)
{
	g_return_if_fail (IANJUTA_IS_BUILDABLE(obj));
	IANJUTA_BUILDABLE_GET_IFACE (obj)->set_command (obj, command_id, command, err);
}

/* Default implementation */
static void
ianjuta_buildable_set_command_default (IAnjutaBuildable *obj, IAnjutaBuildableCommand command_id,   const gchar *command, GError **err)
{
	g_return_if_reached ();
}

static void
ianjuta_buildable_base_init (IAnjutaBuildableIface* klass)
{
	static gboolean initialized = FALSE;

	klass->build = ianjuta_buildable_build_default;
	klass->clean = ianjuta_buildable_clean_default;
	klass->configure = ianjuta_buildable_configure_default;
	klass->execute = ianjuta_buildable_execute_default;
	klass->generate = ianjuta_buildable_generate_default;
	klass->get_command = ianjuta_buildable_get_command_default;
	klass->install = ianjuta_buildable_install_default;
	klass->reset_commands = ianjuta_buildable_reset_commands_default;
	klass->set_command = ianjuta_buildable_set_command_default;
	
	if (!initialized) {

		initialized = TRUE;
	}
}

GType
ianjuta_buildable_get_type (void)
{
	static GType type = 0;
	if (!type) {
		static const GTypeInfo info = {
			sizeof (IAnjutaBuildableIface),
			(GBaseInitFunc) ianjuta_buildable_base_init,
			NULL, 
			NULL,
			NULL,
			NULL,
			0,
			0,
			NULL
		};
		type = g_type_register_static (G_TYPE_INTERFACE, "IAnjutaBuildable", &info, 0);
		g_type_interface_add_prerequisite (type, G_TYPE_OBJECT);
	}
	return type;			
}

GType
ianjuta_buildable_command_get_type (void)
{
	static const GEnumValue values[] =
	{
		{ IANJUTA_BUILDABLE_COMMAND_COMPILE, "IANJUTA_BUILDABLE_COMMAND_COMPILE", "command-compile" }, 
		{ IANJUTA_BUILDABLE_COMMAND_BUILD, "IANJUTA_BUILDABLE_COMMAND_BUILD", "command-build" }, 
		{ IANJUTA_BUILDABLE_COMMAND_BUILD_TARBALL, "IANJUTA_BUILDABLE_COMMAND_BUILD_TARBALL", "command-build-tarball" }, 
		{ IANJUTA_BUILDABLE_COMMAND_INSTALL, "IANJUTA_BUILDABLE_COMMAND_INSTALL", "command-install" }, 
		{ IANJUTA_BUILDABLE_COMMAND_CONFIGURE, "IANJUTA_BUILDABLE_COMMAND_CONFIGURE", "command-configure" }, 
		{ IANJUTA_BUILDABLE_COMMAND_GENERATE, "IANJUTA_BUILDABLE_COMMAND_GENERATE", "command-generate" }, 
		{ IANJUTA_BUILDABLE_COMMAND_CLEAN, "IANJUTA_BUILDABLE_COMMAND_CLEAN", "command-clean" }, 
		{ IANJUTA_BUILDABLE_COMMAND_EXECUTE, "IANJUTA_BUILDABLE_COMMAND_EXECUTE", "command-execute" }, 
		{ IANJUTA_BUILDABLE_COMMAND_IS_BUILT, "IANJUTA_BUILDABLE_COMMAND_IS_BUILT", "command-is-built" }, 
		{ IANJUTA_BUILDABLE_COMMAND_AUTORECONF, "IANJUTA_BUILDABLE_COMMAND_AUTORECONF", "command-autoreconf" }, 
		{ IANJUTA_BUILDABLE_COMMAND_DISTCLEAN, "IANJUTA_BUILDABLE_COMMAND_DISTCLEAN", "command-distclean" }, 
		{ IANJUTA_BUILDABLE_N_COMMANDS, "IANJUTA_BUILDABLE_N_COMMANDS", "n-commands" }, 
		{ 0, NULL, NULL }
	};

	static GType type = 0;

	if (! type)
	{
		type = g_enum_register_static ("IAnjutaBuildableCommand", values);
	}

	return type;
}
