/* -*- Mode: C; indent-tabs-mode: t; c-basic-offset: 4; tab-width: 4 -*- */
/*
 *  ianjuta-editor.h -- Autogenerated from libanjuta.idl
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef _IANJUTA_EDITOR_H_
#define _IANJUTA_EDITOR_H_

#include <glib-object.h>
#include <gtk/gtkwidget.h>
#include <libanjuta/interfaces/ianjuta-iterable.h>

G_BEGIN_DECLS

#define IANJUTA_TYPE_EDITOR (ianjuta_editor_get_type ())
#define IANJUTA_EDITOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), IANJUTA_TYPE_EDITOR, IAnjutaEditor))
#define IANJUTA_IS_EDITOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), IANJUTA_TYPE_EDITOR))
#define IANJUTA_EDITOR_GET_IFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), IANJUTA_TYPE_EDITOR, IAnjutaEditorIface))

#define IANJUTA_TYPE_EDITOR_ATTRIBUTE (ianjuta_editor_attribute_get_type())
#define IANJUTA_TYPE_EDITOR_ERROR (ianjuta_editor_error_get_type())

typedef enum {
	IANJUTA_EDITOR_TEXT,
	IANJUTA_EDITOR_KEYWORD,
	IANJUTA_EDITOR_COMMENT,
	IANJUTA_EDITOR_STRING
} IAnjutaEditorAttribute;

typedef enum {
	IANJUTA_EDITOR_DOESNT_EXIST
} IAnjutaEditorError;

#define IANJUTA_EDITOR_ERROR ianjuta_editor_error_quark()

typedef struct _IAnjutaEditor IAnjutaEditor;
typedef struct _IAnjutaEditorIface IAnjutaEditorIface;

struct _IAnjutaEditorIface {
	GTypeInterface g_iface;
	
	/* Signal */
	void (*changed) (IAnjutaEditor *obj, gint position,  gboolean added,  gint length,  gint lines,  const gchar *text);
	/* Signal */
	void (*char_added) (IAnjutaEditor *obj, gint position,  gchar ch);
	/* Signal */
	void (*update_ui) (IAnjutaEditor *obj);

	void (*append) (IAnjutaEditor *obj, const gchar *text,  gint length, GError **err);
	void (*begin_undo_action) (IAnjutaEditor *obj, GError **err);
	gboolean (*can_redo) (IAnjutaEditor *obj, GError **err);
	gboolean (*can_undo) (IAnjutaEditor *obj, GError **err);
	void (*end_undo_action) (IAnjutaEditor *obj, GError **err);
	void (*erase) (IAnjutaEditor *obj, gint position,  gint length, GError **err);
	void (*erase_all) (IAnjutaEditor *obj, GError **err);
	IAnjutaEditorAttribute* (*get_attributes) (IAnjutaEditor *obj, gint start,  gint length, GError **err);
	IAnjutaIterable* (*get_cell_iter) (IAnjutaEditor *obj, gint position, GError **err);
	gint (*get_column) (IAnjutaEditor *obj, GError **err);
	gchar* (*get_current_word) (IAnjutaEditor *obj, GError **err);
	const gchar* (*get_filename) (IAnjutaEditor *obj, GError **err);
	gint (*get_length) (IAnjutaEditor *obj, GError **err);
	gint (*get_line_begin_position) (IAnjutaEditor *obj, gint line, GError **err);
	gint (*get_line_end_position) (IAnjutaEditor *obj, gint line, GError **err);
	int (*get_line_from_position) (IAnjutaEditor *obj, int position, GError **err);
	gint (*get_lineno) (IAnjutaEditor *obj, GError **err);
	gboolean (*get_overwrite) (IAnjutaEditor *obj, GError **err);
	gint (*get_position) (IAnjutaEditor *obj, GError **err);
	gint (*get_tabsize) (IAnjutaEditor *obj, GError **err);
	gchar* (*get_text) (IAnjutaEditor *obj, gint position,  gint length, GError **err);
	gboolean (*get_use_spaces) (IAnjutaEditor *obj, GError **err);
	void (*goto_line) (IAnjutaEditor *obj, gint lineno, GError **err);
	void (*goto_position) (IAnjutaEditor *obj, gint position, GError **err);
	void (*grab_focus) (IAnjutaEditor *obj, GError **err);
	void (*insert) (IAnjutaEditor *obj, int position,  const gchar *text,  gint length, GError **err);
	void (*redo) (IAnjutaEditor *obj, GError **err);
	void (*set_auto_indent) (IAnjutaEditor *obj, gboolean auto_indent, GError **err);
	void (*set_popup_menu) (IAnjutaEditor *obj, GtkWidget *menu, GError **err);
	void (*set_tabsize) (IAnjutaEditor *obj, gint tabsize, GError **err);
	void (*set_use_spaces) (IAnjutaEditor *obj, gboolean use_spaces, GError **err);
	void (*undo) (IAnjutaEditor *obj, GError **err);

};
GType ianjuta_editor_attribute_get_type (void);
GType ianjuta_editor_error_get_type (void);

GQuark ianjuta_editor_error_quark     (void);
GType  ianjuta_editor_get_type        (void);

void ianjuta_editor_append (IAnjutaEditor *obj, const gchar *text,  gint length, GError **err);

void ianjuta_editor_begin_undo_action (IAnjutaEditor *obj, GError **err);

gboolean ianjuta_editor_can_redo (IAnjutaEditor *obj, GError **err);

gboolean ianjuta_editor_can_undo (IAnjutaEditor *obj, GError **err);

void ianjuta_editor_end_undo_action (IAnjutaEditor *obj, GError **err);

void ianjuta_editor_erase (IAnjutaEditor *obj, gint position,  gint length, GError **err);

void ianjuta_editor_erase_all (IAnjutaEditor *obj, GError **err);

IAnjutaEditorAttribute* ianjuta_editor_get_attributes (IAnjutaEditor *obj, gint start,  gint length, GError **err);

IAnjutaIterable* ianjuta_editor_get_cell_iter (IAnjutaEditor *obj, gint position, GError **err);

gint ianjuta_editor_get_column (IAnjutaEditor *obj, GError **err);

gchar* ianjuta_editor_get_current_word (IAnjutaEditor *obj, GError **err);

const gchar* ianjuta_editor_get_filename (IAnjutaEditor *obj, GError **err);

gint ianjuta_editor_get_length (IAnjutaEditor *obj, GError **err);

gint ianjuta_editor_get_line_begin_position (IAnjutaEditor *obj, gint line, GError **err);

gint ianjuta_editor_get_line_end_position (IAnjutaEditor *obj, gint line, GError **err);

int ianjuta_editor_get_line_from_position (IAnjutaEditor *obj, int position, GError **err);

gint ianjuta_editor_get_lineno (IAnjutaEditor *obj, GError **err);

gboolean ianjuta_editor_get_overwrite (IAnjutaEditor *obj, GError **err);

gint ianjuta_editor_get_position (IAnjutaEditor *obj, GError **err);

gint ianjuta_editor_get_tabsize (IAnjutaEditor *obj, GError **err);

gchar* ianjuta_editor_get_text (IAnjutaEditor *obj, gint position,  gint length, GError **err);

gboolean ianjuta_editor_get_use_spaces (IAnjutaEditor *obj, GError **err);

void ianjuta_editor_goto_line (IAnjutaEditor *obj, gint lineno, GError **err);

void ianjuta_editor_goto_position (IAnjutaEditor *obj, gint position, GError **err);

void ianjuta_editor_grab_focus (IAnjutaEditor *obj, GError **err);

void ianjuta_editor_insert (IAnjutaEditor *obj, int position,  const gchar *text,  gint length, GError **err);

void ianjuta_editor_redo (IAnjutaEditor *obj, GError **err);

void ianjuta_editor_set_auto_indent (IAnjutaEditor *obj, gboolean auto_indent, GError **err);

void ianjuta_editor_set_popup_menu (IAnjutaEditor *obj, GtkWidget *menu, GError **err);

void ianjuta_editor_set_tabsize (IAnjutaEditor *obj, gint tabsize, GError **err);

void ianjuta_editor_set_use_spaces (IAnjutaEditor *obj, gboolean use_spaces, GError **err);

void ianjuta_editor_undo (IAnjutaEditor *obj, GError **err);


G_END_DECLS

#endif
