/* -*- Mode: C; indent-tabs-mode: t; c-basic-offset: 4; tab-width: 4 -*- */
/*
 *  ianjuta-markable.c -- Autogenerated from libanjuta.idl
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include "ianjuta-markable.h"
#include "libanjuta-iface-marshallers.h"

GQuark 
ianjuta_markable_error_quark (void)
{
	static GQuark quark = 0;
	
	if (quark == 0) {
		quark = g_quark_from_static_string ("ianjuta-markable-quark");
	}
	
	return quark;
}

/**
* ianjuta_markable_delete_all_markers:
* @obj: Self
* @marker: Marker to delete.
* @err: Error propagation and reporting
* 
* Delete the @marker from all locations.
*/
void
ianjuta_markable_delete_all_markers (IAnjutaMarkable *obj, IAnjutaMarkableMarker marker, GError **err)
{
	g_return_if_fail (IANJUTA_IS_MARKABLE(obj));
	IANJUTA_MARKABLE_GET_IFACE (obj)->delete_all_markers (obj, marker, err);
}

/**
* ianjuta_markable_is_marker_set:
* @obj: Self
* @location: Location to check.
* @marker: Marker to check.
* @err: Error propagation and reporting 
* 
* Check if the @marker is set at the given @location.
* 
* Returns: TRUE if the marker is set at the location, other false.
*/
gboolean
ianjuta_markable_is_marker_set (IAnjutaMarkable *obj, gint location,   IAnjutaMarkableMarker marker, GError **err)
{
	g_return_val_if_fail (IANJUTA_IS_MARKABLE(obj), FALSE);
	return IANJUTA_MARKABLE_GET_IFACE (obj)->is_marker_set (obj, location, marker, err);
}

/**
 * ianjuta_markable_location_from_handle:
 * @obj: Self
 * @handle: Handle of location.
 * @err: Error propagation and reporting
 *
 * Location where a marker is set could have moved by some operation in
 * the implementation. To retrieve the correct location where the marker
 * has moved, pass the handle retured by ianjuta_markable_mark() to this
 * method.
 *
 * Return value: Current location where the marker was set.
 */
gint
ianjuta_markable_location_from_handle (IAnjutaMarkable *obj, gint handle, GError **err)
{
	g_return_val_if_fail (IANJUTA_IS_MARKABLE(obj), -1);
	return IANJUTA_MARKABLE_GET_IFACE (obj)->location_from_handle (obj, handle, err);
}

/**
 * ianjuta_markable_mark:
 * @obj: Self
 * @location: Location at which the marker to set.
 * @marker: Type of marker to be used
 * @err: Error propagation and reporting
 *
 * Marks the specified location with the given marker type. Location is
 * implementation depenedent. For example, for an editor location means
 * lines where markers are set.
 *
 * Return value: Handle of the location marked. Can be used later to obtain
 * new location, if it has been moved due to addetions/deletions in the
 * implementor object.
 */
gint
ianjuta_markable_mark (IAnjutaMarkable *obj, gint location,   IAnjutaMarkableMarker marker, GError **err)
{
	g_return_val_if_fail (IANJUTA_IS_MARKABLE(obj), -1);
	return IANJUTA_MARKABLE_GET_IFACE (obj)->mark (obj, location, marker, err);
}

/**
* ianjuta_markable_unmark:
* @obj: Self
* @location: Location where the marker is set.
* @marker: The marker to unset.
* @err: Error propagation and reporting
*
* Clears the @marker at given @location.
*/
void
ianjuta_markable_unmark (IAnjutaMarkable *obj, gint location,   IAnjutaMarkableMarker marker, GError **err)
{
	g_return_if_fail (IANJUTA_IS_MARKABLE(obj));
	IANJUTA_MARKABLE_GET_IFACE (obj)->unmark (obj, location, marker, err);
}

static void
ianjuta_markable_base_init (gpointer gclass)
{
	static gboolean initialized = FALSE;
	
	if (!initialized) {
		/* Signal */
		g_signal_new ("marker-clicked",
			IANJUTA_TYPE_MARKABLE,
			G_SIGNAL_RUN_LAST,
			G_STRUCT_OFFSET (IAnjutaMarkableIface, marker_clicked),
			NULL, NULL,
			libanjuta_iface_cclosure_marshal_VOID__BOOLEAN_INT,
			G_TYPE_NONE,
			2,
			G_TYPE_BOOLEAN,
			G_TYPE_INT);


		initialized = TRUE;
	}
}

GType
ianjuta_markable_get_type (void)
{
	static GType type = 0;
	if (!type) {
		static const GTypeInfo info = {
			sizeof (IAnjutaMarkableIface),
			ianjuta_markable_base_init,
			NULL, 
			NULL,
			NULL,
			NULL,
			0,
			0,
			NULL
		};
		type = g_type_register_static (G_TYPE_INTERFACE, "IAnjutaMarkable", &info, 0);
		g_type_interface_add_prerequisite (type, G_TYPE_OBJECT);
	}
	return type;			
}

GType
ianjuta_markable_error_get_type (void)
{
	static const GEnumValue values[] =
	{
		{ IANJUTA_MARKABLE_INVALID_LOCATION, "IANJUTA_MARKABLE_INVALID_LOCATION", "invalid-location" }, 
		{ 0, NULL, NULL }
	};

	static GType type = 0;

	if (! type)
	{
		type = g_enum_register_static ("IAnjutaMarkableError", values);
	}

	return type;
}

GType
ianjuta_markable_marker_get_type (void)
{
	static const GEnumValue values[] =
	{
		{ IANJUTA_MARKABLE_NONE, "IANJUTA_MARKABLE_NONE", "none" }, 
		{ IANJUTA_MARKABLE_BASIC, "IANJUTA_MARKABLE_BASIC", "basic" }, 
		{ IANJUTA_MARKABLE_LIGHT, "IANJUTA_MARKABLE_LIGHT", "light" }, 
		{ IANJUTA_MARKABLE_ATTENTIVE, "IANJUTA_MARKABLE_ATTENTIVE", "attentive" }, 
		{ IANJUTA_MARKABLE_INTENSE, "IANJUTA_MARKABLE_INTENSE", "intense" }, 
		{ 0, NULL, NULL }
	};

	static GType type = 0;

	if (! type)
	{
		type = g_enum_register_static ("IAnjutaMarkableMarker", values);
	}

	return type;
}
