/*
    fileselection.h
    Copyright (C) 2000  Kh. Naba Kumar Singh

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/
#ifndef _FILE_SELECTION_H_
#define _FILE_SELECTION_H_

#include "global.h"

/* This structure must be declared static where ever you use it */
typedef struct _FileSelData FileSelData;
struct _FileSelData
{
  char title[MAX_NAME_LENGTH];
  gpointer data;
  void (*click_ok_callback)(GtkButton*, gpointer);
  void (*click_cancel_callback)(GtkButton*, gpointer);
  GtkWidget *filesel;
  
};
  
GtkWidget* create_fileselection_gui (FileSelData *fd);

/* Free the return */
gchar* fileselection_get_filename (GtkWidget* filesel);

/* Free the return */
gchar* fileselection_get_path (GtkWidget* filesel);

void fileselection_set_title (GtkWidget* filesel, gchar* title);

/* Sets the directory */
gboolean fileselection_set_dir (GtkWidget* filesel, gchar* dir);

/* Sets the filename path */
gboolean
fileselection_set_filename (GtkWidget* filesel, gchar* fname);

#endif
