/* 
    utilities.h
    Copyright (C) 2000  Kh. Naba Kumar Singh

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/
#ifndef _UTILITIES_H_
#define _UTILITIES_H_

#define COMBO_LIST_LENGTH app->preferences->max_combo_histories

typedef enum _FileExtType FileExtType;
enum _FileExtType
{
   FILE_EXT_TYPE_PRJ,
   FILE_EXT_TYPE_C,
   FILE_EXT_TYPE_IC,
   FILE_EXT_TYPE_OC,
   FILE_EXT_TYPE_CPP,
   FILE_EXT_TYPE_ICPP,
   FILE_EXT_TYPE_H,
   FILE_EXT_TYPE_XPM,
   FILE_EXT_TYPE_JPG,
   FILE_EXT_TYPE_PNG,
   FILE_EXT_TYPE_BMP,
   FILE_EXT_TYPE_TIFF,
   FILE_EXT_TYPE_GIF,
   FILE_EXT_TYPE_ASM,
   FILE_EXT_TYPE_JAVA,
   FILE_EXT_TYPE_SH,
   FILE_EXT_TYPE_SCM,
   FILE_EXT_TYPE_FOR,
   FILE_EXT_TYPE_PERL,
   FILE_EXT_TYPE_UNKNOWN
};

/****************************************************************************/
/*  Functions that dynamic allocate memory. Return value(s) should be g_freed */
/****************************************************************************/
gboolean
parse_error_line(gchar *line, gchar **filename, int *lineno);

gboolean
read_string(FILE* stream, gchar* token, gchar **str);

gboolean
read_line(FILE* stream, gchar **str);

gchar*
remove_white_spaces(gchar* text);

GList*
remove_blank_lines(GList* lines); /* GList must be freed */

gchar*
get_a_tmp_file(void);

/***********************************************************************************/
/*  Functions that do not dynamic allocate memory. Return value should not be g_freed */
/***********************************************************************************/

GdkFont*
get_fixed_font (void);

gboolean
write_string(FILE* stream, gchar* token, gchar *str);

gboolean
write_line(FILE* stream, gchar *str);

char*
extract_filename(char* full_filename);

GList*
update_string_list(GList *list, gchar *string, gint length);

gchar*
get_file_extension(gchar* file);

FileExtType
get_file_ext_type(gchar* file);

void
fast_widget_repaint(GtkWidget* w);

gboolean
check_dependency(gchar *file);

gint
compare_string_func(gconstpointer a, gconstpointer b);

gboolean
summon_glade(void
);

gboolean file_is_regular(const gchar * fn);
gboolean file_is_directory(const gchar * fn);
gboolean file_is_link(const gchar * fn);
gboolean file_is_char_device(const gchar * fn);
gboolean file_is_block_device(const gchar * fn);
gboolean file_is_fifo(const gchar * fn);
gboolean file_is_socket(const gchar * fn);
gboolean file_is_readable(const gchar * fn);
gboolean file_is_readonly(const gchar * fn);
gboolean file_is_readwrite(const gchar * fn);
gboolean file_is_writable(const gchar * fn);
gboolean file_is_executable(const gchar * fn);
gboolean file_is_suid(const gchar * fn);
gboolean file_is_sgid(const gchar * fn);
gboolean file_is_sticky(const gchar * fn);

gboolean
copy_file(gchar* src, gchar* dest);

inline void
update_gtk(void);

void
entry_set_text_n_select(GtkWidget* w, gchar* chars, gboolean use_selection);

gboolean
force_create_dir(gchar* d);

#endif