/*
 * text_editor.h
 * Copyright (C) 2000  Kh. Naba Kumar Singh
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */
#ifndef _TEXT_EDITOR_H_
#define _TEXT_EDITOR_H_

#include "text_editor_menu.h"
#include "preferences.h"
#include "global.h"


typedef struct _TextEditorUndoItem TextEditorUndoItem;
typedef struct _BookMark BookMark;
typedef struct _TextEditorButtons TextEditorButtons;
typedef struct _TextEditorGui TextEditorGui;
typedef struct _TextEditor TextEditor;
typedef enum _TextEditorHiliteType TextEditorHiliteType;
typedef enum _TextEditorMode TextEditorMode;
typedef enum _TextEditorUndoItemType TextEditorUndoItemType;
typedef enum _TextEditorStatus TextEditorStatus;

enum _TextEditorHiliteType
{ HILITE_NONE, HILITE_C, HILITE_CPP, HILITE_SCHEME,
  HILITE_JAVA, HILITE_SHELL, HILITE_FORTRAN,
  HILITE_PERL, HILITE_PYTHON, HILITE_HTML
};

enum _TextEditorStatus
{ TEXT_EDITOR_SAVED, TEXT_EDITOR_NOT_SAVED };

enum _TextEditorUndoItemType
{ INSERT, DELETE };

enum _TextEditorMode
{ TEXT_EDITOR_PAGED, TEXT_EDITOR_WINDOWED };

struct _TextEditorUndoItem
{
  gulong length;
  gulong position;
  TextEditorUndoItemType type;
  gchar *text;
};

struct _BookMark
{
  char *lable;
  int line;
};

struct _TextEditorButtons
{
  GtkWidget *new;
  GtkWidget *open;
  GtkWidget *save;
  GtkWidget *reload;
  GtkWidget *cut;
  GtkWidget *copy;
  GtkWidget *paste;
  GtkWidget *find;
  GtkWidget *replace;
  GtkWidget *compile;
  GtkWidget *build;
  GtkWidget *print;
  GtkWidget *attach;
};

struct _TextEditorGui
{
  GtkWidget *window;
  GtkWidget *client_area;
  GtkWidget *client;
  GtkWidget *line_label;
  GtkWidget *editor;
};

struct _TextEditor
{
  TextEditorGui widgets;
  TextEditorMode mode;
  TextEditorStatus status;
  TextEditorMenu *menu;
  TextEditorButtons buttons;
  TextEditorHiliteType hilite_type;
  GList *undo_list;
  guint undo_index;
  gint insert_signal_id;
  gint delete_signal_id;
  gchar *filename;
  gchar *full_filename;
  time_t modified_time;
  gint vadj_signal_id;
  Preferences *preferences;
  GtkAllocation allocation;
  GdkFont *font;
  GtkStyle *style;
  GtkStyle *org_style;


  gboolean autosave_on;

/* Autosave timer ID */
  gint autosave_id;

/* Timer interval in mins */
  gint autosave_it;		
};

void create_text_editor_gui (TextEditor * te);

TextEditor *text_editor_new (gchar * full_filename,
			     TextEditorMode mode, GtkAllocation * allocation,
			     Preferences * pr);

void text_editor_set_hilite_type (TextEditor * te);

void text_editor_show (TextEditor * te);

void text_editor_hide (TextEditor * te);

void text_editor_destroy (TextEditor * te);

gint
text_editor_find (TextEditor * te, gchar * str, gboolean forward,
		  gboolean regexp, gboolean ignore_case);

void text_editor_replace (TextEditor * te);

gboolean text_editor_find_string (TextEditor * te, gchar * s);

guint text_editor_get_total_lines (TextEditor * te);

guint text_editor_get_current_lineno (TextEditor * te);

gboolean text_editor_goto_point (TextEditor * te, guint num);

gboolean text_editor_goto_line (TextEditor * te, guint num);

gboolean text_editor_load_file (TextEditor * te);

gboolean text_editor_save_file (TextEditor * te);

void text_editor_update_preferences (TextEditor * te);

void text_editor_dock (TextEditor * te, GtkWidget * container);

void text_editor_undock (TextEditor * te, GtkWidget * container);

gboolean text_editor_save_yourself (TextEditor * te, FILE * stream);

gboolean text_editor_recover_yourself (TextEditor * te, FILE * stream);

gboolean text_editor_check_disk_status (TextEditor * te);

void text_editor_undo_item_add (TextEditor * te, TextEditorUndoItem * ui);

TextEditorUndoItem *text_editor_undo_item_new (const gchar * text,
					       gulong length, gulong pos,
					       TextEditorUndoItemType type);

void text_editor_undo_item_destroy (TextEditorUndoItem * ui);

void text_editor_undo (TextEditor * te);

void text_editor_redo (TextEditor * te);

void text_editor_hilite (TextEditor * te);

void text_editor_update_controls (TextEditor * te);

#endif
