/* 
    project_dbase.h
    Copyright (C) 2000  Kh. Naba Kumar Singh

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/
#ifndef _PROJECT_DBASE_H_
#define _PROJECT_DBASE_H_

#include "tags_manager.h"
typedef enum _ProjectType ProjectType;
typedef enum _Language Language;
typedef struct _ProjectDBase ProjectDBase;
typedef struct _ProjectDBaseGui ProjectDBaseGui;
typedef enum _FileAdditionType FileAdditionType;

enum _ProjectType
{ blank = 0, console = 1,
  gnome_blank = 2, gnome_full = 3
};
enum _Language
{ c, cpp };
enum _FileAdditionType
{ SOURCE, DOCUMENT, PIXMAP, OTHER, DIRECTORY };

struct _ProjectDBaseGui
{
  GtkWidget *window;
  GtkWidget *client_area;
  GtkWidget *client;
  GtkWidget *scrolledwindow;
  GtkWidget *ctree;
  GtkCTreeNode *root_node;
  GtkCTreeNode *current_node;
  GtkWidget *menu;
  GtkWidget *menu_add_src;
  GtkWidget *menu_add_doc;
  GtkWidget *menu_add_pix;
  GtkWidget *menu_add_other;
  GtkWidget *menu_add_dir;
  GtkWidget *menu_remove;
  GtkWidget *menu_view;
  GtkWidget *menu_configure;
  GtkWidget *menu_info;
};

struct _ProjectDBase
{
  ProjectDBaseGui widgets;
  ProjectType type;
  GtkWidget *fileselection_open;
  GtkWidget *fileselection_add;
  FileAdditionType add_type;

  gchar *top_proj_dir;
  gchar *proj_filename;
  gchar *proj_name;
  gchar *prog_name;
  gchar *version;
  gchar *author;

  GList *src_files;
  GList *doc_files;
  GList *pix_files;

  gchar *src_dir;
  gchar *pix_dir;
  gchar *doc_dir;

  gchar *includes;
  gchar *libraries;

  gboolean project_is_open;
  gboolean project_has_gui;
  gboolean overwrite_makefiles;
  gboolean gettext_support;
  gboolean set_cflags;
  gboolean is_saved;
  gboolean src_makefile_saved;
  gboolean doc_makefile_saved;
  gboolean potfile_saved;

  gboolean is_showing;
  gboolean is_docked;
  gint win_pos_x, win_pos_y, win_width, win_height;

  /* Private */
  gchar *cur_filename;
  gdouble progress_state;
};

ProjectDBase *project_dbase_new (void);

void project_dbase_show (ProjectDBase * p);

void project_dbase_show_info (ProjectDBase * p);

void project_dbase_hide (ProjectDBase * p);

void project_dbase_add_line (ProjectDBase * p);

void project_dbase_write_src_makefile (ProjectDBase * p);

void project_dbase_write_doc_makefile (ProjectDBase * p);

void project_dbase_write_potfile (ProjectDBase * p);

void project_dbase_scan_pix_files (ProjectDBase * p);

void project_dbase_append (ProjectDBase * p, gchar * string);

void project_dbase_clear (ProjectDBase * p);

void project_dbase_destroy (ProjectDBase * p);

gboolean project_dbase_save_yourself (ProjectDBase * p, FILE * stream);

gboolean project_dbase_save_project (ProjectDBase * p);

gboolean project_dbase_load_project (ProjectDBase * p);

void project_dbase_open_project (ProjectDBase * p);

void project_dbase_close_project (ProjectDBase * p);

gboolean project_dbase_load_yourself (ProjectDBase * p, FILE * stream);

void
on_project_dbase_tree_select_row (GtkCList * clist,
				  gint row,
				  gint column,
				  GdkEvent * event, gpointer user_data);

void project_dbase_dock (ProjectDBase * p);

void project_dbase_undock (ProjectDBase * p);

/* Private */

void project_dbase_update_tree (ProjectDBase * p);

void project_dbase_attach (ProjectDBase * p);

void project_dbase_detach (ProjectDBase * p);

void create_project_dbase_gui (ProjectDBase * p);

GtkWidget *create_project_dbase_info_gui (gchar * lab[]);

void project_dbase_update_menu (ProjectDBase * p);

void project_dbase_clean_left (ProjectDBase * p);

void project_dbase_update_controls (ProjectDBase * pd);

gboolean project_dbase_file_is_src (ProjectDBase * p, gchar * file);

#endif
