/*
 * preferences.h
 * Copyright (C) 2000  Kh. Naba Kumar Singh
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */
#ifndef _PREFERENCES_H_
#define _PREFERENCES_H_

#include <gnome.h>

typedef struct _PreferencesWidgets PreferencesWidgets;
typedef struct _Preferences Preferences;
typedef struct _PrefCmdWidgets PrefCmdWidgets;
typedef struct _PrefCmds PrefCmds;
typedef enum _TagPos TagPos;

enum _TagPos
{
  TAG_POS_TOP,
  TAG_POS_BOTTOM,
  TAG_POS_LEFT,
  TAG_POS_RIGHT
};

struct _PrefCmdWidgets
{
  GtkWidget *shell_combo;
  GtkWidget *build_combo;
  GtkWidget *c_compiler_combo;
  GtkWidget *cpp_compiler_combo;
  GtkWidget *pixmap_editor_combo;
  GtkWidget *terminal_combo;
  GtkWidget *browser_combo;
};

struct _PrefCmds
{
  gchar *shell;
  gchar *build;
  gchar *c_compiler;
  gchar *cpp_compiler;
  gchar *pixmap_editor;
  gchar *terminal;
  gchar *browser;
};

struct _PreferencesWidgets
{
  GtkWidget *window;
  GtkWidget *notebook;

  /*
   * Page 0 
   */
  GtkWidget *prj_dir_entry;
  GtkWidget *recent_prj_spin;
  GtkWidget *recent_files_spin;
  GtkWidget *combo_history_spin;
  GtkWidget *beep_check;
  GtkWidget *dialog_check;
  GtkWidget *dependency_check;
  GtkWidget *auto_save_check;
  GtkWidget *auto_indent_check;
  GtkWidget *tab_size_spin;
  GtkWidget *timer_spin;

  /*
   * Page 1 
   */
  PrefCmdWidgets commands;

  /*
   * page2 
   */
  GtkWidget *back_colorpicker;
  GtkWidget *plain_colorpicker;
  GtkWidget *comment_colorpicker;
  GtkWidget *string_colorpicker;
  GtkWidget *keywords_colorpicker;

  GtkWidget *enable_hilite_check;
  GtkWidget *auto_hilite_check;
  GtkWidget *lesser_hilite_check;

  /*
   * Page 3 
   */
  GtkWidget *fontselector;

  /*
   * Page 4 
   */
  GtkWidget *paperselector;
  GtkWidget *pr_command_combo;
  GtkWidget *pr_command_entry;

  /*
   * Page 5 
   */
  GtkWidget *format_disable_check;
  GtkWidget *format_style_combo;
  GtkWidget *custom_style_entry;
  GtkWidget *format_frame1;
  GtkWidget *format_frame2;

  /*
   * Page 6 
   */
  GtkWidget *truncat_mesg_check;
  GtkWidget *mesg_first_spin;
  GtkWidget *mesg_last_spin;
  GtkWidget *tag_pos_radio[4];
  GtkWidget *no_tag_check;
  GtkWidget *tags_update_check;
};

struct _Preferences
{
  PreferencesWidgets widgets;

  /*
   * Page 0 
   */
  PrefCmds commands;

  /*
   * page 1 
   */

  gchar *all_projects_dir;
  gboolean beep_on_build_complete;
  gboolean dialog_on_build_complete;
  gboolean check_dependencies;
  gint max_recent_prjs;
  gint max_recent_files;
  gint max_combo_histories;
  gint max_undo_histories;
  gboolean auto_indent;
  gboolean auto_save;
  gint auto_save_timer;
  gint tab_size;

  /*
   * Page 2 
   */

  GdkColor back_color;
  GdkColor plain_color;
  GdkColor comment_color;
  GdkColor string_color;
  GdkColor keywords_color;

  gboolean enable_hilite;
  gboolean auto_hilite;
  gboolean lesser_hilite;

  /*
   * Page 3 
   */
  gchar *font_name;
  GdkFont *font;
  /*
   * Page 4 
   */
  gchar *pr_command;

  /*
   * Page 5 
   */
  gchar *format_style;
  gchar *custom_style;
  gboolean format_disable;

  /*
   * Page 6 
   */
  gboolean truncat_mesg;
  gint mesg_first;
  gint mesg_last;
  TagPos tag_pos;
  gboolean no_tag;
  gboolean tags_update;

  /*
   * Private 
   */
  gboolean is_showing;
  gint win_pos_x, win_pos_y;

};

void preferences_get (Preferences *);

Preferences *preferences_new (void);

void preferences_set_defaults (Preferences *);

gboolean preferences_save_yourself (Preferences *);

gboolean preferences_load_yourself (Preferences *);

void preferences_hide (Preferences *);

void preferences_show (Preferences *);

void preferences_destroy (Preferences *);

void create_preferences_gui (Preferences *);

gchar *preferences_get_format_opts (Preferences * p);
#endif
