/*
    build_file.c
    Copyright (C) 2000  Kh. Naba Kumar Singh

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/
#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <sys/stat.h>
#include <unistd.h>
#include <sys/types.h>
#include <sys/wait.h>
#include <signal.h>
#include <string.h>

#include <gnome.h>
#include "anjuta.h"
#include "launcher.h"
#include "messages.h"
#include "compile.h"
#include "build_file.h"

static void build_file_terminated(int status, time_t time);
static void build_file_mesg_arrived(gchar *mesg);
void
build_file()
{
  gchar    *buff1, *buff2, *tmp;
  gchar    *file_ext, *out_file, *filename,  *dirname;
  TextEditor* te;

  te = anjuta_get_current_text_editor();
  if(!te) return;
  if(te->full_filename == NULL)
  {
      anjuta_warning(_("This file is not saved. Save it first and then compile."));
      return;
  }
  filename = te->filename;
  switch(get_file_ext_type(filename))
  {
     case FILE_EXT_TYPE_C:
     case FILE_EXT_TYPE_IC:
             if(anjuta_is_installed (app->preferences->commands.c_compiler, TRUE) == FALSE)
               return;
             tmp = compiler_options_get_c_build_command(app->compiler_options);
             break;
     case FILE_EXT_TYPE_CPP:
     case FILE_EXT_TYPE_ICPP:
             if(anjuta_is_installed (app->preferences->commands.cpp_compiler, TRUE) == FALSE)
               return;
             tmp = compiler_options_get_cpp_build_command(app->compiler_options);
             break;
     default:
             anjuta_warning(_("There is no support for building such file."));
             return;
  }
  if(te->status == TEXT_EDITOR_NOT_SAVED)
  {
    if(text_editor_save_file(te) == FALSE)
    {
      anjuta_error(_("There was error in saving the file.\nPlease check it out."));
      return;
    }
  }
  if(app->preferences->check_dependencies)
  {
     gchar *tmp1;
     struct stat st1,st2;
     gint flg;
     buff1 = g_strdup(te->full_filename);
     tmp1 = get_file_extension(buff1);
     if(tmp1)
         *(--tmp1) = '\0';
     stat(te->full_filename, &st1);
     flg = stat(buff1, &st2);
     if((flg==0) && (st2.st_mtime > st1.st_mtime))
     {
       anjuta_warning(_("The executable is up-to-date.No need to build again."));
       g_free(tmp);
       g_free(buff1);
       return;
     }
     g_free(buff1);
  }
  file_ext = get_file_extension(filename);
  out_file = g_strndup(filename, file_ext - filename - 1);
  dirname = g_dirname(te->full_filename);
  buff1 = g_strdup_printf("%s -o %s %s",
                                            tmp,
                                            out_file, filename);
  g_free(tmp);
  chdir(dirname);
  g_free(dirname);
  g_free(out_file);
  /*  we don't free file_ext. Because it is not dynamically allocated */

  if(launcher_execute(buff1, NULL, build_file_mesg_arrived, build_file_terminated) == FALSE)
  {
     g_free(buff1);
     return;
  }
  messages_clear(app->messages, MESSAGE_BUILD);
  buff2 = g_strdup_printf(_("Building %s ...\n"), filename);
  messages_append(app->messages, buff2, MESSAGE_BUILD);
  messages_append(app->messages, buff1, MESSAGE_BUILD);
  messages_append(app->messages, "\n", MESSAGE_BUILD);
  messages_show(app->messages, MESSAGE_BUILD);
  g_free(buff1);
  g_free(buff2);
}

void
build_file_mesg_arrived(gchar *mesg)
{
   messages_append(app->messages, mesg, MESSAGE_BUILD);
}

void
build_file_terminated(int status, time_t time)
{
    gchar  *buff1;

    buff1 = g_strdup_printf(_("Total time taken: %d secs\n"), (int)time);
    if(WEXITSTATUS(status))
    {
       messages_append(app->messages, _("Build completed...............Unsuccessful\n"), MESSAGE_BUILD);
       anjuta_warning(_("Build completed ... unsuccessful"));
    }
    else
    {
       messages_append(app->messages, _("Build completed...............Successful\n"), MESSAGE_BUILD);
       anjuta_status(_("Build completed ... successful"));
    }
    messages_append(app->messages, buff1, MESSAGE_BUILD);
    gdk_beep();
    g_free(buff1);
}

