/*
    appwidzard_cbs.c
    Copyright (C) 2000  Kh. Naba Kumar Singh

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/
#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <sys/stat.h>
#include <unistd.h>
#include <signal.h>
#include <string.h>
#include <ctype.h>

#include <gnome.h>
#include "anjuta.h"
#include "appwidzard.h"
#include "appwidzard_cbs.h"
#include "gnome_project.h"

void
on_druid1_cancel (GnomeDruid * gnomedruid, gpointer user_data)
{
  app_widzard_destroy ((AppWidzard *) user_data);
}

gboolean
on_druidpagestandard1_next (GnomeDruidPage * gnomedruidpage,
			    gpointer arg1, gpointer user_data)
{
  AppWidzard *aw;
  aw = user_data;

  gtk_widget_grab_focus(aw->widgets.prj_name_entry);
  return FALSE;
}

gboolean
on_druidpagestandard2_next (GnomeDruidPage *
			    gnomedruidpage, gpointer arg1, gpointer user_data)
{
  gchar *temp, *top_dir;
  gint i;
  gint error_no;
  AppWidzard *aw;
  gchar buffer[256];
  gchar error_mesg[6][32] = {
    N_("Project name"),
    N_("Program name"),
    N_("Source directory name"),
    N_("Documents directory name"),
    N_("Pixmaps directory name"),
    N_("Project Version")
  };

  aw = user_data;
  if (aw)
  {
    error_no = 0;
    switch (0)
    {
    case 0:
      /*
       * Check for valid Project name
       */
      if (aw->prj_name == NULL)
      {
	error_no = 1;
	break;
      }
      temp = g_strstrip (aw->prj_name);
      if (strlen (temp) == 0)
      {
	error_no = 1;
	break;
      }
      if (!isalpha (temp[0]) && temp[0] != '_')
      {
	error_no = 1;
	break;
      }
      for (i = 0; i < strlen (temp); i++)
      {
	if (!isalpha (temp[i]) && !isdigit (temp[i]) && temp[i] != '_')
	{
	  error_no = 1;
	  break;
	}
      }
      if (error_no)
	break;
      /*
       * Check for valid Version
       */
      if (aw->version == NULL)
      {
	error_no = 6;
	break;
      }
      temp = g_strstrip (aw->version);
      if (strlen (temp) == 0)
      {
	error_no = 6;
	break;
      }
      for (i = 0; i < strlen (temp); i++)
      {
	if (isspace (temp[i]))
	{
	  error_no = 6;
	  break;
	}
      }
      if (error_no)
	break;
      /*
       * Check for valid project directory
       */
      top_dir =
          g_strdup_printf ("%s/%s-%s", app->preferences->all_projects_dir,
		     aw->prj_name, aw->version);
      if (file_is_directory (top_dir) && aw->type != blank)
      {
        anjuta_error (_
		  ("Error: The Project directory already exist.\nChange the Project name or Version."));
	g_free(top_dir);
        return TRUE;
      }
      g_free(top_dir);
      /*
       * Check for valid program name
       */
      if (aw->prog_name == NULL)
      {
	error_no = 2;
	break;
      }
      temp = g_strstrip (aw->prog_name);
      if (strlen (temp) == 0)
      {
	error_no = 2;
	break;
      }
      if (!isalpha (temp[0]) && temp[0] != '_')
      {
	error_no = 2;
	break;
      }
      for (i = 0; i < strlen (temp); i++)
      {
	if (!isalpha (temp[i]) && !isdigit (temp[i]) && temp[i] != '_')
	{
	  error_no = 2;
	  break;
	}
      }
      if (error_no)
	break;
      /*
       * Check for valid src directory name
       */
      if (aw->src_dir_name == NULL)
      {
	error_no = 3;
	break;
      }
      temp = g_strstrip (aw->src_dir_name);
      if (strlen (temp) == 0)
      {
	error_no = 3;
	break;
      }
      if (!isalpha (temp[0]) && temp[0] != '_')
      {
	error_no = 3;
	break;
      }
      for (i = 0; i < strlen (temp) - 1; i++)
      {
	if (!isalpha (temp[i]) && !isdigit (temp[i]) && temp[i] != '_')
	{
	  error_no = 3;
	  break;
	}
	if (!isalpha (temp[i]) && !isdigit (temp[i])
	    && temp[i] != '_' && temp[i] != '/')
	{
	  error_no = 3;
	  break;
	}
      }
      if (error_no)
	break;
      /*
       * Check for valid doc directory name
       */
      if (aw->doc_dir_name == NULL)
      {
	error_no = 4;
	break;
      }
      temp = g_strstrip (aw->doc_dir_name);
      if (strlen (temp) == 0)
      {
	error_no = 4;
	break;
      }
      if (!isalpha (temp[0]) && temp[0] != '_')
      {
	error_no = 4;
	break;
      }
      for (i = 0; i < strlen (temp) - 1; i++)
      {
	if (!isalpha (temp[i]) && !isdigit (temp[i]) && temp[i] != '_')
	{
	  error_no = 4;
	  break;
	}
	if (!isalpha (temp[i]) && !isdigit (temp[i])
	    && temp[i] != '_' && temp[i] != '/')
	{
	  error_no = 4;
	  break;
	}
      }
      if (error_no)
	break;
      /*
       * Check for valid pixmaps directory name
       */
      if (aw->pix_dir_name == NULL)
      {
	error_no = 5;
	break;
      }
      temp = g_strstrip (aw->pix_dir_name);
      if (strlen (temp) == 0)
      {
	error_no = 5;
	break;
      }
      if (!isalpha (temp[0]) && temp[0] != '_')
      {
	error_no = 5;
	break;
      }
      for (i = 0; i < strlen (temp) - 1; i++)
      {
	if (!isalpha (temp[i]) && !isdigit (temp[i]) && temp[i] != '_')
	{
	  error_no = 5;
	  break;
	}
	if (!isalpha (temp[i]) && !isdigit (temp[i])
	    && temp[i] != '_' && temp[i] != '/')
	{
	  error_no = 5;
	  break;
	}
      }
      if (error_no)
	break;
    default:
    }
    if (error_no)
    {
      sprintf (buffer,
	       _
	       ("Invalid %s field:\nYou must supply a valid %s field to proceed further."),
	       _(error_mesg[error_no - 1]), _(error_mesg[error_no - 1]));
      anjuta_error (buffer);
      return TRUE;
    }
  }
  switch (aw->type)
  {
  case blank:
    gnome_druid_set_page (GNOME_DRUID (aw->widgets.druid),
			  GNOME_DRUID_PAGE (aw->widgets.page[4]));
    on_druidpagestandard3_next (NULL, NULL, aw);
    return TRUE;
  case console:
  case gnome_blank:
  case gnome_full:
  default:
    break;
  }
  return FALSE;
}

gboolean
on_druidpagestandard3_next (GnomeDruidPage *
			    gnomedruidpage, gpointer arg1, gpointer user_data)
{
  AppWidzard *aw;
  gchar *text, *prj_type, *gt_support, *lang, *icon;
  aw = user_data;
  icon =
    gnome_icon_entry_get_filename (GNOME_ICON_ENTRY (aw->widgets.icon_entry));
  if (icon == NULL)
  {
    if (aw->icon_file)
    {
      g_free (aw->icon_file);
      aw->icon_file = NULL;
    }
  }
  else
  {
    if (aw->icon_file)
      g_free (aw->icon_file);
    aw->icon_file = g_strdup (icon);
  }

  switch (aw->type)
  {
  case blank:
    prj_type = g_strdup (_("Blank Project"));
    break;
  case console:
    prj_type = g_strdup (_("Console Project"));
    break;
  case gnome_blank:
    prj_type = g_strdup (_("Gnome Blank Project"));
    break;
  case gnome_full:
    prj_type = g_strdup (_("Gnome Full Project"));
    break;
  default:
    /* This will not reach */
    g_warning (_("Unknown project type\n"));
    return FALSE;
  }

  if (aw->gettext_support)
    gt_support = g_strdup (_("Yes"));
  else
    gt_support = g_strdup (_("No"));
  switch (aw->language)
  {
  case c:
    lang = g_strdup ("C");
    break;
  case cpp:
    lang = g_strdup ("C++");
    break;
  default:
    /* This will not reach */
    g_warning (_("Unknown Programming language.\n"));
    g_free (prj_type);
    g_free (gt_support);
    return FALSE;
  }

  if (aw->type == blank)
  {
    text =
      g_strconcat (_("  Confirm the following information:\n\n"),
		   _("  Project Type:        "), prj_type, "\n", NULL);
  }
  else
  {
    text =
      g_strconcat (_("  Confirm the following information:\n\n"),
		   _("  Project Type:        "), prj_type, "\n",
		   _("  Gettext support:     "), gt_support, "\n",
		   _("  Project Name:       "), aw->prj_name, "\n",
		   _("  Author Name(s):    "), aw->author, "\n",
		   _("  Version:               "), aw->version, "\n",
		   _("  Program Name:     "), aw->prog_name, "\n",
		   _("  Source dir:           "), aw->src_dir_name, "\n",
		   _("  Document dir:       "), aw->doc_dir_name, "\n",
		   _("  Pixmap dir:           "), aw->pix_dir_name, "\n",
		   _("  Language:            "), lang, "\n", NULL);
  }
  gnome_druid_page_finish_set_text
    (GNOME_DRUID_PAGE_FINISH (aw->widgets.page[4]), text);
  g_free (prj_type);
  g_free (gt_support);
  g_free (lang);
  return FALSE;
}

void
on_druidpagefinish1_finish (GnomeDruidPage *
			    gnomedruidpage, gpointer arg1, gpointer user_data)
{
  AppWidzard *aw = user_data;
  gtk_widget_hide (aw->widgets.window);
  create_new_project (aw);
  app_widzard_destroy (aw);
}

gboolean
on_druidpagefinish1_back (GnomeDruidPage *
			  gnomedruidpage, gpointer arg1, gpointer user_data)
{
  AppWidzard *aw = user_data;
  if (!aw)
    return FALSE;
  switch (aw->type)
  {
  case blank:
    gnome_druid_set_page (GNOME_DRUID (aw->widgets.druid),
			  GNOME_DRUID_PAGE (aw->widgets.page[2]));
    gtk_widget_grab_focus(aw->widgets.prj_name_entry);
    return TRUE;
  case console:
  case gnome_blank:
  case gnome_full:
  default:
    break;
  }
  return FALSE;
}
