/* 
    toolbar.h
    Copyright (C) 2000  Kh. Naba Kumar Singh

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/
#ifndef _TOOLBAR_H_
#define _TOOLBAR_H_

#include <gnome.h>

typedef struct _MainToolbar MainToolbar;
typedef struct _ExtendedToolbar ExtendedToolbar;
typedef struct _DebugToolbar DebugToolbar;
typedef struct _BrowserToolbar BrowserToolbar;
typedef struct _Toolbar Toolbar;

struct _MainToolbar
{
  GnomeDockItem *dock_item;
  GtkWidget *toolbar;
  gboolean is_showing;

  GtkWidget *new;
  GtkWidget *open;

  GtkWidget *save;
  GtkWidget *save_all;
  GtkWidget *close;
  GtkWidget *reload;

  GtkWidget *undo;
  GtkWidget *redo;

  GtkWidget *led;

  GtkWidget *print;
  GtkWidget *detach;

  GtkWidget *find;
  GtkWidget *find_combo;
  GtkWidget *find_entry;
  GtkWidget *go_to;
  GtkWidget *line_entry;

  GtkWidget *project;
  GtkWidget *messages;

  GtkWidget *help;
};

struct _ExtendedToolbar
{
  GnomeDockItem *dock_item;
  GtkWidget *toolbar;
  gboolean is_showing;

  GtkWidget *open_project;
  GtkWidget *save_project;
  GtkWidget *close_project;

  GtkWidget *hilite;
  GtkWidget *indent;

  GtkWidget *compile;
  GtkWidget *configure;
  GtkWidget *build;
  GtkWidget *build_all;
  GtkWidget *exec;
  GtkWidget *debug;
  GtkWidget *stop;

  GtkWidget *find;
  GtkWidget *replace;
  GtkWidget *find_in_files;
  GtkWidget *reference;
  GtkWidget *trace;
  GtkWidget *view;
};

struct _DebugToolbar
{
  GnomeDockItem *dock_item;
  GtkWidget *toolbar;
  gboolean is_showing;

  GtkWidget *start;
  GtkWidget *interrupt;
  GtkWidget *stop;
  GtkWidget *go;
  GtkWidget *step_in;
  GtkWidget *step_out;
  GtkWidget *step_over;
  GtkWidget *toggle_bp;
  GtkWidget *breakpoints;
  GtkWidget *watch;
  GtkWidget *wachpoints;
  GtkWidget *registers;
  GtkWidget *stack;
  GtkWidget *inspect;
  GtkWidget *frame;
};

struct _BrowserToolbar
{
  GnomeDockItem *dock_item;
  GtkWidget *toolbar;
  gboolean is_showing;

  GtkWidget *tags_type;
  GtkWidget *tags_menu;
  GtkWidget *tag_label;
  GtkWidget *tag_combo;
  GtkWidget *tag_entry;
  GtkWidget *member_label;
  GtkWidget *member_combo;
  GtkWidget *member_entry;
  GtkWidget *widzard;
};

struct _Toolbar
{
  MainToolbar main_toolbar;
  ExtendedToolbar extended_toolbar;
  DebugToolbar debug_toolbar;
  BrowserToolbar browser_toolbar;
};

GtkWidget*
create_main_toolbar(GtkWidget* window, MainToolbar* main_toolbar);

GtkWidget*
create_extended_toolbar(GtkWidget* window, ExtendedToolbar* extended_toolbar);

GtkWidget*
create_browser_toolbar(GtkWidget* window, BrowserToolbar* widzard_toolbar);

GtkWidget*
create_debug_toolbar(GtkWidget* window, DebugToolbar* debug_toolbar);

GtkWidget*
create_tag_menu (void);

#endif
