/*
    text_editor_menu.c
    Copyright (C) 2000  Kh. Naba Kumar Singh

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/
#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <sys/stat.h>
#include <unistd.h>
#include <string.h>

#include <gnome.h>


#include "support.h"
#include "text_editor_menu.h"
#include "anjuta.h"
#include "mainmenu_callbacks.h"
#include "toolbar_callbacks.h"
#include "global.h"

GnomeUIInfo text_editor_menu_options_submenu_uiinfo[] =
{
  {
    GNOME_APP_UI_TOGGLEITEM, N_("Line wrap"),
    NULL,
    on_text_editor_menu_line_wrap_activate, NULL, NULL,
    GNOME_APP_PIXMAP_NONE, NULL,
    0, 0, NULL
  },
  {
    GNOME_APP_UI_TOGGLEITEM, N_("Word wrap"),
    NULL,
    on_text_editor_menu_word_wrap_activate, NULL, NULL,
    GNOME_APP_PIXMAP_NONE, NULL,
    0, 0, NULL
  },
  GNOMEUIINFO_END
};

GnomeUIInfo text_editor_menu_uiinfo[] =
{
  {
    GNOME_APP_UI_ITEM, N_("Cut"),
    NULL,
    on_text_editor_menu_cut_activate, NULL, NULL,
    GNOME_APP_PIXMAP_NONE, NULL,
    0, 0, NULL
  },
  {
    GNOME_APP_UI_ITEM, N_("Copy"),
    NULL,
    on_text_editor_menu_copy_activate, NULL, NULL,
    GNOME_APP_PIXMAP_NONE, NULL,
    0, 0, NULL
  },
  {
    GNOME_APP_UI_ITEM, N_("Paste"),
    NULL,
    on_text_editor_menu_paste_activate, NULL, NULL,
    GNOME_APP_PIXMAP_NONE, NULL,
    GDK_v, GDK_CONTROL_MASK, NULL
  },
  GNOMEUIINFO_SEPARATOR,
  {
    GNOME_APP_UI_ITEM, N_("Hilight"),
    NULL,
    on_text_editor_menu_hilite_activate, NULL, NULL,
    GNOME_APP_PIXMAP_NONE, NULL,
    0, 0, NULL
  },
  {
    GNOME_APP_UI_ITEM, N_("Swap .h/.c"),
    NULL,
    on_text_editor_menu_swap_activate, NULL, NULL,
    GNOME_APP_PIXMAP_NONE, NULL,
    0, 0, NULL
  },
  GNOMEUIINFO_SEPARATOR,
  {
    GNOME_APP_UI_ITEM, N_("Function"),
    NULL,
    NULL, NULL, NULL,
    GNOME_APP_PIXMAP_NONE, NULL,
    0, 0, NULL
  },
  GNOMEUIINFO_SEPARATOR,
  {
    GNOME_APP_UI_SUBTREE, N_("Options"),
    NULL,
    text_editor_menu_options_submenu_uiinfo, NULL, NULL,
    GNOME_APP_PIXMAP_NONE, NULL,
    0, 0, NULL
  },
  GNOMEUIINFO_SEPARATOR,
  {
    GNOME_APP_UI_ITEM, N_("Close"),
    NULL,
    on_text_editor_menu_close_activate, NULL, NULL,
    GNOME_APP_PIXMAP_NONE, NULL,
    0, 0, NULL
  },
  GNOMEUIINFO_END
};

TextEditorMenu*
text_editor_menu_new()
{ 
  TextEditorMenu *tm;
  tm = (TextEditorMenu*)malloc(sizeof(TextEditorMenu));
  if(tm == NULL)return NULL;
  tm->line_wrap  = FALSE;
  tm->word_wrap = FALSE;
  create_text_editor_menu_gui(tm);
  return tm;
}

void
text_editor_menu_destroy(TextEditorMenu* tm)
{
  if(tm)
  {
    gtk_widget_unref(tm->GUI);
    gtk_widget_unref(tm->copy);
    gtk_widget_unref(tm->cut);
    gtk_widget_unref(tm->hilite);
    gtk_widget_unref(tm->swap);
    gtk_widget_unref(tm->functions);
    gtk_widget_unref(tm->line_wrap);
    gtk_widget_unref(tm->word_wrap);
    if(tm->GUI)gtk_widget_destroy(tm->GUI);
    free(tm);
    tm = NULL;
  }
}
 
void
text_editor_menu_popup(TextEditorMenu* menu, GdkEventButton* bevent)
{
   GList *funcs;
   GtkWidget *submenu;
   TextEditor *te;
   gchar* tmp;

   te = anjuta_get_current_text_editor();
   if(!te || !menu) return;
   funcs = tags_manager_get_function_list(app->tags_manager,
              te->filename);
   tmp = g_list_nth_data(funcs, 0);
   if(strlen(tmp)>0)
   {
     submenu =
        create_submenu(_("Functions "), funcs,
	   GTK_SIGNAL_FUNC
	   (on_text_editor_menu_function_activate));
     gtk_menu_item_set_submenu(GTK_MENU_ITEM
		  (menu->functions), submenu);
  }
  else
    gtk_widget_set_sensitive(menu->functions, FALSE);

  if(te->hilite_type == HILITE_NONE)
    gtk_widget_set_sensitive(menu->hilite, FALSE);
  else
    gtk_widget_set_sensitive(menu->hilite, TRUE);
  if(GTK_EDITABLE(te->widgets.editor)->has_selection)
  {
    gtk_widget_set_sensitive(menu->copy, TRUE);
    gtk_widget_set_sensitive(menu->cut, TRUE);
  }
  else
  {
    gtk_widget_set_sensitive(menu->copy, FALSE);
    gtk_widget_set_sensitive(menu->cut, FALSE);
  }

  gtk_menu_popup (GTK_MENU(menu->GUI), NULL, NULL, NULL, NULL,
                           bevent->button, bevent->time);  
}   

void
create_text_editor_menu_gui(TextEditorMenu* menu)
{
  if(menu)
  {
  GtkWidget  *text_editor_menu;

  text_editor_menu = gtk_menu_new ();
  gnome_app_fill_menu (GTK_MENU_SHELL (text_editor_menu), text_editor_menu_uiinfo,
                       NULL, FALSE, 0);
  menu->GUI = text_editor_menu;
  menu->copy = text_editor_menu_uiinfo[0].widget;
  menu->cut = text_editor_menu_uiinfo[1].widget;
  menu->hilite = text_editor_menu_uiinfo[4].widget;
  menu->swap = text_editor_menu_uiinfo[5].widget;
  menu->functions = text_editor_menu_uiinfo[7].widget;
  menu->line_wrap = text_editor_menu_options_submenu_uiinfo[0].widget;
  menu->word_wrap = text_editor_menu_options_submenu_uiinfo[1].widget;
  gtk_widget_ref(menu->GUI);
  gtk_widget_ref(menu->copy);
  gtk_widget_ref(menu->cut);
  gtk_widget_ref(menu->hilite);
  gtk_widget_ref(menu->swap);
  gtk_widget_ref(menu->functions);
  gtk_widget_ref(menu->line_wrap);
  gtk_widget_ref(menu->word_wrap);
  }
}

void
on_text_editor_menu_line_wrap_activate(GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  gboolean state; 
  TextEditor* te = anjuta_get_current_text_editor();
  state = GTK_ANTEXT(te->widgets.editor)->line_wrap;
  if (state == TRUE)  state = FALSE; else state = TRUE;
  gtk_antext_set_line_wrap(GTK_ANTEXT(te->widgets.editor), state);
}

void
on_text_editor_menu_word_wrap_activate(GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  gboolean state; 
  TextEditor* te = anjuta_get_current_text_editor();
  state = GTK_ANTEXT(te->widgets.editor)->word_wrap;
  if(state == TRUE)  state = FALSE; else state = TRUE;
  gtk_antext_set_word_wrap(GTK_ANTEXT(te->widgets.editor), state);
}

void
on_text_editor_menu_cut_activate(GtkMenuItem     *menuitem,
                                      gpointer         user_data)
{
  on_cut1_activate(NULL, NULL);
}

void
on_text_editor_menu_copy_activate(GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  on_copy1_activate(NULL, NULL);
}

void
on_text_editor_menu_paste_activate(GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  on_paste1_activate(NULL, NULL);
}

void
on_text_editor_menu_hilite_activate(GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  on_toolbar_hilite_clicked(NULL,NULL);
}

void
on_text_editor_menu_swap_activate(GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
	size_t len;
	gchar *newfname;
	TextEditor* te;

	newfname = NULL;
        te = anjuta_get_current_text_editor();
	if(!te) return;
        if(!te->full_filename) return;

	len=strlen(te->full_filename);
	while(len)
	{
		if(te->full_filename[len]=='.')
			break; 
		len--;
	}
	if(strcasecmp(&te->full_filename[len],".h")==0)
	{
		len++;
		newfname=g_malloc(len+4);    
		strcpy(newfname,te->full_filename);  /* copy original filename */
		strcpy(&newfname[len],"cc");
		if(!file_is_regular(newfname))
		{
			strcpy(&newfname[len],"cpp"); 	   
			if(!file_is_regular(newfname))
			{  
				newfname[len+1]=0;    /* test if *.c exist */
				if(!file_is_regular(newfname))
				{ 
					g_free(newfname);    /* must free up before return */ 
					return ;
				}
			}
		}
	}
	else if(strncasecmp(&te->full_filename[len],".c",2)==0 )
	{
		len++;
		newfname=g_strdup(te->full_filename);
		newfname[len]='h';
		newfname[len+1]=0;
		if(!file_is_regular(newfname))
		{ 
			g_free(newfname);	
			return ;	
		}	
	}
	if(newfname)     
        {
		anjuta_goto_file_line(newfname, -1);
		g_free( newfname );	
        }
}

void
on_text_editor_menu_function_activate(GtkMenuItem     *menuitem,
                                      gpointer         user_data)
{
  gchar *func = user_data;
  gchar* file;
  guint line;
  tags_manager_get_tag_info(app->tags_manager, func,
                                                    &file, &line);
  if(file)
  {
      anjuta_goto_file_line(file, line);
      g_free(file);
   }
}

void
on_text_editor_menu_close_activate(GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  on_close_file1_activate(NULL, NULL);
}
