/*
    src_paths.c
    Copyright (C) 2000  Kh. Naba Kumar Singh

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/
#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <sys/stat.h>
#include <unistd.h>
#include <string.h>

#include <gnome.h>
#include "anjuta.h"
#include "support.h"
#include "src_paths.h"

SrcPaths*
src_paths_new(void)
{
  SrcPaths* co
= g_malloc(sizeof(SrcPaths));
  if(co)
  {
    co->src_index = 0;
    co->is_showing = FALSE;
    co->win_pos_x = 100;
    co->win_pos_y = 100;
    create_src_paths_gui(co);
  }
  return co;
}

void
src_paths_destroy(SrcPaths* co)
{
  if(co)
  {
    gtk_widget_unref(co->widgets.window);

    gtk_widget_unref(co->widgets.src_clist);
    gtk_widget_unref(co->widgets.src_entry);
    gtk_widget_unref(co->widgets.src_add_b);
    gtk_widget_unref(co->widgets.src_update_b);
    gtk_widget_unref(co->widgets.src_remove_b);
    gtk_widget_unref(co->widgets.src_clear_b);

    if(co->widgets.window) gtk_widget_destroy(co->widgets.window);
    g_free(co);
  }
}

gboolean
src_paths_save_yourself(SrcPaths* co, FILE* s)
{
  if(s==NULL || co == NULL) return FALSE;
  if(fprintf(s, "Src paths: %d %d\n", co->win_pos_x, co->win_pos_y) < 2) return FALSE;
  return TRUE;
}

gint
src_paths_save(SrcPaths *co, FILE* f)
{
  gchar* text;
  gint      length, i;
  FILE* s;

  if(co==NULL)return FALSE;
  if(f != NULL) s = f;
  else
  {
	text = g_strconcat(app->dirs->settings, "/srcpaths.set", NULL);
	s = fopen(text, "w");
	if(s == NULL) return FALSE;
	fprintf(s,
	    "# **************************************************************************\n");
	fprintf(s,
	    _("# *********** DO NOT EDIT OR RENAME THIS FILE *****************\n"));
	fprintf(s,
	    _("# ******************* Created by  Anjuta ********************************\n"));
	fprintf(s,
	    _("# ******** Anjuta No-project source paths setting file ********\n"));
	fprintf(s,
	    "# **************************************************************************\n\n");
	fprintf(s,  "Anjuta: %s\n", VERSION);
  }

  length = g_list_length(GTK_CLIST(co->widgets.src_clist)->row_list);
  if(fprintf(s, "Source Paths Length = %d\n", length)<1){ if(!f) fclose(s);return FALSE;}
  for(i = 0; i<length; i++)
  {
      gtk_clist_get_text(GTK_CLIST(co->widgets.src_clist), i, 0, &text);
      if(!write_string(s,"Src_Path", text)){ if(!f) fclose(s);return FALSE;}
  }
  if(!f) fclose(s);
  return TRUE;
}

gboolean
src_paths_load_yourself(SrcPaths* co, FILE* s)
{
  if(s==NULL || co == NULL) return FALSE;
  if(fscanf(s, "Src paths: %d %d\n", &co->win_pos_x, &co->win_pos_y) < 2) return FALSE;
  return TRUE;
}

gint
src_paths_load(SrcPaths *co, FILE* f)
{
  gchar   *buff, buffer[256];
  gint      length, i;
  gchar* dummy[1];
  FILE* s;

  if(!co)return FALSE;
  if(f != NULL) s = f;
  else
  {
	buff = g_strconcat (app->dirs->settings, "/srcpaths.set", NULL);
	s = fopen(buff, "r");
	if(s == NULL) return FALSE;
	i=0;
	while (i < 6) {
		char ch;
		if ((ch = fgetc(s)) == EOF){fclose(s);return FALSE;}
		if (ch == '\n')
		    i++;
	    }
	if(fscanf(s, "Anjuta: %s\n", buffer)<1) {fclose(s);return FALSE;}
	if (strcmp(buffer, VERSION) != 0){ fclose(s);return FALSE;}
  }

  if(fscanf(s, "Source Paths Length = %d\n", &length)<1){ if(!f) fclose(s);return FALSE;}
  gtk_clist_clear(GTK_CLIST(co->widgets.src_clist));
  gtk_entry_set_text(GTK_ENTRY(co->widgets.src_entry), "");
  for(i = 0; i<length; i++)
  {
      if(!read_string(s, "Src_Path",  &buff)){ if(!f) fclose(s);return FALSE;}
      dummy[0] = buff;
      gtk_clist_append(GTK_CLIST(co->widgets.src_clist), dummy);
      g_free(buff);
  }
  if(!f) fclose(s);
  return TRUE;
}

void
src_paths_get(SrcPaths* co)
{
  src_paths_show(co);
}

void
src_paths_show(SrcPaths* co)
{
  if(!co)return;  
  src_paths_update_controls(co);

  if(co->is_showing)
  {
      gdk_window_raise(co->widgets.window->window);
      return;
  }
  gtk_widget_set_uposition(co->widgets.window, co->win_pos_x, co->win_pos_y);
  gtk_widget_show(co->widgets.window);
  co->is_showing = TRUE;
}

void src_paths_hide(SrcPaths* co)
{
   if(!co) return;
   if(co->is_showing == FALSE) return;
   gdk_window_get_root_origin(co ->widgets.window->window, &co->win_pos_x, &co->win_pos_y);
   gtk_widget_hide(co->widgets.window);
   co->is_showing = FALSE;
}

void
src_paths_update_controls(SrcPaths* co)
{
  gint length;

  length = g_list_length(GTK_CLIST(co->widgets.src_clist)->row_list);
  if(length < 2)
        gtk_widget_set_sensitive(co->widgets.src_clear_b, FALSE);
  else
        gtk_widget_set_sensitive(co->widgets.src_clear_b, TRUE);
  if(length < 1)
  {
    gtk_widget_set_sensitive(co->widgets.src_remove_b, FALSE);
    gtk_widget_set_sensitive(co->widgets.src_update_b, FALSE);
  }
  else
  {
    gtk_widget_set_sensitive(co->widgets.src_remove_b, TRUE);
    gtk_widget_set_sensitive(co->widgets.src_update_b, TRUE);
  }
}
