/*
    project_dbase_gui.c
    Copyright (C) 2000  Kh. Naba Kumar Singh

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/
#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <sys/stat.h>
#include <unistd.h>
#include <string.h>

#include <gnome.h>
#include "anjuta.h"
#include "project_dbase.h"
#include "project_dbase_cbs.h"
#include "utilities.h"
#include "support.h"


static GnomeUIInfo project_menu_uiinfo[] =
{
  {
    GNOME_APP_UI_ITEM, N_("Add source file"),
    NULL,
    on_prj_add_src_activate, NULL, NULL,
    GNOME_APP_PIXMAP_NONE, NULL,
    0, 0, NULL
  },
  {
    GNOME_APP_UI_ITEM, N_("Add document file"),
    NULL,
    on_prj_add_doc_activate, NULL, NULL,
    GNOME_APP_PIXMAP_NONE, NULL,
    0, 0, NULL
  },
  {
    GNOME_APP_UI_ITEM, N_("Add pixmap file"),
    NULL,
    on_prj_add_pix_activate, NULL, NULL,
    GNOME_APP_PIXMAP_NONE, NULL,
    0, 0, NULL
  },
  {
    GNOME_APP_UI_ITEM, N_("Add other file"),
    NULL,
    on_prj_add_other_activate, NULL, NULL,
    GNOME_APP_PIXMAP_NONE, NULL,
    0, 0, NULL
  },
  {
    GNOME_APP_UI_ITEM, N_("Add directory"),
    NULL,
    on_prj_add_dir_activate, NULL, NULL,
    GNOME_APP_PIXMAP_NONE, NULL,
    0, 0, NULL
  },
  GNOMEUIINFO_SEPARATOR,
  {
    GNOME_APP_UI_ITEM, N_("Open"),
    NULL,
    on_prj_view_src_activate, NULL, NULL,
    GNOME_APP_PIXMAP_NONE, NULL,
    0, 0, NULL
  },
  GNOMEUIINFO_SEPARATOR,
  {
    GNOME_APP_UI_ITEM, N_("Remove"),
    NULL,
    on_prj_remove_activate, NULL, NULL,
    GNOME_APP_PIXMAP_NONE, NULL,
    0, 0, NULL
  },
  GNOMEUIINFO_SEPARATOR,
  {
    GNOME_APP_UI_ITEM, N_("Configure project"),
    NULL,
    on_prj_configure_activate, NULL, NULL,
    GNOME_APP_PIXMAP_NONE, NULL,
    0, 0, NULL
  },
  {
    GNOME_APP_UI_ITEM, N_("Project Info"),
    NULL,
    on_prj_info_activate, NULL, NULL,
    GNOME_APP_PIXMAP_NONE, NULL,
    0, 0, NULL
  },
  GNOMEUIINFO_SEPARATOR,
  {
    GNOME_APP_UI_ITEM, N_("Dock/Undock"),
    NULL,
    on_prj_dock_undock_activate, NULL, NULL,
    GNOME_APP_PIXMAP_NONE, NULL,
    0, 0, NULL
  },
  {
    GNOME_APP_UI_ITEM, N_("Help"),
    NULL,
    on_prj_help_activate, NULL, NULL,
    GNOME_APP_PIXMAP_NONE, NULL,
    0, 0, NULL
  },
  GNOMEUIINFO_END
};

GtkWidget* create_project_menu (void);

GtkWidget*
create_project_menu ()
{
  GtkWidget *menu3;

  menu3 = gtk_menu_new ();
  gnome_app_fill_menu (GTK_MENU_SHELL (menu3), project_menu_uiinfo,
                       NULL, FALSE, 0);
  return menu3;
}

void
create_project_dbase_gui (ProjectDBase *p)
{
  GtkWidget *window1;
  GtkWidget *eventbox1;
  GtkWidget *scrolledwindow1;
  GtkWidget *ctree1;
  GtkCList    *clist1;

  window1 = gtk_window_new (GTK_WINDOW_TOPLEVEL);
  gtk_window_set_title (GTK_WINDOW (window1), _("Project: None"));

  eventbox1 = gtk_event_box_new();
  gtk_widget_show (eventbox1);
  gtk_container_add (GTK_CONTAINER (window1), eventbox1);

  scrolledwindow1 = gtk_scrolled_window_new (NULL, NULL);
  gtk_scrolled_window_set_policy (GTK_SCROLLED_WINDOW (scrolledwindow1), GTK_POLICY_ALWAYS, GTK_POLICY_ALWAYS);
  gtk_widget_show (scrolledwindow1);

  ctree1 = gtk_ctree_new (1,0);
  clist1 = &(GTK_CTREE(ctree1)->clist);
  gtk_clist_set_column_auto_resize (GTK_CLIST (ctree1), 0, TRUE);
  gtk_container_add (GTK_CONTAINER (scrolledwindow1), ctree1);
  gtk_clist_set_selection_mode (clist1, GTK_SELECTION_BROWSE);
  gtk_widget_show (ctree1);

  gtk_accel_group_attach( app->accel_group, GTK_OBJECT(window1));

  gtk_signal_connect (GTK_OBJECT (window1), "delete_event",
                      GTK_SIGNAL_FUNC (on_project_dbase_win_delete_event),
                      p);
  gtk_signal_connect (GTK_OBJECT (clist1), "select_row",
                      GTK_SIGNAL_FUNC (on_project_dbase_clist_select_row),
                      p);
  gtk_signal_connect (GTK_OBJECT (ctree1), "event",
                      GTK_SIGNAL_FUNC (on_project_dbase_event),
                      p);

  p->widgets.window = window1;
  p->widgets.client_area = eventbox1;
  p->widgets.client = scrolledwindow1;
  p->widgets.ctree = ctree1;
  p->widgets.scrolledwindow = scrolledwindow1;

  p->widgets.menu = create_project_menu();
  p->widgets.menu_add_src = project_menu_uiinfo[0].widget;
  p->widgets.menu_add_doc = project_menu_uiinfo[1].widget;
  p->widgets.menu_add_pix =  project_menu_uiinfo[2].widget;
  p->widgets.menu_add_other =  project_menu_uiinfo[3].widget;
  p->widgets.menu_add_dir =  project_menu_uiinfo[4].widget;
  p->widgets.menu_view =  project_menu_uiinfo[6].widget;
  p->widgets.menu_remove =  project_menu_uiinfo[8].widget;
  p->widgets.menu_configure =  project_menu_uiinfo[10].widget;
  p->widgets.menu_info =  project_menu_uiinfo[11].widget;
  
  gtk_widget_ref(p->widgets.window);
  gtk_widget_ref(p->widgets.client_area);
  gtk_widget_ref(p->widgets.client);
  gtk_widget_ref(p->widgets.scrolledwindow);
  gtk_widget_ref(p->widgets.ctree);
  gtk_widget_ref(p->widgets.menu);
  gtk_widget_ref(p->widgets.menu_add_src);
  gtk_widget_ref(p->widgets.menu_add_doc);
  gtk_widget_ref(p->widgets.menu_add_pix);
  gtk_widget_ref(p->widgets.menu_add_other); 
	gtk_widget_hide(p->widgets.menu_add_other);
  gtk_widget_ref(p->widgets.menu_add_dir);
	gtk_widget_hide(p->widgets.menu_add_dir);
  gtk_widget_ref(p->widgets.menu_remove);
  gtk_widget_ref(p->widgets.menu_view);
  gtk_widget_ref(p->widgets.menu_configure);
  gtk_widget_ref(p->widgets.menu_info);

}

GtkWidget*
create_project_dbase_info_gui (gchar *lab[])
{
  GtkWidget *dialog1;
  GtkWidget *dialog_vbox1;
  GtkWidget *frame1;
  GtkWidget *table1;
  GtkWidget *frame2;
  GtkWidget *label2;
  GtkWidget *frame3;
  GtkWidget *label4;
  GtkWidget *label5;
  GtkWidget *label1;
  GtkWidget *frame7;
  GtkWidget *label12;
  GtkWidget *frame8;
  GtkWidget *label14;
  GtkWidget *frame9;
  GtkWidget *label16;
  GtkWidget *frame10;
  GtkWidget *label18;
  GtkWidget *frame11;
  GtkWidget *label20;
  GtkWidget *label11;
  GtkWidget *label13;
  GtkWidget *label15;
  GtkWidget *label17;
  GtkWidget *label19;
  GtkWidget *label21;
  GtkWidget *frame12;
  GtkWidget *label22;
  GtkWidget *label23;
  GtkWidget *label3;
  GtkWidget *frame4;
  GtkWidget *label6;
  GtkWidget *label24;
  GtkWidget *frame13;
  GtkWidget *label25;
  GtkWidget *label26;
  GtkWidget *frame14;
  GtkWidget *label27;
  GtkWidget *frame15;
  GtkWidget *label28;
  GtkWidget *vseparator1;
  GtkWidget *label29;
  GtkWidget *frame16;
  GtkWidget *label30;
  GtkWidget *hseparator1;
  GtkWidget *hseparator2;
  GtkWidget *hseparator3;
  GtkWidget *hseparator4;
  GtkWidget *hseparator5;
  GtkWidget *hseparator6;
  GtkWidget *label31;
  GtkWidget *frame17;
  GtkWidget *label32;
  GtkWidget *dialog_action_area1;
  GtkWidget *button1;

  dialog1 = gnome_dialog_new (_("Anjuta: Project Information"), NULL);
  gnome_dialog_set_close (GNOME_DIALOG (dialog1), TRUE);

  dialog_vbox1 = GNOME_DIALOG (dialog1)->vbox;
  gtk_widget_show (dialog_vbox1);

  frame1 = gtk_frame_new (_(" Project Information "));
  gtk_widget_show (frame1);
  gtk_box_pack_start (GTK_BOX (dialog_vbox1), frame1, TRUE, TRUE, 0);

  table1 = gtk_table_new (11, 5, FALSE);
  gtk_widget_show (table1);
  gtk_container_add (GTK_CONTAINER (frame1), table1);

  frame2 = gtk_frame_new (NULL);
  gtk_widget_show (frame2);
  gtk_table_attach (GTK_TABLE (table1), frame2, 1, 2, 2, 3,
                    (GtkAttachOptions) (GTK_EXPAND | GTK_FILL),
                    (GtkAttachOptions) (GTK_FILL), 0, 0);
  gtk_container_set_border_width (GTK_CONTAINER (frame2), 3);
  gtk_frame_set_shadow_type (GTK_FRAME (frame2), GTK_SHADOW_IN);

  label2 = gtk_label_new (lab[0]);
  gtk_widget_show (label2);
  gtk_container_add (GTK_CONTAINER (frame2), label2);
  gtk_misc_set_padding (GTK_MISC (label2), 3, 0);

  frame3 = gtk_frame_new (NULL);
  gtk_widget_show (frame3);
  gtk_table_attach (GTK_TABLE (table1), frame3, 1, 2, 4, 5,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (GTK_FILL), 0, 0);
  gtk_container_set_border_width (GTK_CONTAINER (frame3), 3);
  gtk_frame_set_shadow_type (GTK_FRAME (frame3), GTK_SHADOW_IN);

  label4 = gtk_label_new (lab[1]);
  gtk_widget_show (label4);
  gtk_container_add (GTK_CONTAINER (frame3), label4);
  gtk_misc_set_padding (GTK_MISC (label4), 3, 0);

  label5 = gtk_label_new (_("Author(s):"));
  gtk_widget_show (label5);
  gtk_table_attach (GTK_TABLE (table1), label5, 0, 1, 5, 6,
                    (GtkAttachOptions) (0),
                    (GtkAttachOptions) (0), 0, 0);
  gtk_misc_set_padding (GTK_MISC (label5), 3, 0);

  label1 = gtk_label_new (_("Project Name:"));
  gtk_widget_show (label1);
  gtk_table_attach (GTK_TABLE (table1), label1, 0, 1, 2, 3,
                    (GtkAttachOptions) (0),
                    (GtkAttachOptions) (0), 0, 0);
  gtk_label_set_justify (GTK_LABEL (label1), GTK_JUSTIFY_LEFT);
  gtk_misc_set_padding (GTK_MISC (label1), 3, 0);

  frame7 = gtk_frame_new (NULL);
  gtk_widget_show (frame7);
  gtk_table_attach (GTK_TABLE (table1), frame7, 4, 5, 2, 3,
                    (GtkAttachOptions) (GTK_EXPAND | GTK_FILL),
                    (GtkAttachOptions) (GTK_FILL), 0, 0);
  gtk_container_set_border_width (GTK_CONTAINER (frame7), 3);
  gtk_frame_set_shadow_type (GTK_FRAME (frame7), GTK_SHADOW_IN);

  label12 = gtk_label_new (lab[6]);
  gtk_widget_show (label12);
  gtk_container_add (GTK_CONTAINER (frame7), label12);
  gtk_misc_set_padding (GTK_MISC (label12), 3, 0);

  frame8 = gtk_frame_new (NULL);
  gtk_widget_show (frame8);
  gtk_table_attach (GTK_TABLE (table1), frame8, 4, 5, 4, 5,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (GTK_FILL), 0, 0);
  gtk_container_set_border_width (GTK_CONTAINER (frame8), 3);
  gtk_frame_set_shadow_type (GTK_FRAME (frame8), GTK_SHADOW_IN);

  label14 = gtk_label_new (lab[7]);
  gtk_widget_show (label14);
  gtk_container_add (GTK_CONTAINER (frame8), label14);
  gtk_misc_set_padding (GTK_MISC (label14), 3, 0);

  frame9 = gtk_frame_new (NULL);
  gtk_widget_show (frame9);
  gtk_table_attach (GTK_TABLE (table1), frame9, 4, 5, 5, 6,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (GTK_FILL), 0, 0);
  gtk_container_set_border_width (GTK_CONTAINER (frame9), 3);
  gtk_frame_set_shadow_type (GTK_FRAME (frame9), GTK_SHADOW_IN);

  label16 = gtk_label_new (lab[8]);
  gtk_widget_show (label16);
  gtk_container_add (GTK_CONTAINER (frame9), label16);
  gtk_misc_set_padding (GTK_MISC (label16), 3, 0);

  frame10 = gtk_frame_new (NULL);
  gtk_widget_show (frame10);
  gtk_table_attach (GTK_TABLE (table1), frame10, 4, 5, 6, 7,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (GTK_FILL), 0, 0);
  gtk_container_set_border_width (GTK_CONTAINER (frame10), 3);
  gtk_frame_set_shadow_type (GTK_FRAME (frame10), GTK_SHADOW_IN);

  label18 = gtk_label_new (lab[9]);
  gtk_widget_show (label18);
  gtk_container_add (GTK_CONTAINER (frame10), label18);
  gtk_misc_set_padding (GTK_MISC (label18), 3, 0);

  frame11 = gtk_frame_new (NULL);
  gtk_widget_show (frame11);
  gtk_table_attach (GTK_TABLE (table1), frame11, 4, 5, 8, 9,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (GTK_FILL), 0, 0);
  gtk_container_set_border_width (GTK_CONTAINER (frame11), 3);
  gtk_frame_set_shadow_type (GTK_FRAME (frame11), GTK_SHADOW_IN);

  label20 = gtk_label_new (lab[10]);
  gtk_widget_show (label20);
  gtk_container_add (GTK_CONTAINER (frame11), label20);
  gtk_misc_set_padding (GTK_MISC (label20), 3, 0);

  label11 = gtk_label_new (_("Program Name:"));
  gtk_widget_show (label11);
  gtk_table_attach (GTK_TABLE (table1), label11, 3, 4, 2, 3,
                    (GtkAttachOptions) (0),
                    (GtkAttachOptions) (0), 3, 0);

  label13 = gtk_label_new (_("Source dir:"));
  gtk_widget_show (label13);
  gtk_table_attach (GTK_TABLE (table1), label13, 3, 4, 4, 5,
                    (GtkAttachOptions) (0),
                    (GtkAttachOptions) (0), 3, 0);

  label15 = gtk_label_new (_("Document dir:"));
  gtk_widget_show (label15);
  gtk_table_attach (GTK_TABLE (table1), label15, 3, 4, 5, 6,
                    (GtkAttachOptions) (0),
                    (GtkAttachOptions) (0), 3, 0);

  label17 = gtk_label_new (_("Pixmap dir:"));
  gtk_widget_show (label17);
  gtk_table_attach (GTK_TABLE (table1), label17, 3, 4, 6, 7,
                    (GtkAttachOptions) (0),
                    (GtkAttachOptions) (0), 3, 0);

  label19 = gtk_label_new (_("No of src files:"));
  gtk_widget_show (label19);
  gtk_table_attach (GTK_TABLE (table1), label19, 3, 4, 8, 9,
                    (GtkAttachOptions) (0),
                    (GtkAttachOptions) (0), 3, 0);

  label21 = gtk_label_new (_("No of doc files:"));
  gtk_widget_show (label21);
  gtk_table_attach (GTK_TABLE (table1), label21, 3, 4, 9, 10,
                    (GtkAttachOptions) (0),
                    (GtkAttachOptions) (0), 0, 0);

  frame12 = gtk_frame_new (NULL);
  gtk_widget_show (frame12);
  gtk_table_attach (GTK_TABLE (table1), frame12, 4, 5, 9, 10,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (GTK_FILL), 0, 0);
  gtk_container_set_border_width (GTK_CONTAINER (frame12), 3);
  gtk_frame_set_shadow_type (GTK_FRAME (frame12), GTK_SHADOW_IN);

  label22 = gtk_label_new (lab[11]);
  gtk_widget_show (label22);
  gtk_container_add (GTK_CONTAINER (frame12), label22);
  gtk_misc_set_padding (GTK_MISC (label22), 3, 0);

  label23 = gtk_label_new (_("No of pix files:"));
  gtk_widget_show (label23);
  gtk_table_attach (GTK_TABLE (table1), label23, 3, 4, 10, 11,
                    (GtkAttachOptions) (0),
                    (GtkAttachOptions) (0), 0, 0);

  label3 = gtk_label_new (_("Version:"));
  gtk_widget_show (label3);
  gtk_table_attach (GTK_TABLE (table1), label3, 0, 1, 4, 5,
                    (GtkAttachOptions) (0),
                    (GtkAttachOptions) (0), 0, 0);
  gtk_label_set_justify (GTK_LABEL (label3), GTK_JUSTIFY_LEFT);
  gtk_misc_set_padding (GTK_MISC (label3), 3, 0);

  frame4 = gtk_frame_new (NULL);
  gtk_widget_show (frame4);
  gtk_table_attach (GTK_TABLE (table1), frame4, 1, 2, 5, 7,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (GTK_FILL), 0, 0);
  gtk_container_set_border_width (GTK_CONTAINER (frame4), 3);
  gtk_frame_set_shadow_type (GTK_FRAME (frame4), GTK_SHADOW_IN);

  label6 = gtk_label_new (lab[2]);
  gtk_widget_show (label6);
  gtk_container_add (GTK_CONTAINER (frame4), label6);
  gtk_misc_set_padding (GTK_MISC (label6), 3, 0);

  label24 = gtk_label_new (_("Gui editable by Glade:"));
  gtk_widget_show (label24);
  gtk_table_attach (GTK_TABLE (table1), label24, 0, 1, 8, 9,
                    (GtkAttachOptions) (0),
                    (GtkAttachOptions) (0), 0, 0);
  gtk_misc_set_padding (GTK_MISC (label24), 3, 0);

  frame13 = gtk_frame_new (NULL);
  gtk_widget_show (frame13);
  gtk_table_attach (GTK_TABLE (table1), frame13, 1, 2, 8, 9,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (GTK_FILL), 0, 0);
  gtk_container_set_border_width (GTK_CONTAINER (frame13), 3);
  gtk_frame_set_shadow_type (GTK_FRAME (frame13), GTK_SHADOW_IN);

  label25 = gtk_label_new (lab[3]);
  gtk_widget_show (label25);
  gtk_container_add (GTK_CONTAINER (frame13), label25);
  gtk_misc_set_padding (GTK_MISC (label25), 3, 0);

  label26 = gtk_label_new (_("Makefiles managed:"));
  gtk_widget_show (label26);
  gtk_table_attach (GTK_TABLE (table1), label26, 0, 1, 9, 10,
                    (GtkAttachOptions) (0),
                    (GtkAttachOptions) (0), 0, 0);
  gtk_misc_set_padding (GTK_MISC (label26), 3, 0);

  frame14 = gtk_frame_new (NULL);
  gtk_widget_show (frame14);
  gtk_table_attach (GTK_TABLE (table1), frame14, 1, 2, 9, 10,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (GTK_FILL), 0, 0);
  gtk_container_set_border_width (GTK_CONTAINER (frame14), 3);
  gtk_frame_set_shadow_type (GTK_FRAME (frame14), GTK_SHADOW_IN);

  label27 = gtk_label_new (lab[4]);
  gtk_widget_show (label27);
  gtk_container_add (GTK_CONTAINER (frame14), label27);
  gtk_misc_set_padding (GTK_MISC (label27), 3, 0);

  frame15 = gtk_frame_new (NULL);
  gtk_widget_show (frame15);
  gtk_table_attach (GTK_TABLE (table1), frame15, 4, 5, 10, 11,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (GTK_FILL), 0, 0);
  gtk_container_set_border_width (GTK_CONTAINER (frame15), 3);
  gtk_frame_set_shadow_type (GTK_FRAME (frame15), GTK_SHADOW_IN);

  label28 = gtk_label_new (lab[12]);
  gtk_widget_show (label28);
  gtk_container_add (GTK_CONTAINER (frame15), label28);
  gtk_misc_set_padding (GTK_MISC (label28), 3, 0);

  vseparator1 = gtk_vseparator_new ();
  gtk_widget_show (vseparator1);
  gtk_table_attach (GTK_TABLE (table1), vseparator1, 2, 3, 1, 11,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (GTK_EXPAND | GTK_FILL), 3, 2);

  label29 = gtk_label_new (_("Gettext support:"));
  gtk_widget_show (label29);
  gtk_table_attach (GTK_TABLE (table1), label29, 0, 1, 10, 11,
                    (GtkAttachOptions) (0),
                    (GtkAttachOptions) (0), 0, 0);
  gtk_misc_set_padding (GTK_MISC (label29), 3, 0);

  frame16 = gtk_frame_new (NULL);
  gtk_widget_show (frame16);
  gtk_table_attach (GTK_TABLE (table1), frame16, 1, 2, 10, 11,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (GTK_FILL), 0, 0);
  gtk_container_set_border_width (GTK_CONTAINER (frame16), 3);
  gtk_frame_set_shadow_type (GTK_FRAME (frame16), GTK_SHADOW_IN);

  label30 = gtk_label_new (lab[5]);
  gtk_widget_show (label30);
  gtk_container_add (GTK_CONTAINER (frame16), label30);
  gtk_misc_set_padding (GTK_MISC (label30), 3, 0);

  hseparator1 = gtk_hseparator_new ();
  gtk_widget_show (hseparator1);
  gtk_table_attach (GTK_TABLE (table1), hseparator1, 0, 2, 7, 8,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (GTK_FILL), 0, 0);

  hseparator2 = gtk_hseparator_new ();
  gtk_widget_show (hseparator2);
  gtk_table_attach (GTK_TABLE (table1), hseparator2, 0, 2, 3, 4,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (GTK_FILL), 0, 0);

  hseparator3 = gtk_hseparator_new ();
  gtk_widget_show (hseparator3);
  gtk_table_attach (GTK_TABLE (table1), hseparator3, 0, 2, 1, 2,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (GTK_FILL), 0, 0);

  hseparator4 = gtk_hseparator_new ();
  gtk_widget_show (hseparator4);
  gtk_table_attach (GTK_TABLE (table1), hseparator4, 3, 5, 1, 2,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (GTK_FILL), 0, 0);

  hseparator5 = gtk_hseparator_new ();
  gtk_widget_show (hseparator5);
  gtk_table_attach (GTK_TABLE (table1), hseparator5, 3, 5, 3, 4,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (GTK_FILL), 0, 0);

  hseparator6 = gtk_hseparator_new ();
  gtk_widget_show (hseparator6);
  gtk_table_attach (GTK_TABLE (table1), hseparator6, 3, 5, 7, 8,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (GTK_FILL), 0, 0);

  label31 = gtk_label_new (_("Project Type:"));
  gtk_widget_show (label31);
  gtk_table_attach (GTK_TABLE (table1), label31, 0, 1, 0, 1,
                    (GtkAttachOptions) (0),
                    (GtkAttachOptions) (0), 0, 0);

  frame17 = gtk_frame_new (NULL);
  gtk_widget_show (frame17);
  gtk_table_attach (GTK_TABLE (table1), frame17, 1, 5, 0, 1,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (GTK_FILL), 0, 0);
  gtk_container_set_border_width (GTK_CONTAINER (frame17), 3);
  gtk_frame_set_shadow_type (GTK_FRAME (frame17), GTK_SHADOW_IN);

  label32 = gtk_label_new (lab[13]);
  gtk_widget_show (label32);
  gtk_container_add (GTK_CONTAINER (frame17), label32);
  gtk_misc_set_padding (GTK_MISC (label32), 3, 0);

  dialog_action_area1 = GNOME_DIALOG (dialog1)->action_area;
  gtk_widget_show (dialog_action_area1);
  gtk_button_box_set_layout (GTK_BUTTON_BOX (dialog_action_area1), GTK_BUTTONBOX_END);
  gtk_button_box_set_spacing (GTK_BUTTON_BOX (dialog_action_area1), 8);

  gnome_dialog_append_button (GNOME_DIALOG (dialog1), GNOME_STOCK_BUTTON_CLOSE);
  button1 = g_list_last (GNOME_DIALOG (dialog1)->buttons)->data;
  gtk_widget_show (button1);
  GTK_WIDGET_SET_FLAGS (button1, GTK_CAN_DEFAULT);

  return dialog1;
}

