/* GTK - The GIMP Toolkit
 * Copyright (C) 1995-1997 Peter Mattis, Spencer Kimball and Josh MacDonald
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#ifndef __GTK_ANEDITOR_H__
#define __GTK_ANEDITOR_H__
#include <gdk/gdk.h>
#include "gtkantext.h"


#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */


#define GTK_ANEDITOR(obj) GTK_CHECK_CAST (obj, gtk_aneditor_get_type (), GtkAnEditor)
#define GTK_ANEDITOR_CLASS(klass) \
  GTK_CHECK_CLASS_CAST (klass, gtk_aneditor_get_type (), GtkAnEditorClass)
#define GTK_IS_ANEDITOR(obj) GTK_CHECK_TYPE (obj, gtk_aneditor_get_type ())


  typedef struct _GtkAnEditor        GtkAnEditor;
  typedef struct _GtkAnEditorClass   GtkAnEditorClass;

  typedef struct _GtkAnEditorHilitePatterns GtkAnEditorHilitePatterns;
  typedef struct _GtkAnEditorHiliteRegexps  GtkAnEditorHiliteRegexps;
  typedef struct _GtkAnEditorHiliteColors   GtkAnEditorHiliteColors;
  typedef struct _GtkAnEditorHiliteFonts   GtkAnEditorHiliteFonts;

  struct _GtkAnEditorHilitePatterns {
    char *comment_start;
    char *comment_end;
    char *string_start;
    char *string_end;
    char *keywords;
  };

 struct _GtkAnEditorHiliteColors {
  GdkColormap *cmap;
  GdkColor plain;
  GdkColor comment;
  GdkColor string;
  GdkColor keywords;
 };

/* I put the fonts -Naba */
 struct _GtkAnEditorHiliteFonts {
  GdkFont *plain;
  GdkFont *comment;
  GdkFont *string;
  GdkFont *keyword;
 };

  struct _GtkAnEditor
  {
    GtkAnText text;

    /* --<indenter stuff>------------------------------------------------- */
    /* one_line_ind is used for one line indenter, and is called when
     * TAB is pressed.  If the function pointer is NULL, this is
     * ignored.  This functionallity is not really implemented
     * yet...the function is called alright, but there should be some
     * other API.
     */
    void (*one_line_ind) (GtkAnEditor *editor);

    /* --<hilite stuff>--------------------------------------------------- */
    /* Automatic highlighting. If this flag is true (default)
     * highlighting is done automatically, when nothing else is
     * happening.  Hightlighting takes a while, so on slow boxes, you
     * might consider turning this off, and handle hightligthing
     * yourself.  This can be done by calling gtk_aneditor_hilite_buffer. */
    gint hilite_when_idle : 1;

    /* don't worry about this */
    guint hilite_time;
    guint changed_from, changed_to;
    GtkAnEditorHiliteRegexps *regexps;
    GtkAnEditorHiliteColors  *colors;
    /* I put the fonts -Naba*/
    GtkAnEditorHiliteFonts  *fonts;
  };

  struct _GtkAnEditorClass
  {
    GtkAnTextClass parent_class;
  };

  /* widget stuff */
  guint          gtk_aneditor_get_type               (void);
  GtkWidget*     gtk_aneditor_new                    (GtkAdjustment *hadj,
						    GtkAdjustment *vadj);
  
  /* search stuff */
  gboolean      gtk_aneditor_search_from_point       (GtkAnEditor     *editor,
						    gchar         *string,
						    gboolean       casein);
  gboolean      gtk_aneditor_search_back_from_point  (GtkAnEditor     *editor, 
						    gchar         *string,
						    gboolean       casein);
  gint          gtk_aneditor_regex_search_from_point (GtkAnEditor     *editor,
						    gchar         *regex);
  gint     gtk_aneditor_regex_search_back_from_point (GtkAnEditor     *editor,
						    gchar         *regex);

  /* hide'n'show */
#if 0
  void          gtk_aneditor_hide_text               (GtkAnEditor     *editor,
						    guint          from,
						    guint          to,
						    gchar         *subs);
#endif

  /* syntax highlighting */
  GtkAnEditorHiliteRegexps *gtk_aneditor_new_regexps   (GtkAnEditorHilitePatterns
						                  *patterns);
  void           gtk_aneditor_destroy_regexps        (GtkAnEditorHiliteRegexps
						                  *regexps);
  gboolean       gtk_aneditor_set_patterns           (GtkAnEditor     *editor,
						    GtkAnEditorHilitePatterns
						                  *patterns);
  void           gtk_aneditor_set_regexps            (GtkAnEditor     *editor,
						    GtkAnEditorHiliteRegexps
						                  *regexps);
  void gtk_aneditor_set_colors (GtkAnEditor *editor,
	GdkColor *pc,
	GdkColor *cc,
	GdkColor *sc,
	GdkColor *kc);

  void gtk_aneditor_set_fonts (GtkAnEditor *editor,
	GdkFont *pf,
	GdkFont *cf,
	GdkFont *sf,
	GdkFont *kf);

  void gtk_aneditor_flush_properties (GtkAnEditor *editor);

  gboolean       gtk_aneditor_upd_regexps            (GtkAnEditor     *editor,
						    GtkAnEditorHilitePatterns
						                  *patterns);
  void           gtk_aneditor_hilite_buffer          (GtkAnEditor     *editor);


#ifdef __cplusplus
}
#endif /* __cplusplus */


#endif /* __GTK_ANEDITOR_H__ */

