/*
    executer.h
    Copyright (C) 2000  Kh. Naba Kumar Singh

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/
#ifndef _EXECUTE_H_
#define _EXECUTE_H_

typedef struct _Executer Executer;

struct _Executer
{
  gchar    *args;
  GList    *args_history;
  gboolean    terminal;
};  

GtkWidget*
create_executer_dialog(Executer*);

Executer*
executer_new(void);

void
executer_show(Executer*);

/* Executer is auto hide */

void
executer_destroy(Executer*);

/* private */

void
executer_execute (Executer *e);

void
on_executer_combo_realize              (GtkWidget       *widget,
                                        gpointer         user_data);

void
on_executer_entry_changed              (GtkEditable     *editable,
                                        gpointer         user_data);

void
on_executer_checkbutton_toggled        (GtkToggleButton *togglebutton,
                                        gpointer         user_data);

void
on_executer_checkbutton_realize        (GtkWidget       *widget,
                                        gpointer         user_data);

void
on_configure_combo_realize             (GtkWidget       *widget,
                                        gpointer         user_data);

void
on_configure_entry_changed             (GtkEditable     *editable,
                                        gpointer         user_data);

void
on_configure_checkbutton_toggled       (GtkToggleButton *togglebutton,
                                        gpointer         user_data);

void
on_configure_checkbutton_realize       (GtkWidget       *widget,
                                        gpointer         user_data);

#endif
