/* 
    controls.h
    Copyright (C) 2000  Kh. Naba Kumar Singh

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/
#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include "launcher.h"
#include "text_editor.h"
#include "debugger.h"
#include "toolbar.h"
#include "anjuta.h"
#include "utilities.h"
#include "controls.h"

void
update_main_menubar();

void
debug_toolbar_update()
{
  DebugToolbar *dt;
  gboolean A, R, Pr, Ld;
  dt = &(app->widgets.toolbar.debug_toolbar);
  A = debugger_is_active();
  R = debugger_is_ready();
  Pr = debugger.prog_is_running;
  Ld = TRUE;

  gtk_widget_set_sensitive(dt->go, A && R && Ld);
  gtk_widget_set_sensitive(dt->step_in, A && R && Ld);
  gtk_widget_set_sensitive(dt->step_over, A && R && Pr);
  gtk_widget_set_sensitive(dt->step_out, A && R && Pr);
  gtk_widget_set_sensitive(dt->toggle_bp, A && R && Ld);
  gtk_widget_set_sensitive(dt->inspect, A && R && Pr && Ld);
  gtk_widget_set_sensitive(dt->interrupt, A && !R && Pr && Ld);
  gtk_widget_set_sensitive(dt->frame, A && R && Pr && Ld);
  gtk_widget_set_sensitive(dt->stop, A);

  update_main_menubar();
}


void
main_toolbar_update()
{
  MainToolbar *mt;
  gboolean F, S, C, UD, RD;
  TextEditor *te;

  mt = &(app->widgets.toolbar.main_toolbar);
  te = anjuta_get_current_text_editor();
  if(te)
  {
     F = TRUE;
     RD = (te->undo_index > 0);
     UD  = (te->undo_index  < g_list_length(te->undo_list));
     S = (te->status == TEXT_EDITOR_SAVED);
     switch(get_file_ext_type(te->filename))
     {
     case FILE_EXT_TYPE_C:
     case FILE_EXT_TYPE_CPP:
     case FILE_EXT_TYPE_IC:
     case FILE_EXT_TYPE_ICPP:
     case FILE_EXT_TYPE_H:
                C = TRUE;
                break;
     case FILE_EXT_TYPE_XPM:
     default:
                C = FALSE;
     }
  }
  else
     F = S = C = UD = RD = FALSE;
   gtk_widget_set_sensitive(mt->save, F && !S);
   gtk_widget_set_sensitive(mt->save_all,
                     (g_list_length(app->text_editor_list) > 0));
   gtk_widget_set_sensitive(mt->close, F);
   gtk_widget_set_sensitive(mt->reload, F);
   gtk_widget_set_sensitive(mt->undo, F && UD);
   gtk_widget_set_sensitive(mt->redo, F && RD);
   gtk_widget_set_sensitive(mt->detach, F);
   gtk_widget_set_sensitive(mt->print, F);
   gtk_widget_set_sensitive(mt->find, F);
   gtk_widget_set_sensitive(mt->find_combo, F);
   gtk_widget_set_sensitive(mt->go_to, F);
   gtk_widget_set_sensitive(mt->line_entry, F);
   update_main_menubar();
}

void
extended_toolbar_update()
{
  gboolean P, F, L, A, C;
  ExtendedToolbar *et;
  TextEditor *te;

  et = &(app->widgets.toolbar.extended_toolbar);
  P = app->project_dbase->project_is_open;
  L = launcher_is_busy();
  A = debugger_is_active();
  te = anjuta_get_current_text_editor();
  if(te == NULL)
  {
	F  = FALSE;
	C = FALSE;
  }
  else
  {
     switch(get_file_ext_type(te->filename))
     {
     case FILE_EXT_TYPE_C:
     case FILE_EXT_TYPE_CPP:
     case FILE_EXT_TYPE_ASM:
     case FILE_EXT_TYPE_IC:
     case FILE_EXT_TYPE_ICPP:
                F = TRUE;
                break;
     case FILE_EXT_TYPE_H:
     case FILE_EXT_TYPE_XPM:
     default:
                F = FALSE;
     }
     switch(get_file_ext_type(te->filename))
     {
     case FILE_EXT_TYPE_C:
     case FILE_EXT_TYPE_CPP:
     case FILE_EXT_TYPE_IC:
     case FILE_EXT_TYPE_ICPP:
     case FILE_EXT_TYPE_H:
                C = TRUE;
                break;
     case FILE_EXT_TYPE_XPM:
     default:
                C = FALSE;
     }
   }
   gtk_widget_set_sensitive(et->open_project, !P);
   gtk_widget_set_sensitive(et->save_project, P);
   gtk_widget_set_sensitive(et->close_project, P);
   gtk_widget_set_sensitive(et->hilite, C);
   gtk_widget_set_sensitive(et->indent, C);
   gtk_widget_set_sensitive(et->compile, F && !L);
   gtk_widget_set_sensitive(et->configure, P && !L);
   gtk_widget_set_sensitive(et->build, (F||P) && !L);
   gtk_widget_set_sensitive(et->build_all, P && !L);
   gtk_widget_set_sensitive(et->exec, (F||P) && !L);
   gtk_widget_set_sensitive(et->debug, !L);
   gtk_widget_set_sensitive(et->stop, !A && L);
   update_main_menubar();
}

void
update_main_menubar()
{
  FileSubMenu *fm;
  EditSubMenu *em;
  ViewSubMenu *vm;
  ProjectSubMenu *pm;
  FormatSubMenu *ftm;
  BuildSubMenu    *bm;
  BookmarkSubMenu *mm;
  WindowsSubMenu *wm;
  DebugSubMenu *dm;
  UtilitiesSubMenu *um;
  HelpSubMenu *hm;
  gboolean F, P, SL, SF, L, G, A, R, Pr, UD, RD, Ld, C;
  TextEditor *te;

  fm = &(app->widgets.menubar.file);
  em = &(app->widgets.menubar.edit);
  vm = &(app->widgets.menubar.view);
  pm = &(app->widgets.menubar.project);
  ftm = &(app->widgets.menubar.format);
  bm = &(app->widgets.menubar.build);
  mm = &(app->widgets.menubar.bookmark);
  wm = &(app->widgets.menubar.windows);
  dm = &(app->widgets.menubar.debug);
  um = &(app->widgets.menubar.utilities);
  hm = &(app->widgets.menubar.help);

  P = app->project_dbase->project_is_open;
  if(P)
      G = app->project_dbase->project_has_gui;
  else
      G = FALSE;
  L = launcher_is_busy();

  te = anjuta_get_current_text_editor();
  if(te == NULL)
  {
    F  = FALSE;
    SF = FALSE;
    SL = FALSE;
    UD = RD = FALSE;
    C = FALSE;
  }
  else
  {
    F = TRUE;
     RD = (te->undo_index > 0);
     UD  = (te->undo_index  < g_list_length(te->undo_list));
    if(te->status == TEXT_EDITOR_SAVED) SF = TRUE;
    else SF = FALSE;
    SL = TRUE; /* Text selection. I don't know what to do with it. */
    switch(get_file_ext_type(te->filename))
    {
     case FILE_EXT_TYPE_C:
     case FILE_EXT_TYPE_CPP:
     case FILE_EXT_TYPE_IC:
     case FILE_EXT_TYPE_ICPP:
     case FILE_EXT_TYPE_H:
                C = TRUE;
                break;
     case FILE_EXT_TYPE_XPM:
     default:
                C = FALSE;
    }
  }
  A = debugger_is_active();
  R = debugger_is_ready();
  Pr = debugger.prog_is_running;
  Ld = TRUE;

   gtk_widget_set_sensitive(fm->save_file, F && !SF);
   gtk_widget_set_sensitive(fm->save_as_file, F);
   gtk_widget_set_sensitive(fm->save_all_file,
                     (g_list_length(app->text_editor_list) > 0));
   gtk_widget_set_sensitive(fm->close_file, F);
   gtk_widget_set_sensitive(fm->reload_file, F);
   gtk_widget_set_sensitive(fm->save_project, P);
   gtk_widget_set_sensitive(fm->close_project, P);

   gtk_widget_set_sensitive(fm->rename, F);
   gtk_widget_set_sensitive(fm->print, F);

   gtk_widget_set_sensitive(em->undo, F && UD);
   gtk_widget_set_sensitive(em->redo, F && RD);
   gtk_widget_set_sensitive(em->cut, F && SL);
   gtk_widget_set_sensitive(em->copy, F && SL);
   gtk_widget_set_sensitive(em->paste, F);
   gtk_widget_set_sensitive(em->clear, F&&SL);
   gtk_widget_set_sensitive(em->select_all, F);
   gtk_widget_set_sensitive(em->find, F);
   gtk_widget_set_sensitive(em->find_in_files, !L);
   gtk_widget_set_sensitive(em->find_replace, F);
   gtk_widget_set_sensitive(em->goto_line, F);
   gtk_widget_set_sensitive(em->edit_app_gui, P && G);

   gtk_widget_set_sensitive(pm->add_src, P);
   gtk_widget_set_sensitive(pm->add_pix, P);
   gtk_widget_set_sensitive(pm->add_doc, P);
   gtk_widget_set_sensitive(pm->add_other, P);
   gtk_widget_set_sensitive(pm->add_dir, P);
   gtk_widget_set_sensitive(pm->remove, P);
   gtk_widget_set_sensitive(pm->readme, P);
   gtk_widget_set_sensitive(pm->todo, P);
   gtk_widget_set_sensitive(pm->changelog, P);
   gtk_widget_set_sensitive(pm->news, P);
   gtk_widget_set_sensitive(pm->configure, P);
   gtk_widget_set_sensitive(pm->info, P);

   gtk_widget_set_sensitive(ftm->hilite, C);
   gtk_widget_set_sensitive(ftm->indent, C);
   gtk_widget_set_sensitive(ftm->update_tags, F || P);
   gtk_widget_set_sensitive(ftm->line_wrap, F);
   gtk_widget_set_sensitive(ftm->word_wrap, F);
   gtk_widget_set_sensitive(ftm->detach, F);

   gtk_widget_set_sensitive(bm->compile, F && !L);
   gtk_widget_set_sensitive(bm->build, (F||P) && !L);
   gtk_widget_set_sensitive(bm->build_all, P && !L);
   gtk_widget_set_sensitive(bm->install, P && !L);
   gtk_widget_set_sensitive(bm->build_dist, P && !L);
   gtk_widget_set_sensitive(bm->configure, P && !L);
   gtk_widget_set_sensitive(bm->autogen, P && !L);
   gtk_widget_set_sensitive(bm->clean, P && !L);
   gtk_widget_set_sensitive(bm->clean_all, P && !L);
   gtk_widget_set_sensitive(bm->stop_build, !A && L);
   gtk_widget_set_sensitive(bm->execute, (F||P) && !L);
   gtk_widget_set_sensitive(bm->execute_params, (F||P));

   gtk_widget_set_sensitive(mm->toggle, F);
   gtk_widget_set_sensitive(mm->prev, TRUE);
   gtk_widget_set_sensitive(mm->next, TRUE);
   gtk_widget_set_sensitive(mm->last, TRUE);
   gtk_widget_set_sensitive(mm->clear, TRUE);

   gtk_widget_set_sensitive(wm->close, F);

  gtk_widget_set_sensitive(dm->start_debug, !L);
  gtk_widget_set_sensitive(dm->open_exec, A && R);
  gtk_widget_set_sensitive(dm->load_core, A && R);
  gtk_widget_set_sensitive(dm->attach, A && R);
  gtk_widget_set_sensitive(dm->restart, A && R && Pr && !debugger.prog_is_attached);
  gtk_widget_set_sensitive(dm->stop_prog, A && Pr && R && !debugger.prog_is_attached);
  gtk_widget_set_sensitive(dm->detach, A && R && Pr && debugger.prog_is_attached);
  gtk_widget_set_sensitive(dm->cont, A&&R && Ld);
  gtk_widget_set_sensitive(dm->step_in, A && R && Ld);
  gtk_widget_set_sensitive(dm->step_over, A && R && Pr);
  gtk_widget_set_sensitive(dm->step_out, A && R && Pr);
  gtk_widget_set_sensitive(dm->run_to_cursor, A && R && Ld);
  gtk_widget_set_sensitive(dm->tog_break, A && R && Ld);
  gtk_widget_set_sensitive(dm->set_break, A && R && Ld);
  gtk_widget_set_sensitive(dm->show_breakpoints, A && R && Ld);
  gtk_widget_set_sensitive(dm->disable_all_breakpoints, A && R && Ld);
  gtk_widget_set_sensitive(dm->clear_all_breakpoints, A && R && Ld);
  gtk_widget_set_sensitive(dm->interrupt, A && !R && Pr);
  gtk_widget_set_sensitive(dm->send_signal, A && Pr);
  gtk_widget_set_sensitive(dm->inspect, A && R && Pr);
  gtk_widget_set_sensitive(dm->add_watch, A && R);
  gtk_widget_set_sensitive(dm->stop, A);

  gtk_widget_set_sensitive(dm->info_targets, A && R);
  gtk_widget_set_sensitive(dm->info_program, A && R);
  gtk_widget_set_sensitive(dm->info_udot, A && R);
  gtk_widget_set_sensitive(dm->info_threads, A && R);
  gtk_widget_set_sensitive(dm->info_variables, A && R);
  gtk_widget_set_sensitive(dm->info_locals, A && R);
  gtk_widget_set_sensitive(dm->info_frame, A && R);
  gtk_widget_set_sensitive(dm->info_args, A && R);

  update_led_animator();
}

void
update_led_animator()
{
  GnomeAnimator* led;
  gboolean A, L, R;

  A = debugger_is_active();
  R = debugger_is_ready();
  L = launcher_is_busy();

  led = GNOME_ANIMATOR(app->widgets.toolbar.main_toolbar.led);
  if(L && !A) gnome_animator_start(led);
  else if(!L && !A)
  {
	  gnome_animator_stop(led);
	  gnome_animator_goto_frame(led, 0);
  }
  else
  {
	if(!R) gnome_animator_start(led);
	else
	{
	  gnome_animator_stop(led);
	  gnome_animator_goto_frame(led, 0);
	}
  }
}
