/*
 * compiler_options_gui.c Copyright (C) 2000  Kh. Naba Kumar Singh
 * 
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the Free 
 * Software Foundation; either version 2 of the License, or (at your option)
 * any later version.
 * 
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY 
 * or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * for more details.
 * 
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc., 59 
 * Temple Place, Suite 330, Boston, MA  02111-1307  USA 
 */
#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif


#include <sys/stat.h>
#include <unistd.h>
#include <string.h>

#include <gnome.h>

#include "anjuta.h"
#include "compiler_options.h"
#include "compiler_options_cbs.h"
#include "support.h"

GtkWidget *create_compiler_options_page0 (CompilerOptions * co);

GtkWidget *create_compiler_options_page1 (CompilerOptions * co);

GtkWidget *create_compiler_options_page2 (CompilerOptions * co);

GtkWidget *create_compiler_options_page3 (CompilerOptions * co);

void
create_compiler_options_gui (CompilerOptions * co)
{
  GtkWidget *window1;
  GtkWidget *dialog1;
  GtkWidget *dialog_vbox1;
  GtkWidget *notebook1;
  GtkWidget *frame4;
  GtkWidget *hbox1;
  GtkWidget *vbox1;
  GSList *vbox1_group = NULL;
  GtkWidget *radiobutton1;
  GtkWidget *radiobutton2;
  GtkWidget *radiobutton3;
  GtkWidget *radiobutton4;
  GtkWidget *vseparator1;
  GtkWidget *label7;
  GtkWidget *label2;
  GtkWidget *scrolledwindow1;
  GtkWidget *viewport1;
  GtkWidget *table2;
  GtkWidget *checkbutton1;
  GtkWidget *checkbutton2;
  GtkWidget *checkbutton3;
  GtkWidget *checkbutton4;
  GtkWidget *checkbutton5;
  GtkWidget *checkbutton6;
  GtkWidget *checkbutton7;
  GtkWidget *checkbutton8;
  GtkWidget *checkbutton9;
  GtkWidget *checkbutton10;
  GtkWidget *checkbutton11;
  GtkWidget *checkbutton12;
  GtkWidget *checkbutton13;
  GtkWidget *checkbutton14;
  GtkWidget *checkbutton15;
  GtkWidget *label3;
  GtkWidget *frame5;
  GtkWidget *vbox2;
  GSList *vbox2_group = NULL;
  GtkWidget *radiobutton5;
  GtkWidget *radiobutton6;
  GtkWidget *radiobutton7;
  GtkWidget *radiobutton8;
  GtkWidget *hseparator1;
  GtkWidget *label13;
  GtkWidget *label4;
  GtkWidget *frame6;
  GtkWidget *vbox3;
  GtkWidget *checkbutton20;
  GtkWidget *checkbutton21;
  GtkWidget *checkbutton22;
  GtkWidget *hseparator2;
  GtkWidget *frame7;
  GtkWidget *entry1;
  GtkWidget *label5;
  GtkWidget *dialog_action_area1;
  GtkWidget *comopt_ok;
  GtkWidget *comopt_apply;
  GtkWidget *comopt_help;
  GtkWidget *comopt_cancel;
  GtkWidget *tmp_widget;
  GtkWidget *label101;
  GtkWidget *label102;
  GtkWidget *label103;
  GtkWidget *label111;
  GtkWidget *frame;
  gint i;

  dialog1 = gnome_dialog_new (_("Compiler Options"), NULL);
  gtk_window_set_policy (GTK_WINDOW (dialog1), FALSE, FALSE, FALSE);
  gnome_dialog_close_hides (GNOME_DIALOG (dialog1), TRUE);

  dialog_vbox1 = GNOME_DIALOG (dialog1)->vbox;
  gtk_widget_show (dialog_vbox1);

  window1 = dialog1;

  notebook1 = gtk_notebook_new ();
  gtk_widget_show (notebook1);
  gtk_box_pack_start (GTK_BOX (dialog_vbox1), notebook1, TRUE, TRUE, 0);

  tmp_widget = create_compiler_options_page0 (co);
  gtk_container_add (GTK_CONTAINER (notebook1), tmp_widget);

  label101 = gtk_label_new (_("Include Paths"));
  gtk_widget_show (label101);
  gtk_notebook_set_tab_label (GTK_NOTEBOOK (notebook1),
			      gtk_notebook_get_nth_page (GTK_NOTEBOOK
							 (notebook1), 0),
			      label101);

  tmp_widget = create_compiler_options_page3 (co);
  gtk_container_add (GTK_CONTAINER (notebook1), tmp_widget);

  label111 = gtk_label_new (_("Library Paths"));
  gtk_widget_show (label111);
  gtk_notebook_set_tab_label (GTK_NOTEBOOK (notebook1),
			      gtk_notebook_get_nth_page (GTK_NOTEBOOK
							 (notebook1), 1),
			      label111);

  tmp_widget = create_compiler_options_page1 (co);
  gtk_container_add (GTK_CONTAINER (notebook1), tmp_widget);

  label102 = gtk_label_new (_("Libraries"));
  gtk_widget_show (label102);
  gtk_notebook_set_tab_label (GTK_NOTEBOOK (notebook1),
			      gtk_notebook_get_nth_page (GTK_NOTEBOOK
							 (notebook1), 2),
			      label102);

  tmp_widget = create_compiler_options_page2 (co);
  gtk_container_add (GTK_CONTAINER (notebook1), tmp_widget);

  label103 = gtk_label_new (_("Defines"));
  gtk_widget_show (label103);
  gtk_notebook_set_tab_label (GTK_NOTEBOOK (notebook1),
			      gtk_notebook_get_nth_page (GTK_NOTEBOOK
							 (notebook1), 3),
			      label103);

  frame4 = gtk_frame_new (NULL);
  gtk_widget_show (frame4);
  gtk_container_add (GTK_CONTAINER (notebook1), frame4);
  gtk_container_set_border_width (GTK_CONTAINER (frame4), 5);

  hbox1 = gtk_hbox_new (FALSE, 0);
  gtk_widget_show (hbox1);
  gtk_container_add (GTK_CONTAINER (frame4), hbox1);

  vbox1 = gtk_vbox_new (FALSE, 0);
  gtk_widget_show (vbox1);
  gtk_box_pack_start (GTK_BOX (hbox1), vbox1, TRUE, TRUE, 0);

  radiobutton1 = gtk_radio_button_new_with_label (vbox1_group, _("None"));
  vbox1_group = gtk_radio_button_group (GTK_RADIO_BUTTON (radiobutton1));
  gtk_widget_show (radiobutton1);
  gtk_box_pack_start (GTK_BOX (vbox1), radiobutton1, FALSE, FALSE, 0);
  gtk_container_set_border_width (GTK_CONTAINER (radiobutton1), 5);
  gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (radiobutton1), TRUE);

  radiobutton2 = gtk_radio_button_new_with_label (vbox1_group, _("Glib"));
  vbox1_group = gtk_radio_button_group (GTK_RADIO_BUTTON (radiobutton2));
  gtk_widget_show (radiobutton2);
  gtk_box_pack_start (GTK_BOX (vbox1), radiobutton2, FALSE, FALSE, 0);
  gtk_container_set_border_width (GTK_CONTAINER (radiobutton2), 5);

  radiobutton3 = gtk_radio_button_new_with_label (vbox1_group, _("Gtk"));
  vbox1_group = gtk_radio_button_group (GTK_RADIO_BUTTON (radiobutton3));
  gtk_widget_show (radiobutton3);
  gtk_box_pack_start (GTK_BOX (vbox1), radiobutton3, FALSE, FALSE, 0);
  gtk_container_set_border_width (GTK_CONTAINER (radiobutton3), 5);

  radiobutton4 = gtk_radio_button_new_with_label (vbox1_group, _("Gnome"));
  vbox1_group = gtk_radio_button_group (GTK_RADIO_BUTTON (radiobutton4));
  gtk_widget_show (radiobutton4);
  gtk_box_pack_start (GTK_BOX (vbox1), radiobutton4, FALSE, FALSE, 0);
  gtk_container_set_border_width (GTK_CONTAINER (radiobutton4), 5);

  vseparator1 = gtk_vseparator_new ();
  gtk_widget_show (vseparator1);
  gtk_box_pack_start (GTK_BOX (hbox1), vseparator1, FALSE, TRUE, 0);

  label7 =
    gtk_label_new (_
		   ("Support will add all the neccessary include paths and libraries required for the compilation of the source."));
  gtk_widget_show (label7);
  gtk_box_pack_start (GTK_BOX (hbox1), label7, TRUE, TRUE, 0);
  gtk_label_set_justify (GTK_LABEL (label7), GTK_JUSTIFY_FILL);
  gtk_label_set_line_wrap (GTK_LABEL (label7), TRUE);

  label2 = gtk_label_new (_("Supports"));
  gtk_widget_show (label2);
  gtk_notebook_set_tab_label (GTK_NOTEBOOK (notebook1),
			      gtk_notebook_get_nth_page (GTK_NOTEBOOK
							 (notebook1), 4),
			      label2);

  scrolledwindow1 = gtk_scrolled_window_new (NULL, NULL);
  gtk_widget_show (scrolledwindow1);
  gtk_container_add (GTK_CONTAINER (notebook1), scrolledwindow1);
  gtk_scrolled_window_set_policy (GTK_SCROLLED_WINDOW (scrolledwindow1),
				  GTK_POLICY_AUTOMATIC, GTK_POLICY_AUTOMATIC);

  viewport1 = gtk_viewport_new (NULL, NULL);
  gtk_widget_show (viewport1);
  gtk_container_add (GTK_CONTAINER (scrolledwindow1), viewport1);

  table2 = gtk_table_new (15, 1, FALSE);
  gtk_widget_show (table2);
  gtk_container_add (GTK_CONTAINER (viewport1), table2);

  checkbutton1 = gtk_check_button_new_with_label (_("No Warnings"));
  gtk_widget_show (checkbutton1);
  gtk_table_attach (GTK_TABLE (table2), checkbutton1, 0, 1, 0, 1,
		    (GtkAttachOptions) (GTK_FILL),
		    (GtkAttachOptions) (0), 0, 0);

  checkbutton2 = gtk_check_button_new_with_label (_("All Warnings"));
  gtk_widget_show (checkbutton2);
  gtk_table_attach (GTK_TABLE (table2), checkbutton2, 0, 1, 1, 2,
		    (GtkAttachOptions) (GTK_FILL),
		    (GtkAttachOptions) (0), 0, 0);
  gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (checkbutton2), TRUE);

  checkbutton3 =
    gtk_check_button_new_with_label (_("Warning for Implicit declarations"));
  gtk_widget_show (checkbutton3);
  gtk_table_attach (GTK_TABLE (table2), checkbutton3, 0, 1, 2, 3,
		    (GtkAttachOptions) (GTK_FILL),
		    (GtkAttachOptions) (0), 0, 0);

  checkbutton4 =
    gtk_check_button_new_with_label (_("Warning for mismached Return types"));
  gtk_widget_show (checkbutton4);
  gtk_table_attach (GTK_TABLE (table2), checkbutton4, 0, 1, 3, 4,
		    (GtkAttachOptions) (GTK_FILL),
		    (GtkAttachOptions) (0), 0, 0);

  checkbutton5 =
    gtk_check_button_new_with_label (_("Warning for Unused Variables"));
  gtk_widget_show (checkbutton5);
  gtk_table_attach (GTK_TABLE (table2), checkbutton5, 0, 1, 4, 5,
		    (GtkAttachOptions) (GTK_FILL),
		    (GtkAttachOptions) (0), 0, 0);

  checkbutton6 =
    gtk_check_button_new_with_label (_
				     ("Warning for unhandled Switch case with enums"));
  gtk_widget_show (checkbutton6);
  gtk_table_attach (GTK_TABLE (table2), checkbutton6, 0, 1, 5, 6,
		    (GtkAttachOptions) (GTK_FILL),
		    (GtkAttachOptions) (0), 0, 0);

  checkbutton7 =
    gtk_check_button_new_with_label (_("Warning for nested Comment"));
  gtk_widget_show (checkbutton7);
  gtk_table_attach (GTK_TABLE (table2), checkbutton7, 0, 1, 6, 7,
		    (GtkAttachOptions) (GTK_FILL),
		    (GtkAttachOptions) (0), 0, 0);

  checkbutton8 =
    gtk_check_button_new_with_label (_
				     ("Warning for Uninitialized variable use"));
  gtk_widget_show (checkbutton8);
  gtk_table_attach (GTK_TABLE (table2), checkbutton8, 0, 1, 7, 8,
		    (GtkAttachOptions) (GTK_FILL),
		    (GtkAttachOptions) (0), 0, 0);

  checkbutton9 =
    gtk_check_button_new_with_label (_("Warning for missing Parentheses"));
  gtk_widget_show (checkbutton9);
  gtk_table_attach (GTK_TABLE (table2), checkbutton9, 0, 1, 8, 9,
		    (GtkAttachOptions) (GTK_FILL),
		    (GtkAttachOptions) (0), 0, 0);

  checkbutton10 =
    gtk_check_button_new_with_label (_("Warning for Un-Traditional syntax"));
  gtk_widget_show (checkbutton10);
  gtk_table_attach (GTK_TABLE (table2), checkbutton10, 0, 1, 9, 10,
		    (GtkAttachOptions) (GTK_FILL),
		    (GtkAttachOptions) (0), 0, 0);

  checkbutton11 =
    gtk_check_button_new_with_label (_("Warning for Variable Shadowing"));
  gtk_widget_show (checkbutton11);
  gtk_table_attach (GTK_TABLE (table2), checkbutton11, 0, 1, 10, 11,
		    (GtkAttachOptions) (GTK_FILL),
		    (GtkAttachOptions) (0), 0, 0);

  checkbutton12 =
    gtk_check_button_new_with_label (_
				     ("Warning for suspected Pointer-arith"));
  gtk_widget_show (checkbutton12);
  gtk_table_attach (GTK_TABLE (table2), checkbutton12, 0, 1, 11, 12,
		    (GtkAttachOptions) (GTK_FILL),
		    (GtkAttachOptions) (0), 0, 0);

  checkbutton13 =
    gtk_check_button_new_with_label (_("Warning for Missing-prototypes"));
  gtk_widget_show (checkbutton13);
  gtk_table_attach (GTK_TABLE (table2), checkbutton13, 0, 1, 12, 13,
		    (GtkAttachOptions) (GTK_FILL),
		    (GtkAttachOptions) (0), 0, 0);

  checkbutton14 =
    gtk_check_button_new_with_label (_
				     ("Warning for Un-Inline-able declarations"));
  gtk_widget_show (checkbutton14);
  gtk_table_attach (GTK_TABLE (table2), checkbutton14, 0, 1, 13, 14,
		    (GtkAttachOptions) (GTK_FILL),
		    (GtkAttachOptions) (0), 0, 0);

  checkbutton15 =
    gtk_check_button_new_with_label (_("Warning for Overloaded-virtuals"));
  gtk_widget_show (checkbutton15);
  gtk_table_attach (GTK_TABLE (table2), checkbutton15, 0, 1, 14, 15,
		    (GtkAttachOptions) (GTK_FILL),
		    (GtkAttachOptions) (0), 0, 0);

  label3 = gtk_label_new (_("Warnings"));
  gtk_widget_show (label3);
  gtk_notebook_set_tab_label (GTK_NOTEBOOK (notebook1),
			      gtk_notebook_get_nth_page (GTK_NOTEBOOK
							 (notebook1), 5),
			      label3);

  frame5 = gtk_frame_new (NULL);
  gtk_widget_show (frame5);
  gtk_container_add (GTK_CONTAINER (notebook1), frame5);
  gtk_container_set_border_width (GTK_CONTAINER (frame5), 5);

  vbox2 = gtk_vbox_new (FALSE, 0);
  gtk_widget_show (vbox2);
  gtk_container_add (GTK_CONTAINER (frame5), vbox2);

  radiobutton5 =
    gtk_radio_button_new_with_label (vbox2_group, _("No optimization"));
  vbox2_group = gtk_radio_button_group (GTK_RADIO_BUTTON (radiobutton5));
  gtk_widget_show (radiobutton5);
  gtk_box_pack_start (GTK_BOX (vbox2), radiobutton5, FALSE, FALSE, 0);
  gtk_container_set_border_width (GTK_CONTAINER (radiobutton5), 5);

  radiobutton6 =
    gtk_radio_button_new_with_label (vbox2_group,
				     _
				     ("Low level optimization (Machine dependent)"));
  vbox2_group = gtk_radio_button_group (GTK_RADIO_BUTTON (radiobutton6));
  gtk_widget_show (radiobutton6);
  gtk_box_pack_start (GTK_BOX (vbox2), radiobutton6, FALSE, FALSE, 0);
  gtk_container_set_border_width (GTK_CONTAINER (radiobutton6), 5);

  radiobutton7 =
    gtk_radio_button_new_with_label (vbox2_group,
				     _
				     ("Higher level optimization (without space-speed tradeoff)"));
  vbox2_group = gtk_radio_button_group (GTK_RADIO_BUTTON (radiobutton7));
  gtk_widget_show (radiobutton7);
  gtk_box_pack_start (GTK_BOX (vbox2), radiobutton7, FALSE, FALSE, 0);
  gtk_container_set_border_width (GTK_CONTAINER (radiobutton7), 5);

  radiobutton8 =
    gtk_radio_button_new_with_label (vbox2_group,
				     _
				     ("Fastest code optimization (Function inlined where ever possible"));
  vbox2_group = gtk_radio_button_group (GTK_RADIO_BUTTON (radiobutton8));
  gtk_widget_show (radiobutton8);
  gtk_box_pack_start (GTK_BOX (vbox2), radiobutton8, FALSE, FALSE, 0);
  gtk_container_set_border_width (GTK_CONTAINER (radiobutton8), 5);

  hseparator1 = gtk_hseparator_new ();
  gtk_widget_show (hseparator1);
  gtk_box_pack_start (GTK_BOX (vbox2), hseparator1, FALSE, TRUE, 0);

  frame = gtk_frame_new (NULL);
  gtk_box_pack_start (GTK_BOX (vbox2), frame, FALSE, FALSE, 0);
  gtk_widget_show (frame);

  label13 =
    gtk_label_new (_
		   ("Note: With optimization enabled, you might have some "
		    "difficulty in debugging your program. So it is not a good "
		    "idea to enable both debug and optimization options, unless "
		    "what you want is to debug the optimized code."));
  gtk_widget_show (label13);

  gtk_label_set_justify (GTK_LABEL (label13), GTK_JUSTIFY_FILL);
  gtk_label_set_line_wrap (GTK_LABEL (label13), TRUE);
  gtk_misc_set_padding (GTK_MISC (label13), 5, 5);
  gtk_container_add (GTK_CONTAINER (frame), label13);


  label4 = gtk_label_new (_("Optimization"));
  gtk_widget_show (label4);
  gtk_notebook_set_tab_label (GTK_NOTEBOOK (notebook1),
			      gtk_notebook_get_nth_page (GTK_NOTEBOOK
							 (notebook1), 6),
			      label4);

  frame6 = gtk_frame_new (NULL);
  gtk_widget_show (frame6);
  gtk_container_add (GTK_CONTAINER (notebook1), frame6);
  gtk_container_set_border_width (GTK_CONTAINER (frame6), 5);

  vbox3 = gtk_vbox_new (FALSE, 0);
  gtk_widget_show (vbox3);
  gtk_container_add (GTK_CONTAINER (frame6), vbox3);

  checkbutton20 = gtk_check_button_new_with_label (_("Enable Debugging"));
  gtk_widget_show (checkbutton20);
  gtk_box_pack_start (GTK_BOX (vbox3), checkbutton20, FALSE, FALSE, 0);
  gtk_container_set_border_width (GTK_CONTAINER (checkbutton20), 5);
  gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (checkbutton20), TRUE);

  checkbutton21 = gtk_check_button_new_with_label (_("Enable Profiling"));
  gtk_widget_show (checkbutton21);
  gtk_box_pack_start (GTK_BOX (vbox3), checkbutton21, FALSE, FALSE, 0);
  gtk_container_set_border_width (GTK_CONTAINER (checkbutton21), 5);

  checkbutton22 =
    gtk_check_button_new_with_label (_
				     ("Show warning as error (This will terminate the compiler)"));
  gtk_widget_show (checkbutton22);
  gtk_box_pack_start (GTK_BOX (vbox3), checkbutton22, FALSE, FALSE, 0);
  gtk_container_set_border_width (GTK_CONTAINER (checkbutton22), 5);

  hseparator2 = gtk_hseparator_new ();
  gtk_widget_show (hseparator2);
  gtk_box_pack_start (GTK_BOX (vbox3), hseparator2, TRUE, TRUE, 0);

  frame7 =
    gtk_frame_new (_("Additional compiler options (command line options)"));
  gtk_widget_show (frame7);
  gtk_box_pack_start (GTK_BOX (vbox3), frame7, TRUE, TRUE, 0);
  gtk_container_set_border_width (GTK_CONTAINER (frame7), 5);

  entry1 = gtk_entry_new ();
  gtk_widget_show (entry1);
  gtk_container_add (GTK_CONTAINER (frame7), entry1);

  label5 = gtk_label_new (_("Others"));
  gtk_widget_show (label5);
  gtk_notebook_set_tab_label (GTK_NOTEBOOK (notebook1),
			      gtk_notebook_get_nth_page (GTK_NOTEBOOK
							 (notebook1), 7),
			      label5);

  dialog_action_area1 = GNOME_DIALOG (dialog1)->action_area;
  gtk_widget_show (dialog_action_area1);
  gtk_button_box_set_layout (GTK_BUTTON_BOX (dialog_action_area1),
			     GTK_BUTTONBOX_END);
  gtk_button_box_set_spacing (GTK_BUTTON_BOX (dialog_action_area1), 8);

  gnome_dialog_append_button (GNOME_DIALOG (dialog1),
			      GNOME_STOCK_BUTTON_HELP);
  comopt_help = g_list_last (GNOME_DIALOG (dialog1)->buttons)->data;
  gtk_widget_show (comopt_help);
  GTK_WIDGET_SET_FLAGS (comopt_help, GTK_CAN_DEFAULT);

  gnome_dialog_append_button (GNOME_DIALOG (dialog1), GNOME_STOCK_BUTTON_OK);
  comopt_ok = g_list_last (GNOME_DIALOG (dialog1)->buttons)->data;
  gtk_widget_show (comopt_ok);
  GTK_WIDGET_SET_FLAGS (comopt_ok, GTK_CAN_DEFAULT);

  gnome_dialog_append_button (GNOME_DIALOG (dialog1),
			      GNOME_STOCK_BUTTON_APPLY);
  comopt_apply = g_list_last (GNOME_DIALOG (dialog1)->buttons)->data;
  gtk_widget_show (comopt_apply);
  GTK_WIDGET_SET_FLAGS (comopt_apply, GTK_CAN_DEFAULT);

  gnome_dialog_append_button (GNOME_DIALOG (dialog1),
			      GNOME_STOCK_BUTTON_CANCEL);
  comopt_cancel = g_list_last (GNOME_DIALOG (dialog1)->buttons)->data;
  gtk_widget_show (comopt_cancel);
  GTK_WIDGET_SET_FLAGS (comopt_cancel, GTK_CAN_DEFAULT);

  gtk_accel_group_attach (app->accel_group, GTK_OBJECT (window1));

  gtk_signal_connect (GTK_OBJECT (dialog1), "delete_event",
		      GTK_SIGNAL_FUNC (on_comopt_delete_event), co);
  gtk_signal_connect (GTK_OBJECT (comopt_ok), "clicked",
		      GTK_SIGNAL_FUNC (on_comopt_ok_clicked), co);
  gtk_signal_connect (GTK_OBJECT (comopt_help), "clicked",
		      GTK_SIGNAL_FUNC (on_comopt_help_clicked), co);
  gtk_signal_connect (GTK_OBJECT (comopt_apply), "clicked",
		      GTK_SIGNAL_FUNC (on_comopt_apply_clicked), co);
  gtk_signal_connect (GTK_OBJECT (comopt_cancel), "clicked",
		      GTK_SIGNAL_FUNC (on_comopt_cancel_clicked), co);

  gtk_signal_connect (GTK_OBJECT (checkbutton1), "toggled",
		      GTK_SIGNAL_FUNC (on_checkbutton1_toggled), co);
  gtk_signal_connect (GTK_OBJECT (checkbutton2), "toggled",
		      GTK_SIGNAL_FUNC (on_checkbutton2_toggled), co);


  co->widgets.window = window1;
  gtk_widget_ref (window1);
  co->widgets.button[0] = radiobutton1;
  co->widgets.button[1] = radiobutton2;
  co->widgets.button[2] = radiobutton3;
  co->widgets.button[3] = radiobutton4;
  co->widgets.button[4] = checkbutton1;
  co->widgets.button[5] = checkbutton2;
  co->widgets.button[6] = checkbutton3;
  co->widgets.button[7] = checkbutton4;
  co->widgets.button[8] = checkbutton5;
  co->widgets.button[9] = checkbutton6;
  co->widgets.button[10] = checkbutton7;
  co->widgets.button[11] = checkbutton8;
  co->widgets.button[12] = checkbutton9;
  co->widgets.button[13] = checkbutton10;
  co->widgets.button[14] = checkbutton11;
  co->widgets.button[15] = checkbutton12;
  co->widgets.button[16] = checkbutton13;
  co->widgets.button[17] = checkbutton14;
  co->widgets.button[18] = checkbutton15;
  co->widgets.button[19] = radiobutton5;
  co->widgets.button[20] = radiobutton6;
  co->widgets.button[21] = radiobutton7;
  co->widgets.button[22] = radiobutton8;
  co->widgets.button[23] = checkbutton20;
  co->widgets.button[24] = checkbutton21;
  co->widgets.button[25] = checkbutton22;
  co->widgets.other_options_entry = entry1;
  gtk_widget_ref (entry1);
  for (i = 0; i < 26; i++)
    gtk_widget_ref (co->widgets.button[i]);
}

GtkWidget *
create_compiler_options_page0 (CompilerOptions * co)
{
  GtkWidget *frame1;
  GtkWidget *table2;
  GtkWidget *scrolledwindow1;
  GtkWidget *clist1;
  GtkWidget *label7;
  GtkWidget *entry1;
  GtkWidget *label8;
  GtkWidget *vbox1;
  GtkWidget *button0;
  GtkWidget *button1;
  GtkWidget *button2;
  GtkWidget *button3;
  GtkWidget *button4;

  frame1 = gtk_frame_new (NULL);
  gtk_widget_show (frame1);
  gtk_container_set_border_width (GTK_CONTAINER (frame1), 5);

  table2 = gtk_table_new (2, 2, FALSE);
  gtk_widget_show (table2);
  gtk_container_add (GTK_CONTAINER (frame1), table2);
  gtk_container_set_border_width (GTK_CONTAINER (table2), 5);
  gtk_table_set_row_spacings (GTK_TABLE (table2), 5);
  gtk_table_set_col_spacings (GTK_TABLE (table2), 6);

  scrolledwindow1 = gtk_scrolled_window_new (NULL, NULL);
  gtk_widget_show (scrolledwindow1);
  gtk_table_attach (GTK_TABLE (table2), scrolledwindow1, 0, 1, 1, 2,
		    (GtkAttachOptions) (GTK_EXPAND | GTK_FILL),
		    (GtkAttachOptions) (GTK_EXPAND | GTK_FILL), 0, 0);
  gtk_scrolled_window_set_policy (GTK_SCROLLED_WINDOW (scrolledwindow1),
				  GTK_POLICY_AUTOMATIC, GTK_POLICY_AUTOMATIC);

  clist1 = gtk_clist_new (1);
  gtk_widget_show (clist1);
  gtk_container_add (GTK_CONTAINER (scrolledwindow1), clist1);
  gtk_clist_set_column_width (GTK_CLIST (clist1), 0, 80);
  gtk_clist_set_selection_mode (GTK_CLIST (clist1), GTK_SELECTION_BROWSE);
  gtk_clist_column_titles_show (GTK_CLIST (clist1));

  label7 = gtk_label_new (_("Include Paths"));
  gtk_widget_show (label7);
  gtk_clist_set_column_widget (GTK_CLIST (clist1), 0, label7);

  entry1 = gtk_entry_new ();
  gtk_widget_show (entry1);
  gtk_table_attach (GTK_TABLE (table2), entry1, 0, 1, 0, 1,
		    (GtkAttachOptions) (GTK_EXPAND | GTK_FILL),
		    (GtkAttachOptions) (GTK_FILL), 0, 0);

  label8 = gtk_label_new (_("<: Enter here"));
  gtk_widget_show (label8);
  gtk_table_attach (GTK_TABLE (table2), label8, 1, 2, 0, 1,
		    (GtkAttachOptions) (0), (GtkAttachOptions) (0), 0, 0);

  vbox1 = gtk_vbox_new (FALSE, 0);
  gtk_widget_show (vbox1);
  gtk_table_attach (GTK_TABLE (table2), vbox1, 1, 2, 1, 2,
		    (GtkAttachOptions) (GTK_FILL),
		    (GtkAttachOptions) (GTK_FILL), 0, 0);

  button0 = gtk_button_new_with_label (_("Add"));
  gtk_widget_show (button0);
  gtk_box_pack_start (GTK_BOX (vbox1), button0, FALSE, FALSE, 0);
  gtk_container_set_border_width (GTK_CONTAINER (button0), 5);

  button1 = gtk_button_new_with_label (_("Update"));
  gtk_widget_show (button1);
  gtk_box_pack_start (GTK_BOX (vbox1), button1, FALSE, FALSE, 0);
  gtk_container_set_border_width (GTK_CONTAINER (button1), 5);

  button2 = gtk_button_new_with_label (_("Remove"));
  gtk_widget_show (button2);
  gtk_box_pack_start (GTK_BOX (vbox1), button2, FALSE, FALSE, 0);
  gtk_container_set_border_width (GTK_CONTAINER (button2), 5);

  button3 = gtk_button_new_with_label (_("Clear"));
  gtk_widget_show (button3);
  gtk_box_pack_start (GTK_BOX (vbox1), button3, FALSE, FALSE, 0);
  gtk_container_set_border_width (GTK_CONTAINER (button3), 5);

  button4 = gnome_stock_button (GNOME_STOCK_BUTTON_HELP);
  gtk_widget_show (button4);
  gtk_box_pack_start (GTK_BOX (vbox1), button4, FALSE, FALSE, 0);
  gtk_container_set_border_width (GTK_CONTAINER (button4), 5);

  gtk_signal_connect (GTK_OBJECT (clist1), "select_row",
		      GTK_SIGNAL_FUNC (on_co_inc_clist_select_row), co);
  gtk_signal_connect (GTK_OBJECT (button0), "clicked",
		      GTK_SIGNAL_FUNC (on_co_inc_add_clicked), co);
  gtk_signal_connect (GTK_OBJECT (button1), "clicked",
		      GTK_SIGNAL_FUNC (on_co_inc_update_clicked), co);
  gtk_signal_connect (GTK_OBJECT (button2), "clicked",
		      GTK_SIGNAL_FUNC (on_co_inc_remove_clicked), co);
  gtk_signal_connect (GTK_OBJECT (button3), "clicked",
		      GTK_SIGNAL_FUNC (on_co_inc_clear_clicked), co);
  gtk_signal_connect (GTK_OBJECT (button4), "clicked",
		      GTK_SIGNAL_FUNC (on_co_inc_help_clicked), co);

  co->widgets.inc_clist = clist1;
  gtk_widget_ref (clist1);
  co->widgets.inc_entry = entry1;
  gtk_widget_ref (entry1);
  co->widgets.inc_add_b = button0;
  gtk_widget_ref (button0);
  co->widgets.inc_update_b = button1;
  gtk_widget_ref (button1);
  co->widgets.inc_remove_b = button2;
  gtk_widget_ref (button2);
  co->widgets.inc_clear_b = button3;
  gtk_widget_ref (button3);

  return frame1;
}

GtkWidget *
create_compiler_options_page1 (CompilerOptions * co)
{
  GtkWidget *frame1;
  GtkWidget *table2;
  GtkWidget *scrolledwindow1;
  GtkWidget *scrolledwindow2;
  GtkWidget *clist1;
  GtkWidget *clist2;
  GtkWidget *label7;
  GtkWidget *entry1;
  GtkWidget *label8;
  GtkWidget *vbox1;
  GtkWidget *button0;
  GtkWidget *button1;
  GtkWidget *button2;
  GtkWidget *button3;
  GtkWidget *button4;

  frame1 = gtk_frame_new (NULL);
  gtk_widget_show (frame1);
  gtk_container_set_border_width (GTK_CONTAINER (frame1), 5);

  table2 = gtk_table_new (3, 2, FALSE);
  gtk_widget_show (table2);
  gtk_container_add (GTK_CONTAINER (frame1), table2);
  gtk_container_set_border_width (GTK_CONTAINER (table2), 5);
  gtk_table_set_row_spacings (GTK_TABLE (table2), 5);
  gtk_table_set_col_spacings (GTK_TABLE (table2), 6);

  scrolledwindow1 = gtk_scrolled_window_new (NULL, NULL);
  gtk_widget_show (scrolledwindow1);
  gtk_table_attach (GTK_TABLE (table2), scrolledwindow1, 0, 1, 1, 2,
		    (GtkAttachOptions) (GTK_EXPAND | GTK_FILL),
		    (GtkAttachOptions) (GTK_EXPAND | GTK_FILL), 0, 0);
  gtk_scrolled_window_set_policy (GTK_SCROLLED_WINDOW (scrolledwindow1),
				  GTK_POLICY_AUTOMATIC, GTK_POLICY_AUTOMATIC);

  scrolledwindow2 = gtk_scrolled_window_new (NULL, NULL);
  gtk_widget_show (scrolledwindow2);
  gtk_table_attach (GTK_TABLE (table2), scrolledwindow2, 1, 2, 1, 2,
		    (GtkAttachOptions) (GTK_EXPAND | GTK_FILL),
		    (GtkAttachOptions) (GTK_EXPAND | GTK_FILL), 0, 0);
  gtk_scrolled_window_set_policy (GTK_SCROLLED_WINDOW (scrolledwindow2),
				  GTK_POLICY_AUTOMATIC, GTK_POLICY_AUTOMATIC);

  clist1 = gtk_clist_new (2);
  gtk_widget_show (clist1);
  gtk_container_add (GTK_CONTAINER (scrolledwindow1), clist1);
  gtk_clist_set_column_width (GTK_CLIST (clist1), 0, 10);
  gtk_clist_set_column_width (GTK_CLIST (clist1), 1, 80);
  gtk_clist_set_column_auto_resize (GTK_CLIST (clist1), 1, TRUE);
  gtk_clist_set_selection_mode (GTK_CLIST (clist1), GTK_SELECTION_BROWSE);
  gtk_clist_column_titles_show (GTK_CLIST (clist1));

  clist2 = gtk_clist_new (2);
  gtk_widget_show (clist2);
  gtk_container_add (GTK_CONTAINER (scrolledwindow2), clist2);
  gtk_clist_set_column_width (GTK_CLIST (clist2), 0, 80);
  gtk_clist_set_column_width (GTK_CLIST (clist2), 1, 80);
  gtk_clist_set_column_auto_resize (GTK_CLIST (clist2), 1, TRUE);
  gtk_clist_set_selection_mode (GTK_CLIST (clist2), GTK_SELECTION_BROWSE);
  gtk_clist_column_titles_show (GTK_CLIST (clist2));

  label7 = gtk_label_new (_("Added Libraries"));
  gtk_widget_show (label7);
  gtk_clist_set_column_widget (GTK_CLIST (clist1), 1, label7);

  label7 = gtk_label_new (_("Stock"));
  gtk_widget_show (label7);
  gtk_clist_set_column_widget (GTK_CLIST (clist2), 0, label7);

  label7 = gtk_label_new (_("Description"));
  gtk_widget_show (label7);
  gtk_clist_set_column_widget (GTK_CLIST (clist2), 1, label7);

  entry1 = gtk_entry_new ();
  gtk_widget_show (entry1);
  gtk_table_attach (GTK_TABLE (table2), entry1, 0, 2, 0, 1,
		    (GtkAttachOptions) (GTK_EXPAND | GTK_FILL),
		    (GtkAttachOptions) (GTK_FILL), 0, 0);

  label8 = gtk_label_new (_("<: Enter here"));
  gtk_widget_show (label8);
  gtk_table_attach (GTK_TABLE (table2), label8, 2, 3, 0, 1,
		    (GtkAttachOptions) (0), (GtkAttachOptions) (0), 0, 0);

  vbox1 = gtk_vbox_new (FALSE, 0);
  gtk_widget_show (vbox1);
  gtk_table_attach (GTK_TABLE (table2), vbox1, 2, 3, 1, 2,
		    (GtkAttachOptions) (GTK_FILL),
		    (GtkAttachOptions) (GTK_FILL), 0, 0);
  button0 = gtk_button_new_with_label (_("Add"));
  gtk_widget_show (button0);
  gtk_box_pack_start (GTK_BOX (vbox1), button0, FALSE, FALSE, 0);
  gtk_container_set_border_width (GTK_CONTAINER (button0), 5);

  button1 = gtk_button_new_with_label (_("Update"));
  gtk_widget_show (button1);
  gtk_box_pack_start (GTK_BOX (vbox1), button1, FALSE, FALSE, 0);
  gtk_container_set_border_width (GTK_CONTAINER (button1), 5);

  button2 = gtk_button_new_with_label (_("Remove"));
  gtk_widget_show (button2);
  gtk_box_pack_start (GTK_BOX (vbox1), button2, FALSE, FALSE, 0);
  gtk_container_set_border_width (GTK_CONTAINER (button2), 5);

  button3 = gtk_button_new_with_label (_("Clear"));
  gtk_widget_show (button3);
  gtk_box_pack_start (GTK_BOX (vbox1), button3, FALSE, FALSE, 0);
  gtk_container_set_border_width (GTK_CONTAINER (button3), 5);

  button4 = gnome_stock_button (GNOME_STOCK_BUTTON_HELP);
  gtk_widget_show (button4);
  gtk_box_pack_start (GTK_BOX (vbox1), button4, FALSE, FALSE, 0);
  gtk_container_set_border_width (GTK_CONTAINER (button4), 5);

  gtk_signal_connect (GTK_OBJECT (clist1), "select_row",
		      GTK_SIGNAL_FUNC (on_co_lib_clist_select_row), co);
  gtk_signal_connect (GTK_OBJECT (clist2), "select_row",
		      GTK_SIGNAL_FUNC (on_co_lib_stock_clist_select_row), co);
  gtk_signal_connect (GTK_OBJECT (button0), "clicked",
		      GTK_SIGNAL_FUNC (on_co_lib_add_clicked), co);
  gtk_signal_connect (GTK_OBJECT (button1), "clicked",
		      GTK_SIGNAL_FUNC (on_co_lib_update_clicked), co);
  gtk_signal_connect (GTK_OBJECT (button2), "clicked",
		      GTK_SIGNAL_FUNC (on_co_lib_remove_clicked), co);
  gtk_signal_connect (GTK_OBJECT (button3), "clicked",
		      GTK_SIGNAL_FUNC (on_co_lib_clear_clicked), co);
  gtk_signal_connect (GTK_OBJECT (button4), "clicked",
		      GTK_SIGNAL_FUNC (on_co_lib_help_clicked), co);

  co->widgets.lib_clist = clist1;
  gtk_widget_ref (clist1);
  co->widgets.lib_stock_clist = clist2;
  gtk_widget_ref (clist2);

  co->widgets.lib_entry = entry1;
  gtk_widget_ref (entry1);
  co->widgets.lib_add_b = button0;
  gtk_widget_ref (button0);
  co->widgets.lib_update_b = button1;
  gtk_widget_ref (button1);
  co->widgets.lib_remove_b = button2;
  gtk_widget_ref (button2);
  co->widgets.lib_clear_b = button3;
  gtk_widget_ref (button3);

  return frame1;
}

GtkWidget *
create_compiler_options_page2 (CompilerOptions * co)
{
  GtkWidget *frame1;
  GtkWidget *table2;
  GtkWidget *scrolledwindow1;
  GtkWidget *clist1;
  GtkWidget *label7;
  GtkWidget *entry1;
  GtkWidget *label8;
  GtkWidget *vbox1;
  GtkWidget *button0;
  GtkWidget *button1;
  GtkWidget *button2;
  GtkWidget *button3;
  GtkWidget *button4;

  frame1 = gtk_frame_new (NULL);
  gtk_widget_show (frame1);
  gtk_container_set_border_width (GTK_CONTAINER (frame1), 5);

  table2 = gtk_table_new (2, 2, FALSE);
  gtk_widget_show (table2);
  gtk_container_add (GTK_CONTAINER (frame1), table2);
  gtk_container_set_border_width (GTK_CONTAINER (table2), 5);
  gtk_table_set_row_spacings (GTK_TABLE (table2), 5);
  gtk_table_set_col_spacings (GTK_TABLE (table2), 6);

  scrolledwindow1 = gtk_scrolled_window_new (NULL, NULL);
  gtk_widget_show (scrolledwindow1);
  gtk_table_attach (GTK_TABLE (table2), scrolledwindow1, 0, 1, 1, 2,
		    (GtkAttachOptions) (GTK_EXPAND | GTK_FILL),
		    (GtkAttachOptions) (GTK_EXPAND | GTK_FILL), 0, 0);
  gtk_scrolled_window_set_policy (GTK_SCROLLED_WINDOW (scrolledwindow1),
				  GTK_POLICY_AUTOMATIC, GTK_POLICY_AUTOMATIC);

  clist1 = gtk_clist_new (1);
  gtk_widget_show (clist1);
  gtk_container_add (GTK_CONTAINER (scrolledwindow1), clist1);
  gtk_clist_set_column_width (GTK_CLIST (clist1), 0, 80);
  gtk_clist_set_selection_mode (GTK_CLIST (clist1), GTK_SELECTION_BROWSE);
  gtk_clist_column_titles_show (GTK_CLIST (clist1));

  label7 = gtk_label_new (_("Defines"));
  gtk_widget_show (label7);
  gtk_clist_set_column_widget (GTK_CLIST (clist1), 0, label7);

  entry1 = gtk_entry_new ();
  gtk_widget_show (entry1);
  gtk_table_attach (GTK_TABLE (table2), entry1, 0, 1, 0, 1,
		    (GtkAttachOptions) (GTK_EXPAND | GTK_FILL),
		    (GtkAttachOptions) (GTK_FILL), 0, 0);

  label8 = gtk_label_new (_("<: Enter here"));
  gtk_widget_show (label8);
  gtk_table_attach (GTK_TABLE (table2), label8, 1, 2, 0, 1,
		    (GtkAttachOptions) (0), (GtkAttachOptions) (0), 0, 0);

  vbox1 = gtk_vbox_new (FALSE, 0);
  gtk_widget_show (vbox1);
  gtk_table_attach (GTK_TABLE (table2), vbox1, 1, 2, 1, 2,
		    (GtkAttachOptions) (GTK_FILL),
		    (GtkAttachOptions) (GTK_FILL), 0, 0);

  button0 = gtk_button_new_with_label (_("Add"));
  gtk_widget_show (button0);
  gtk_box_pack_start (GTK_BOX (vbox1), button0, FALSE, FALSE, 0);
  gtk_container_set_border_width (GTK_CONTAINER (button0), 5);

  button1 = gtk_button_new_with_label (_("Update"));
  gtk_widget_show (button1);
  gtk_box_pack_start (GTK_BOX (vbox1), button1, FALSE, FALSE, 0);
  gtk_container_set_border_width (GTK_CONTAINER (button1), 5);

  button2 = gtk_button_new_with_label (_("Remove"));
  gtk_widget_show (button2);
  gtk_box_pack_start (GTK_BOX (vbox1), button2, FALSE, FALSE, 0);
  gtk_container_set_border_width (GTK_CONTAINER (button2), 5);

  button3 = gtk_button_new_with_label (_("Clear"));
  gtk_widget_show (button3);
  gtk_box_pack_start (GTK_BOX (vbox1), button3, FALSE, FALSE, 0);
  gtk_container_set_border_width (GTK_CONTAINER (button3), 5);

  button4 = gnome_stock_button (GNOME_STOCK_BUTTON_HELP);
  gtk_widget_show (button4);
  gtk_box_pack_start (GTK_BOX (vbox1), button4, FALSE, FALSE, 0);
  gtk_container_set_border_width (GTK_CONTAINER (button4), 5);

  gtk_signal_connect (GTK_OBJECT (clist1), "select_row",
		      GTK_SIGNAL_FUNC (on_co_def_clist_select_row), co);
  gtk_signal_connect (GTK_OBJECT (button0), "clicked",
		      GTK_SIGNAL_FUNC (on_co_def_add_clicked), co);
  gtk_signal_connect (GTK_OBJECT (button1), "clicked",
		      GTK_SIGNAL_FUNC (on_co_def_update_clicked), co);
  gtk_signal_connect (GTK_OBJECT (button2), "clicked",
		      GTK_SIGNAL_FUNC (on_co_def_remove_clicked), co);
  gtk_signal_connect (GTK_OBJECT (button3), "clicked",
		      GTK_SIGNAL_FUNC (on_co_def_clear_clicked), co);
  gtk_signal_connect (GTK_OBJECT (button4), "clicked",
		      GTK_SIGNAL_FUNC (on_co_def_help_clicked), co);

  co->widgets.def_clist = clist1;
  gtk_widget_ref (clist1);
  co->widgets.def_entry = entry1;
  gtk_widget_ref (entry1);
  co->widgets.def_add_b = button0;
  gtk_widget_ref (button0);
  co->widgets.def_update_b = button1;
  gtk_widget_ref (button1);
  co->widgets.def_remove_b = button2;
  gtk_widget_ref (button2);
  co->widgets.def_clear_b = button3;
  gtk_widget_ref (button3);

  return frame1;
}

GtkWidget *
create_compiler_options_page3 (CompilerOptions * co)
{
  GtkWidget *frame1;
  GtkWidget *table2;
  GtkWidget *scrolledwindow1;
  GtkWidget *clist1;
  GtkWidget *label7;
  GtkWidget *entry1;
  GtkWidget *label8;
  GtkWidget *vbox1;
  GtkWidget *button0;
  GtkWidget *button1;
  GtkWidget *button2;
  GtkWidget *button3;
  GtkWidget *button4;

  frame1 = gtk_frame_new (NULL);
  gtk_widget_show (frame1);
  gtk_container_set_border_width (GTK_CONTAINER (frame1), 5);

  table2 = gtk_table_new (2, 2, FALSE);
  gtk_widget_show (table2);
  gtk_container_add (GTK_CONTAINER (frame1), table2);
  gtk_container_set_border_width (GTK_CONTAINER (table2), 5);
  gtk_table_set_row_spacings (GTK_TABLE (table2), 5);
  gtk_table_set_col_spacings (GTK_TABLE (table2), 6);

  scrolledwindow1 = gtk_scrolled_window_new (NULL, NULL);
  gtk_widget_show (scrolledwindow1);
  gtk_table_attach (GTK_TABLE (table2), scrolledwindow1, 0, 1, 1, 2,
		    (GtkAttachOptions) (GTK_EXPAND | GTK_FILL),
		    (GtkAttachOptions) (GTK_EXPAND | GTK_FILL), 0, 0);
  gtk_scrolled_window_set_policy (GTK_SCROLLED_WINDOW (scrolledwindow1),
				  GTK_POLICY_AUTOMATIC, GTK_POLICY_AUTOMATIC);

  clist1 = gtk_clist_new (1);
  gtk_widget_show (clist1);
  gtk_container_add (GTK_CONTAINER (scrolledwindow1), clist1);
  gtk_clist_set_column_width (GTK_CLIST (clist1), 0, 80);
  gtk_clist_set_selection_mode (GTK_CLIST (clist1), GTK_SELECTION_BROWSE);
  gtk_clist_column_titles_show (GTK_CLIST (clist1));

  label7 = gtk_label_new (_("Library Paths"));
  gtk_widget_show (label7);
  gtk_clist_set_column_widget (GTK_CLIST (clist1), 0, label7);

  entry1 = gtk_entry_new ();
  gtk_widget_show (entry1);
  gtk_table_attach (GTK_TABLE (table2), entry1, 0, 1, 0, 1,
		    (GtkAttachOptions) (GTK_EXPAND | GTK_FILL),
		    (GtkAttachOptions) (GTK_FILL), 0, 0);

  label8 = gtk_label_new (_("<: Enter here"));
  gtk_widget_show (label8);
  gtk_table_attach (GTK_TABLE (table2), label8, 1, 2, 0, 1,
		    (GtkAttachOptions) (0), (GtkAttachOptions) (0), 0, 0);

  vbox1 = gtk_vbox_new (FALSE, 0);
  gtk_widget_show (vbox1);
  gtk_table_attach (GTK_TABLE (table2), vbox1, 1, 2, 1, 2,
		    (GtkAttachOptions) (GTK_FILL),
		    (GtkAttachOptions) (GTK_FILL), 0, 0);
  button0 = gtk_button_new_with_label (_("Add"));
  gtk_widget_show (button0);
  gtk_box_pack_start (GTK_BOX (vbox1), button0, FALSE, FALSE, 0);
  gtk_container_set_border_width (GTK_CONTAINER (button0), 5);

  button1 = gtk_button_new_with_label (_("Update"));
  gtk_widget_show (button1);
  gtk_box_pack_start (GTK_BOX (vbox1), button1, FALSE, FALSE, 0);
  gtk_container_set_border_width (GTK_CONTAINER (button1), 5);

  button2 = gtk_button_new_with_label (_("Remove"));
  gtk_widget_show (button2);
  gtk_box_pack_start (GTK_BOX (vbox1), button2, FALSE, FALSE, 0);
  gtk_container_set_border_width (GTK_CONTAINER (button2), 5);

  button3 = gtk_button_new_with_label (_("Clear"));
  gtk_widget_show (button3);
  gtk_box_pack_start (GTK_BOX (vbox1), button3, FALSE, FALSE, 0);
  gtk_container_set_border_width (GTK_CONTAINER (button3), 5);

  button4 = gnome_stock_button (GNOME_STOCK_BUTTON_HELP);
  gtk_widget_show (button4);
  gtk_box_pack_start (GTK_BOX (vbox1), button4, FALSE, FALSE, 0);
  gtk_container_set_border_width (GTK_CONTAINER (button4), 5);

  gtk_signal_connect (GTK_OBJECT (clist1), "select_row",
		      GTK_SIGNAL_FUNC (on_co_lib_paths_clist_select_row), co);
  gtk_signal_connect (GTK_OBJECT (button0), "clicked",
		      GTK_SIGNAL_FUNC (on_co_lib_paths_add_clicked), co);
  gtk_signal_connect (GTK_OBJECT (button1), "clicked",
		      GTK_SIGNAL_FUNC (on_co_lib_paths_update_clicked), co);
  gtk_signal_connect (GTK_OBJECT (button2), "clicked",
		      GTK_SIGNAL_FUNC (on_co_lib_paths_remove_clicked), co);
  gtk_signal_connect (GTK_OBJECT (button3), "clicked",
		      GTK_SIGNAL_FUNC (on_co_lib_paths_clear_clicked), co);
  gtk_signal_connect (GTK_OBJECT (button4), "clicked",
		      GTK_SIGNAL_FUNC (on_co_lib_paths_help_clicked), co);

  co->widgets.lib_paths_clist = clist1;
  gtk_widget_ref (clist1);
  co->widgets.lib_paths_entry = entry1;
  gtk_widget_ref (entry1);
  co->widgets.lib_paths_add_b = button0;
  gtk_widget_ref (button0);
  co->widgets.lib_paths_update_b = button1;
  gtk_widget_ref (button1);
  co->widgets.lib_paths_remove_b = button2;
  gtk_widget_ref (button2);
  co->widgets.lib_paths_clear_b = button3;
  gtk_widget_ref (button3);

  return frame1;
}
