/*
    compiler_options.c
    Copyright (C) 2000  Kh. Naba Kumar Singh

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/
#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <sys/stat.h>
#include <unistd.h>
#include <string.h>

#include <gnome.h>
#include "anjuta.h"
#include "support.h"
#include "compiler_options.h"

static char *support_cflags[] =
{
"",
" `glib-config --cflags`",
" `gtk-config --cflags`",
" `gnome-config --cflags gnome gnomeui gtk glib`",
};

static char *support_flags[] =
{
"",
" `glib-config --cflags --libs`",
" `gtk-config --cflags --libs`",
" `gnome-config --cflags --libs gnome gnomeui gtk glib`",
};

static char *button_option[] =
{
" -w",
" -Wall",
" -Wimplicit",
" -Wreturn-type",
" -Wunused",
" -Wswitch",
" -Wcomment",
" -Wuninitialized",
" -Wparentheses",
" -Wtraditional",
" -Wshadow",
" -Wpointer-arith",
" -Wmissing-prototypes",
" -Winline",
" -Woverloaded-virtual",
" -O",
" -O1",
" -O2",
" -O3",
" -g",
" -p",
" -Werror"
};

CompilerOptions*
compiler_options_new(void)
{
  gint i, ch;
  gchar *stock_file, *dummy[2];
  gchar lib_name[256];
  gchar desbuff[512];
  FILE *fp;
  
  CompilerOptions* co
= g_malloc(sizeof(CompilerOptions));
  if(co)
  {
    co->other_options = g_strdup("");
    for(i=0;i<26;i++) co->button_state[i] = FALSE;
    co->button_state[0] = TRUE;
    co->button_state[5] = TRUE;
    co->button_state[19] = TRUE;
    co->button_state[23] = TRUE;
    co->inc_index = 0;
    co->inc_index = 0;
    co->inc_index = 0;
    co->is_showing = FALSE;
    co->win_pos_x = 100;
    co->win_pos_y = 100;
    create_compiler_options_gui(co);

    /* Now read the stock libraries */
    stock_file = g_strconcat(app->dirs->data, "/stock_libs.anj", NULL);
    fp = fopen(stock_file, "r");
    g_free(stock_file);

    if (fp == NULL) return co;
   
    /* Skip the first line which is comment */
    do
    {
        ch = fgetc(fp);
        if (ch == EOF){fclose (fp); return co;}
    } while (ch != '\n');
    
    while (feof(fp) == FALSE)
    {
      /* Read a line at a time */
      fscanf(fp, "%s", lib_name);  /* The lib name */
      
      /* Followed by description */
      i = 0;
      do
      {
         ch = fgetc(fp);
         if (ch == EOF) {fclose (fp); return co;} /* Done when eof */
         desbuff[i] = (gchar) ch;
         i++;
      } while (ch != '\n');
      
      desbuff[--i] = '\0';
      dummy[0] = lib_name;
      dummy[1] = desbuff;
      gtk_clist_append (GTK_CLIST(co->widgets.lib_stock_clist), dummy);
    }
    fclose (fp);
  }
  return co;
}

void
compiler_options_destroy(CompilerOptions* co)
{
  gint i;
  if(co)
  {
    gtk_widget_unref(co->widgets.window);
    for(i=0;i<26;i++) gtk_widget_unref(co->widgets.button[i]);
    gtk_widget_unref(co->widgets.inc_clist);
    gtk_widget_unref(co->widgets.inc_entry);
    gtk_widget_unref(co->widgets.inc_add_b);
    gtk_widget_unref(co->widgets.inc_update_b);
    gtk_widget_unref(co->widgets.inc_remove_b);
    gtk_widget_unref(co->widgets.inc_clear_b);

    gtk_widget_unref(co->widgets.lib_paths_clist);
    gtk_widget_unref(co->widgets.lib_paths_entry);
    gtk_widget_unref(co->widgets.lib_paths_add_b);
    gtk_widget_unref(co->widgets.lib_paths_update_b);
    gtk_widget_unref(co->widgets.lib_paths_remove_b);
    gtk_widget_unref(co->widgets.lib_paths_clear_b);

    gtk_widget_unref(co->widgets.lib_clist);
    gtk_widget_unref(co->widgets.lib_stock_clist);

    gtk_widget_unref(co->widgets.lib_entry);
    gtk_widget_unref(co->widgets.lib_add_b);
    gtk_widget_unref(co->widgets.lib_update_b);
    gtk_widget_unref(co->widgets.lib_remove_b);
    gtk_widget_unref(co->widgets.lib_clear_b);

    gtk_widget_unref(co->widgets.def_clist);
    gtk_widget_unref(co->widgets.def_entry);
    gtk_widget_unref(co->widgets.def_add_b);
    gtk_widget_unref(co->widgets.def_update_b);
    gtk_widget_unref(co->widgets.def_remove_b);
    gtk_widget_unref(co->widgets.def_clear_b);
    gtk_widget_unref(co->widgets.other_options_entry);

    if(co->widgets.window) gtk_widget_destroy(co->widgets.window);
    if(co->other_options) g_free(co->other_options);
    g_free(co);
    co =NULL;
  }
}

gboolean
compiler_options_save_yourself(CompilerOptions* co, FILE* s)
{
  if(s==NULL || co == NULL) return FALSE;

  if(fprintf(s, "Compiler options: %d %d\n", co->win_pos_x, co->win_pos_y) < 2) return FALSE;
  return TRUE;
}

gint
compiler_options_save(CompilerOptions *co, FILE* f)
{
  gchar* text;
  gint      length, i;
  FILE* s;

  if(co==NULL)return FALSE;
  if(f != NULL) s = f;
  else
  {
	text = g_strconcat(app->dirs->settings, "/compiler.set", NULL);
	s = fopen(text, "w");
	if(s == NULL) return FALSE;
	fprintf(s,
	    "# **************************************************************************\n");
	fprintf(s,
	    _("# *********** DO NOT EDIT OR RENAME THIS FILE *****************\n"));
	fprintf(s,
	    _("# ******************* Created by  Anjuta ********************************\n"));
	fprintf(s,
	    _("# ******** Anjuta No-project compiler and Linker settings file ********\n"));
	fprintf(s,
	    "# **************************************************************************\n\n");
	fprintf(s,  "Anjuta: %s\n", VERSION);
  }

  length = g_list_length(GTK_CLIST(co->widgets.inc_clist)->row_list);
  if(fprintf(s, "Include Paths Length = %d\n", length)<1){ if(!f) fclose(s);return FALSE;}
  for(i = 0; i<length; i++)
  {
      gtk_clist_get_text(GTK_CLIST(co->widgets.inc_clist), i, 0, &text);
      if(!write_string(s,"Include_Path", text)){ if(!f) fclose(s);return FALSE;}
  }

  length = g_list_length(GTK_CLIST(co->widgets.lib_paths_clist)->row_list);
  if(fprintf(s, "Library Paths Length = %d\n", length)<1){ if(!f) fclose(s);return FALSE;}
  for(i = 0; i<length; i++)
  {
      gtk_clist_get_text(GTK_CLIST(co->widgets.lib_paths_clist), i, 0, &text);
      if(!write_string(s, "Library_Path", text)){ if(!f) fclose(s);return FALSE;}
  }

  length = g_list_length(GTK_CLIST(co->widgets.lib_clist)->row_list);
  if(fprintf(s, "Libraries Length = %d\n", length)<1){ if(!f) fclose(s);return FALSE;}
  for(i = 0; i<length; i++)
  {
      gtk_clist_get_text(GTK_CLIST(co->widgets.lib_clist), i, 1, &text);
      if(!write_string(s, "Library", text)){ if(!f) fclose(s);return FALSE;}
  }
  length = g_list_length(GTK_CLIST(co->widgets.def_clist)->row_list);
  if(fprintf(s, "Defines Length = %d\n", length) <1){ if(!f) fclose(s);return FALSE;}
  for(i = 0; i<length; i++)
  {
      gtk_clist_get_text(GTK_CLIST(co->widgets.def_clist), i, 0, &text);
      if(!write_string(s, "Define", text)){ if(!f) fclose(s);return FALSE;}
  }
  for(i = 0; i< 26; i++)
  {
      if(fprintf(s, "Button State: %d\n", (int)co->button_state[i])<1){ if(!f) fclose(s);return FALSE;}
  }
  if(!write_string(s, "Other_Options", co->other_options)){ if(!f) fclose(s);return FALSE;}
  if(!f) fclose(s);
  return TRUE;
}

gboolean
compiler_options_load_yourself(CompilerOptions* co, FILE* s)
{
  if(s==NULL || co == NULL) return FALSE;
  if(fscanf(s, "Compiler options: %d %d\n", &co->win_pos_x, &co->win_pos_y) < 2) return FALSE;
  return TRUE;
}

gint
compiler_options_load(CompilerOptions *co, FILE* f)
{
  gchar   *buff, buffer[256];
  gint      state;
  gint      length, i;
  gchar* dummy[2];
  FILE* s;
  gchar dumtext[] = "O";

  dummy[0] = dumtext;
  if(!co)return FALSE;
  if(f != NULL) s = f;
  else
  {
	buff = g_strconcat(app->dirs->settings, "/compiler.set", NULL);
	s = fopen(buff, "r");
	if(s == NULL) return FALSE;
	i=0;
	while (i < 6) {
		char ch;
		if ((ch = fgetc(s)) == EOF){fclose(s);return FALSE;}
		if (ch == '\n')
		    i++;
	    }
	if(fscanf(s, "Anjuta: %s\n", buffer)<1) {fclose(s);return FALSE;}
	if (strcmp(buffer, VERSION) != 0){ fclose(s);return FALSE;}
  }

  if(fscanf(s, "Include Paths Length = %d\n", &length)<1){ if(!f) fclose(s);return FALSE;}
  gtk_clist_clear(GTK_CLIST(co->widgets.inc_clist));
  gtk_entry_set_text(GTK_ENTRY(co->widgets.inc_entry), "");
  for(i = 0; i<length; i++)
  {
      if(!read_string(s, "Include_Path",  &buff)){ if(!f) fclose(s);return FALSE;}
      dummy[0] = buff;
      gtk_clist_append(GTK_CLIST(co->widgets.inc_clist), dummy);
      g_free(buff);
  }

  if(fscanf(s, "Library Paths Length = %d\n", &length)<1){ if(!f) fclose(s);return FALSE;}
  gtk_clist_clear(GTK_CLIST(co->widgets.lib_paths_clist));
  gtk_entry_set_text(GTK_ENTRY(co->widgets.lib_paths_entry), "");
  for(i = 0; i<length; i++)
  {
      if(!read_string(s, "Library_Path",  &buff)){ if(!f) fclose(s);return FALSE;}
      dummy[0] = buff;
      gtk_clist_append(GTK_CLIST(co->widgets.lib_paths_clist), dummy);
      g_free(buff);
  }

  if(fscanf(s, "Libraries Length = %d\n", &length)<1){ if(!f) fclose(s);return FALSE;}
  gtk_clist_clear(GTK_CLIST(co->widgets.lib_clist));
  gtk_entry_set_text(GTK_ENTRY(co->widgets.lib_entry), "");
  for(i = 0; i<length; i++)
  {
      if(!read_string(s, "Library",  &buff)){ if(!f) fclose(s);return FALSE;}
      dummy[1] = buff;
      gtk_clist_append(GTK_CLIST(co->widgets.lib_clist), dummy);
      g_free(buff);
  }

  if(fscanf(s, "Defines Length = %d\n", &length)<1){ if(!f) fclose(s);return FALSE;}
  gtk_clist_clear(GTK_CLIST(co->widgets.def_clist));
  gtk_entry_set_text(GTK_ENTRY(co->widgets.def_entry), "");
  for(i = 0; i<length; i++)
  {
      if(!read_string(s, "Define", &buff)){ if(!f) fclose(s);return FALSE;}
      dummy[0] = buff;
      gtk_clist_append(GTK_CLIST(co->widgets.def_clist), dummy);
      g_free(buff);
  }
  for(i = 0; i< 26; i++)
  {
      if(fscanf(s, "Button State: %d\n", &state)<1){ if(!f) fclose(s);return FALSE;}
      co->button_state[i] = state;
  }
  gtk_entry_set_text(GTK_ENTRY(co->widgets.other_options_entry), "");
  if(!read_string(s, "Other_Options", &buff)){ if(!f) fclose(s);return FALSE;}
  if(co->other_options) g_free(co->other_options);
  co->other_options = g_strdup(buff);
  g_free(buff);
  if(!f) fclose(s);
  return TRUE;
}

void
compiler_options_get(CompilerOptions* co)
{
  compiler_options_show(co);
}

void
compiler_options_show(CompilerOptions* co)
{
  gint i;

  if(!co)return;  
  for(i=0; i<26; i++)
  {
    gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(co->widgets.button[i]), co->button_state[i]);
  }
  if(co->other_options) gtk_entry_set_text(GTK_ENTRY(co->widgets.other_options_entry), co->other_options);
  compiler_options_update_controls(co);

  if(co->is_showing)
  {
      gdk_window_raise(co->widgets.window->window);
      return;
  }
  gtk_widget_set_uposition(co->widgets.window, co->win_pos_x, co->win_pos_y);
  gtk_widget_show(co->widgets.window);
  co->is_showing = TRUE;
}

void compiler_options_hide(CompilerOptions* co)
{
   if(!co) return;
   if(co->is_showing == FALSE) return;
   gdk_window_get_root_origin(co ->widgets.window->window, &co->win_pos_x, &co->win_pos_y);
   gtk_widget_hide(co->widgets.window);
   co->is_showing = FALSE;
}

void
compiler_options_update_controls(CompilerOptions* co)
{
  gint length;

  length = g_list_length(GTK_CLIST(co->widgets.inc_clist)->row_list);
  if(length < 2)
        gtk_widget_set_sensitive(co->widgets.inc_clear_b, FALSE);
  else
        gtk_widget_set_sensitive(co->widgets.inc_clear_b, TRUE);
  if(length < 1)
  {
    gtk_widget_set_sensitive(co->widgets.inc_remove_b, FALSE);
    gtk_widget_set_sensitive(co->widgets.inc_update_b, FALSE);
  }
  else
  {
    gtk_widget_set_sensitive(co->widgets.inc_remove_b, TRUE);
    gtk_widget_set_sensitive(co->widgets.inc_update_b, TRUE);
  }

  length = g_list_length(GTK_CLIST(co->widgets.lib_paths_clist)->row_list);
  if(length < 2)
        gtk_widget_set_sensitive(co->widgets.lib_paths_clear_b, FALSE);
  else
        gtk_widget_set_sensitive(co->widgets.lib_paths_clear_b, TRUE);
  if(length < 1)
  {
    gtk_widget_set_sensitive(co->widgets.lib_paths_remove_b, FALSE);
    gtk_widget_set_sensitive(co->widgets.lib_paths_update_b, FALSE);
  }
  else
  {
    gtk_widget_set_sensitive(co->widgets.lib_paths_remove_b, TRUE);
    gtk_widget_set_sensitive(co->widgets.lib_paths_update_b, TRUE);
  }

  length = g_list_length(GTK_CLIST(co->widgets.lib_clist)->row_list);
  if(length < 2)
        gtk_widget_set_sensitive(co->widgets.lib_clear_b, FALSE);
  else
        gtk_widget_set_sensitive(co->widgets.lib_clear_b, TRUE);
  if(length < 1)
  {
    gtk_widget_set_sensitive(co->widgets.lib_remove_b, FALSE);
    gtk_widget_set_sensitive(co->widgets.lib_update_b, FALSE);
  }
  else
  {
    gtk_widget_set_sensitive(co->widgets.lib_remove_b, TRUE);
    gtk_widget_set_sensitive(co->widgets.lib_update_b, TRUE);
  }

  length = g_list_length(GTK_CLIST(co->widgets.def_clist)->row_list);
  if(length < 2)
        gtk_widget_set_sensitive(co->widgets.def_clear_b, FALSE);
  else
        gtk_widget_set_sensitive(co->widgets.def_clear_b, TRUE);
  if(length < 1)
  {
    gtk_widget_set_sensitive(co->widgets.def_remove_b, FALSE);
    gtk_widget_set_sensitive(co->widgets.def_update_b, FALSE);
  }
  else
  {
    gtk_widget_set_sensitive(co->widgets.def_remove_b, TRUE);
    gtk_widget_set_sensitive(co->widgets.def_update_b, TRUE);
  }
}

gchar*
compiler_options_get_cflags(CompilerOptions* co)
{
  gchar* str, *tmp;
  gint i;

  str = compiler_options_get_defines(co);

  for(i=4;i<25;i++)
  if(co->button_state[i])
  {
     tmp = str;
     str = g_strconcat( tmp, button_option[i-4], NULL);
     g_free(tmp);
  }
  tmp = str;
  str = g_strconcat( tmp, " ", co->other_options, " ", NULL);
  g_free(tmp);
  return str;
}

gchar*
compiler_options_get_include_paths(CompilerOptions* co)
{
  gchar* str, *tmp;
  gchar* text;
  gint i;

  str = g_strdup("");
  for(i = 0; i<g_list_length(GTK_CLIST(co->widgets.inc_clist)->row_list);i++)
  {
      gtk_clist_get_text(GTK_CLIST(co->widgets.inc_clist), i, 0, &text);
      tmp = g_strconcat(str, " -I", text, NULL);
      g_free(str);
      str = tmp;
  }
  return str;
}

gchar*
compiler_options_get_library_paths(CompilerOptions* co)
{
  gchar* str, *tmp;
  gchar* text;
  gint i;

  str = g_strdup("");
  for(i = 0; i<g_list_length(GTK_CLIST(co->widgets.lib_paths_clist)->row_list);i++)
  {
      gtk_clist_get_text(GTK_CLIST(co->widgets.lib_paths_clist), i, 0, &text);
      tmp = g_strconcat(str, " -L", text, NULL);
      g_free(str);
      str = tmp;
  }
  return str;
}

gchar*
compiler_options_get_libraries(CompilerOptions* co)
{
  gchar *str, *tmp;
  gchar *text;
  gint i;

  str = g_strdup("");
  for(i = 0; i<g_list_length(GTK_CLIST(co->widgets.lib_clist)->row_list);i++)
  {
      gtk_clist_get_text(GTK_CLIST(co->widgets.lib_clist), i, 0, &text);
      if (strcmp(text, "O") != 0) continue;

      gtk_clist_get_text(GTK_CLIST(co->widgets.lib_clist), i, 1, &text);
      tmp = g_strconcat(str, " -l", text, NULL);
      g_free(str);
      str = tmp;
  }
  return str;
}

gchar*
compiler_options_get_defines(CompilerOptions* co)
{
  gchar* str, *tmp;
  gchar* text;
  gint i;

  str = g_strdup("");
  for(i = 0; i<g_list_length(GTK_CLIST(co->widgets.def_clist)->row_list);i++)
  {
      gtk_clist_get_text(GTK_CLIST(co->widgets.def_clist), i, 0, &text);
      tmp = g_strconcat(str, " -D", text, NULL);
      g_free(str);
      str = tmp;
  }
  return str;
}

/**********************************************
 * compiling = TRUE for only compiling
 * otherwise, with linking: compiling = FALSE.
 **********************************************/
gchar*
compiler_options_get_all_flags(CompilerOptions* co, gboolean compiling) 
{
  gchar* str, *tmp, *buff;
  gint i;

  str = g_strdup("");
  buff = compiler_options_get_include_paths(co);
  tmp = g_strconcat(str, buff, NULL);
  g_free(buff);
  g_free(str);
  str = tmp;

  if(compiling == FALSE)
  {
    buff = compiler_options_get_library_paths(co);
    tmp = g_strconcat(str, buff, NULL);
    g_free(buff);
    g_free(str);
    str = tmp;
  }

  if(compiling == FALSE)
  {
    buff = compiler_options_get_libraries(co);
    tmp = g_strconcat(str, buff, NULL);
    g_free(buff);
    g_free(str);
    str = tmp;
  }

  buff = compiler_options_get_defines(co);
  tmp = g_strconcat(str, buff, NULL);
  g_free(buff);
  g_free(str);
  str = tmp;

  for(i=0;i<4;i++)
  if(co->button_state[i])
  {
     tmp = str;
     if(compiling)
           str = g_strconcat( tmp, support_cflags[i], NULL);
     else
           str = g_strconcat( tmp, support_flags[i], NULL);
     g_free(tmp);
  }
  for(i=4;i<26;i++)
  if(co->button_state[i])
  {
     tmp = str;
     str = g_strconcat( tmp, button_option[i-4], NULL);
     g_free(tmp);
  }
  tmp = str;
  if(compiling)
       str = g_strconcat( tmp," ", co->other_options, " -c", NULL);
  else
       str = g_strconcat( tmp," ", co->other_options, " ", NULL);
  g_free(tmp);
  return str;
}

gchar*
compiler_options_get_c_compile_command(CompilerOptions* co)
{
  gchar *str, *tmp1, *tmp2;
  tmp1 = g_strdup(app->preferences->commands.c_compiler);
  tmp2 = compiler_options_get_all_flags(co, TRUE);
  str = g_strconcat(tmp1, tmp2, NULL);
  g_free(tmp1);
  g_free(tmp2);
  return str;
}

gchar*
compiler_options_get_cpp_compile_command(CompilerOptions* co)
{
  gchar *str, *tmp1, *tmp2;
  tmp1 = g_strdup(app->preferences->commands.cpp_compiler);
  tmp2 = compiler_options_get_all_flags(co, TRUE);
  str = g_strconcat(tmp1, tmp2, NULL);
  g_free(tmp1);
  g_free(tmp2);
  return str;
}

gchar*
compiler_options_get_c_build_command(CompilerOptions* co)
{
  gchar *str, *tmp1, *tmp2;
  tmp1 = g_strdup(app->preferences->commands.c_compiler);
  tmp2 = compiler_options_get_all_flags(co, FALSE);
  str = g_strconcat(tmp1, tmp2," ", NULL);
  g_free(tmp1);
  g_free(tmp2);
  return str;
}

gchar*
compiler_options_get_cpp_build_command(CompilerOptions* co)
{
  gchar *str, *tmp1, *tmp2;
  tmp1 = g_strdup(app->preferences->commands.cpp_compiler);
  tmp2 = compiler_options_get_all_flags(co, FALSE);
  str = g_strconcat(tmp1, tmp2," ", NULL);
  g_free(tmp1);
  g_free(tmp2);
  return str;
}

gchar*
compiler_options_get_build_command(CompilerOptions* co)
{
  gchar* str;
  str = g_strconcat(app->preferences->commands.build, " -k", NULL);
  return str;
}
