/*
    appwidz_page1.c
    Copyright (C) 2000  Kh. Naba Kumar Singh

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/
#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <sys/stat.h>
#include <unistd.h>
#include <string.h>
#include <ctype.h>

#include <gnome.h>

#include "support.h"
#include "appwidzard.h"

static void
on_prj_name_entry_changed              (GtkEditable     *editable,
                                        gpointer         user_data)
{
  gchar *text;
  AppWidzard* aw = user_data;
  text = gtk_entry_get_text(GTK_ENTRY(editable));
  if(strlen(text) == 0)
  {
     if(aw->prj_name) 
     {
        g_free(aw->prj_name);
        aw->prj_name = NULL;
        return;
      }
      return;
  }
  if(aw->prj_name) g_free(aw->prj_name);
  aw->prj_name = g_strdup(text);
  gtk_entry_set_text(GTK_ENTRY(aw->widgets.prog_name_entry), aw->prj_name);
}

static void
on_prj_name_entry_realize              (GtkWidget       *widget,
                                        gpointer         user_data)
{

}

static gboolean
on_prj_name_entry_focus_out_event             (GtkWidget       *widget,
                                        GdkEventFocus   *event,
                                        gpointer         user_data)
{
  gchar* temp;
  AppWidzard* aw = user_data;
  if(aw->prj_name)
  {
     temp = g_strdup(aw->prj_name);
     aw->prj_name[0] = toupper(aw->prj_name[0]);
     gtk_entry_set_text(GTK_ENTRY(widget), aw->prj_name);
     gtk_entry_set_text(GTK_ENTRY(aw->widgets.prog_name_entry), temp);
     g_free(temp);
  }
  temp = g_strdup_printf("%s Version %s", aw->prj_name, aw->version);
  gtk_entry_set_text(GTK_ENTRY(aw->widgets.menu_entry_entry), temp);
  gtk_entry_set_text(GTK_ENTRY(aw->widgets.menu_comment_entry), temp);
  g_free(temp);
  return FALSE;
}

static void
on_prog_name_entry_changed             (GtkEditable     *editable,
                                        gpointer         user_data)
{
  gchar *text;
  AppWidzard* aw = user_data;
  text = gtk_entry_get_text(GTK_ENTRY(editable));
  if(strlen(text) == 0)
  {
     if(aw->prog_name) 
     {
        g_free(aw->prog_name);
        aw->prog_name = NULL;
        return;
      }
      return;
  }
  if(aw->prog_name) g_free(aw->prog_name);
  aw->prog_name = g_strdup(text);
}


static void
on_prog_name_entry_realize             (GtkWidget       *widget,
                                        gpointer         user_data)
{

}


static void
on_src_dir_entry_changed               (GtkEditable     *editable,
                                        gpointer         user_data)
{
  gchar *text;
  AppWidzard* aw = user_data;
  text = gtk_entry_get_text(GTK_ENTRY(editable));
  if(strlen(text) == 0)
  {
     if(aw->src_dir_name) 
     {
        g_free(aw->src_dir_name);
        aw->src_dir_name = NULL;
        return;
      }
      return;
  }
  if(aw->src_dir_name) g_free(aw->src_dir_name);
  aw->src_dir_name = g_strdup(text);
}


static void
on_src_dir_entry_realize               (GtkWidget       *widget,
                                        gpointer         user_data)
{
  gtk_entry_set_text(GTK_ENTRY(widget), "src");
}


static void
on_doc_dir_entry_changed               (GtkEditable     *editable,
                                        gpointer         user_data)
{
  gchar *text;
  AppWidzard* aw = user_data;
  text = gtk_entry_get_text(GTK_ENTRY(editable));
  if(strlen(text) == 0)
  {
     if(aw->doc_dir_name) 
     {
        g_free(aw->doc_dir_name);
        aw->doc_dir_name = NULL;
        return;
      }
      return;
  }
  if(aw->doc_dir_name) g_free(aw->doc_dir_name);
  aw->doc_dir_name = g_strdup(text);

}


static void
on_doc_dir_entry_realize               (GtkWidget       *widget,
                                        gpointer         user_data)
{
  gtk_entry_set_text(GTK_ENTRY(widget), "doc");
}


static void
on_pix_dir_entry_changed               (GtkEditable     *editable,
                                        gpointer         user_data)
{
  gchar *text;
  AppWidzard* aw = user_data;
  text = gtk_entry_get_text(GTK_ENTRY(editable));
  if(strlen(text) == 0)
  {
     if(aw->pix_dir_name) 
     {
        g_free(aw->pix_dir_name);
        aw->pix_dir_name = NULL;
        return;
      }
      return;
  }
  if(aw->pix_dir_name) g_free(aw->pix_dir_name);
  aw->pix_dir_name = g_strdup(text);
}


static void
on_pix_dir_entry_realize               (GtkWidget       *widget,
                                        gpointer         user_data)
{
  gtk_entry_set_text(GTK_ENTRY(widget), "pixmaps");
}


static void
on_author_entry_changed                (GtkEditable     *editable,
                                        gpointer         user_data)
{
  gchar *text;
  AppWidzard* aw = user_data;
  text = gtk_entry_get_text(GTK_ENTRY(editable));
  if(strlen(text) == 0)
  {
     if(aw->author) 
     {
        g_free(aw->author);
        aw->author = NULL;
        return;
      }
      return;
  }
  if(aw->author) g_free(aw->author);
  aw->author = g_strdup(text);
}


static void
on_author_entry_realize                (GtkWidget       *widget,
                                        gpointer         user_data)
{
  gtk_entry_set_text(GTK_ENTRY(widget), getenv("USER"));
}


static void
on_version_entry_changed               (GtkEditable     *editable,
                                        gpointer         user_data)
{
  gchar *text;
  AppWidzard* aw = user_data;
  text = gtk_entry_get_text(GTK_ENTRY(editable));
  if(strlen(text) == 0)
  {
     if(aw->version) 
     {
        g_free(aw->version);
        aw->version = NULL;
        return;
      }
      return;
  }
  if(aw->version) g_free(aw->version);
  aw->version = g_strdup(text);
}


static void
on_version_entry_realize               (GtkWidget       *widget,
                                        gpointer         user_data)
{
  gtk_entry_set_text(GTK_ENTRY(widget), _("0.1"));
}

void
create_app_widzard_page2(AppWidzard *aw)
{
  GtkWidget *window1;
  GtkWidget *frame;
  GtkWidget *vbox3;
  GtkWidget *frame1;
  GtkWidget *label7;
  GtkWidget *hbox2;
  GtkWidget *table1;
  GtkWidget *label2;
  GtkWidget *label3;
  GtkWidget *label4;
  GtkWidget *label5;
  GtkWidget *prj_name_entry;
  GtkWidget *prog_name_entry;
  GtkWidget *src_dir_entry;
  GtkWidget *doc_dir_entry;
  GtkWidget *pix_dir_entry;
  GtkWidget *label1;
  GtkWidget *label8;
  GtkWidget *label9;
  GtkWidget *author_entry;
  GtkWidget *version_entry;
  GtkWidget *druid_vbox2;

  window1 = aw->widgets.window;

  frame = gtk_frame_new (NULL);
  gtk_widget_show (frame);
  druid_vbox2 = GNOME_DRUID_PAGE_STANDARD (aw->widgets.page[2])->vbox;
  gtk_box_pack_start (GTK_BOX (druid_vbox2), frame, TRUE, TRUE, 0);

  vbox3 = gtk_vbox_new (FALSE, 5);
  gtk_widget_show (vbox3);
  gtk_container_add (GTK_CONTAINER (frame), vbox3);

  frame1 = gtk_frame_new (NULL);
  gtk_widget_show (frame1);
  gtk_box_pack_start (GTK_BOX (vbox3), frame1, FALSE, FALSE, 0);
  gtk_frame_set_shadow_type (GTK_FRAME (frame1), GTK_SHADOW_IN);
  gtk_container_set_border_width (GTK_CONTAINER (frame1), 5);

  label7 = gtk_label_new (_("Enter the basic Project information"));
  gtk_widget_show (label7);
  gtk_container_add (GTK_CONTAINER (frame1), label7);
  gtk_label_set_justify (GTK_LABEL (label7), GTK_JUSTIFY_FILL);
  gtk_label_set_line_wrap (GTK_LABEL (label7), TRUE);
  gtk_misc_set_padding (GTK_MISC (label7), 5, 5);

  hbox2 = gtk_hbox_new (FALSE, 0);
  gtk_widget_show (hbox2);
  gtk_box_pack_start (GTK_BOX (vbox3), hbox2, TRUE, TRUE, 0);

  table1 = gtk_table_new (7, 2, TRUE);
  gtk_widget_show (table1);
  gtk_box_pack_start (GTK_BOX (hbox2), table1, TRUE, TRUE, 4);
  gtk_table_set_row_spacings (GTK_TABLE (table1), 6);

  label2 = gtk_label_new (_("Program Name:"));
  gtk_widget_show (label2);
  gtk_table_attach (GTK_TABLE (table1), label2, 0, 1, 3, 4,
                    (GtkAttachOptions) (GTK_EXPAND),
                    (GtkAttachOptions) (0), 0, 0);
  gtk_label_set_justify (GTK_LABEL (label2), GTK_JUSTIFY_LEFT);

  label3 = gtk_label_new (_("Source Directory:"));
  gtk_widget_show (label3);
  gtk_table_attach (GTK_TABLE (table1), label3, 0, 1, 4, 5,
                    (GtkAttachOptions) (GTK_EXPAND),
                    (GtkAttachOptions) (0), 0, 0);
  gtk_label_set_justify (GTK_LABEL (label3), GTK_JUSTIFY_LEFT);

  label4 = gtk_label_new (_("Documents Directory:"));
  gtk_widget_show (label4);
  gtk_table_attach (GTK_TABLE (table1), label4, 0, 1, 5, 6,
                    (GtkAttachOptions) (GTK_EXPAND),
                    (GtkAttachOptions) (0), 0, 0);
  gtk_label_set_justify (GTK_LABEL (label4), GTK_JUSTIFY_LEFT);

  label5 = gtk_label_new (_("Pixmaps Directory:"));
  gtk_widget_show (label5);
  gtk_table_attach (GTK_TABLE (table1), label5, 0, 1, 6, 7,
                    (GtkAttachOptions) (GTK_EXPAND),
                    (GtkAttachOptions) (0), 0, 0);
  gtk_label_set_justify (GTK_LABEL (label5), GTK_JUSTIFY_LEFT);

  prj_name_entry = gtk_entry_new ();
  gtk_widget_show (prj_name_entry);
  gtk_table_attach (GTK_TABLE (table1), prj_name_entry, 1, 2, 0, 1,
                    (GtkAttachOptions) (GTK_EXPAND | GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);

  prog_name_entry = gtk_entry_new ();
  gtk_widget_show (prog_name_entry);
  gtk_table_attach (GTK_TABLE (table1), prog_name_entry, 1, 2, 3, 4,
                    (GtkAttachOptions) (GTK_EXPAND | GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);

  src_dir_entry = gtk_entry_new ();
  gtk_widget_show (src_dir_entry);
  gtk_table_attach (GTK_TABLE (table1), src_dir_entry, 1, 2, 4, 5,
                    (GtkAttachOptions) (GTK_EXPAND | GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);

  doc_dir_entry = gtk_entry_new ();
  gtk_widget_show (doc_dir_entry);
  gtk_table_attach (GTK_TABLE (table1), doc_dir_entry, 1, 2, 5, 6,
                    (GtkAttachOptions) (GTK_EXPAND | GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);

  pix_dir_entry = gtk_entry_new ();
  gtk_widget_show (pix_dir_entry);
  gtk_table_attach (GTK_TABLE (table1), pix_dir_entry, 1, 2, 6, 7,
                    (GtkAttachOptions) (GTK_EXPAND | GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);

  label1 = gtk_label_new (_("Project Name:"));
  gtk_widget_show (label1);
  gtk_table_attach (GTK_TABLE (table1), label1, 0, 1, 0, 1,
                    (GtkAttachOptions) (GTK_EXPAND),
                    (GtkAttachOptions) (0), 0, 0);
  gtk_label_set_justify (GTK_LABEL (label1), GTK_JUSTIFY_LEFT);

  label8 = gtk_label_new (_("Author:"));
  gtk_widget_show (label8);
  gtk_table_attach (GTK_TABLE (table1), label8, 0, 1, 1, 2,
                    (GtkAttachOptions) (0),
                    (GtkAttachOptions) (0), 0, 0);

  label9 = gtk_label_new (_("Version:"));
  gtk_widget_show (label9);
  gtk_table_attach (GTK_TABLE (table1), label9, 0, 1, 2, 3,
                    (GtkAttachOptions) (0),
                    (GtkAttachOptions) (0), 0, 0);

  author_entry = gtk_entry_new ();
  gtk_widget_show (author_entry);
  gtk_table_attach (GTK_TABLE (table1), author_entry, 1, 2, 1, 2,
                    (GtkAttachOptions) (GTK_EXPAND | GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);

  version_entry = gtk_entry_new ();
  gtk_widget_show (version_entry);
  gtk_table_attach (GTK_TABLE (table1), version_entry, 1, 2, 2, 3,
                    (GtkAttachOptions) (GTK_EXPAND | GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);

  gtk_signal_connect (GTK_OBJECT (prj_name_entry), "changed",
                      GTK_SIGNAL_FUNC (on_prj_name_entry_changed),
                      aw);
  gtk_signal_connect (GTK_OBJECT (prj_name_entry), "realize",
                      GTK_SIGNAL_FUNC (on_prj_name_entry_realize),
                      aw);
  gtk_signal_connect (GTK_OBJECT (prj_name_entry), "focus_out_event",
                      GTK_SIGNAL_FUNC (on_prj_name_entry_focus_out_event),
                      aw);
  gtk_signal_connect (GTK_OBJECT (prog_name_entry), "changed",
                      GTK_SIGNAL_FUNC (on_prog_name_entry_changed),
                      aw);
  gtk_signal_connect (GTK_OBJECT (prog_name_entry), "realize",
                      GTK_SIGNAL_FUNC (on_prog_name_entry_realize),
                      aw);
  gtk_signal_connect (GTK_OBJECT (src_dir_entry), "changed",
                      GTK_SIGNAL_FUNC (on_src_dir_entry_changed),
                      aw);
  gtk_signal_connect (GTK_OBJECT (src_dir_entry), "realize",
                      GTK_SIGNAL_FUNC (on_src_dir_entry_realize),
                      aw);
  gtk_signal_connect (GTK_OBJECT (doc_dir_entry), "changed",
                      GTK_SIGNAL_FUNC (on_doc_dir_entry_changed),
                      aw);
  gtk_signal_connect (GTK_OBJECT (doc_dir_entry), "realize",
                      GTK_SIGNAL_FUNC (on_doc_dir_entry_realize),
                      aw);
  gtk_signal_connect (GTK_OBJECT (pix_dir_entry), "changed",
                      GTK_SIGNAL_FUNC (on_pix_dir_entry_changed),
                      aw);
  gtk_signal_connect (GTK_OBJECT (pix_dir_entry), "realize",
                      GTK_SIGNAL_FUNC (on_pix_dir_entry_realize),
                      aw);
  gtk_signal_connect (GTK_OBJECT (author_entry), "changed",
                      GTK_SIGNAL_FUNC (on_author_entry_changed),
                      aw);
  gtk_signal_connect (GTK_OBJECT (author_entry), "realize",
                      GTK_SIGNAL_FUNC (on_author_entry_realize),
                      aw);
  gtk_signal_connect (GTK_OBJECT (version_entry), "changed",
                      GTK_SIGNAL_FUNC (on_version_entry_changed),
                      aw);
  gtk_signal_connect (GTK_OBJECT (version_entry), "realize",
                      GTK_SIGNAL_FUNC (on_version_entry_realize),
                      aw);

  aw->widgets.prog_name_entry = prog_name_entry;
  gtk_widget_ref(prog_name_entry);
  aw->widgets.prj_name_entry = prj_name_entry;
  gtk_widget_ref(prj_name_entry);
  aw->widgets.src_dir_entry = src_dir_entry;
  gtk_widget_ref(src_dir_entry);
  aw->widgets.doc_dir_entry = doc_dir_entry;
  gtk_widget_ref(doc_dir_entry);
  aw->widgets.pix_dir_entry = pix_dir_entry;
  gtk_widget_ref(pix_dir_entry);
  aw->widgets.author_entry = author_entry;
  gtk_widget_ref(author_entry);
  aw->widgets.version_entry = version_entry;
  gtk_widget_ref(version_entry);
}
