/*
    appwidz_page0.c
    Copyright (C) 2000  Kh. Naba Kumar Singh

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/
#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <sys/stat.h>
#include <unistd.h>
#include <string.h>

#include <gnome.h>

#include "support.h"
#include "appwidzard.h"
#include "pixmaps.h"

static void
on_widzard_app_icon_select (GnomeIconList * gil, gint num,
			    GdkEvent * event, gpointer user_data)
{
  AppWidzard *aw = user_data;
  switch (num)
  {
  case 0:
    aw->type = blank;
    break;
  case 1:
    aw->type = console;
    break;
  case 2:
    aw->type = gnome_blank;
    break;
  case 3:
  default:
    aw->type = gnome_full;
  }
}

void
create_app_widzard_page1 (AppWidzard * aw)
{
  GtkWidget *frame;
  GtkWidget *frame3;
  GtkWidget *vbox4;
  GtkWidget *scrolledwindow1;
  GtkWidget *iconlist1;
  GtkWidget *frame2;
  GtkWidget *label2;
  GtkWidget *druid_vbox1;

  gchar *icon0_file, *icon1_file, *icon2_file, *icon3_file;

  frame = gtk_frame_new (NULL);
  gtk_widget_show (frame);
  druid_vbox1 = GNOME_DRUID_PAGE_STANDARD (aw->widgets.page[1])->vbox;
  gtk_box_pack_start (GTK_BOX (druid_vbox1), frame, TRUE, TRUE, 0);

  vbox4 = gtk_vbox_new (FALSE, 0);
  gtk_widget_show (vbox4);
  gtk_container_add (GTK_CONTAINER (frame), vbox4);

  frame2 = gtk_frame_new (NULL);
  gtk_widget_show (frame2);
  gtk_box_pack_start (GTK_BOX (vbox4), frame2, FALSE, FALSE, 0);
  gtk_container_set_border_width (GTK_CONTAINER (frame2), 5);
  gtk_frame_set_shadow_type (GTK_FRAME (frame2), GTK_SHADOW_IN);

  label2 =
    gtk_label_new (_("Select the type of application you want to develop"));
  gtk_misc_set_padding (GTK_MISC (label2), 5, 5);
  gtk_widget_show (label2);
  gtk_container_add (GTK_CONTAINER (frame2), label2);

  frame3 = gtk_frame_new (NULL);
  gtk_widget_show (frame3);
  gtk_box_pack_start (GTK_BOX (vbox4), frame3, TRUE, TRUE, 0);
  gtk_container_set_border_width (GTK_CONTAINER (frame3), 5);
  gtk_frame_set_shadow_type (GTK_FRAME (frame3), GTK_SHADOW_IN);

  scrolledwindow1 = gtk_scrolled_window_new (NULL, NULL);
  gtk_widget_show (scrolledwindow1);
  gtk_scrolled_window_set_policy (GTK_SCROLLED_WINDOW (scrolledwindow1),
				  GTK_POLICY_AUTOMATIC, GTK_POLICY_AUTOMATIC);
  gtk_container_add (GTK_CONTAINER (frame3), scrolledwindow1);

  iconlist1 = gnome_icon_list_new_flags (110, NULL, 0);
  gnome_icon_list_set_selection_mode (GNOME_ICON_LIST (iconlist1),
				      GTK_SELECTION_BROWSE);
  gtk_widget_show (iconlist1);
  gtk_container_add (GTK_CONTAINER (scrolledwindow1), iconlist1);
  gnome_icon_list_set_icon_border (GNOME_ICON_LIST (iconlist1), 5);
  gnome_icon_list_set_row_spacing (GNOME_ICON_LIST (iconlist1), 20);
  gnome_icon_list_set_text_spacing (GNOME_ICON_LIST (iconlist1), 5);

  icon0_file = gnome_pixmap_file (PIXMAP_APP_BLANK);
  icon1_file = gnome_pixmap_file (PIXMAP_APP_CONSOLE);
  icon2_file = gnome_pixmap_file (PIXMAP_APP_GNOME_BLANK);
  icon3_file = gnome_pixmap_file (PIXMAP_APP_GNOME);

  gnome_icon_list_append (GNOME_ICON_LIST (iconlist1),
			  icon0_file, _("Blank  Application"));

  gnome_icon_list_append (GNOME_ICON_LIST (iconlist1),
			  icon1_file, _("Console  Application"));

  gnome_icon_list_append (GNOME_ICON_LIST (iconlist1),
			  icon2_file, _("Gnome Blank  Application"));

  gnome_icon_list_append (GNOME_ICON_LIST (iconlist1),
			  icon3_file, _("Gnome  Application"));


  g_free (icon0_file);
  g_free (icon1_file);
  g_free (icon2_file);
  g_free (icon3_file);

  gtk_signal_connect (GTK_OBJECT (iconlist1), "select_icon",
		      GTK_SIGNAL_FUNC (on_widzard_app_icon_select), aw);
  gnome_icon_list_select_icon (GNOME_ICON_LIST (iconlist1), 3);

}
