/*
 *   about.c
 *   Copyright (C) 2000  Kh. Naba Kumar Singh
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <sys/stat.h>
#include <unistd.h>
#include <string.h>

#include <gnome.h>
#include "utilities.h"
#include "support.h"

GtkWidget*
create_about_gui ()
{
  const gchar *authors[] = {
    "Naba Kumar",
    NULL
  };
  GtkWidget *about_gui;

  about_gui = gnome_about_new ("Anjuta", VERSION,
                        _("Copyright (c) 1999 Naba Kumar"),
                        authors,
                        NULL,
                        "anjuta/anjuta_logo.png");
  gtk_widget_set_uposition (about_gui, 200, 150);
  gtk_window_set_modal (GTK_WINDOW (about_gui), FALSE);
  gtk_window_set_position (GTK_WINDOW (about_gui), GTK_WIN_POS_CENTER);
  return about_gui;
}
