/* AbiSource
 * 
 * Copyright (C) 2002 Dom Lachowicz <cinamod@hotmail.com>
 * Copyright (C) 2004 Robert Staudinger <robsta@stereolyzer.net>
 * Copyright (C) 2005 Daniel d'Andrada T. de Carvalho
 * <daniel.carvalho@indt.org.br>
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  
 * 02111-1307, USA.
 */



#ifndef _OPENDOCUMENT_STYLESSTREAM_LISTENER_H_
#define _OPENDOCUMENT_STYLESSTREAM_LISTENER_H_


#include "OpenDocument_Stream_Listener.h"
#include "OO_PageStyle.h"



/**
 * Class to handle the styles stream
 */
class ABI_EXPORT OpenDocument_StylesStream_Listener : 
        public OpenDocument_Stream_Listener
{
public:
    OpenDocument_StylesStream_Listener ( IE_Imp_OpenDocument* pImporter);
  
    virtual ~OpenDocument_StylesStream_Listener ();

    UT_UTF8String getStyleName(const UT_UTF8String & in) const;
  
    virtual void startElement (const XML_Char* pName, const XML_Char** ppAtts);

    virtual void endElement (const XML_Char* pName);
  
    virtual void charData (const XML_Char * buffer, int length) {}  

    const XML_Char* getSectionProps() const;
  
private:

    UT_UTF8String m_name;
    UT_UTF8String m_displayName;
    UT_UTF8String m_parent;
    UT_UTF8String m_next;
    enum { CHARACTER, PARAGRAPH } m_type;
    OO_Style* m_ooStyle;
    PD_Style* m_pParentStyle;
    OO_PageStyle m_ooPageStyle;
    const XML_Char* m_pageMaster;
    
    UT_GenericStringMap<UT_UTF8String *> m_styleNameMap;
};





#endif //_OPENDOCUMENT_STYLESSTREAM_LISTENER_H_
