/* AbiSource
 * 
 * Copyright (C) 2002 Dom Lachowicz <cinamod@hotmail.com>
 * Copyright (C) 2004 Robert Staudinger <robsta@stereolyzer.net>
 * Copyright (C) 2005 Daniel d'Andrada T. de Carvalho
 * <daniel.carvalho@indt.org.br>
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  
 * 02111-1307, USA.
 */
 
 
 // Class definition include
 #include "OpenDocument_MetaStream_Listener.h"
 
 
/** Constructor
 * 
 */
OpenDocument_MetaStream_Listener::OpenDocument_MetaStream_Listener
                (IE_Imp_OpenDocument* pImporter)
                 : OpenDocument_Stream_Listener ( pImporter )
{
    getDocument()->setMetaDataProp(PD_META_KEY_FORMAT,
        UT_UTF8String ("OpenDocument::ODT"));
}
  
  
  
/** Destructor
 * 
 */  
OpenDocument_MetaStream_Listener::~OpenDocument_MetaStream_Listener ()
{
}




/** Called to signal that the start tag of an element has been reached.
 * 
 */
void OpenDocument_MetaStream_Listener::startElement (
                                                const XML_Char* pName,
                                                const XML_Char** ppAtts) 
{
    m_charData.clear ();
    m_attribs.clear ();
    
    if (!UT_strcmp (pName, "meta:user-defined")) {
        const XML_Char* pAttrib = UT_getAttribute ("meta:name", ppAtts);
        
        if (pAttrib != NULL) {
            m_attribs.ins("meta:name", pAttrib);
        }
        
    }
    
    
}





/** Called to signal that the end tag of an element has been reached.
 * 
 */
void OpenDocument_MetaStream_Listener::endElement (const XML_Char* pName)
{
    if (m_charData.size()) {

        if (!UT_strcmp (pName, "meta:generator")) {
            
            getDocument()->setMetaDataProp (PD_META_KEY_GENERATOR, m_charData);
            
        } else if (!UT_strcmp (pName, "dc:title")) {
            
            getDocument()->setMetaDataProp (PD_META_KEY_TITLE, m_charData);
            
        } else if (!UT_strcmp (pName, "dc:description")) {
            
            getDocument()->setMetaDataProp (PD_META_KEY_DESCRIPTION, m_charData);
            
        } else if (!UT_strcmp (pName, "dc:subject")) {
            
            getDocument()->setMetaDataProp (PD_META_KEY_SUBJECT, m_charData);
            
        } else if (!UT_strcmp (pName, "meta:keyword")) {

            if (!m_keywords.empty()) {
                m_keywords.append(" ");
            }
            
            m_keywords += m_charData;
                                    
        } else if (!UT_strcmp (pName, "meta:initial-creator")) {
            
            // Should have a PD_META_KEY_INITIAL_CREATOR macro for this one
            getDocument()->setMetaDataProp("meta:initial-creator", m_charData);
            
        } else if (!UT_strcmp (pName, "dc:creator")) {
            
            getDocument()->setMetaDataProp (PD_META_KEY_CREATOR, m_charData);

        } else if (!UT_strcmp (pName, "meta:printed-by")) {
            
            // Should have a PD_META_KEY_PRINTED_BY macro for this one
            getDocument()->setMetaDataProp ("meta:printed-by", m_charData);

        } else if (!UT_strcmp (pName, "meta:creation-date")) {
            
            // ATTENTION: I'm assuming that dc.date is used by AbiWord as
            // the document creation date & time.
            getDocument()->setMetaDataProp (PD_META_KEY_DATE, m_charData);

        } else if (!UT_strcmp (pName, "dc:date")) {
            
            // Note that, for the OpenDocument standard, dc.date
            // is the last modification date & time.
            getDocument()->setMetaDataProp (PD_META_KEY_DATE_LAST_CHANGED,
                m_charData);

        } else if (!UT_strcmp (pName, "meta:print-date")) {
            
            // Should have a PD_META_KEY_PRINT_DATE macro for this one
            getDocument()->setMetaDataProp ("meta:print-date", m_charData);

        } else if (!UT_strcmp (pName, "meta:template")) {
            
            // AbiWord can't handle this kind of meta-data.
            // So, I'm ignoring it.

        } else if (!UT_strcmp (pName, "meta:auto-reload")) {
            
            // AbiWord can't handle this kind of meta-data.
            // So, I'm ignoring it.

        } else if (!UT_strcmp (pName, "meta:hyperlink-behaviour")) {
            
            // AbiWord can't handle this kind of meta-data.
            // So, I'm ignoring it.

        } else if (!UT_strcmp (pName, "dc:language")) {
            
            getDocument()->setMetaDataProp(PD_META_KEY_LANGUAGE, m_charData);

        } else if (!UT_strcmp (pName, "meta:editing-cycles")) {
            
            // Should have a PD_META_KEY_EDITING_CYCLES macro for this one
            getDocument()->setMetaDataProp("meta:editing-cycles", m_charData);

        } else if (!UT_strcmp (pName, "meta:editing-duration")) {
            
            // Should have a PD_META_KEY_EDITING_DURATION macro for this one
            getDocument()->setMetaDataProp("meta:editing-duration", m_charData);

        } else if (!UT_strcmp (pName, "meta:document-statistic")) {
            
            // AbiWord can't handle this kind of meta-data.
            // So, I'm ignoring it.

        } else if (!UT_strcmp (pName, "meta:user-defined")) {

            if (m_attribs["meta:name"] != NULL) {
                getDocument()->setMetaDataProp(
                    m_attribs["meta:name"]->utf8_str(),
                    m_charData);
            }

        } else if (!UT_strcmp (pName, "office:meta")) {
            
            getDocument()->setMetaDataProp(PD_META_KEY_KEYWORDS, m_keywords);

        }
    }

    /*
     * 
     * The following AbiWord meta-data have no counterpart on the OpenDocument
     * standard:
     * 
     * - PD_META_KEY_CONTRIBUTOR
     * - PD_META_KEY_COVERAGE
     * - PD_META_KEY_PUBLISHER
     * - PD_META_KEY_RELATION
     * - PD_META_KEY_RIGHTS
     * - PD_META_KEY_SOURCE
     * - PD_META_KEY_TYPE
     * 
     */
     

    m_charData.clear ();
    m_attribs.clear ();
}






/** Called when parsing the content between the start and end element tags.
 * 
 */
void OpenDocument_MetaStream_Listener::charData (
                                                const XML_Char* pBuffer,
                                                int length)
{
    if (pBuffer && length) {
        m_charData += UT_String (pBuffer, length).c_str();
    }
}
