/*
 * Copyright (C) 2005 by Robert Staudinger <robsta@stereolyzer.net>
 *
 * Based on the AbiWord's Wikipedia plugin
 * Copyright (C) 2001 by Dom Lachowicz & Michael D. Pritchett
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
 * 02111-1307, USA.
 */

/*
 * Please use GNOME coding style in this file.
 */

#ifdef ABI_PLUGIN_BUILTIN
#define abi_plugin_register abipgn_abiwidget_register
#define abi_plugin_unregister abipgn_abiwidget_unregister
#define abi_plugin_supports_version abipgn_abiwidget_supports_version
#endif


#include <gtk/gtk.h>

#include "xap_Module.h"
#include "xap_App.h"
#include "xap_Frame.h"
#include "fv_View.h"
#include "ap_Menu_Id.h"
#include "ev_Menu_Actions.h"
#include "ev_Menu.h"
#include "ev_Menu_Layouts.h"
#include "ev_Menu_Labels.h"
#include "ev_EditMethod.h"
#include "xap_Menu_Layouts.h"

#include "abi-view.h"


gboolean
window_close_cb (GtkWidget 	*window,
				 GdkEvent 	*event,
				 gpointer 	 data)
{
	gtk_widget_destroy (window);
}

void        
button_clicked_cb (GtkButton *button,
				   gpointer   data)
{
	AbiView *abi = NULL;

	abi = ABI_VIEW (data);
	//abi_view_load_file (abi, "foo.abw");
	abi_view_load_file (abi, "/home/robsta/Desktop/guadec-5.zabw");
}

bool 
AbiWidgetPlugin_invoke (AV_View* v, EV_EditMethodCallData *d)
{
	GtkWidget *window = NULL;
	GtkWidget *box = NULL;
	GtkWidget *abi = NULL;
	GtkWidget *button = NULL;
	GValue *val = {0, };

	window = gtk_window_new (GTK_WINDOW_TOPLEVEL);
	g_signal_connect (window, "delete-event", G_CALLBACK (window_close_cb), NULL);

	box = gtk_vbox_new (FALSE, 6);
	gtk_container_add (GTK_CONTAINER (window), box);	

	abi = abi_view_new ();	
	gtk_box_pack_start (GTK_BOX (box), abi, TRUE, TRUE, 0);

	button = gtk_button_new_with_label ("Open guadec-5.zabw");
	g_signal_connect (GTK_BUTTON (button), "clicked", G_CALLBACK (button_clicked_cb), abi);
	gtk_box_pack_start (GTK_BOX (box), button, FALSE, FALSE, 0);

	gtk_window_set_default_size (GTK_WINDOW (window), 480, 320);
	gtk_window_set_title (GTK_WINDOW (window), "/home/robsta/Desktop/guadec-5.zabw");
	gtk_widget_show_all (window);

/*
	g_value_init (val, G_TYPE_BOOLEAN);
	g_value_set_boolean (val, TRUE);
	g_object_set_property (abi, "show-rulers", val);

void        g_object_get_property           (GObject *object,
                                             const gchar *property_name,
                                             GValue *value);
*/

	return TRUE;
}

static const char* AbiWidgetPlugin_MenuLabel = "AbiWidget Test";
static const char* AbiWidgetPlugin_MenuTooltip = "Test the AbiWidget";

static void
AbiWidgetPlugin_removeFromMenus()
{
  XAP_App *pApp = XAP_App::getApp();

  // remove the edit method
  EV_EditMethodContainer* pEMC = pApp->getEditMethodContainer() ;
  EV_EditMethod * pEM = ev_EditMethod_lookup ( "AbiWidgetPlugin_invoke" ) ;
  pEMC->removeEditMethod ( pEM ) ;
  DELETEP( pEM ) ;

  // now remove crap from the menus
  int frameCount = pApp->getFrameCount();
  XAP_Menu_Factory * pFact = pApp->getMenuFactory();

  pFact->removeMenuItem("Main",NULL,AbiWidgetPlugin_MenuLabel);
  pFact->removeMenuItem("contextText",NULL,AbiWidgetPlugin_MenuLabel);
  for(int i = 0;i < frameCount;++i)
    {
      // Get the current frame that we're iterating through.
      XAP_Frame* pFrame = pApp->getFrame(i);
      pFrame->rebuildMenus();
    }
}

static void
AbiWidgetPlugin_addToMenus()
{
  XAP_App *pApp = XAP_App::getApp();
    
  // Create an EditMethod that will link our method's name with
  // it's callback function.  This is used to link the name to 
  // the callback.
  EV_EditMethod *myEditMethod = new EV_EditMethod(
						  "AbiWidgetPlugin_invoke",  // name of callback function
						  AbiWidgetPlugin_invoke,    // callback function itself.
						  0,                      // no additional data required.
						  ""                      // description -- allegedly never used for anything
						  );
  
  // Now we need to get the EditMethod container for the application.
  // This holds a series of Edit Methods and links names to callbacks.
  EV_EditMethodContainer* pEMC = pApp->getEditMethodContainer();
  
  // We have to add our EditMethod to the application's EditMethodList
  // so that the application will know what callback to call when a call
  // to "AiksaurusABI_invoke" is received.
  pEMC->addEditMethod(myEditMethod);
  
  
  // Now we need to grab an ActionSet.  This is going to be used later
  // on in our for loop.  Take a look near the bottom.
  EV_Menu_ActionSet* pActionSet = pApp->getMenuActionSet();
  
  
  // We need to go through and add the menu element to each "frame" 
  // of the application.  We can iterate through the frames by doing
  // XAP_App::getFrameCount() to tell us how many frames there are,
  // then calling XAP_App::getFrame(i) to get the i-th frame.
  
  int frameCount = pApp->getFrameCount();
  XAP_Menu_Factory * pFact = pApp->getMenuFactory();

  //
  // Put it in the context menu.
  //
  XAP_Menu_Id newID = pFact->addNewMenuAfter("contextText",NULL,"Bullets and &Numbering",EV_MLF_Normal);
  pFact->addNewLabel(NULL,newID,AbiWidgetPlugin_MenuLabel, AbiWidgetPlugin_MenuTooltip);

  //
  // Also put it under word Wount in the main menu,
  //
  pFact->addNewMenuAfter("Main",NULL,"&Word Count",EV_MLF_Normal,newID);
  
  // Create the Action that will be called.
  EV_Menu_Action* myAction = new EV_Menu_Action(
						newID,                     // id that the layout said we could use
						0,                      // no, we don't have a sub menu.
						0,                      // no, we don't raise a dialog.
						0,                      // no, we don't have a checkbox.
						0,
						"AbiWidgetPlugin_invoke",  // name of callback function to call.
						NULL,                   // don't know/care what this is for
						NULL                    // don't know/care what this is for
						);
  
  // Now what we need to do is add this particular action to the ActionSet
  // of the application.  This forms the link between our new ID that we 
  // got for this particular frame with the EditMethod that knows how to 
  // call our callback function.  
  
  pActionSet->addAction(myAction);
  
  for(int i = 0;i < frameCount;++i)
    {
      // Get the current frame that we're iterating through.
      XAP_Frame* pFrame = pApp->getFrame(i);
      pFrame->rebuildMenus();
    }
}



ABI_PLUGIN_DECLARE ("AbiWidgetPlugin")

ABI_FAR_CALL
int abi_plugin_register (XAP_ModuleInfo * mi)
{
    mi->name = "AbiWidget plugin";
    mi->desc = "Test the AbiWidget";
    mi->version = ABI_VERSION_STRING;
    mi->author = "Robert Staudinger"; // and Michael D. Pritchett and Dom Lachowicz
    mi->usage = "No Usage";
    
	/* TODO uncomment to activate  
    AbiWidgetPlugin_addToMenus();
	*/
    return 1;
}

ABI_FAR_CALL
int abi_plugin_unregister (XAP_ModuleInfo * mi)
{
    mi->name = 0;
    mi->desc = 0;
    mi->version = 0;
    mi->author = 0;
    mi->usage = 0;

	/* TODO uncomment to activate 
    AbiWidgetPlugin_removeFromMenus();
	*/
    return 1;
}

ABI_FAR_CALL
int abi_plugin_supports_version (UT_uint32 major, UT_uint32 minor, UT_uint32 release)
{
    return 1; 
}
