dnl aclocal.m4 generated automatically by aclocal 1.4-p4

dnl Copyright (C) 1994, 1995-8, 1999 Free Software Foundation, Inc.
dnl This file is free software; the Free Software Foundation
dnl gives unlimited permission to copy and/or distribute it,
dnl with or without modifications, as long as this notice is preserved.

dnl This program is distributed in the hope that it will be useful,
dnl but WITHOUT ANY WARRANTY, to the extent permitted by law; without
dnl even the implied warranty of MERCHANTABILITY or FITNESS FOR A
dnl PARTICULAR PURPOSE.

# Do all the work for Automake.  This macro actually does too much --
# some checks are only needed if your package does certain things.
# But this isn't really a big deal.

# serial 1

dnl Usage:
dnl AM_INIT_AUTOMAKE(package,version, [no-define])

AC_DEFUN(AM_INIT_AUTOMAKE,
[AC_REQUIRE([AC_PROG_INSTALL])
PACKAGE=[$1]
AC_SUBST(PACKAGE)
VERSION=[$2]
AC_SUBST(VERSION)
dnl test to see if srcdir already configured
if test "`cd $srcdir && pwd`" != "`pwd`" && test -f $srcdir/config.status; then
  AC_MSG_ERROR([source directory already configured; run "make distclean" there first])
fi
ifelse([$3],,
AC_DEFINE_UNQUOTED(PACKAGE, "$PACKAGE", [Name of package])
AC_DEFINE_UNQUOTED(VERSION, "$VERSION", [Version number of package]))
AC_REQUIRE([AM_SANITY_CHECK])
AC_REQUIRE([AC_ARG_PROGRAM])
dnl FIXME This is truly gross.
missing_dir=`cd $ac_aux_dir && pwd`
AM_MISSING_PROG(ACLOCAL, aclocal, $missing_dir)
AM_MISSING_PROG(AUTOCONF, autoconf, $missing_dir)
AM_MISSING_PROG(AUTOMAKE, automake, $missing_dir)
AM_MISSING_PROG(AUTOHEADER, autoheader, $missing_dir)
AM_MISSING_PROG(MAKEINFO, makeinfo, $missing_dir)
AC_REQUIRE([AC_PROG_MAKE_SET])])

#
# Check to make sure that the build environment is sane.
#

AC_DEFUN(AM_SANITY_CHECK,
[AC_MSG_CHECKING([whether build environment is sane])
# Just in case
sleep 1
echo timestamp > conftestfile
# Do `set' in a subshell so we don't clobber the current shell's
# arguments.  Must try -L first in case configure is actually a
# symlink; some systems play weird games with the mod time of symlinks
# (eg FreeBSD returns the mod time of the symlink's containing
# directory).
if (
   set X `ls -Lt $srcdir/configure conftestfile 2> /dev/null`
   if test "[$]*" = "X"; then
      # -L didn't work.
      set X `ls -t $srcdir/configure conftestfile`
   fi
   if test "[$]*" != "X $srcdir/configure conftestfile" \
      && test "[$]*" != "X conftestfile $srcdir/configure"; then

      # If neither matched, then we have a broken ls.  This can happen
      # if, for instance, CONFIG_SHELL is bash and it inherits a
      # broken ls alias from the environment.  This has actually
      # happened.  Such a system could not be considered "sane".
      AC_MSG_ERROR([ls -t appears to fail.  Make sure there is not a broken
alias in your environment])
   fi

   test "[$]2" = conftestfile
   )
then
   # Ok.
   :
else
   AC_MSG_ERROR([newly created file is older than distributed files!
Check your system clock])
fi
rm -f conftest*
AC_MSG_RESULT(yes)])

dnl AM_MISSING_PROG(NAME, PROGRAM, DIRECTORY)
dnl The program must properly implement --version.
AC_DEFUN(AM_MISSING_PROG,
[AC_MSG_CHECKING(for working $2)
# Run test in a subshell; some versions of sh will print an error if
# an executable is not found, even if stderr is redirected.
# Redirect stdin to placate older versions of autoconf.  Sigh.
if ($2 --version) < /dev/null > /dev/null 2>&1; then
   $1=$2
   AC_MSG_RESULT(found)
else
   $1="$3/missing $2"
   AC_MSG_RESULT(missing)
fi
AC_SUBST($1)])

#serial 1
# This test replaces the one in autoconf.
# Currently this macro should have the same name as the autoconf macro
# because gettext's gettext.m4 (distributed in the automake package)
# still uses it.  Otherwise, the use in gettext.m4 makes autoheader
# give these diagnostics:
#   configure.in:556: AC_TRY_COMPILE was called before AC_ISC_POSIX
#   configure.in:556: AC_TRY_RUN was called before AC_ISC_POSIX

undefine([AC_ISC_POSIX])

AC_DEFUN([AC_ISC_POSIX],
  [
    dnl This test replaces the obsolescent AC_ISC_POSIX kludge.
    AC_CHECK_LIB(cposix, strerror, [LIBS="$LIBS -lcposix"])
  ]
)

# aclocal-include.m4
# 
# This macro adds the name macrodir to the set of directories
# that `aclocal' searches for macros.  

# serial 1

dnl AM_ACLOCAL_INCLUDE(macrodir)
AC_DEFUN([AM_ACLOCAL_INCLUDE],
[
	AM_CONDITIONAL(INSIDE_GNOME_COMMON, test x = y)

	test -n "$ACLOCAL_FLAGS" && ACLOCAL="$ACLOCAL $ACLOCAL_FLAGS"

	for k in $1 ; do ACLOCAL="$ACLOCAL -I $k" ; done
])

# Define a conditional.

AC_DEFUN(AM_CONDITIONAL,
[AC_SUBST($1_TRUE)
AC_SUBST($1_FALSE)
if $2; then
  $1_TRUE=
  $1_FALSE='#'
else
  $1_TRUE='#'
  $1_FALSE=
fi])

# Copyright (C) 2001 Sam Tobin-Hochstadt
# This file is free software; you may copy and/or distribute it with
# or without modifications, as long as this notice is preserved.
# This software is distributed in the hope that it will be useful, but
# WITHOUT ANY WARRANTY, to the extent permitted by law; without even
# the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
# PURPOSE.
#
# The above license applies to THIS FILE ONLY, the abiword code
# itself may be copied and distributed under the terms of the GNU
# GPL, see COPYING for more details
#
# This file detects which of the AbiWord platforms we are currently
# building on.  The detection logic in question is mostly by Jeff
# Hostetler, and is taken from the original AbiWord build system.  
#
# Usage: ABI_DETECT_PLATFORM
# The platform is then available in the PLATFORM variable.
# 
# TODO Rewrite this to use $host, which is likely to be more accurate
# and actually maintained.

AC_DEFUN([ABI_DETECT_PLATFORM], [

# OS_NAME is the output of uname -s minus any forward slashes
# (so we don't imply another level of depth).  This is to solve
# a problem with BSD/OS.  In fact, it might be good to do this
# to all uname results, so that one doesn't see "sun4/m" as an
# architecture.  The substitutions are taken from the Linux
# kernel Makefile.  The result of this is that even if you have
# a Pentium Pro, you will see your bins in a "...i386" directory.
# This doesn't mean it didn't use your optimizations.

# this makes HP-UX look like "HP" (sed turns "HP-UX" into "HP" with the -.* pattern)
OS_NAME=`uname -s | sed "s/\//-/" | sed "s/_/-/" | sed "s/-.*//g"`
OS_RELEASE=`uname -r | sed "s/\//-/" | sed "s/[() ].*//g"`


if test "$OS_NAME" = "CYGWIN32"; then
	OS_NAME="WIN32"
fi

if test "$OS_NAME" = "CYGWIN"; then
	OS_NAME="WIN32"
fi

if test "$OS_NAME" = "WIN32"; then
	CYGWIN_MAJOR_VERSION=`echo $(OS_RELEASE) | cut -d . -f 1`
	CYGWIN_MINOR_VERSION=`echo $(OS_RELEASE) | cut -d . -f 2`
	CYGWIN_REVISION=`echo $(OS_RELEASE) | cut -d . -f 3`
fi

# 
# 1. Whether to consider using Cocoa API:
# 
AC_ARG_ENABLE(Cocoa,[  --disable-Cocoa    don't use Cocoa API  (MacOSX builds only)],[
	if [ test "x$enableval" = "xno" ]; then
		abi_gui_cocoa=no
	else
		abi_gui_cocoa=yes
	fi
],abi_gui_cocoa=yes)
# 
# 2. Whether to consider using Carbon API:
# 
AC_ARG_ENABLE(Carbon,[  --disable-Carbon   don't use Carbon API (MacOSX builds only)],[
	if [ test "x$enableval" = "xno" ]; then
		abi_gui_carbon=no
	else
		abi_gui_carbon=yes
	fi
],abi_gui_carbon=yes)
# 
# 3. Default to Cocoa, then Carbon, then GTK
#    (Values are equivalent to PLATFORM setting)
# 
if [ test $abi_gui_cocoa = yes ]; then
	abi_gui=cocoa
else
	if [ test $abi_gui_carbon = yes ]; then
		abi_gui=mac
	else
		abi_gui=unix
	fi
fi
# 
# 4. For Cocoa or Carbon, recognize Darwin as MACOSX; otherwise, recognize as FreeBSD
# 
if test "$OS_NAME" = "Darwin"; then
	if [ test $abi_gui = unix ]; then
		OS_NAME=FreeBSD
	else
		OS_NAME=MACOSX
	fi
fi

# At this point, we now have the following info:
# OS_NAME = something like 'Linux'
# OS_RELEASE = something like '2.4.1'
# Additionally, there may be info about Cygwin versions.

dnl TODO It would be nice to eventually add -Werror
dnl FIXME these flags are gcc-specific, and need to be fixed
dnl actually MacOS X build does not want some of them because of 
dnl precompiled Mac headers.... with Apple's GCC.
dnl 
case "$OS_NAME" in 
	MACOSX) WARNING_CFLAGS="" ;;
	*BSD)   WARNING_CFLAGS="-Wall -pedantic -ansi -D_BSD_SOURCE -pipe" ;;
	SunOS)  WARNING_CFLAGS="-Wall -pedantic -ansi -D_BSD_SOURCE -pipe -D__EXTENSIONS__ -DSCANDIR_MISSING -DSunOS";;
	*)      WARNING_CFLAGS="-Wall -pedantic -ansi -D_POSIX_SOURCE -D_BSD_SOURCE -pipe" ;;
esac

# huge nasty case statement to actually pick the platform

case "$OS_NAME" in 
	WIN32) PLATFORM="win" ;;
	Linux|AIX|*BSD|IRIX*|HP|OSF1|SunOS) PLATFORM="unix" ;;
	QNX|procnto) PLATFORM="qnx" ;;
	MACOSX) PLATFORM=$abi_gui ;;
	BeOS) PLATFORM="beos" ;;
esac

if test "$PLATFORM" = "cocoa"; then
	BE_PLATFORM="unix"
else
	BE_PLATFORM="$PLATFORM"
fi

AC_SUBST(PLATFORM)
AC_SUBST(BE_PLATFORM)
AC_SUBST(OS_NAME)
AC_SUBST(WARNING_CFLAGS)

])


# Check for optional glib

# Usage: 
# ABI_GLIB12_OPT(<micro-version>,<optional>) where <optional> = "no"|"yes"
#
# Pass "--with-glib=$abi_glib_opt" as option to peer wv's configure.

AC_DEFUN([ABI_GLIB12_OPT], [	
	if [ test "x$2" = "xyes" ]; then
		abi_glib_opt=check
	else
		abi_glib_opt=required
	fi
	AC_ARG_WITH(glib,[  --with-glib[=DIR]  Use glib (v1.2) [in DIR] ],[
		if [ test "x$withval" = "xno" ]; then
			if [ test $abi_glib_opt = required ]; then
				AC_MSG_ERROR([* * * glib-1.2 is not optional! * * *])
			fi
			abi_glib_opt=no
		elif [ test "x$withval" = "xyes" ]; then
			abi_glib_opt=required
			GLIB_DIR=""
		else
			abi_glib_opt=required
			GLIB_DIR="$withval"
		fi
	],[	GLIB_DIR=""
	])
	if [ test $abi_glib_opt != no ]; then
		if [ test "x$GLIB_DIR" = "x" ]; then
			AC_PATH_PROG(GLIB_CONFIG,glib12-config, ,[$PATH])
		else
			AC_PATH_PROG(GLIB_CONFIG,glib12-config, ,[$GLIB_DIR/bin:$PATH])
		fi
		if [ test "x$GLIB_CONFIG" = "x" ]; then
			if [ test "x$GLIB_DIR" = "x" ]; then
				AC_PATH_PROG(GLIB_CONFIG,glib-config, ,[$PATH])
			else
				AC_PATH_PROG(GLIB_CONFIG,glib-config, ,[$GLIB_DIR/bin:$PATH])
			fi
		fi
		if [ test "x$GLIB_CONFIG" = "x" ]; then
			if [ test $abi_glib_opt = required ]; then
				AC_MSG_ERROR([* * * unable to find glib12-config or glib-config in path! * * *])
			fi
			abi_glib_opt=no
		fi
	fi
	if [ test $abi_glib_opt != no ]; then
	        if [ $GLIB_CONFIG --version > /dev/null 2>&1 ]; then
			abi_glib_opt_version=`$GLIB_CONFIG --version`
			abi_glib_opt_major=`echo $abi_glib_opt_version | sed 's/\([[0-9]]*\).\([[0-9]]*\).\([[0-9]]*\)/\1/'`
			abi_glib_opt_minor=`echo $abi_glib_opt_version | sed 's/\([[0-9]]*\).\([[0-9]]*\).\([[0-9]]*\)/\2/'`
			abi_glib_opt_micro=`echo $abi_glib_opt_version | sed 's/\([[0-9]]*\).\([[0-9]]*\).\([[0-9]]*\)/\3/'`

			abi_glib_opt_version=""
			if [ test $abi_glib_opt_major -eq 1 ]; then
				if [ test $abi_glib_opt_minor -eq 2 ]; then
					if [ test $abi_glib_opt_micro -ge "$1" ]; then
						abi_glib_opt_version="1.2.$abi_glib_opt_micro"
					fi
				fi
			fi
			if [ test "x$abi_glib_opt_version" = "x" ]; then
				if [ test $abi_glib_opt = required ]; then
					AC_MSG_ERROR([* * * glib version is incompatible! require at least "1.2.$1" * * *])
				fi
				abi_glib_opt=no
			fi
		else
			AC_MSG_WARN([* * * problem obtaining glib version... * * *])
			if [ test $abi_glib_opt = required ]; then
				AC_MSG_ERROR([* * * unable to determine glib version! * * *])
			fi
			abi_glib_opt=no
		fi
	fi
	if [ test $abi_glib_opt != no ]; then
		dnl Pass "--with-glib=$abi_glib_opt" as option to peer wv's configure
		dnl 
		if [ test "x$GLIB_DIR" = "x" ]; then
			abi_glib_opt=yes
		else
			abi_glib_opt="$GLIB_DIR"
		fi
	fi
])

# Check for required gtk+

# Usage: 
# ABI_GTK12(<micro-version>)

AC_DEFUN([ABI_GTK12], [	
	AC_ARG_WITH(gtk,[  --with-gtk[=DIR]   Use gtk+ (v1.2) [in DIR] ],[
		if [ test "x$withval" = "xno" ]; then
			AC_MSG_ERROR([* * * gtk-1.2 is not optional! * * *])
		elif [ test "x$withval" = "xyes" ]; then
			GTK_DIR=""
		else
			GTK_DIR="$withval"
		fi
	],[	GTK_DIR=""
	])
	if [ test "x$GTK_DIR" = "x" ]; then
		AC_PATH_PROG(GTK_CONFIG,gtk12-config, ,[$PATH])
	else
		AC_PATH_PROG(GTK_CONFIG,gtk12-config, ,[$GTK_DIR/bin:$PATH])
	fi
	if [ test "x$GTK_CONFIG" = "x" ]; then
		if [ test "x$GTK_DIR" = "x" ]; then
			AC_PATH_PROG(GTK_CONFIG,gtk-config, ,[$PATH])
		else
			AC_PATH_PROG(GTK_CONFIG,gtk-config, ,[$GTK_DIR/bin:$PATH])
		fi
	fi
	if [ test "x$GTK_CONFIG" = "x" ]; then
		AC_MSG_ERROR([* * * unable to find gtk12-config or gtk-config in path! * * *])
	fi
        if [ $GTK_CONFIG --version > /dev/null 2>&1 ]; then
		abi_gtk_version=`$GTK_CONFIG --version`
		abi_gtk_major=`echo $abi_gtk_version | sed 's/\([[0-9]]*\).\([[0-9]]*\).\([[0-9]]*\)/\1/'`
		abi_gtk_minor=`echo $abi_gtk_version | sed 's/\([[0-9]]*\).\([[0-9]]*\).\([[0-9]]*\)/\2/'`
		abi_gtk_micro=`echo $abi_gtk_version | sed 's/\([[0-9]]*\).\([[0-9]]*\).\([[0-9]]*\)/\3/'`

		abi_gtk_version=""
		if [ test $abi_gtk_major -eq 1 ]; then
			if [ test $abi_gtk_minor -eq 2 ]; then
				if [ test $abi_gtk_micro -ge "$1" ]; then
					abi_gtk_version="1.2.$abi_gtk_micro"
				fi
			fi
		fi
		if [ test "x$abi_gtk_version" = "x" ]; then
			AC_MSG_ERROR([* * * gtk version is incompatible! require at least "1.2.$1" * * *])
		fi
	else
		AC_MSG_ERROR([* * * unable to determine gtk version! * * *])
	fi
])

# On unix, check for glib library.
# On mac, check for glib, but it's optional; module support unnecessary.
# Ensure that the version number of glib is >= 1.2.0

# Usage: 
# ABI_GLIB
#

AC_DEFUN([ABI_GLIB], [

dnl Perhaps this should be:
dnl
dnl    if test "$BE_PLATFORM" = "unix"; then
dnl
dnl which would eliminate the cocoa distinction... ??

if test "$PLATFORM" = "unix"; then
	ABI_GLIB12_OPT(0,no)

        GMODULE_CFLAGS=`$GLIB_CONFIG --cflags gmodule`
        GMODULE_LIBS=`$GLIB_CONFIG --libs gmodule`

        AC_SUBST(GMODULE_CFLAGS)
        AC_SUBST(GMODULE_LIBS)

elif test "$PLATFORM" = "mac"; then
	ABI_GLIB12_OPT(0,yes)

	if [ test "x$abi_glib_opt" = "xno" ]; then
	        GLIB_CFLAGS=""
        	GLIB_LIBS=""
	else
	        GLIB_CFLAGS=`$GLIB_CONFIG --cflags`
        	GLIB_LIBS=`$GLIB_CONFIG --libs`
	fi

        AC_SUBST(GLIB_CFLAGS)
        AC_SUBST(GLIB_LIBS)

elif test "$PLATFORM" = "cocoa"; then
	ABI_GLIB12_OPT(0,no)

        GLIB_CFLAGS=`$GLIB_CONFIG --cflags`
       	GLIB_LIBS=`$GLIB_CONFIG --libs`

        AC_SUBST(GLIB_CFLAGS)
        AC_SUBST(GLIB_LIBS)

fi

])

# On unix, check gtk libraries.
# Ensure that the version number of gtk is >= 1.2.2

# Usage: 
# ABI_GLIB_GTK
#

AC_DEFUN([ABI_GLIB_GTK], [

ABI_GLIB

if test "$PLATFORM" = "unix"; then
	ABI_GTK12(2)

        GTK_CFLAGS=`$GTK_CONFIG --cflags`
        GTK_LIBS=`$GTK_CONFIG --libs`

        AC_SUBST(GTK_CFLAGS)
        AC_SUBST(GTK_LIBS)
fi

])

# start: abi/ac-helpers/abi-iconv.m4
# 
# Copyright (C) 2002 Francis James Franklin
# Copyright (C) 2002 AbiSource, Inc
# 
# This file is free software; you may copy and/or distribute it with
# or without modifications, as long as this notice is preserved.
# This software is distributed in the hope that it will be useful, but
# WITHOUT ANY WARRANTY, to the extent permitted by law; without even
# the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
# PURPOSE.
#
# The above license applies to THIS FILE ONLY, the abiword code
# itself may be copied and distributed under the terms of the GNU
# GPL, see COPYING for more details
#
# This file detects which of the AbiWord platforms we are currently
# building on.  The detection logic in question is mostly by Jeff
# Hostetler, and is taken from the original AbiWord build system.  
#
# Usage: ABI_DETECT_ICONV

AC_DEFUN([ABI_DETECT_ICONV], [

dnl iconv is simply the funnest
dnl 
dnl 1. Very old platforms don't have it - fair enough.
dnl 2. Old (and, alas, even some new) platforms have it broken.
dnl 3. Some new platforms have it.
dnl 4. Some people have libiconv installed.
dnl 5. Some people want/need to use peer libiconv.

ABI_LIBICONV_DIR=""
AC_ARG_WITH(libiconv,[  --with-libiconv=DIR   use libiconv in DIR],[
	if [ test "$withval" = "no" ]; then
		abi_libiconv=no
        elif [ test "$withval" = "yes" ]; then
		abi_libiconv=yes
        elif [ test "$withval" = "peer" ]; then
		abi_libiconv=peer
	else
		abi_libiconv=sys
		ABI_LIBICONV_DIR="$withval"
        fi
],[	abi_libiconv=check
])

if test $abi_libiconv = peer; then
	abi_iconv=peer
else
	if test $abi_libiconv = sys; then
		_abi_cppflags="$CPPFLAGS"
		CPPFLAGS="$CPPFLAGS -I$ABI_LIBICONV_DIR/include"
	fi
# test for existence & nature of iconv.h
	AC_CHECK_HEADER(iconv.h,[
		AC_TRY_COMPILE([
#include <iconv.h>
		],[
#ifndef _LIBICONV_VERSION
        * * /* not (or old?) libiconv */ * *
#endif
#if _LIBICONV_VERSION < 0x0107
        * * /* old stuff */ * *
#endif
		],[	if test $abi_libiconv = no; then
				AC_MSG_ERROR([found libiconv - can I use it?])
			fi
			abi_iconv=sys_libiconv
		],[	if test $abi_libiconv = sys; then
				AC_MSG_ERROR([(usable) libiconv not found])
			fi
			if test $abi_libiconv = yes; then
				AC_MSG_WARN([libiconv not found in system location])
				abi_iconv=peer
			else
				abi_iconv=sys_iconv
			fi
		]),	abi_iconv=peer
	])
	if test $abi_libiconv = sys; then
		CPPFLAGS="$_abi_cppflags"
	fi
fi

LIBICONV_PEERDIR="`cd ..; pwd`/libiconv"

if test $abi_iconv = peer; then
	AC_MSG_CHECKING(for libiconv in peer directory)
	if test -d ../libiconv; then
		AC_MSG_RESULT(yes)
	else
		AC_MSG_RESULT(no)
		AC_MSG_ERROR([unable to use libiconv - no peer found])
	fi

	abi_iconv_message="peer libiconv"
	ICONV_INCLUDES='-I$(top_srcdir)/../libiconv/include'
	ICONV_LIBS='$(top_srcdir)/../libiconv/lib/.libs/libiconv.a'

        PEERDIRS="${PEERDIRS} ${LIBICONV_PEERDIR}"
	PEERS="${PEERS} libiconv"

elif test $abi_iconv = sys_libiconv; then
	if test $abi_libiconv = sys; then
		abi_iconv_message="libiconv in -L$ABI_LIBICONV_DIR/lib -liconv"
		ICONV_INCLUDES="-I$ABI_LIBICONV_DIR/include"
		ICONV_LIBS="-L$ABI_LIBICONV_DIR/lib -liconv"
	else
		abi_iconv_message="libiconv in -liconv"
		ICONV_INCLUDES=""
		ICONV_LIBS="-liconv"
	fi

else
	abi_iconv_message="system iconv"
	ICONV_INCLUDES=""
	ICONV_LIBS=""

fi

AC_SUBST(LIBICONV_PEERDIR)

AC_SUBST(ICONV_INCLUDES)
AC_SUBST(ICONV_LIBS)

])
# 
# end: abi/ac-helpers/abi-iconv.m4
# 

# start: abi/ac-helpers/abi-gnome.m4
# 
# Copyright (C) 2002 AbiSource, Inc
# 
# This file is free software; you may copy and/or distribute it with
# or without modifications, as long as this notice is preserved.
# This software is distributed in the hope that it will be useful, but
# WITHOUT ANY WARRANTY, to the extent permitted by law; without even
# the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
# PURPOSE.
#
# The above license applies to THIS FILE ONLY, the abiword code
# itself may be copied and distributed under the terms of the GNU
# GPL, see COPYING for more details
#
# This file detects which of the AbiWord platforms we are currently
# building on.  The detection logic in question is mostly by Jeff
# Hostetler, and is taken from the original AbiWord build system.  
#
# Usage: ABI_GNOME_QUICK

AC_DEFUN([ABI_GNOME_QUICK], [

dnl Quick&Easy GNOME Detection

GNOME_CFLAGS=""
GNOME_LIBS=""

AC_ARG_ENABLE(gnome,[  --enable-gnome    Turn on gnome ],[
	case "${enableval}" in
	 yes)	if test "$PLATFORM" = unix; then
			gnome=true
		else
			AC_MSG_ERROR([sorry: --enable-gnome supported only on UNIX platforms])
			gnome=false
		fi
		;;
	  no)	gnome=false ;;
	   *)	AC_MSG_ERROR(bad value ${enableval} for --enable-gnome) ;;
	esac
],[	gnome=false
])

if test "$gnome" = true ; then
	AC_MSG_CHECKING(for gnome-libs >= 1.2.0)
	if gnome-config --modversion gnome 2> /dev/null | grep gnome-libs >/dev/null 2>&1; then 
	    dnl We need the "%d" in order not to get e-notation on hpux.
	    vers=`gnome-config --modversion gnome | sed s,gnome-libs-,, | awk 'BEGIN { FS = "."; } { printf "%d", ([$]1 * 1000 + [$]2) * 1000 + [$]3;}'`
	    if test "$vers" -ge 1002000; then
	        AC_MSG_RESULT(found)
	    else
	       AC_MSG_RESULT(You need at least gnome-libs 1.2.0: disabling gnome)
               gnome=false
	    fi
	else
	    AC_MSG_RESULT(not found: disabling gnome)
            gnome=false
        fi
fi

if test "$gnome" = true ; then
	gnomelibs="bonobox bonobox_print gnomeui gal print vfs gdk_pixbuf"
	gnomeliberrors=`gnome-config --cflags $gnomelibs 2>&1 | grep "Unknown library"`
	if test "x$gnomeliberrors" != "x"; then
		AC_MSG_ERROR([One or more gnome libraries not found; require: $gnomelibs])
	fi
fi

if test "$gnome" = true ; then
	dnl What is the minimum gal library we can use?
	AC_MSG_CHECKING(for gal >= 0.5)
	if gnome-config --modversion gal 2> /dev/null | grep gal > /dev/null 2>&1; then 
	    dnl We need the "%d" in order not to get e-notation on hpux.
	    vers=`gnome-config --modversion gal | sed s,gal-,, | awk 'BEGIN { FS = "."; } { printf "%d", [$]1 * 1000 + [$]2;}'`
	    if test "$vers" -ge 5; then
	        AC_MSG_RESULT(found)
	    else
	       AC_MSG_RESULT(You need at least gal 0.5: disabling gnome)
               gnome=false
	    fi
	else
	    AC_MSG_RESULT(not found: disabling gnome)
            gnome=false
        fi
fi

if test "$gnome" = true ; then
	GNOME_CFLAGS="`gnome-config --cflags $gnomelibs` -DHAVE_GNOME=1"
	GNOME_LIBS="`gnome-config --libs $gnomelibs`"
fi

AC_SUBST(GNOME_CFLAGS)
AC_SUBST(GNOME_LIBS)
	
AM_CONDITIONAL(WITH_GNOME, test "x$gnome" = "xtrue")

])
# 
# end: abi/ac-helpers/abi-gnome.m4
# 

# start: abi/ac-helpers/abi-xml-parser.m4
# 
# Copyright (C) 2002 Francis James Franklin
# Copyright (C) 2002 AbiSource, Inc
# Copyright (C) 1998-2000 Joe Orton
# Copyright (C) 1998-2000 Sam Tobin-Hochstadt
# 
# This file is free software; you may copy and/or distribute it with
# or without modifications, as long as this notice is preserved.
# This software is distributed in the hope that it will be useful, but
# WITHOUT ANY WARRANTY, to the extent permitted by law; without even
# the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
# PURPOSE.
#
# The above license applies to THIS FILE ONLY, the abiword code
# itself may be copied and distributed under the terms of the GNU
# GPL, see COPYING for more details
#
# This file detects which of the AbiWord platforms we are currently
# building on.  The detection logic in question is mostly by Jeff
# Hostetler, and is taken from the original AbiWord build system.  
#
# Usage: ABI_XML_PARSER

# Check for XML parser.
# Supports:
#  *  libxml2
#  *  expat in -lexpat
#  *  peer expat

AC_DEFUN([ABI_XML_PARSER],[
if test "x$abi_xml" = "x"; then

XML_CFLAGS=""
XML_LIBS=""

EXPAT_PEERDIR=""

abi_wv_xml=""

abi_xml=unknown

ABI_XML_DIR=
AC_ARG_WITH([libxml2],[  --with-libxml2         force use of libxml2 ],[
	if test "x$withval" = "xno"; then
		abi_xml=expat
		abi_wv_xml="--with-expat"
	elif test "x$withval" = "xyes"; then
		abi_xml=xml2
		abi_wv_xml="--with-libxml2"
	else
		abi_xml=xml2
		ABI_XML_DIR="$withval"
		abi_wv_xml="--with-libxml2=$withval"
	fi
])

AC_ARG_WITH([expat],[  --with-expat         force use of expat ],[
	if test "x$withval" = "xno"; then
		if test $abi_xml != xml2; then
			AC_MSG_ERROR([* * * require either expat or libxml2 * * *])
		fi
		abi_xml=xml2
		abi_wv_xml="--with-libxml2"
	elif test "x$withval" = "xpeer"; then
		if test $abi_xml = xml2; then
			AC_MSG_ERROR([* * * don't specify both expat and libxml2 * * *])
		fi
		abi_xml=peer
		abi_wv_xml="--with-expat=peer"
	elif test "x$withval" = "xyes"; then
		if test $abi_xml = xml2; then
			AC_MSG_ERROR([* * * don't specify both expat and libxml2 * * *])
		fi
		abi_xml=expat
		abi_wv_xml="--with-expat"
	else
		if test $abi_xml = xml2; then
			AC_MSG_ERROR([* * * don't specify both expat and libxml2 * * *])
		fi
		abi_xml=expat
		ABI_XML_DIR="$withval"
		abi_wv_xml="--with-expat=$withval"
	fi
])

dnl default to libxml2
dnl 
if test $abi_xml = unknown; then
	if test -d ../expat; then
		abi_xml=peer
		abi_wv_xml="--with-expat=peer"
	else
		abi_xml=expat
		abi_wv_xml="--with-expat"
	fi
fi

dnl check for libxml2
dnl 
if test $abi_xml = xml2; then
	if test "x$ABI_XML_DIR" = "x"; then
		AC_PATH_PROG(ABI_XML_CONFIG,xml2-config, ,[$PATH])
	else
		AC_PATH_PROG(ABI_XML_CONFIG,xml2-config, ,[$ABI_XML_DIR/bin:$PATH])
	fi
	if test "x$ABI_XML_CONFIG" = "x"; then
		AC_MSG_ERROR([* * * unable to find xml2-config! require libxml2-devel * * *])
	fi
	XML_CFLAGS="`$ABI_XML_CONFIG --cflags`"
	XML_LIBS="`$ABI_XML_CONFIG --libs`"
	abi_xml_parser_message="libxml2 in $XML_LIBS"
fi

dnl check for expat (installed library)
dnl
if test $abi_xml = expat; then
	if test "x$ABI_XML_DIR" != "x"; then
		_abi_cppflags="$CPPFLAGS"
		_abi_ldflags="$LDFLAGS"
		CPPFLAGS="$CPPFLAGS -I$ABI_XML_DIR/include"
		LDFLAGS="$LDFLAGS -L$ABI_XML_DIR/lib"
	fi
	AC_CHECK_HEADER(expat.h,[
		AC_CHECK_LIB(expat,XML_Parse,[
			XML_LIBS="-lexpat"
		],[	AC_MSG_ERROR([* * * require expat-devel; or --with-expat=peer * * *])
		])
	],[	AC_MSG_ERROR([* * * require expat-devel; or --with-expat=peer * * *])
	])
	if test "x$ABI_XML_DIR" != "x"; then
		CPPFLAGS="$_abi_cppflags"
		LDFLAGS="$_abi_ldflags"
		XML_CFLAGS="-I$ABI_XML_DIR/include"
		XML_LIBS="-L$ABI_XML_DIR/lib -lexpat"
	fi
	abi_xml_parser_message="expat in $XML_LIBS"
fi

dnl check for expat (peer)
dnl
if test $abi_xml = peer; then
	abi_xml=expat
	AC_MSG_CHECKING(for peer expat)
	if test -d ../expat; then
		EXPAT_PEERDIR="`cd ../expat > /dev/null; pwd`"
		AC_MSG_RESULT($EXPAT_PEERDIR)
	else
		AC_MSG_ERROR(peer expat not found)
	fi
	XML_CFLAGS="-I $EXPAT_PEERDIR/lib"
	XML_LIBS="$EXPAT_PEERDIR/lib/.libs/libexpat.a"
	abi_xml_parser_message="peer expat"
        PEERDIRS="${PEERDIRS} ${EXPAT_PEERDIR}"
	PEERS="${PEERS} expat"
fi

if test $abi_xml = expat; then
	AC_DEFINE(HAVE_EXPAT,1,[Define if you have expat])
else
	AC_DEFINE(HAVE_LIBXML2,1,[Define if you have libxml2])
fi
AM_CONDITIONAL(HAVE_EXPAT, test $abi_xml = expat)

AC_SUBST(XML_CFLAGS)
AC_SUBST(XML_LIBS)

AC_SUBST(EXPAT_PEERDIR)

fi
])
# 
# end: abi/ac-helpers/abi-xml-parser.m4

# Copyright (C) 2001 Sam Tobin-Hochstadt
# This file is free software; you may copy and/or distribute it with
# or without modifications, as long as this notice is preserved.
# This software is distributed in the hope that it will be useful, but
# WITHOUT ANY WARRANTY, to the extent permitted by law; without even
# the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
# PURPOSE.

# The above license applies to THIS FILE ONLY, the abiword code
# itself may be copied and distributed under the terms of the GNU
# GPL, see COPYING for more details

# Check for Psiconv library.
# Supports:
#  *  psiconv in -lpsiconv
#  *  Bundled psiconv if a directory name argument is passed
#
# Hacked from the abi-xml-parser.m4 code
#
# Usage: 
#  ABI_PSICONV
# or
#  ABI_PSICONV(psiconv-dir)

AC_DEFUN([ABI_PSICONV], [

if test "$ABI_NEED_PSICONV" = "yes"; then

abi_found_psiconv="no"

# check for a shared install

if test "$abi_found_psiconv" = "no"; then
	echo "checking for psiconv"
	AC_CHECK_LIB(psiconv, psiconv_write,
		PSICONV_LIBS="-lpsiconv" abi_found_psiconv="yes"
		)
fi

# check for the header file

if test "$abi_found_psiconv" = "yes"; then
	AC_CHECK_HEADER(psiconv/data.h, 
	[abi_found_psiconvincs="yes"])
	if test "$abi_found_psiconvincs" = "yes"; then
		PSICONV_CFLAGS=""
		abi_psiconv_message="psiconv in -lpsiconv"
	else 
		#AC_MSG_WARN([psiconv library found but header file missing])
		abi_found_psiconv="no"
		PSICONV_LIBS=""
	fi
fi


# otherwise, use the sources given as an argument.  [ this means the
# peer dir for abi ]

if test "$abi_found_psiconv" = "no"; then
    if test "x$1" != "x" && test -d "$1"; then
	abspath=`cd $1; pwd`
	PSICONV_LIBS="${abspath}/psiconv/.libs/libpsiconv.a"
	PSICONV_CFLAGS="-I${abspath}/"
	AC_MSG_RESULT(using supplied psiconv library)	
	AC_DEFINE(HAVE_PSICONV, 1, [ Define if you have psiconv ])
	abi_psiconv_message="supplied psiconv in ${abspath}"
	PSICONV_PEERDIR=${abspath}
        PEERDIRS="${PEERDIRS} ${PSICONV_PEERDIR}"
	PEERS="${PEERS} `basename ${abspath}`"
    else
	AC_MSG_ERROR([ psiconv was not found ])
    fi

fi

fi

AM_CONDITIONAL(LOCAL_PSICONV, test "$local_psiconv" = "true")
AC_SUBST(PSICONV_CFLAGS)
AC_SUBST(PSICONV_LIBS)
AC_SUBST(PSICONV_PEERDIR)

])

# Copyright (C) 2001 Sam Tobin-Hochstadt
# This file is free software; you may copy and/or distribute it with
# or without modifications, as long as this notice is preserved.
# This software is distributed in the hope that it will be useful, but
# WITHOUT ANY WARRANTY, to the extent permitted by law; without even
# the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
# PURPOSE.

# The above license applies to THIS FILE ONLY, the abiword code
# itself may be copied and distributed under the terms of the GNU
# GPL, see COPYING for more details

# Check for Wv library.
# Supports:
#  *  wv in -lwv
#  *  Bundled wv if a directory name argument is passed
#
# Hacked from the abi-xml-parser.m4 code
#
# Usage: 
#  ABI_WV
# or
#  ABI_WV(wv-dir)

AC_DEFUN([ABI_WV], [

AC_ARG_WITH(sys_wv,[  --with-sys-wv    Use system libwv],[
	abi_sys_wv="$withval"
],[	abi_sys_wv=no
])

if test "$ABI_NEED_WV" = "yes"; then

if test "x$abi_sys_wv" != "xno"; then

# check for a shared install

	if test "x$abi_sys_wv" != "xyes"; then
		AC_PATH_PROG(WVLIBCFG,wv-libconfig,,["$abi_sys_wv"/bin:$PATH])
	else
		AC_PATH_PROG(WVLIBCFG,wv-libconfig,,[$PATH])
	fi
	if [ test "x$WVLIBCFG" = "x" ]; then
		AC_MSG_WARN([* * * Can't find wv-libconfig, so I'm just going to guess what libs I need. * * *])
		abi_wv_libs="-lwv -lpng -lz"
	else
		abi_wv_libs=`$WVLIBCFG`
	fi
	AC_CHECK_LIB(wv,wvInitParser,,[AC_MSG_ERROR([* * * Sorry, unable to link against libwv. * * *])],$abi_wv_libs)
	AC_CHECK_HEADER(wv.h,        ,[AC_MSG_ERROR([* * * Sorry, unable to find wv.h * * *])])
	AC_CHECK_HEADER(wvexporter.h,,[AC_MSG_ERROR([* * * Sorry, unable to find wvexporter.h * * *])])
	WV_CFLAGS=""
	WV_LIBS="$abi_wv_libs"
	WV_PEERDIR=""

	abi_wv_message="wv in $abi_wv_libs"
else

# otherwise, use the sources given as an argument.  [ this means the
# peer dir for abi ]

	AC_MSG_CHECKING(for wv)
	if test "x$1" != "x" && test -d "$1"; then
		abspath=`cd $1; pwd`
		AC_MSG_RESULT($abspath)	
	else
		AC_MSG_ERROR([* * * wv was not found - I looked for it in "$1" * * *])
	fi
	WV_CFLAGS="-I${abspath}"
	WV_LIBS="${abspath}/libwv.a"
	WV_PEERDIR="${abspath}"

	abi_wv_message="supplied wv in ${abspath}"

        PEERDIRS="${PEERDIRS} ${WV_PEERDIR}"
	PEERS="${PEERS} `basename ${abspath}`"
fi

AC_DEFINE(HAVE_WV, 1, [ Define if you have wv ])

else
# Abi doesn't need wv...
# 
abi_sys_wv=irrelevant
WV_CFLAGS=""
WV_LIBS=""
WV_PEERDIR=""
fi

AM_CONDITIONAL(LOCAL_WV,[test "x$abi_sys_wv" = "xno"])
AC_SUBST(WV_CFLAGS)
AC_SUBST(WV_LIBS)
AC_SUBST(WV_PEERDIR)

])

# start: abi/ac-helpers/abi-zlib.m4
# 
# Copyright (C) 2002 Francis James Franklin
# Copyright (C) 2002 AbiSource, Inc
# 
# This file is free software; you may copy and/or distribute it with
# or without modifications, as long as this notice is preserved.
# This software is distributed in the hope that it will be useful, but
# WITHOUT ANY WARRANTY, to the extent permitted by law; without even
# the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
# PURPOSE.
#
# The above license applies to THIS FILE ONLY, the abiword code
# itself may be copied and distributed under the terms of the GNU
# GPL, see COPYING for more details
#
# This file detects which of the AbiWord platforms we are currently
# building on.  The detection logic in question is mostly by Jeff
# Hostetler, and is taken from the original AbiWord build system.  
#
# Usage: ABI_ZLIB

AC_DEFUN([ABI_ZLIB],[

dnl Check for zlib
dnl Supports:
dnl  *  zlib in system library locations
dnl  *  Bundled zlib if a directory name argument is passed

abi_found_zlib="no"

ABI_ZLIB_DIR=""
AC_ARG_WITH(zlib,[  --with-zlib=DIR       use zlib in DIR],[
	if [ test "$withval" = "no" ]; then
		AC_MSG_ERROR([* * * zlib is required by AbiWord * * *])
        elif [ test "$withval" = "yes" ]; then
		abi_zlib=check
        elif [ test "$withval" = "peer" ]; then
		abi_zlib=peer
	else
		abi_zlib=sys
		ABI_ZLIB_DIR="$withval"
        fi
],[	abi_zlib=check
])

if test $abi_zlib = peer; then
	abi_z=peer
else
	if test $abi_zlib = sys; then
		_abi_cppflags="$CPPFLAGS"
		CPPFLAGS="$CPPFLAGS -I$ABI_ZLIB_DIR/include"
	fi
	AC_CHECK_HEADER(zlib.h,[
		abi_z=sys
	],[	if test $abi_zlib = sys; then
			AC_MSG_ERROR([* * * zlib not found in system location * * *])
		fi
		abi_z=peer
	])
	if test $abi_zlib = sys; then
		CPPFLAGS="$_abi_cppflags"
	fi
fi

dnl ZLIB_PEERDIR="`cd ..; pwd`/zlib"

if test $abi_z = peer; then
	AC_MSG_CHECKING(for zlib in peer directory)
	if test -d ../zlib; then
		if test -r ../zlib/libz.a; then
			AC_MSG_RESULT(yes)
		else
			AC_MSG_RESULT(no)
			AC_MSG_ERROR([unable to use peer zlib - zlib/libz.a not found])
		fi
	else
		AC_MSG_RESULT(no)
		AC_MSG_ERROR([unable to use zlib - no peer found])
	fi

	abi_zlib_message="peer zlib"
	ZLIB_CFLAGS='-I$(top_srcdir)/../zlib'
	ZLIB_LIBS='$(top_srcdir)/../zlib/libz.a'

dnl	PEERDIRS="${PEERDIRS} ${ZLIB_PEERDIR}"
dnl	PEERS="${PEERS} zlib"
else
	if test $abi_zlib = sys; then
		abi_zlib_message="zlib in -L$ABI_ZLIB_DIR/lib -lz"
		ZLIB_CFLAGS="-I$ABI_ZLIB_DIR/include"
		ZLIB_LIBS="-L$ABI_ZLIB_DIR/lib -lz"
	else
		abi_zlib_message="zlib in -lz"
		ZLIB_CFLAGS=""
		ZLIB_LIBS="-lz"
	fi
fi

dnl AC_SUBST(ZLIB_PEERDIR)

AC_SUBST(ZLIB_CFLAGS)
AC_SUBST(ZLIB_LIBS)

])
# 
# end: abi/ac-helpers/abi-zlib.m4
# 

# start: abi/ac-helpers/abi-libpng.m4
# 
# Copyright (C) 2002 Francis James Franklin
# Copyright (C) 2002 AbiSource, Inc
# Copyright (C) 2001 Sam Tobin-Hochstadt
# 
# This file is free software; you may copy and/or distribute it with
# or without modifications, as long as this notice is preserved.
# This software is distributed in the hope that it will be useful, but
# WITHOUT ANY WARRANTY, to the extent permitted by law; without even
# the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
# PURPOSE.
#
# The above license applies to THIS FILE ONLY, the abiword code
# itself may be copied and distributed under the terms of the GNU
# GPL, see COPYING for more details
#
# This file detects which of the AbiWord platforms we are currently
# building on.  The detection logic in question is mostly by Jeff
# Hostetler, and is taken from the original AbiWord build system.  
#
# Usage: ABI_LIBPNG

AC_DEFUN([ABI_LIBPNG],[

dnl Check for libpng
dnl Supports:
dnl  *  libpng in system library locations
dnl  *  Bundled libpng if a directory name argument is passed

abi_found_libpng="no"

ABI_LIBPNG_DIR=""
AC_ARG_WITH(libpng,[  --with-libpng=DIR     use libpng in DIR],[
	if [ test "$withval" = "no" ]; then
		AC_MSG_ERROR([* * * libpng is required by AbiWord * * *])
        elif [ test "$withval" = "yes" ]; then
		abi_libpng=check
        elif [ test "$withval" = "peer" ]; then
		abi_libpng=peer
	else
		abi_libpng=sys
		ABI_LIBPNG_DIR="$withval"
        fi
],[	abi_libpng=check
])

if test $abi_libpng = peer; then
	abi_png=peer
else
	if test $abi_libpng = sys; then
		_abi_cppflags="$CPPFLAGS"
		CPPFLAGS="$CPPFLAGS $ZLIB_CFLAGS -I$ABI_LIBPNG_DIR/include"
	fi
	AC_CHECK_HEADER(png.h,[
		abi_png=sys
	],[	if test $abi_libpng = sys; then
			AC_MSG_ERROR([* * * libpng not found in system location * * *])
		fi
		abi_png=peer
	])
	if test $abi_libpng = sys; then
		CPPFLAGS="$_abi_cppflags"
	fi
fi

LIBPNG_PEERDIR="`cd ..; pwd`/libpng"

if test $abi_png = peer; then
	AC_MSG_CHECKING(for libpng in peer directory)
	if test -d ../libpng; then
		if test -r ../libpng/libpng.a; then
			AC_MSG_RESULT(yes)
		else
			AC_MSG_RESULT(no)
			AC_MSG_ERROR([unable to use peer libpng - libpng/libpng.a not found])
		fi
	else
		AC_MSG_RESULT(no)
		AC_MSG_ERROR([unable to use libpng - no peer found])
	fi

	abi_libpng_message="peer libpng"
	LIBPNG_CFLAGS='-I$(top_srcdir)/../libpng'
	LIBPNG_LIBS='$(top_srcdir)/../libpng/libpng.a'

dnl	PEERDIRS="${PEERDIRS} ${LIBPNG_PEERDIR}"
dnl	PEERS="${PEERS} libpng"
else
	if test $abi_libpng = sys; then
		abi_libpng_message="libpng in -L$ABI_LIBPNG_DIR/lib -lpng"
		LIBPNG_CFLAGS="-I$ABI_LIBPNG_DIR/include"
		LIBPNG_LIBS="-L$ABI_LIBPNG_DIR/lib -lpng"
	else
		abi_libpng_message="libpng in -lpng"
		LIBPNG_CFLAGS=""
		LIBPNG_LIBS="-lpng"
	fi
fi

AC_SUBST(LIBPNG_PEERDIR)

AC_SUBST(LIBPNG_CFLAGS)
AC_SUBST(LIBPNG_LIBS)

])
# 
# end: abi/ac-helpers/abi-libpng.m4
# 

# Copyright (C) 2001 Sam Tobin-Hochstadt
# Copyright (C) 2001 Hubert Figuiere
# This file is free software; you may copy and/or distribute it with
# or without modifications, as long as this notice is preserved.
# This software is distributed in the hope that it will be useful, but
# WITHOUT ANY WARRANTY, to the extent permitted by law; without even
# the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
# PURPOSE.

# The above license applies to THIS FILE ONLY, the abiword code
# itself may be copied and distributed under the terms of the GNU
# GPL, see COPYING for more details

# Check for libjpeg
# Supports:
#  *  libjpeg in system library locations
#
# Hacked from the abi-libpng-parser.m4 code
#
# Usage: 
#  ABI_LIBJPEG

AC_DEFUN([ABI_LIBJPEG], [

abi_found_libjpeg="no"

AC_ARG_WITH(libjpeg-prefix, [  --with-libjpeg-prefix=PFX   Prefix where libjpeg is installed (optional)], libjpeg_prefix="$withval", libjpeg_prefix="")

# check for library file using prefix
if test "x$libjpeg_prefix" != "x"; then
    if test -f "$libjpeg_prefix/lib/libjpeg.a"; then
           good_libjpeg_prefix="yes"
       else
           good_libjpeg_prefix="no"
    fi
fi


# check for shared install, with or without prefix
if test "$good_libjpeg_prefix" = "yes"; then
    saved_ldflags="$LDFLAGS"
    LDFLAGS="-L$libjpeg_prefix/lib"
    AC_CHECK_LIB(jpeg, jpeg_start_decompress,
        abi_libjpeg_libs="-L$libjpeg_prefix/lib -ljpeg" abi_found_libjpeg="yes",
	abi_found_libjpeg="no")
    LDFLAGS="$saved_ldflags"
else
    if test "$abi_found_libjpeg" = "no"; then
	echo "checking for libjpeg"
	AC_CHECK_LIB(jpeg, jpeg_start_decompress,
           abi_libjpeg_libs="-ljpeg" abi_found_libjpeg="yes",
           abi_found_libjpeg="no")
    fi
fi

# check for header file
if test "$abi_found_libjpeg" = "yes"; then
    if test "$good_libjpeg_prefix" = "yes"; then
        if test -f "$libjpeg_prefix/include/png.h"; then
            abi_found_libjpegincs="yes"
        else
            abi_found_libjpegincs="no"
        fi
	if test "$abi_found_libjpegincs" = "yes"; then
            LIBJPEG_LIBS="$abi_libjpeg_libs"
            LIBJPEG_CFLAGS="-I$libjpeg_prefix/include -DHAVE_LIBJPEG"
	fi
    else
       AC_CHECK_HEADER(jpeglib.h,abi_found_libjpegincs="yes")
       if test "$abi_found_libjpegincs" = "yes"; then
           LIBJPEG_LIBS="$abi_libjpeg_libs"
           LIBJPEG_CFLAGS="-DHAVE_LIBJPEG"
       fi
    fi   
fi

if test "$abi_found_libjpeg" = "yes" -a "$abi_found_libjpegincs" = "yes"; then
	libjpeg="true"
fi


AC_SUBST(LIBJPEG_CFLAGS)
AC_SUBST(LIBJPEG_LIBS)
AM_CONDITIONAL(WITH_LIBJPEG, test "x$libjpeg" = "xtrue")

])

