#include "pfaedit.h"
#include <stdio.h>
#include "splinefont.h"
#include "psfont.h"			/* For AdobeStandardEncoding */

static void AfmSplineChar(FILE *afm, SplineChar *sc) {
    DBounds b;

    SplineCharFindBounds(sc,&b);
    fprintf( afm, "C %d ; WX %d ; N %s ; B %d %d %d %d ;\n",
	    sc->enc, sc->width, sc->name,
	    (int) b.minx, (int) b.miny, (int) b.maxx, (int) b.maxy );
}

int AfmSplineFont(FILE *afm, SplineFont *sf) {
    DBounds b;
    double width;
    int i, cnt, isadobe;
    int caph, xh, ash, dsh;

    fprintf( afm, "StartFontMetrics 2.0\n" );
    fprintf( afm, "Comment Generated by pfaedit\n" );
    fprintf( afm, "FontName %s\n", sf->fontname );
    if ( sf->fullname!=NULL ) fprintf( afm, "FullName %s\n", sf->fullname );
    if ( sf->familyname!=NULL ) fprintf( afm, "FamilyName %s\n", sf->familyname );
    if ( sf->weight!=NULL ) fprintf( afm, "Weight %s\n", sf->weight );
    if ( sf->copyright!=NULL ) fprintf( afm, "Notice (%s)\n", sf->copyright );
    fprintf( afm, "ItalicAngle %g\n", sf->italicangle );
    width = -1;
    for ( i=0; i<sf->charcnt; ++i ) if ( strcmp(sf->chars[i]->name,".notdef")!=0 ) {
	if ( width==-1 ) width = sf->chars[i]->width;
	else if ( width!=sf->chars[i]->width ) {
	    width = -2;
    break;
	}
    }
    fprintf( afm, "IsFixedPitch %s\n", width==-2?"false":"true" );
    fprintf( afm, "UnderlinePosition %g\n", sf->upos );
    fprintf( afm, "UnderlineThickness %g\n", sf->uwidth );
    if ( sf->version!=NULL ) fprintf( afm, "Version %s\n", sf->version );
    isadobe = false;
    if ( sf->charcnt>=256 ) {
	isadobe = true;
	for ( i=0; i<256 && isadobe; ++i )
	    if ( strcmp(sf->chars[i]->name,AdobeStandardEncoding[i])!=0 )
		isadobe = false;
    }
    fprintf( afm, "EncodingScheme %s\n", isadobe?"AdobeStandardEncoding":"FontSpecific" );
    SplineFontFindBounds(sf,&b);
    fprintf( afm, "FontBBox %d %d %d %d\n", (int) b.minx, (int) b.miny,
	    (int) b.maxx, (int) b.maxy );

    caph = xh = ash = dsh = 0; cnt = 0;
    for ( i=0; i<sf->charcnt; ++i ) {
	if ( sf->chars[i]->unicodeenc=='I' || sf->chars[i]->unicodeenc=='x' ||
		sf->chars[i]->unicodeenc=='p' || sf->chars[i]->unicodeenc=='l' ) {
	    SplineCharFindBounds(sf->chars[i],&b);
	    if ( sf->chars[i]->unicodeenc=='I' )
		caph = b.maxy;
	    else if ( sf->chars[i]->unicodeenc=='x' )
		xh = b.maxy;
	    else if ( sf->chars[i]->unicodeenc=='l' )
		ash = b.maxy;
	    else
		dsh = b.miny;
	}
	if ( strcmp(sf->chars[i]->name,".notdef")!=0 )
	    ++cnt;
    }
    if ( caph!=0 )
	fprintf( afm, "CapHeight %d\n", caph );
    if ( xh!=0 )
	fprintf( afm, "XHeight %d\n", xh );
    if ( ash!=0 )
	fprintf( afm, "Ascender %d\n", ash );
    if ( dsh!=0 )
	fprintf( afm, "Descender %d\n", dsh );

    fprintf( afm, "StartCharMetrics %d\n", cnt );
    for ( i=0; i<sf->charcnt; ++i ) if ( strcmp(sf->chars[i]->name,".notdef")!=0 ) {
	AfmSplineChar(afm,sf->chars[i]);
    }
    fprintf( afm, "EndCharMetrics\n" );
    /* kerning pairs? */
    fprintf( afm, "EndFontMetrics\n" );
return( !ferror(afm));
}
