/* FriBidi - Library of BiDi algorithm
 * Copyright (C) 1999 Dov Grobgeld
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	 See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */
/*======================================================================
//  This file was automatically created from PropList-2.1.8.txt
//  by the perl script CreateGetType.pl.
//----------------------------------------------------------------------*/


//#include "fribidi.h"

/* The Bidi property List */
struct {
  FriBidiChar      first, last;
  FriBidiCharType  char_type;
} FriBidiPropertyList[] = {
  {0x0000, 0x0008, FRIBIDI_TYPE_ON },
  {0x0009, 0x0009, FRIBIDI_TYPE_SS },
  {0x000A, 0x000A, FRIBIDI_TYPE_BS },
  {0x000B, 0x000B, FRIBIDI_TYPE_SS },
  {0x000C, 0x000D, FRIBIDI_TYPE_BS },
  {0x000E, 0x001B, FRIBIDI_TYPE_ON },
  {0x001C, 0x001E, FRIBIDI_TYPE_BS },
  {0x001F, 0x001F, FRIBIDI_TYPE_SS },
  {0x0020, 0x0020, FRIBIDI_TYPE_WS },/*  ' '   */
  {0x0021, 0x0022, FRIBIDI_TYPE_ON },/*  '!'..'"'   */
  {0x0023, 0x0025, FRIBIDI_TYPE_ET },/*  '#'..'%'   */
  {0x0026, 0x002A, FRIBIDI_TYPE_ON },/*  '&'..'*'   */
  {0x002B, 0x002B, FRIBIDI_TYPE_ET },/*  '+'   */
  {0x002C, 0x002C, FRIBIDI_TYPE_CS },/*  ','   */
  {0x002D, 0x002D, FRIBIDI_TYPE_ET },/*  '-'   */
  {0x002E, 0x002E, FRIBIDI_TYPE_CS },/*  '.'   */
  {0x002F, 0x002F, FRIBIDI_TYPE_ES },/*  '/'   */
  {0x0030, 0x0039, FRIBIDI_TYPE_EN },/*  '0'..'9'   */
  {0x003A, 0x003A, FRIBIDI_TYPE_CS },/*  ':'   */
  {0x003B, 0x0040, FRIBIDI_TYPE_ON },/*  ';'..'@'   */
  {0x0041, 0x005A, FRIBIDI_TYPE_LTR },/*  'A'..'Z'   */
  {0x005B, 0x0060, FRIBIDI_TYPE_ON },/*  '['..'`'   */
  {0x0061, 0x007A, FRIBIDI_TYPE_LTR },/*  'a'..'z'   */
  {0x007B, 0x009F, FRIBIDI_TYPE_ON },/*  '{'..''   */
  {0x00A0, 0x00A0, FRIBIDI_TYPE_WS },
  {0x00A1, 0x00A1, FRIBIDI_TYPE_ON },
  {0x00A2, 0x00A5, FRIBIDI_TYPE_ET },
  {0x00A6, 0x00A9, FRIBIDI_TYPE_ON },
  {0x00AA, 0x00AA, FRIBIDI_TYPE_LTR },
  {0x00AB, 0x00AF, FRIBIDI_TYPE_ON },
  {0x00B0, 0x00B1, FRIBIDI_TYPE_ET },
  {0x00B2, 0x00B3, FRIBIDI_TYPE_EN },
  {0x00B4, 0x00B4, FRIBIDI_TYPE_ON },
  {0x00B5, 0x00B5, FRIBIDI_TYPE_LTR },
  {0x00B6, 0x00B8, FRIBIDI_TYPE_ON },
  {0x00B9, 0x00B9, FRIBIDI_TYPE_EN },
  {0x00BA, 0x00BA, FRIBIDI_TYPE_LTR },
  {0x00BB, 0x00BF, FRIBIDI_TYPE_ON },
  {0x00C0, 0x00D6, FRIBIDI_TYPE_LTR },
  {0x00D7, 0x00D7, FRIBIDI_TYPE_ON },
  {0x00D8, 0x00F6, FRIBIDI_TYPE_LTR },
  {0x00F7, 0x00F7, FRIBIDI_TYPE_ON },
  {0x00F8, 0x01F5, FRIBIDI_TYPE_LTR },
  {0x01FA, 0x0217, FRIBIDI_TYPE_LTR },
  {0x0250, 0x02A8, FRIBIDI_TYPE_LTR },
  {0x02B0, 0x02B8, FRIBIDI_TYPE_LTR },
  {0x02B9, 0x02BA, FRIBIDI_TYPE_ON },
  {0x02BB, 0x02C1, FRIBIDI_TYPE_LTR },
  {0x02C2, 0x02DE, FRIBIDI_TYPE_ON },
  {0x02E0, 0x02E4, FRIBIDI_TYPE_LTR },
  {0x02E5, 0x02E9, FRIBIDI_TYPE_ON },
  {0x0300, 0x0345, FRIBIDI_TYPE_ON },
  {0x0360, 0x0361, FRIBIDI_TYPE_ON },
  {0x0374, 0x0375, FRIBIDI_TYPE_LTR },
  {0x037A, 0x037A, FRIBIDI_TYPE_LTR },
  {0x037E, 0x037E, FRIBIDI_TYPE_ON },
  {0x0384, 0x0385, FRIBIDI_TYPE_ON },
  {0x0386, 0x0386, FRIBIDI_TYPE_LTR },
  {0x0387, 0x0387, FRIBIDI_TYPE_ON },
  {0x0388, 0x038A, FRIBIDI_TYPE_LTR },
  {0x038C, 0x038C, FRIBIDI_TYPE_LTR },
  {0x038E, 0x03A1, FRIBIDI_TYPE_LTR },
  {0x03A3, 0x03CE, FRIBIDI_TYPE_LTR },
  {0x03D0, 0x03D6, FRIBIDI_TYPE_LTR },
  {0x03DA, 0x03DA, FRIBIDI_TYPE_LTR },
  {0x03DC, 0x03DC, FRIBIDI_TYPE_LTR },
  {0x03DE, 0x03DE, FRIBIDI_TYPE_LTR },
  {0x03E0, 0x03E0, FRIBIDI_TYPE_LTR },
  {0x03E2, 0x03F3, FRIBIDI_TYPE_LTR },
  {0x0401, 0x040C, FRIBIDI_TYPE_LTR },
  {0x040E, 0x044F, FRIBIDI_TYPE_LTR },
  {0x0451, 0x045C, FRIBIDI_TYPE_LTR },
  {0x045E, 0x0482, FRIBIDI_TYPE_LTR },
  {0x0483, 0x0486, FRIBIDI_TYPE_ON },
  {0x0490, 0x04C4, FRIBIDI_TYPE_LTR },
  {0x04C7, 0x04C8, FRIBIDI_TYPE_LTR },
  {0x04CB, 0x04CC, FRIBIDI_TYPE_LTR },
  {0x04D0, 0x04EB, FRIBIDI_TYPE_LTR },
  {0x04EE, 0x04F5, FRIBIDI_TYPE_LTR },
  {0x04F8, 0x04F9, FRIBIDI_TYPE_LTR },
  {0x0531, 0x0556, FRIBIDI_TYPE_LTR },
  {0x0559, 0x055F, FRIBIDI_TYPE_LTR },
  {0x0561, 0x0587, FRIBIDI_TYPE_LTR },
  {0x0589, 0x0589, FRIBIDI_TYPE_LTR },
  {0x0591, 0x05A1, FRIBIDI_TYPE_RTL }, //#TF changed from _ON
  {0x05A3, 0x05B9, FRIBIDI_TYPE_RTL }, //#TF changed from _ON
  {0x05BB, 0x05BD, FRIBIDI_TYPE_RTL }, //#TF changed from _ON
  {0x05BE, 0x05BE, FRIBIDI_TYPE_RTL },
  {0x05BF, 0x05BF, FRIBIDI_TYPE_RTL }, //#TF changed from _ON
  {0x05C0, 0x05C0, FRIBIDI_TYPE_RTL },
  {0x05C1, 0x05C2, FRIBIDI_TYPE_RTL }, //#TF changed from _ON
  {0x05C3, 0x05C3, FRIBIDI_TYPE_RTL },
  {0x05C4, 0x05C4, FRIBIDI_TYPE_RTL }, //#TF changed from _ON
  {0x05D0, 0x05EA, FRIBIDI_TYPE_RTL },
  {0x05F0, 0x05F4, FRIBIDI_TYPE_RTL },
  {0x060C, 0x060C, FRIBIDI_TYPE_CS },
  {0x061B, 0x061B, FRIBIDI_TYPE_RTL },
  {0x061F, 0x061F, FRIBIDI_TYPE_RTL },
  {0x0621, 0x063A, FRIBIDI_TYPE_RTL },
  {0x0640, 0x064A, FRIBIDI_TYPE_RTL },
  {0x064B, 0x0652, FRIBIDI_TYPE_ON },
  {0x0660, 0x0669, FRIBIDI_TYPE_AN },
  {0x066A, 0x066A, FRIBIDI_TYPE_ET },
  {0x066B, 0x066C, FRIBIDI_TYPE_AN },
  {0x066D, 0x066D, FRIBIDI_TYPE_RTL },
  {0x0670, 0x0670, FRIBIDI_TYPE_ON },
  {0x0671, 0x06B7, FRIBIDI_TYPE_RTL },
  {0x06BA, 0x06BE, FRIBIDI_TYPE_RTL },
  {0x06C0, 0x06CE, FRIBIDI_TYPE_RTL },
  {0x06D0, 0x06D5, FRIBIDI_TYPE_RTL },
  {0x06D6, 0x06E4, FRIBIDI_TYPE_ON },
  {0x06E5, 0x06E6, FRIBIDI_TYPE_RTL },
  {0x06E7, 0x06ED, FRIBIDI_TYPE_ON },
  {0x06F0, 0x06F9, FRIBIDI_TYPE_EN },
  {0x0700, 0x070D, FRIBIDI_TYPE_WS }, //0x0700 - 0x074A added by #TF
  {0x070F, 0x074A, FRIBIDI_TYPE_RTL },
  {0x0901, 0x0902, FRIBIDI_TYPE_ON },
  {0x0903, 0x0903, FRIBIDI_TYPE_LTR },
  {0x0905, 0x0939, FRIBIDI_TYPE_LTR },
  {0x093C, 0x093C, FRIBIDI_TYPE_ON },
  {0x093D, 0x0940, FRIBIDI_TYPE_LTR },
  {0x0941, 0x0948, FRIBIDI_TYPE_ON },
  {0x0949, 0x094C, FRIBIDI_TYPE_LTR },
  {0x094D, 0x094D, FRIBIDI_TYPE_ON },
  {0x0950, 0x0950, FRIBIDI_TYPE_LTR },
  {0x0951, 0x0954, FRIBIDI_TYPE_ON },
  {0x0958, 0x0961, FRIBIDI_TYPE_LTR },
  {0x0962, 0x0963, FRIBIDI_TYPE_ON },
  {0x0964, 0x0970, FRIBIDI_TYPE_LTR },
  {0x0981, 0x0981, FRIBIDI_TYPE_ON },
  {0x0982, 0x0983, FRIBIDI_TYPE_LTR },
  {0x0985, 0x098C, FRIBIDI_TYPE_LTR },
  {0x098F, 0x0990, FRIBIDI_TYPE_LTR },
  {0x0993, 0x09A8, FRIBIDI_TYPE_LTR },
  {0x09AA, 0x09B0, FRIBIDI_TYPE_LTR },
  {0x09B2, 0x09B2, FRIBIDI_TYPE_LTR },
  {0x09B6, 0x09B9, FRIBIDI_TYPE_LTR },
  {0x09BC, 0x09BC, FRIBIDI_TYPE_ON },
  {0x09BE, 0x09C0, FRIBIDI_TYPE_LTR },
  {0x09C1, 0x09C4, FRIBIDI_TYPE_ON },
  {0x09C7, 0x09C8, FRIBIDI_TYPE_LTR },
  {0x09CB, 0x09CC, FRIBIDI_TYPE_LTR },
  {0x09CD, 0x09CD, FRIBIDI_TYPE_ON },
  {0x09D7, 0x09D7, FRIBIDI_TYPE_LTR },
  {0x09DC, 0x09DD, FRIBIDI_TYPE_LTR },
  {0x09DF, 0x09E1, FRIBIDI_TYPE_LTR },
  {0x09E2, 0x09E3, FRIBIDI_TYPE_ON },
  {0x09E6, 0x09F1, FRIBIDI_TYPE_LTR },
  {0x09F2, 0x09F3, FRIBIDI_TYPE_ET },
  {0x09F4, 0x09FA, FRIBIDI_TYPE_LTR },
  {0x0A02, 0x0A02, FRIBIDI_TYPE_ON },
  {0x0A05, 0x0A0A, FRIBIDI_TYPE_LTR },
  {0x0A0F, 0x0A10, FRIBIDI_TYPE_LTR },
  {0x0A13, 0x0A28, FRIBIDI_TYPE_LTR },
  {0x0A2A, 0x0A30, FRIBIDI_TYPE_LTR },
  {0x0A32, 0x0A33, FRIBIDI_TYPE_LTR },
  {0x0A35, 0x0A36, FRIBIDI_TYPE_LTR },
  {0x0A38, 0x0A39, FRIBIDI_TYPE_LTR },
  {0x0A3C, 0x0A3C, FRIBIDI_TYPE_ON },
  {0x0A3E, 0x0A40, FRIBIDI_TYPE_LTR },
  {0x0A41, 0x0A42, FRIBIDI_TYPE_ON },
  {0x0A47, 0x0A48, FRIBIDI_TYPE_ON },
  {0x0A4B, 0x0A4D, FRIBIDI_TYPE_ON },
  {0x0A59, 0x0A5C, FRIBIDI_TYPE_LTR },
  {0x0A5E, 0x0A5E, FRIBIDI_TYPE_LTR },
  {0x0A66, 0x0A6F, FRIBIDI_TYPE_LTR },
  {0x0A70, 0x0A71, FRIBIDI_TYPE_ON },
  {0x0A72, 0x0A74, FRIBIDI_TYPE_LTR },
  {0x0A81, 0x0A82, FRIBIDI_TYPE_ON },
  {0x0A83, 0x0A83, FRIBIDI_TYPE_LTR },
  {0x0A85, 0x0A8B, FRIBIDI_TYPE_LTR },
  {0x0A8D, 0x0A8D, FRIBIDI_TYPE_LTR },
  {0x0A8F, 0x0A91, FRIBIDI_TYPE_LTR },
  {0x0A93, 0x0AA8, FRIBIDI_TYPE_LTR },
  {0x0AAA, 0x0AB0, FRIBIDI_TYPE_LTR },
  {0x0AB2, 0x0AB3, FRIBIDI_TYPE_LTR },
  {0x0AB5, 0x0AB9, FRIBIDI_TYPE_LTR },
  {0x0ABC, 0x0ABC, FRIBIDI_TYPE_ON },
  {0x0ABD, 0x0AC0, FRIBIDI_TYPE_LTR },
  {0x0AC1, 0x0AC5, FRIBIDI_TYPE_ON },
  {0x0AC7, 0x0AC8, FRIBIDI_TYPE_ON },
  {0x0AC9, 0x0AC9, FRIBIDI_TYPE_LTR },
  {0x0ACB, 0x0ACC, FRIBIDI_TYPE_LTR },
  {0x0ACD, 0x0ACD, FRIBIDI_TYPE_ON },
  {0x0AD0, 0x0AD0, FRIBIDI_TYPE_LTR },
  {0x0AE0, 0x0AE0, FRIBIDI_TYPE_LTR },
  {0x0AE6, 0x0AEF, FRIBIDI_TYPE_LTR },
  {0x0B01, 0x0B01, FRIBIDI_TYPE_ON },
  {0x0B02, 0x0B03, FRIBIDI_TYPE_LTR },
  {0x0B05, 0x0B0C, FRIBIDI_TYPE_LTR },
  {0x0B0F, 0x0B10, FRIBIDI_TYPE_LTR },
  {0x0B13, 0x0B28, FRIBIDI_TYPE_LTR },
  {0x0B2A, 0x0B30, FRIBIDI_TYPE_LTR },
  {0x0B32, 0x0B33, FRIBIDI_TYPE_LTR },
  {0x0B36, 0x0B39, FRIBIDI_TYPE_LTR },
  {0x0B3C, 0x0B3C, FRIBIDI_TYPE_ON },
  {0x0B3D, 0x0B3E, FRIBIDI_TYPE_LTR },
  {0x0B3F, 0x0B3F, FRIBIDI_TYPE_ON },
  {0x0B40, 0x0B40, FRIBIDI_TYPE_LTR },
  {0x0B41, 0x0B43, FRIBIDI_TYPE_ON },
  {0x0B47, 0x0B48, FRIBIDI_TYPE_LTR },
  {0x0B4B, 0x0B4C, FRIBIDI_TYPE_LTR },
  {0x0B4D, 0x0B4D, FRIBIDI_TYPE_ON },
  {0x0B56, 0x0B56, FRIBIDI_TYPE_ON },
  {0x0B57, 0x0B57, FRIBIDI_TYPE_LTR },
  {0x0B5C, 0x0B5D, FRIBIDI_TYPE_LTR },
  {0x0B5F, 0x0B61, FRIBIDI_TYPE_LTR },
  {0x0B66, 0x0B70, FRIBIDI_TYPE_LTR },
  {0x0B82, 0x0B82, FRIBIDI_TYPE_ON },
  {0x0B83, 0x0B83, FRIBIDI_TYPE_LTR },
  {0x0B85, 0x0B8A, FRIBIDI_TYPE_LTR },
  {0x0B8E, 0x0B90, FRIBIDI_TYPE_LTR },
  {0x0B92, 0x0B95, FRIBIDI_TYPE_LTR },
  {0x0B99, 0x0B9A, FRIBIDI_TYPE_LTR },
  {0x0B9C, 0x0B9C, FRIBIDI_TYPE_LTR },
  {0x0B9E, 0x0B9F, FRIBIDI_TYPE_LTR },
  {0x0BA3, 0x0BA4, FRIBIDI_TYPE_LTR },
  {0x0BA8, 0x0BAA, FRIBIDI_TYPE_LTR },
  {0x0BAE, 0x0BB5, FRIBIDI_TYPE_LTR },
  {0x0BB7, 0x0BB9, FRIBIDI_TYPE_LTR },
  {0x0BBE, 0x0BBF, FRIBIDI_TYPE_LTR },
  {0x0BC0, 0x0BC0, FRIBIDI_TYPE_ON },
  {0x0BC1, 0x0BC2, FRIBIDI_TYPE_LTR },
  {0x0BC6, 0x0BC8, FRIBIDI_TYPE_LTR },
  {0x0BCA, 0x0BCC, FRIBIDI_TYPE_LTR },
  {0x0BCD, 0x0BCD, FRIBIDI_TYPE_ON },
  {0x0BD7, 0x0BD7, FRIBIDI_TYPE_LTR },
  {0x0BE7, 0x0BF2, FRIBIDI_TYPE_LTR },
  {0x0C01, 0x0C03, FRIBIDI_TYPE_LTR },
  {0x0C05, 0x0C0C, FRIBIDI_TYPE_LTR },
  {0x0C0E, 0x0C10, FRIBIDI_TYPE_LTR },
  {0x0C12, 0x0C28, FRIBIDI_TYPE_LTR },
  {0x0C2A, 0x0C33, FRIBIDI_TYPE_LTR },
  {0x0C35, 0x0C39, FRIBIDI_TYPE_LTR },
  {0x0C3E, 0x0C40, FRIBIDI_TYPE_ON },
  {0x0C41, 0x0C44, FRIBIDI_TYPE_LTR },
  {0x0C46, 0x0C48, FRIBIDI_TYPE_ON },
  {0x0C4A, 0x0C4D, FRIBIDI_TYPE_ON },
  {0x0C55, 0x0C56, FRIBIDI_TYPE_ON },
  {0x0C60, 0x0C61, FRIBIDI_TYPE_LTR },
  {0x0C66, 0x0C6F, FRIBIDI_TYPE_LTR },
  {0x0C82, 0x0C83, FRIBIDI_TYPE_LTR },
  {0x0C85, 0x0C8C, FRIBIDI_TYPE_LTR },
  {0x0C8E, 0x0C90, FRIBIDI_TYPE_LTR },
  {0x0C92, 0x0CA8, FRIBIDI_TYPE_LTR },
  {0x0CAA, 0x0CB3, FRIBIDI_TYPE_LTR },
  {0x0CB5, 0x0CB9, FRIBIDI_TYPE_LTR },
  {0x0CBE, 0x0CBE, FRIBIDI_TYPE_LTR },
  {0x0CBF, 0x0CBF, FRIBIDI_TYPE_ON },
  {0x0CC0, 0x0CC4, FRIBIDI_TYPE_LTR },
  {0x0CC6, 0x0CC6, FRIBIDI_TYPE_ON },
  {0x0CC7, 0x0CC8, FRIBIDI_TYPE_LTR },
  {0x0CCA, 0x0CCB, FRIBIDI_TYPE_LTR },
  {0x0CCC, 0x0CCD, FRIBIDI_TYPE_ON },
  {0x0CD5, 0x0CD6, FRIBIDI_TYPE_LTR },
  {0x0CDE, 0x0CDE, FRIBIDI_TYPE_LTR },
  {0x0CE0, 0x0CE1, FRIBIDI_TYPE_LTR },
  {0x0CE6, 0x0CEF, FRIBIDI_TYPE_LTR },
  {0x0D02, 0x0D03, FRIBIDI_TYPE_LTR },
  {0x0D05, 0x0D0C, FRIBIDI_TYPE_LTR },
  {0x0D0E, 0x0D10, FRIBIDI_TYPE_LTR },
  {0x0D12, 0x0D28, FRIBIDI_TYPE_LTR },
  {0x0D2A, 0x0D39, FRIBIDI_TYPE_LTR },
  {0x0D3E, 0x0D40, FRIBIDI_TYPE_LTR },
  {0x0D41, 0x0D43, FRIBIDI_TYPE_ON },
  {0x0D46, 0x0D48, FRIBIDI_TYPE_LTR },
  {0x0D4A, 0x0D4C, FRIBIDI_TYPE_LTR },
  {0x0D4D, 0x0D4D, FRIBIDI_TYPE_ON },
  {0x0D57, 0x0D57, FRIBIDI_TYPE_LTR },
  {0x0D60, 0x0D61, FRIBIDI_TYPE_LTR },
  {0x0D66, 0x0D6F, FRIBIDI_TYPE_LTR },
  {0x0E01, 0x0E30, FRIBIDI_TYPE_LTR },
  {0x0E31, 0x0E31, FRIBIDI_TYPE_ON },
  {0x0E32, 0x0E33, FRIBIDI_TYPE_LTR },
  {0x0E34, 0x0E3A, FRIBIDI_TYPE_ON },
  {0x0E3F, 0x0E3F, FRIBIDI_TYPE_ET },
  {0x0E40, 0x0E46, FRIBIDI_TYPE_LTR },
  {0x0E47, 0x0E4E, FRIBIDI_TYPE_ON },
  {0x0E4F, 0x0E5B, FRIBIDI_TYPE_LTR },
  {0x0E81, 0x0E82, FRIBIDI_TYPE_LTR },
  {0x0E84, 0x0E84, FRIBIDI_TYPE_LTR },
  {0x0E87, 0x0E88, FRIBIDI_TYPE_LTR },
  {0x0E8A, 0x0E8A, FRIBIDI_TYPE_LTR },
  {0x0E8D, 0x0E8D, FRIBIDI_TYPE_LTR },
  {0x0E94, 0x0E97, FRIBIDI_TYPE_LTR },
  {0x0E99, 0x0E9F, FRIBIDI_TYPE_LTR },
  {0x0EA1, 0x0EA3, FRIBIDI_TYPE_LTR },
  {0x0EA5, 0x0EA5, FRIBIDI_TYPE_LTR },
  {0x0EA7, 0x0EA7, FRIBIDI_TYPE_LTR },
  {0x0EAA, 0x0EAB, FRIBIDI_TYPE_LTR },
  {0x0EAD, 0x0EB0, FRIBIDI_TYPE_LTR },
  {0x0EB1, 0x0EB1, FRIBIDI_TYPE_ON },
  {0x0EB2, 0x0EB3, FRIBIDI_TYPE_LTR },
  {0x0EB4, 0x0EB9, FRIBIDI_TYPE_ON },
  {0x0EBB, 0x0EBC, FRIBIDI_TYPE_ON },
  {0x0EBD, 0x0EBD, FRIBIDI_TYPE_LTR },
  {0x0EC0, 0x0EC4, FRIBIDI_TYPE_LTR },
  {0x0EC6, 0x0EC6, FRIBIDI_TYPE_LTR },
  {0x0EC8, 0x0ECD, FRIBIDI_TYPE_ON },
  {0x0ED0, 0x0ED9, FRIBIDI_TYPE_LTR },
  {0x0EDC, 0x0EDD, FRIBIDI_TYPE_LTR },
  {0x0F00, 0x0F17, FRIBIDI_TYPE_LTR },
  {0x0F18, 0x0F19, FRIBIDI_TYPE_ON },
  {0x0F1A, 0x0F34, FRIBIDI_TYPE_LTR },
  {0x0F35, 0x0F35, FRIBIDI_TYPE_ON },
  {0x0F36, 0x0F36, FRIBIDI_TYPE_LTR },
  {0x0F37, 0x0F37, FRIBIDI_TYPE_ON },
  {0x0F38, 0x0F38, FRIBIDI_TYPE_LTR },
  {0x0F39, 0x0F3F, FRIBIDI_TYPE_ON },
  {0x0F40, 0x0F47, FRIBIDI_TYPE_LTR },
  {0x0F49, 0x0F69, FRIBIDI_TYPE_LTR },
  {0x0F71, 0x0F7E, FRIBIDI_TYPE_ON },
  {0x0F7F, 0x0F7F, FRIBIDI_TYPE_LTR },
  {0x0F80, 0x0F84, FRIBIDI_TYPE_ON },
  {0x0F85, 0x0F85, FRIBIDI_TYPE_LTR },
  {0x0F86, 0x0F87, FRIBIDI_TYPE_ON },
  {0x0F88, 0x0F8B, FRIBIDI_TYPE_LTR },
  {0x0F90, 0x0F95, FRIBIDI_TYPE_ON },
  {0x0F97, 0x0F97, FRIBIDI_TYPE_ON },
  {0x0F99, 0x0FAD, FRIBIDI_TYPE_ON },
  {0x0FB1, 0x0FB7, FRIBIDI_TYPE_ON },
  {0x0FB9, 0x0FB9, FRIBIDI_TYPE_ON },
  {0x10A0, 0x10C5, FRIBIDI_TYPE_LTR },
  {0x10D0, 0x10F6, FRIBIDI_TYPE_LTR },
  {0x10FB, 0x10FB, FRIBIDI_TYPE_LTR },
  {0x1100, 0x1159, FRIBIDI_TYPE_LTR },
  {0x115F, 0x11A2, FRIBIDI_TYPE_LTR },
  {0x11A8, 0x11F9, FRIBIDI_TYPE_LTR },
  {0x1E00, 0x1E9B, FRIBIDI_TYPE_LTR },
  {0x1EA0, 0x1EF9, FRIBIDI_TYPE_LTR },
  {0x1F00, 0x1F15, FRIBIDI_TYPE_LTR },
  {0x1F18, 0x1F1D, FRIBIDI_TYPE_LTR },
  {0x1F20, 0x1F45, FRIBIDI_TYPE_LTR },
  {0x1F48, 0x1F4D, FRIBIDI_TYPE_LTR },
  {0x1F50, 0x1F57, FRIBIDI_TYPE_LTR },
  {0x1F59, 0x1F59, FRIBIDI_TYPE_LTR },
  {0x1F5B, 0x1F5B, FRIBIDI_TYPE_LTR },
  {0x1F5D, 0x1F5D, FRIBIDI_TYPE_LTR },
  {0x1F5F, 0x1F7D, FRIBIDI_TYPE_LTR },
  {0x1F80, 0x1FB4, FRIBIDI_TYPE_LTR },
  {0x1FB6, 0x1FBC, FRIBIDI_TYPE_LTR },
  {0x1FBD, 0x1FBD, FRIBIDI_TYPE_ON },
  {0x1FBE, 0x1FBE, FRIBIDI_TYPE_LTR },
  {0x1FBF, 0x1FC1, FRIBIDI_TYPE_ON },
  {0x1FC2, 0x1FC4, FRIBIDI_TYPE_LTR },
  {0x1FC6, 0x1FCC, FRIBIDI_TYPE_LTR },
  {0x1FCD, 0x1FCF, FRIBIDI_TYPE_ON },
  {0x1FD0, 0x1FD3, FRIBIDI_TYPE_LTR },
  {0x1FD6, 0x1FDB, FRIBIDI_TYPE_LTR },
  {0x1FDD, 0x1FDF, FRIBIDI_TYPE_ON },
  {0x1FE0, 0x1FEC, FRIBIDI_TYPE_LTR },
  {0x1FED, 0x1FEF, FRIBIDI_TYPE_ON },
  {0x1FF2, 0x1FF4, FRIBIDI_TYPE_LTR },
  {0x1FF6, 0x1FFC, FRIBIDI_TYPE_LTR },
  {0x1FFD, 0x1FFE, FRIBIDI_TYPE_ON },
  {0x2000, 0x2006, FRIBIDI_TYPE_WS },
  {0x2007, 0x2007, FRIBIDI_TYPE_CS },
  {0x2008, 0x200B, FRIBIDI_TYPE_WS },
  {0x200C, 0x200D, FRIBIDI_TYPE_ON },
  {0x200E, 0x200E, FRIBIDI_TYPE_LTR },
  {0x200E, 0x200F, FRIBIDI_TYPE_CTL },
  {0x200F, 0x200F, FRIBIDI_TYPE_RTL },
  {0x2010, 0x2027, FRIBIDI_TYPE_ON },
  {0x2028, 0x2029, FRIBIDI_TYPE_BS },
  {0x202A, 0x202A, FRIBIDI_TYPE_LTR },
  {0x202A, 0x202E, FRIBIDI_TYPE_CTL },
  {0x202B, 0x202B, FRIBIDI_TYPE_RTL },
  {0x202C, 0x202C, FRIBIDI_TYPE_ON },
  {0x202D, 0x202D, FRIBIDI_TYPE_LTR },
  {0x202E, 0x202E, FRIBIDI_TYPE_RTL },
  {0x2030, 0x2034, FRIBIDI_TYPE_ET },
  {0x2035, 0x2046, FRIBIDI_TYPE_ON },
  {0x206A, 0x206F, FRIBIDI_TYPE_ON },
  {0x2070, 0x2070, FRIBIDI_TYPE_EN },
  {0x2074, 0x2079, FRIBIDI_TYPE_EN },
  {0x207A, 0x207B, FRIBIDI_TYPE_ET },
  {0x207C, 0x207E, FRIBIDI_TYPE_ON },
  {0x207F, 0x207F, FRIBIDI_TYPE_LTR },
  {0x2080, 0x2089, FRIBIDI_TYPE_EN },
  {0x208A, 0x208B, FRIBIDI_TYPE_ET },
  {0x208C, 0x208E, FRIBIDI_TYPE_ON },
  {0x20A0, 0x20AC, FRIBIDI_TYPE_ET },
  {0x20D0, 0x20E1, FRIBIDI_TYPE_ON },
  {0x2100, 0x2101, FRIBIDI_TYPE_ON },
  {0x2102, 0x2102, FRIBIDI_TYPE_LTR },
  {0x2103, 0x2106, FRIBIDI_TYPE_ON },
  {0x2107, 0x2107, FRIBIDI_TYPE_LTR },
  {0x2108, 0x2109, FRIBIDI_TYPE_ON },
  {0x210A, 0x2113, FRIBIDI_TYPE_LTR },
  {0x2114, 0x2114, FRIBIDI_TYPE_ON },
  {0x2115, 0x2115, FRIBIDI_TYPE_LTR },
  {0x2116, 0x2117, FRIBIDI_TYPE_ON },
  {0x2118, 0x211D, FRIBIDI_TYPE_LTR },
  {0x211E, 0x2123, FRIBIDI_TYPE_ON },
  {0x2124, 0x2124, FRIBIDI_TYPE_LTR },
  {0x2125, 0x2125, FRIBIDI_TYPE_ON },
  {0x2126, 0x2126, FRIBIDI_TYPE_LTR },
  {0x2127, 0x2127, FRIBIDI_TYPE_ON },
  {0x2128, 0x2128, FRIBIDI_TYPE_LTR },
  {0x2129, 0x2129, FRIBIDI_TYPE_ON },
  {0x212A, 0x2131, FRIBIDI_TYPE_LTR },
  {0x2132, 0x2132, FRIBIDI_TYPE_ON },
  {0x2133, 0x2138, FRIBIDI_TYPE_LTR },
  {0x2153, 0x215F, FRIBIDI_TYPE_ON },
  {0x2160, 0x2182, FRIBIDI_TYPE_LTR },
  {0x2190, 0x21EA, FRIBIDI_TYPE_ON },
  {0x2200, 0x2211, FRIBIDI_TYPE_ON },
  {0x2212, 0x2213, FRIBIDI_TYPE_ET },
  {0x2214, 0x22F1, FRIBIDI_TYPE_ON },
  {0x2300, 0x2300, FRIBIDI_TYPE_ON },
  {0x2302, 0x2335, FRIBIDI_TYPE_ON },
  {0x2336, 0x237A, FRIBIDI_TYPE_LTR },
  {0x2400, 0x2424, FRIBIDI_TYPE_ON },
  {0x2440, 0x244A, FRIBIDI_TYPE_ON },
  {0x2460, 0x249B, FRIBIDI_TYPE_EN },
  {0x249C, 0x24E9, FRIBIDI_TYPE_LTR },
  {0x24EA, 0x24EA, FRIBIDI_TYPE_EN },
  {0x2500, 0x2595, FRIBIDI_TYPE_ON },
  {0x25A0, 0x25EF, FRIBIDI_TYPE_ON },
  {0x2600, 0x2613, FRIBIDI_TYPE_ON },
  {0x261A, 0x266F, FRIBIDI_TYPE_ON },
  {0x2701, 0x2704, FRIBIDI_TYPE_ON },
  {0x2706, 0x2709, FRIBIDI_TYPE_ON },
  {0x270C, 0x2727, FRIBIDI_TYPE_ON },
  {0x2729, 0x274B, FRIBIDI_TYPE_ON },
  {0x274D, 0x274D, FRIBIDI_TYPE_ON },
  {0x274F, 0x2752, FRIBIDI_TYPE_ON },
  {0x2756, 0x2756, FRIBIDI_TYPE_ON },
  {0x2758, 0x275E, FRIBIDI_TYPE_ON },
  {0x2761, 0x2767, FRIBIDI_TYPE_ON },
  {0x2776, 0x2794, FRIBIDI_TYPE_ON },
  {0x2798, 0x27AF, FRIBIDI_TYPE_ON },
  {0x27B1, 0x27BE, FRIBIDI_TYPE_ON },
  {0x3000, 0x3000, FRIBIDI_TYPE_WS },
  {0x3001, 0x3005, FRIBIDI_TYPE_ON },
  {0x3006, 0x3007, FRIBIDI_TYPE_LTR },
  {0x3008, 0x3020, FRIBIDI_TYPE_ON },
  {0x3021, 0x3029, FRIBIDI_TYPE_LTR },
  {0x302A, 0x3037, FRIBIDI_TYPE_ON },
  {0x303F, 0x303F, FRIBIDI_TYPE_ON },
  {0x3041, 0x3094, FRIBIDI_TYPE_LTR },
  {0x3099, 0x309C, FRIBIDI_TYPE_ON },
  {0x309D, 0x309E, FRIBIDI_TYPE_LTR },
  {0x30A1, 0x30FE, FRIBIDI_TYPE_LTR },
  {0x3105, 0x312C, FRIBIDI_TYPE_LTR },
  {0x3131, 0x318E, FRIBIDI_TYPE_LTR },
  {0x3190, 0x319F, FRIBIDI_TYPE_LTR },
  {0x3200, 0x321C, FRIBIDI_TYPE_LTR },
  {0x3220, 0x3243, FRIBIDI_TYPE_LTR },
  {0x3260, 0x327B, FRIBIDI_TYPE_LTR },
  {0x327F, 0x32B0, FRIBIDI_TYPE_LTR },
  {0x32C0, 0x32CB, FRIBIDI_TYPE_LTR },
  {0x32D0, 0x32FE, FRIBIDI_TYPE_LTR },
  {0x3300, 0x3376, FRIBIDI_TYPE_LTR },
  {0x337B, 0x33DD, FRIBIDI_TYPE_LTR },
  {0x33E0, 0x33FE, FRIBIDI_TYPE_LTR },
  {0x4E00, 0x9FA5, FRIBIDI_TYPE_LTR },
  {0xAC00, 0xD7A3, FRIBIDI_TYPE_LTR },
  {0xD800, 0xFA2D, FRIBIDI_TYPE_LTR },
  {0xFB00, 0xFB06, FRIBIDI_TYPE_LTR },
  {0xFB13, 0xFB17, FRIBIDI_TYPE_LTR },
  {0xFB1E, 0xFB1E, FRIBIDI_TYPE_ON },
  {0xFB1F, 0xFB28, FRIBIDI_TYPE_RTL },
  {0xFB29, 0xFB29, FRIBIDI_TYPE_ET },
  {0xFB2A, 0xFB36, FRIBIDI_TYPE_RTL },
  {0xFB38, 0xFB3C, FRIBIDI_TYPE_RTL },
  {0xFB3E, 0xFB3E, FRIBIDI_TYPE_RTL },
  {0xFB40, 0xFB41, FRIBIDI_TYPE_RTL },
  {0xFB43, 0xFB44, FRIBIDI_TYPE_RTL },
  {0xFB46, 0xFBB1, FRIBIDI_TYPE_RTL },
  {0xFBD3, 0xFD3D, FRIBIDI_TYPE_RTL },
  {0xFD3E, 0xFD3F, FRIBIDI_TYPE_ON },
  {0xFD50, 0xFD8F, FRIBIDI_TYPE_RTL },
  {0xFD92, 0xFDC7, FRIBIDI_TYPE_RTL },
  {0xFDF0, 0xFDFB, FRIBIDI_TYPE_RTL },
  {0xFE20, 0xFE23, FRIBIDI_TYPE_ON },
  {0xFE30, 0xFE44, FRIBIDI_TYPE_ON },
  {0xFE49, 0xFE4F, FRIBIDI_TYPE_ON },
  {0xFE50, 0xFE50, FRIBIDI_TYPE_CS },
  {0xFE51, 0xFE51, FRIBIDI_TYPE_ON },
  {0xFE52, 0xFE52, FRIBIDI_TYPE_CS },
  {0xFE54, 0xFE54, FRIBIDI_TYPE_ON },
  {0xFE55, 0xFE55, FRIBIDI_TYPE_CS },
  {0xFE56, 0xFE5E, FRIBIDI_TYPE_ON },
  {0xFE5F, 0xFE5F, FRIBIDI_TYPE_ET },
  {0xFE60, 0xFE61, FRIBIDI_TYPE_ON },
  {0xFE62, 0xFE63, FRIBIDI_TYPE_ET },
  {0xFE64, 0xFE66, FRIBIDI_TYPE_ON },
  {0xFE68, 0xFE68, FRIBIDI_TYPE_ON },
  {0xFE69, 0xFE6A, FRIBIDI_TYPE_ET },
  {0xFE6B, 0xFE6B, FRIBIDI_TYPE_ON },
  {0xFE70, 0xFE72, FRIBIDI_TYPE_RTL },
  {0xFE74, 0xFE74, FRIBIDI_TYPE_RTL },
  {0xFE76, 0xFEFC, FRIBIDI_TYPE_RTL },
  {0xFEFF, 0xFEFF, FRIBIDI_TYPE_ON },
  {0xFF01, 0xFF02, FRIBIDI_TYPE_ON },
  {0xFF03, 0xFF05, FRIBIDI_TYPE_ET },
  {0xFF06, 0xFF0A, FRIBIDI_TYPE_ON },
  {0xFF0B, 0xFF0B, FRIBIDI_TYPE_ET },
  {0xFF0C, 0xFF0C, FRIBIDI_TYPE_CS },
  {0xFF0D, 0xFF0D, FRIBIDI_TYPE_ET },
  {0xFF0E, 0xFF0E, FRIBIDI_TYPE_CS },
  {0xFF0F, 0xFF0F, FRIBIDI_TYPE_ES },
  {0xFF10, 0xFF19, FRIBIDI_TYPE_EN },
  {0xFF1A, 0xFF1A, FRIBIDI_TYPE_CS },
  {0xFF1B, 0xFF20, FRIBIDI_TYPE_ON },
  {0xFF21, 0xFF3A, FRIBIDI_TYPE_LTR },
  {0xFF3B, 0xFF40, FRIBIDI_TYPE_ON },
  {0xFF41, 0xFF5A, FRIBIDI_TYPE_LTR },
  {0xFF5B, 0xFF5E, FRIBIDI_TYPE_ON },
  {0xFF61, 0xFF64, FRIBIDI_TYPE_ON },
  {0xFF65, 0xFF9D, FRIBIDI_TYPE_LTR },
  {0xFF9E, 0xFF9F, FRIBIDI_TYPE_ON },
  {0xFFA0, 0xFFBE, FRIBIDI_TYPE_LTR },
  {0xFFC2, 0xFFC7, FRIBIDI_TYPE_LTR },
  {0xFFCA, 0xFFCF, FRIBIDI_TYPE_LTR },
  {0xFFD2, 0xFFD7, FRIBIDI_TYPE_LTR },
  {0xFFDA, 0xFFDC, FRIBIDI_TYPE_LTR },
  {0xFFE0, 0xFFE1, FRIBIDI_TYPE_ET },
  {0xFFE2, 0xFFE4, FRIBIDI_TYPE_ON },
  {0xFFE5, 0xFFE6, FRIBIDI_TYPE_ET },
  {0xFFE8, 0xFFEE, FRIBIDI_TYPE_ON },
  {0xFFFC, 0xFFFD, FRIBIDI_TYPE_ON }
};

gint nFriBidiPropertyList = 521;


/*======================================================================
//  An arabic letter for the purpose of changing EN to AN is considered
//  any unicode character whose name starts with "ARABIC" and is strong
//  right.
//======================================================================*/
struct {
  FriBidiChar first, last;
} FriBidiArabicStrongLetterRanges[] = {
  {0x061B, 0x064A},
  {0x066D, 0x066D},
  {0x0671, 0x06D5},
  {0x06E5, 0x06E6},
  {0xFB50, 0xFD3D},
  {0xFD50, 0xFDFB},
  {0xFE70, 0xFEFC}
};

gint nFriBidiArabicStrongLetterRanges = 7;
/*======================================================================
//  Mirrored characters include all the characters in the Unicode list
//  that have been declared as being mirrored and that have a mirrored
//  equivalent.
//
//  There are lots of characters that are designed as being mirrored
//  but do not have any mirrored glyph, e.g. the sign for there exist.
//  Are these used in Arabic? That is are all the mathematical signs
//  that are assigned to be mirrorable actually mirrored in Arabic?
//  If that is the case, I'll change the below code to include also
//  characters that mirror to themself. It will then be the responsibility
//  of the display engine to actually mirror these.
//----------------------------------------------------------------------*/

struct {
     FriBidiChar ch, mirrored_ch;
} FriBidiMirroredChars[] = {
  {0x0028, 0x0029},
  {0x0029, 0x0028},
  {0x003C, 0x003E},
  {0x003E, 0x003C},
  {0x005B, 0x005D},
  {0x005D, 0x005B},
  {0x007B, 0x007D},
  {0x007D, 0x007B},
  {0x00AB, 0x00BB},
  {0x00BB, 0x00AB},
  {0x2039, 0x203A},
  {0x203A, 0x2039},
  {0x2045, 0x2046},
  {0x2046, 0x2045},
  {0x207D, 0x207E},
  {0x207E, 0x207D},
  {0x208D, 0x208E},
  {0x208E, 0x208D},
  {0x2264, 0x2265},
  {0x2265, 0x2264},
  {0x2266, 0x2267},
  {0x2267, 0x2266},
  {0x2268, 0x2269},
  {0x2269, 0x2268},
  {0x226A, 0x226B},
  {0x226B, 0x226A},
  {0x226E, 0x226F},
  {0x226F, 0x226E},
  {0x2270, 0x2271},
  {0x2271, 0x2270},
  {0x2272, 0x2273},
  {0x2273, 0x2272},
  {0x2274, 0x2275},
  {0x2275, 0x2274},
  {0x22A2, 0x22A3},
  {0x22A3, 0x22A2},
  {0x22C9, 0x22CA},
  {0x22CA, 0x22C9},
  {0x22CB, 0x22CC},
  {0x22CC, 0x22CB},
  {0x22D6, 0x22D7},
  {0x22D7, 0x22D6},
  {0x22D8, 0x22D9},
  {0x22D9, 0x22D8},
  {0x22DC, 0x22DD},
  {0x22DD, 0x22DC},
  {0x22E6, 0x22E7},
  {0x22E7, 0x22E6},
  {0x22F0, 0x22F1},
  {0x22F1, 0x22F0},
  {0x2308, 0x2309},
  {0x2309, 0x2308},
  {0x230A, 0x230B},
  {0x230B, 0x230A},
  {0x2329, 0x232A},
  {0x232A, 0x2329},
  {0x3008, 0x3009},
  {0x3009, 0x3008},
  {0x300A, 0x300B},
  {0x300B, 0x300A},
  {0x300C, 0x300D},
  {0x300D, 0x300C},
  {0x300E, 0x300F},
  {0x300F, 0x300E},
  {0x3010, 0x3011},
  {0x3011, 0x3010},
  {0x3014, 0x3015},
  {0x3015, 0x3014},
  {0x3016, 0x3017},
  {0x3017, 0x3016},
  {0x3018, 0x3019},
  {0x3019, 0x3018},
  {0x301A, 0x301B},
  {0x301B, 0x301A}
};

gint nFriBidiMirroredChars = 74;
