/* ANSI-C code produced by gperf version 2.7 */
/* Command-line: gperf -t -L ANSI-C -H aliases_hash -N aliases_lookup -7 -C -k 1,3-7,9-11,$ src/aliases.gperf  */
struct alias { const char* name; unsigned int encoding_index; };

#define TOTAL_KEYWORDS 274
#define MIN_WORD_LENGTH 2
#define MAX_WORD_LENGTH 45
#define MIN_HASH_VALUE 4
#define MAX_HASH_VALUE 2515
/* maximum key range = 2512, duplicates = 0 */

#ifdef __GNUC__
__inline
#endif
static unsigned int
aliases_hash (register const char *str, register unsigned int len)
{
  static const unsigned short asso_values[] =
    {
      2516, 2516, 2516, 2516, 2516, 2516, 2516, 2516, 2516, 2516,
      2516, 2516, 2516, 2516, 2516, 2516, 2516, 2516, 2516, 2516,
      2516, 2516, 2516, 2516, 2516, 2516, 2516, 2516, 2516, 2516,
      2516, 2516, 2516, 2516, 2516, 2516, 2516, 2516, 2516, 2516,
      2516, 2516, 2516, 2516, 2516,    0,   45, 2516,  210,  100,
        40,   50,  330,  160,   65,  220,    0,  230,  380, 2516,
      2516, 2516, 2516, 2516, 2516,    0,   30,  443,  130,    0,
        45,    5,   30,    0,    5,   35,  305,  285,    0,    0,
       130, 2516,   15,    0,    0,  500,   70,   50,    0,    5,
         0, 2516, 2516, 2516, 2516,   10, 2516, 2516, 2516, 2516,
      2516, 2516, 2516, 2516, 2516, 2516, 2516, 2516, 2516, 2516,
      2516, 2516, 2516, 2516, 2516, 2516, 2516, 2516, 2516, 2516,
      2516, 2516, 2516, 2516, 2516, 2516, 2516, 2516
    };
  register int hval = len;

  switch (hval)
    {
      default:
      case 11:
        hval += asso_values[(unsigned char) str[10]];
      case 10:
        hval += asso_values[(unsigned char) str[9]];
      case 9:
        hval += asso_values[(unsigned char) str[8]];
      case 8:
      case 7:
        hval += asso_values[(unsigned char) str[6]];
      case 6:
        hval += asso_values[(unsigned char) str[5]];
      case 5:
        hval += asso_values[(unsigned char) str[4]];
      case 4:
        hval += asso_values[(unsigned char) str[3]];
      case 3:
        hval += asso_values[(unsigned char) str[2]];
      case 2:
      case 1:
        hval += asso_values[(unsigned char) str[0]];
        break;
    }
  return hval + asso_values[(unsigned char) str[len - 1]];
}

#ifdef __GNUC__
__inline
#endif
const struct alias *
aliases_lookup (register const char *str, register unsigned int len)
{
  static const struct alias wordlist[] =
    {
      {""}, {""}, {""}, {""},
      {"SJIS", ei_sjis},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""}, {""},
      {"R8", ei_hp_roman8},
      {""}, {""}, {""}, {""}, {""}, {""},
      {"ISO-IR-58", ei_gb2312},
      {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {"HZ", ei_hz},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""}, {""}, {""},
      {"GREEK8", ei_iso8859_7},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {"KOREAN", ei_ksc5601},
      {""}, {""},
      {"SHIFT-JIS", ei_sjis},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {"SHIFT_JIS", ei_sjis},
      {""},
      {"KOI8-R", ei_koi8_r},
      {""}, {""},
      {"TCVN", ei_tcvn},
      {"ISO-IR-138", ei_iso8859_8},
      {""}, {""},
      {"GBK", ei_ces_gbk},
      {"JAVA", ei_java},
      {"GREEK", ei_iso8859_7},
      {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {"ISO-IR-6", ei_ascii},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""},
      {"JOHAB", ei_johab},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""}, {""}, {""}, {""},
      {"866", ei_cp866},
      {""}, {""}, {""}, {""},
      {"NEXTSTEP", ei_nextstep},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {"BIGFIVE", ei_ces_big5},
      {"BIG-FIVE", ei_ces_big5},
      {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {"GEORGIAN-PS", ei_georgian_ps},
      {""}, {""}, {""},
      {"ISO-8859-8", ei_iso8859_8},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {"ISO_8859-8", ei_iso8859_8},
      {"HEBREW", ei_iso8859_8},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""}, {""}, {""},
      {"ISO-IR-126", ei_iso8859_7},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""}, {""}, {""}, {""}, {""},
      {"ISO-IR-166", ei_tis620},
      {""}, {""}, {""}, {""},
      {"X0212", ei_jisx0212},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""}, {""}, {""}, {""}, {""},
      {"ISO-8859-2", ei_iso8859_2},
      {""}, {""}, {""}, {""},
      {"X0208", ei_jisx0208},
      {""}, {""}, {""}, {""},
      {"ISO_8859-2", ei_iso8859_2},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {"ISO-8859-3", ei_iso8859_3},
      {""}, {""}, {""},
      {"JIS_X0208", ei_jisx0208},
      {""}, {""}, {""}, {""}, {""},
      {"ISO_8859-3", ei_iso8859_3},
      {"GB2312", ei_euc_cn},
      {""}, {""}, {""}, {""}, {""}, {""},
      {"ELOT_928", ei_iso8859_7},
      {""},
      {"MS-EE", ei_cp1250},
      {""},
      {"MS-ANSI", ei_cp1252},
      {""}, {""},
      {"HZ-GB-2312", ei_hz},
      {""}, {""}, {""}, {""},
      {"ISO-8859-6", ei_iso8859_6},
      {""}, {""}, {""}, {""}, {""},
      {"ROMAN8", ei_hp_roman8},
      {"L8", ei_iso8859_14},
      {""}, {""},
      {"ISO_8859-6", ei_iso8859_6},
      {"LATIN8", ei_iso8859_14},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {"HP-ROMAN8", ei_hp_roman8},
      {""}, {""}, {""},
      {"MS_KANJI", ei_sjis},
      {""}, {""}, {""},
      {"L2", ei_iso8859_2},
      {"MS-GREEK", ei_cp1253},
      {""}, {""}, {""}, {""}, {""},
      {"JIS_X0212", ei_jisx0212},
      {"ISO-IR-148", ei_iso8859_9},
      {""},
      {"L3", ei_iso8859_3},
      {""},
      {"BIG5", ei_ces_big5},
      {"BIG-5", ei_ces_big5},
      {""}, {""}, {""}, {""}, {""},
      {"ISO-2022-KR", ei_iso2022_kr},
      {"MS-ARAB", ei_cp1256},
      {""}, {""},
      {"ISO-8859-1", ei_iso8859_1},
      {"ISO-8859-13", ei_iso8859_13},
      {"L6", ei_iso8859_10},
      {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {"ISO_8859-1", ei_iso8859_1},
      {"ISO_8859-13", ei_iso8859_13},
      {"MS-HEBR", ei_cp1255},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {"LATIN2", ei_iso8859_2},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""}, {""}, {""}, {""}, {""},
      {"L1", ei_iso8859_1},
      {""}, {""}, {""},
      {"LATIN3", ei_iso8859_3},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""},
      {"850", ei_cp850},
      {""}, {""}, {""}, {""}, {""},
      {"JIS_X0208-1983", ei_jisx0208},
      {""}, {""}, {""}, {""}, {""},
      {"ISO-IR-101", ei_iso8859_2},
      {""}, {""}, {""}, {""}, {""},
      {"LATIN6", ei_iso8859_10},
      {""}, {""}, {""}, {""},
      {"ISO_8859-15:1998", ei_iso8859_15},
      {""},
      {"ASCII", ei_ascii},
      {""},
      {"CHINESE", ei_gb2312},
      {""}, {""}, {""}, {""},
      {"X0201", ei_jisx0201},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {"ISO-IR-87", ei_jisx0208},
      {""}, {""},
      {"L5", ei_iso8859_9},
      {""},
      {"ISO646-US", ei_ascii},
      {""}, {""},
      {"JIS0208", ei_jisx0208},
      {""},
      {"JIS_X0201", ei_jisx0201},
      {""}, {""}, {""},
      {"ISO-2022-JP-2", ei_iso2022_jp2},
      {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {"IBM866", ei_cp866},
      {""}, {""},
      {"GEORGIAN-ACADEMY", ei_georgian_academy},
      {"ISO-8859-5", ei_iso8859_5},
      {""}, {""},
      {"ECMA-118", ei_iso8859_7},
      {""}, {""}, {""}, {""}, {""}, {""},
      {"ISO_8859-5", ei_iso8859_5},
      {""},
      {"US", ei_ascii},
      {""},
      {"ANSI_X3.4-1968", ei_ascii},
      {"ISO-IR-127", ei_iso8859_6},
      {""}, {""}, {""}, {""}, {""},
      {"LATIN1", ei_iso8859_1},
      {""},
      {"EUCKR", ei_euc_kr},
      {"EUC-KR", ei_euc_kr},
      {"CSKOI8R", ei_koi8_r},
      {""}, {""}, {""},
      {"VISCII", ei_viscii},
      {""}, {""}, {""}, {""}, {""}, {""},
      {"JIS_X0208.1983-1", ei_jisx0208},
      {"L7", ei_iso8859_13},
      {"CSSHIFTJIS", ei_sjis},
      {""}, {""},
      {"TIS620", ei_tis620},
      {"TIS-620", ei_tis620},
      {"TIS620-0", ei_tis620},
      {""}, {""},
      {"ISO_8859-10:1992", ei_iso8859_10},
      {""},
      {"ISO-2022-JP-1", ei_iso2022_jp1},
      {"TCVN-5712", ei_tcvn},
      {""}, {""},
      {"WINDOWS-1258", ei_cp1258},
      {""}, {""},
      {"ISO-IR-110", ei_iso8859_4},
      {""}, {""},
      {"EUCTW", ei_euc_tw},
      {"EUC-TW", ei_euc_tw},
      {"UTF-8", ei_utf8},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""}, {""}, {""}, {""},
      {"ISO_8859-8:1988", ei_iso8859_8},
      {"ISO-2022-JP", ei_iso2022_jp},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""},
      {"UCS-2-BE", ei_ucs2be},
      {""}, {""}, {""},
      {"WINDOWS-1252", ei_cp1252},
      {""}, {""},
      {"UCS-2", ei_ucs2},
      {""}, {""}, {""},
      {"JIS_X0208-1990", ei_jisx0208},
      {""},
      {"ISO-8859-15", ei_iso8859_15},
      {"WINDOWS-1253", ei_cp1253},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {"ISO_8859-15", ei_iso8859_15},
      {""}, {""}, {""}, {""}, {""},
      {"WINDOWS-1256", ei_cp1256},
      {""}, {""},
      {"ISO-8859-7", ei_iso8859_7},
      {""}, {""}, {""}, {""},
      {"ISO_8859-3:1988", ei_iso8859_3},
      {"ISO_8859-14:1998", ei_iso8859_14},
      {""}, {""}, {""},
      {"ISO_8859-7", ei_iso8859_7},
      {""}, {""}, {""}, {""},
      {"ISO-IR-157", ei_iso8859_10},
      {""}, {""}, {""},
      {"JIS_X0212-1990", ei_jisx0212},
      {"ISO-8859-9", ei_iso8859_9},
      {"LATIN5", ei_iso8859_9},
      {""}, {""}, {""}, {""},
      {"JIS_X0208.1983-0", ei_jisx0208},
      {"L4", ei_iso8859_4},
      {""}, {""},
      {"ISO_8859-9", ei_iso8859_9},
      {""},
      {"WINDOWS-1251", ei_cp1251},
      {"CP866", ei_cp866},
      {""},
      {"ISO-IR-159", ei_jisx0212},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {"ISO-IR-100", ei_iso8859_1},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""}, {""}, {""}, {""}, {""},
      {"ISO_646.IRV:1991", ei_ascii},
      {""}, {""}, {""},
      {"GB_2312-80", ei_gb2312},
      {"JIS_X0212.1990-0", ei_jisx0212},
      {""},
      {"CSISO87JISX0208", ei_jisx0208},
      {""}, {""}, {""}, {""}, {""}, {""},
      {"EXTENDED_UNIX_CODE_PACKED_FORMAT_FOR_JAPANESE", ei_euc_jp},
      {""}, {""}, {""}, {""}, {""},
      {"ISO-8859-10", ei_iso8859_10},
      {""}, {""}, {""},
      {"ISO-IR-109", ei_iso8859_3},
      {""}, {""}, {""}, {""}, {""},
      {"ISO_8859-10", ei_iso8859_10},
      {"WINDOWS-1255", ei_cp1255},
      {""}, {""},
      {"ISO-IR-179", ei_iso8859_13},
      {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {"EUCJP", ei_euc_jp},
      {"EUC-JP", ei_euc_jp},
      {""},
      {"CSGB2312", ei_euc_cn},
      {""}, {""}, {""}, {""}, {""}, {""},
      {"ASMO-708", ei_iso8859_6},
      {""},
      {"ISO_8859-5:1988", ei_iso8859_5},
      {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {"TIS620.2533-1", ei_tis620},
      {""}, {""}, {""},
      {"ARMSCII-8", ei_armscii_8},
      {""}, {""}, {""}, {""}, {""}, {""},
      {"ISO-2022-CN", ei_iso2022_cn},
      {""}, {""}, {""},
      {"ISO-2022-CN-EXT", ei_iso2022_cn_ext},
      {"CP1258", ei_cp1258},
      {""},
      {"LATIN7", ei_iso8859_13},
      {"WINDOWS-1250", ei_cp1250},
      {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {"TCVN5712-1", ei_tcvn},
      {""},
      {"WINDOWS-1257", ei_cp1257},
      {""}, {""},
      {"MACTHAI", ei_mac_thai},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""}, {""}, {""}, {""}, {""},
      {"UTF-16", ei_utf16},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {"MACGREEK", ei_mac_greek},
      {""}, {""}, {""}, {""}, {""},
      {"MACINTOSH", ei_mac_roman},
      {""},
      {"CP1133", ei_cp1133},
      {""}, {""}, {""},
      {"CSISOLATINGREEK", ei_iso8859_7},
      {"CSBIG5", ei_ces_big5},
      {""}, {""}, {""},
      {"CP932", ei_cp932},
      {"CSISO2022KR", ei_iso2022_kr},
      {""}, {""}, {""}, {""}, {""},
      {"ISO-IR-149", ei_ksc5601},
      {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {"ECMA-114", ei_iso8859_6},
      {""},
      {"ISO_8859-2:1987", ei_iso8859_2},
      {""}, {""}, {""},
      {"CP1252", ei_cp1252},
      {"ISO-8859-4", ei_iso8859_4},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {"CSISOLATIN2", ei_iso8859_2},
      {"ISO_8859-4", ei_iso8859_4},
      {""}, {""},
      {"TIS620.2533-0", ei_tis620},
      {"CSISOLATINHEBREW", ei_iso8859_8},
      {""},
      {"IBM367", ei_ascii},
      {""}, {""},
      {"CP1253", ei_cp1253},
      {"ISO_8859-6:1987", ei_iso8859_6},
      {"IBM819", ei_iso8859_1},
      {""},
      {"UCS-2-LE", ei_ucs2le},
      {""}, {""}, {""}, {""},
      {"CP936", ei_ces_gbk},
      {"CSISOLATIN3", ei_iso8859_3},
      {""}, {""}, {""}, {""},
      {"CP1361", ei_johab},
      {""}, {""}, {""},
      {"UCS-4-BE", ei_ucs4be},
      {""}, {""},
      {"IBM850", ei_cp850},
      {"WINDOWS-1254", ei_cp1254},
      {"JISX0201-1976", ei_jisx0201},
      {"UCS-2-INTERNAL", ei_ucs2internal},
      {""}, {""},
      {"MS-TURK", ei_cp1254},
      {""},
      {"CP1256", ei_cp1256},
      {""}, {""}, {""}, {""}, {""},
      {"ISO_8859-1:1987", ei_iso8859_1},
      {""}, {""}, {""},
      {"CSISOLATIN6", ei_iso8859_10},
      {""},
      {"EUCCN", ei_euc_cn},
      {"EUC-CN", ei_euc_cn},
      {"CSASCII", ei_ascii},
      {""},
      {"ISO_8859-4:1988", ei_iso8859_4},
      {"CSIBM866", ei_cp866},
      {""}, {""}, {""}, {""}, {""}, {""},
      {"TIS620.2529-1", ei_tis620},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {"MACHEBREW", ei_mac_hebrew},
      {"CSHPROMAN8", ei_hp_roman8},
      {""}, {""}, {""}, {""}, {""}, {""},
      {"CSISO2022JP2", ei_iso2022_jp2},
      {""},
      {"ARABIC", ei_iso8859_6},
      {""},
      {"VISCII1.1-1", ei_viscii},
      {""}, {""}, {""}, {""}, {""}, {""},
      {"ISO-8859-14", ei_iso8859_14},
      {""}, {""}, {""}, {""}, {""}, {""},
      {"CSISO159JISX02121990", ei_jisx0212},
      {""}, {""},
      {"ISO_8859-14", ei_iso8859_14},
      {""},
      {"UCS-2-SWAPPED", ei_ucs2swapped},
      {""}, {""}, {""}, {""},
      {"CSISO58GB231280", ei_gb2312},
      {"CP1251", ei_cp1251},
      {""},
      {"US-ASCII", ei_ascii},
      {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {"CSISOLATIN1", ei_iso8859_1},
      {""}, {""}, {""}, {""},
      {"CSVISCII", ei_viscii},
      {"WINBALTRIM", ei_cp1257},
      {""}, {""}, {""}, {""}, {""},
      {"LATIN4", ei_iso8859_4},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {"UTF-7", ei_utf7},
      {""}, {""}, {""}, {""},
      {"ISO-10646-UCS-2", ei_ucs2},
      {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {"CP367", ei_ascii},
      {""},
      {"ISO_8859-7:1987", ei_iso8859_7},
      {""}, {""},
      {"CP819", ei_iso8859_1},
      {"CSISO2022JP", ei_iso2022_jp},
      {""}, {""}, {""}, {""}, {""},
      {"ISO-IR-144", ei_iso8859_5},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {"ISO_8859-9:1989", ei_iso8859_9},
      {""}, {""},
      {"CP850", ei_cp850},
      {""}, {""},
      {"KSC_5601", ei_ksc5601},
      {""}, {""}, {""}, {""},
      {"MACROMAN", ei_mac_roman},
      {""},
      {"MACROMANIA", ei_mac_romania},
      {""}, {""},
      {"KOI8-U", ei_koi8_u},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""},
      {"CSHALFWIDTHKATAKANA", ei_jisx0201},
      {""}, {""}, {""}, {""},
      {"KOI8-RU", ei_koi8_ru},
      {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {"JISX0201.1976-0", ei_jisx0201},
      {""}, {""}, {""},
      {"CP1255", ei_cp1255},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {"CSISOLATIN5", ei_iso8859_9},
      {""}, {""}, {""}, {""}, {""}, {""},
      {"UNICODELITTLE", ei_ucs2le},
      {""}, {""}, {""}, {""}, {""}, {""},
      {"UNICODEBIG", ei_ucs2be},
      {""},
      {"TCVN5712-1:1993", ei_tcvn},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {"MULELAO-1", ei_mulelao},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""}, {""}, {""},
      {"IBM-CP1133", ei_cp1133},
      {""}, {""},
      {"WINDOWS-874", ei_cp874},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""}, {""},
      {"UCS-4-LE", ei_ucs4le},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""}, {""}, {""},
      {"KS_C_5601-1987", ei_ksc5601},
      {""}, {""}, {""}, {""}, {""}, {""},
      {"UCS-4-INTERNAL", ei_ucs4internal},
      {"UCS-4", ei_ucs4},
      {""},
      {"KS_C_5601-1989", ei_ksc5601},
      {""},
      {"CP1250", ei_cp1250},
      {""}, {""}, {""}, {""},
      {"MAC", ei_mac_roman},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""}, {""},
      {"CSISO2022CN", ei_iso2022_cn},
      {""},
      {"CP1257", ei_cp1257},
      {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {"MACCROATIAN", ei_mac_croatian},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {"CSISOLATINARABIC", ei_iso8859_6},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {"UCS-4-SWAPPED", ei_ucs4swapped},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {"CSMACINTOSH", ei_mac_roman},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""}, {""}, {""}, {""}, {""},
      {"CP950", ei_cp950},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {"ISO-10646-UCS-4", ei_ucs4},
      {""}, {""},
      {"MACUKRAINE", ei_mac_ukraine},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""}, {""},
      {"CP874", ei_cp874},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""},
      {"MACTURKISH", ei_mac_turkish},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {"MS-CYRL", ei_cp1251},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {"UNICODE-1-1", ei_ucs2be},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""},
      {"CSUNICODE", ei_ucs2},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""}, {""}, {""},
      {"CP1254", ei_cp1254},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {"CSISOLATIN4", ei_iso8859_4},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""},
      {"CSEUCKR", ei_euc_kr},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {"CP949", ei_ksc5601},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""}, {""}, {""}, {""},
      {"MACCENTRALEUROPE", ei_mac_centraleurope},
      {"CSEUCTW", ei_euc_tw},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {"UNICODE-1-1-UTF-7", ei_utf7},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {"CYRILLIC", ei_iso8859_5},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""},
      {"KSC5601.1987-0", ei_ksc5601},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""}, {""},
      {"CSISOLATINCYRILLIC", ei_iso8859_5},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""}, {""}, {""}, {""}, {""},
      {"MACARABIC", ei_mac_arabic},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""},
      {"CSUNICODE11", ei_ucs2be},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""}, {""},
      {"MACICELAND", ei_mac_iceland},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {"CSKSC56011987", ei_ksc5601},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""},
      {"CSUNICODE11UTF7", ei_utf7},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""}, {""}, {""}, {""}, {""},
      {"CSEUCPKDFMTJAPANESE", ei_euc_jp},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {"CSUCS4", ei_ucs4},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {"MACCYRILLIC", ei_mac_cyrillic},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""}, {""}, {""},
      {"CSPC850MULTILINGUAL", ei_cp850}
    };

  if (len <= MAX_WORD_LENGTH && len >= MIN_WORD_LENGTH)
    {
      register int key = aliases_hash (str, len);

      if (key <= MAX_HASH_VALUE && key >= 0)
        {
          register const char *s = wordlist[key].name;

          if (*str == *s && !strcmp (str + 1, s + 1))
            return &wordlist[key];
        }
    }
  return 0;
}
