#include <stdio.h>
#include "interface_repository.h"

/*** App-specific servant structures ***/

typedef struct {
	POA_CORBA_IDLType servant;
	PortableServer_POA poa;
	CORBA_TypeCode attr_type;

	CORBA_DefinitionKind attr_def_kind;
} impl_POA_CORBA_IDLType;

typedef struct {
	POA_CORBA_Repository servant;
	PortableServer_POA poa;

	CORBA_DefinitionKind attr_def_kind;
	GHashTable *id_hash;

	/* Contains: constants, typedefs, exceptions, interface definitions
	   and modules
	 */
	GSList *contents;
	
} impl_POA_CORBA_Repository;

typedef struct {
	POA_CORBA_ModuleDef servant;
	PortableServer_POA poa;
	CORBA_DefinitionKind attr_def_kind;
	CORBA_RepositoryId attr_id;
	CORBA_Identifier attr_name;
	CORBA_VersionSpec attr_version;
	CORBA_Container attr_defined_in;
	CORBA_ScopedName attr_absolute_name;

	/* Contains: constants, typedefs, exceptions, interface definitions
	   and other other modules
	 */
	GSList *contents;
	
} impl_POA_CORBA_ModuleDef;

typedef struct {
	POA_CORBA_ConstantDef servant;
	PortableServer_POA poa;

	CORBA_IDLType attr_type_def;

	CORBA_any *attr_value;

	CORBA_DefinitionKind attr_def_kind;
	CORBA_RepositoryId attr_id;
	CORBA_Identifier attr_name;
	CORBA_VersionSpec attr_version;
	CORBA_Container attr_defined_in;
} impl_POA_CORBA_ConstantDef;

typedef struct {
	POA_CORBA_TypedefDef servant;
	PortableServer_POA poa;
	CORBA_DefinitionKind attr_def_kind;
	CORBA_RepositoryId attr_id;
	CORBA_Identifier attr_name;
	CORBA_VersionSpec attr_version;
	CORBA_Container attr_defined_in;
	CORBA_ScopedName attr_absolute_name;
	CORBA_TypeCode attr_type;
} impl_POA_CORBA_TypedefDef;

typedef struct {
	POA_CORBA_StructDef servant;
	PortableServer_POA poa;
	CORBA_StructMemberSeq attr_members;

	CORBA_DefinitionKind attr_def_kind;
	CORBA_RepositoryId attr_id;
	CORBA_Identifier attr_name;
	CORBA_VersionSpec attr_version;
	CORBA_Container attr_defined_in;
	CORBA_ScopedName attr_absolute_name;
	CORBA_TypeCode attr_type;

	/* Contains: structs, unions and enums
	 */
	GSList *contents;
} impl_POA_CORBA_StructDef;

typedef struct {
	POA_CORBA_UnionDef servant;
	PortableServer_POA poa;
	CORBA_TypeCode attr_discriminator_type;

	CORBA_IDLType attr_discriminator_type_def;

	CORBA_UnionMemberSeq attr_members;

	CORBA_DefinitionKind attr_def_kind;
	CORBA_RepositoryId attr_id;
	CORBA_Identifier attr_name;
	CORBA_VersionSpec attr_version;
	CORBA_Container attr_defined_in;
	CORBA_ScopedName attr_absolute_name;
	CORBA_TypeCode attr_type;

	/* Contains: structs, unions and enums
	 */
	GSList *contents;
} impl_POA_CORBA_UnionDef;

typedef struct {
	POA_CORBA_EnumDef servant;
	PortableServer_POA poa;
	CORBA_EnumMemberSeq attr_members;

	CORBA_DefinitionKind attr_def_kind;
	CORBA_RepositoryId attr_id;
	CORBA_Identifier attr_name;
	CORBA_VersionSpec attr_version;
	CORBA_Container attr_defined_in;
	CORBA_ScopedName attr_absolute_name;
	CORBA_TypeCode attr_type;
} impl_POA_CORBA_EnumDef;

typedef struct {
	POA_CORBA_AliasDef servant;
	PortableServer_POA poa;
	CORBA_IDLType attr_original_type_def;

	CORBA_DefinitionKind attr_def_kind;
	CORBA_RepositoryId attr_id;
	CORBA_Identifier attr_name;
	CORBA_VersionSpec attr_version;
	CORBA_Container attr_defined_in;
	CORBA_ScopedName attr_absolute_name;
	CORBA_TypeCode attr_type;
} impl_POA_CORBA_AliasDef;

typedef struct {
	POA_CORBA_PrimitiveDef servant;
	PortableServer_POA poa;
	CORBA_PrimitiveKind attr_kind;

	CORBA_DefinitionKind attr_def_kind;
	CORBA_TypeCode attr_type;
} impl_POA_CORBA_PrimitiveDef;

typedef struct {
	POA_CORBA_StringDef servant;
	PortableServer_POA poa;
	CORBA_unsigned_long attr_bound;

	CORBA_DefinitionKind attr_def_kind;
	CORBA_TypeCode attr_type;
} impl_POA_CORBA_StringDef;

typedef struct {
	POA_CORBA_WstringDef servant;
	PortableServer_POA poa;
	CORBA_unsigned_long attr_bound;

	CORBA_DefinitionKind attr_def_kind;
	CORBA_TypeCode attr_type;
} impl_POA_CORBA_WstringDef;

typedef struct {
	POA_CORBA_FixedDef servant;
	PortableServer_POA poa;
	CORBA_unsigned_short attr_digits;

	CORBA_short attr_scale;

	CORBA_DefinitionKind attr_def_kind;
	CORBA_TypeCode attr_type;
} impl_POA_CORBA_FixedDef;

typedef struct {
	POA_CORBA_SequenceDef servant;
	PortableServer_POA poa;
	CORBA_unsigned_long attr_bound;

	CORBA_TypeCode attr_element_type;

	CORBA_IDLType attr_element_type_def;

	CORBA_DefinitionKind attr_def_kind;
	CORBA_TypeCode attr_type;
} impl_POA_CORBA_SequenceDef;

typedef struct {
	POA_CORBA_ArrayDef servant;
	PortableServer_POA poa;
	CORBA_unsigned_long attr_length;

	CORBA_TypeCode attr_element_type;

	CORBA_IDLType attr_element_type_def;

	CORBA_DefinitionKind attr_def_kind;
	CORBA_TypeCode attr_type;
} impl_POA_CORBA_ArrayDef;

typedef struct {
	POA_CORBA_ExceptionDef servant;
	PortableServer_POA poa;
	CORBA_TypeCode attr_type;

	CORBA_StructMemberSeq *attr_members;

	CORBA_DefinitionKind attr_def_kind;
	CORBA_RepositoryId attr_id;
	CORBA_Identifier attr_name;
	CORBA_VersionSpec attr_version;
	CORBA_Container attr_defined_in;
	CORBA_ScopedName attr_absolute_name;

	/* Contains: structs, unions and enums
	 */
	GSList *contents;
} impl_POA_CORBA_ExceptionDef;

typedef struct {
	POA_CORBA_AttributeDef servant;
	PortableServer_POA poa;
	CORBA_TypeCode attr_type;

	CORBA_IDLType attr_type_def;

	CORBA_AttributeMode attr_mode;

	CORBA_DefinitionKind attr_def_kind;
	CORBA_RepositoryId attr_id;
	CORBA_Identifier attr_name;
	CORBA_VersionSpec attr_version;
	CORBA_Container attr_defined_in;
	CORBA_ScopedName attr_absolute_name;
} impl_POA_CORBA_AttributeDef;

typedef struct {
	POA_CORBA_OperationDef servant;
	PortableServer_POA poa;
	CORBA_TypeCode attr_result;

	CORBA_IDLType attr_result_def;

	CORBA_ParDescriptionSeq attr_params;

	CORBA_OperationMode attr_mode;

	CORBA_ContextIdSeq attr_contexts;

	CORBA_ExceptionDefSeq attr_exceptions;

	CORBA_DefinitionKind attr_def_kind;
	CORBA_RepositoryId attr_id;
	CORBA_Identifier attr_name;
	CORBA_VersionSpec attr_version;
	CORBA_Container attr_defined_in;
	CORBA_ScopedName attr_absolute_name;
} impl_POA_CORBA_OperationDef;

typedef struct {
	POA_CORBA_InterfaceDef servant;
	PortableServer_POA poa;
	CORBA_InterfaceDefSeq *attr_base_interfaces;

	CORBA_DefinitionKind attr_def_kind;
	CORBA_RepositoryId attr_id;
	CORBA_Identifier attr_name;
	CORBA_VersionSpec attr_version;
	CORBA_Container attr_defined_in;
	CORBA_ScopedName attr_absolute_name;
	CORBA_TypeCode attr_type;

	/* Contains: constants, types, exceptions, operations and attributes */
	GSList *contents;
} impl_POA_CORBA_InterfaceDef;

/*** Implementation stub prototypes ***/

static void impl_CORBA_IDLType__destroy(impl_POA_CORBA_IDLType * servant,
					CORBA_Environment * ev);

CORBA_TypeCode
impl_CORBA_IDLType__get_type(impl_POA_CORBA_IDLType * servant,
			     CORBA_Environment * ev);

CORBA_DefinitionKind
impl_CORBA_IDLType__get_def_kind(impl_POA_CORBA_IDLType * servant,
				 CORBA_Environment * ev);
void
 impl_CORBA_IDLType_destroy(impl_POA_CORBA_IDLType * servant,
 			    CORBA_Environment * ev);

static void impl_CORBA_Repository__destroy(impl_POA_CORBA_Repository * servant,
					   CORBA_Environment * ev);

CORBA_Contained
impl_CORBA_Repository_lookup_id(impl_POA_CORBA_Repository * servant,
				CORBA_RepositoryId search_id,
				CORBA_Environment * ev);

CORBA_PrimitiveDef
impl_CORBA_Repository_get_primitive(impl_POA_CORBA_Repository * servant,
				    CORBA_PrimitiveKind kind,
				    CORBA_Environment * ev);

CORBA_StringDef
impl_CORBA_Repository_create_string(impl_POA_CORBA_Repository * servant,
				    CORBA_unsigned_long bound,
				    CORBA_Environment * ev);

CORBA_WstringDef
impl_CORBA_Repository_create_wstring(impl_POA_CORBA_Repository * servant,
				     CORBA_unsigned_long bound,
				     CORBA_Environment * ev);

CORBA_SequenceDef
impl_CORBA_Repository_create_sequence(impl_POA_CORBA_Repository * servant,
				      CORBA_unsigned_long bound,
				      CORBA_IDLType element_type,
				      CORBA_Environment * ev);

CORBA_ArrayDef
impl_CORBA_Repository_create_array(impl_POA_CORBA_Repository * servant,
				   CORBA_unsigned_long length,
				   CORBA_IDLType element_type,
				   CORBA_Environment * ev);

CORBA_FixedDef
impl_CORBA_Repository_create_fixed(impl_POA_CORBA_Repository * servant,
				   CORBA_unsigned_short digits,
				   CORBA_short scale,
				   CORBA_Environment * ev);

CORBA_DefinitionKind
impl_CORBA_Repository__get_def_kind(impl_POA_CORBA_Repository * servant,
				    CORBA_Environment * ev);
void
 impl_CORBA_Repository_destroy(impl_POA_CORBA_Repository * servant,
			       CORBA_Environment * ev);

CORBA_Contained
impl_CORBA_Repository_lookup(impl_POA_CORBA_Repository * servant,
			     CORBA_ScopedName search_name,
			     CORBA_Environment * ev);
CORBA_ContainedSeq *
 impl_CORBA_Repository_contents(impl_POA_CORBA_Repository * servant,
				CORBA_DefinitionKind limit_type,
				CORBA_boolean exclude_inherited,
				CORBA_Environment * ev);
CORBA_ContainedSeq *
 impl_CORBA_Repository_lookup_name(impl_POA_CORBA_Repository * servant,
				   CORBA_Identifier search_name,
				   CORBA_long levels_to_search,
				   CORBA_DefinitionKind limit_type,
				   CORBA_boolean exclude_inherited,
				   CORBA_Environment * ev);
CORBA_Container_DescriptionSeq *
 impl_CORBA_Repository_describe_contents(impl_POA_CORBA_Repository * servant,
					 CORBA_DefinitionKind limit_type,
					 CORBA_boolean exclude_inherited,
					 CORBA_long max_returned_objs,
					 CORBA_Environment * ev);

CORBA_ModuleDef
impl_CORBA_Repository_create_module(impl_POA_CORBA_Repository * servant,
				    CORBA_RepositoryId id,
				    CORBA_Identifier name,
				    CORBA_VersionSpec version,
				    CORBA_Environment * ev);
CORBA_ConstantDef
impl_CORBA_Repository_create_constant(impl_POA_CORBA_Repository * servant,
				      CORBA_RepositoryId id,
				      CORBA_Identifier name,
				      CORBA_VersionSpec version,
				      CORBA_IDLType type,
				      CORBA_any * value,
				      CORBA_Environment * ev);
CORBA_StructDef
impl_CORBA_Repository_create_struct(impl_POA_CORBA_Repository * servant,
				    CORBA_RepositoryId id,
				    CORBA_Identifier name,
				    CORBA_VersionSpec version,
				    CORBA_StructMemberSeq * members,
				    CORBA_Environment * ev);
CORBA_UnionDef
impl_CORBA_Repository_create_union(impl_POA_CORBA_Repository * servant,
				   CORBA_RepositoryId id,
				   CORBA_Identifier name,
				   CORBA_VersionSpec version,
				   CORBA_IDLType discriminator_type,
				   CORBA_UnionMemberSeq * members,
				   CORBA_Environment * ev);
CORBA_EnumDef
impl_CORBA_Repository_create_enum(impl_POA_CORBA_Repository * servant,
				  CORBA_RepositoryId id,
				  CORBA_Identifier name,
				  CORBA_VersionSpec version,
				  CORBA_EnumMemberSeq * members,
				  CORBA_Environment * ev);
CORBA_AliasDef
impl_CORBA_Repository_create_alias(impl_POA_CORBA_Repository * servant,
				   CORBA_RepositoryId id,
				   CORBA_Identifier name,
				   CORBA_VersionSpec version,
				   CORBA_IDLType original_type,
				   CORBA_Environment * ev);
CORBA_InterfaceDef
impl_CORBA_Repository_create_interface(impl_POA_CORBA_Repository * servant,
				       CORBA_RepositoryId id,
				       CORBA_Identifier name,
				       CORBA_VersionSpec version,
				 CORBA_InterfaceDefSeq * base_interfaces,
				       CORBA_Environment * ev);
CORBA_ExceptionDef
impl_CORBA_Repository_create_exception(impl_POA_CORBA_Repository * servant,
				       CORBA_RepositoryId id,
				       CORBA_Identifier name,
				       CORBA_VersionSpec version,
				       CORBA_StructMemberSeq * members,
				       CORBA_Environment * ev);

static void impl_CORBA_ModuleDef__destroy(impl_POA_CORBA_ModuleDef * servant,
					  CORBA_Environment * ev);

CORBA_DefinitionKind
impl_CORBA_ModuleDef__get_def_kind(impl_POA_CORBA_ModuleDef * servant,
				   CORBA_Environment * ev);
void
 impl_CORBA_ModuleDef_destroy(impl_POA_CORBA_ModuleDef * servant,
			      CORBA_Environment * ev);

CORBA_Contained
impl_CORBA_ModuleDef_lookup(impl_POA_CORBA_ModuleDef * servant,
			    CORBA_ScopedName search_name,
			    CORBA_Environment * ev);
CORBA_ContainedSeq *
 impl_CORBA_ModuleDef_contents(impl_POA_CORBA_ModuleDef * servant,
			       CORBA_DefinitionKind limit_type,
			       CORBA_boolean exclude_inherited,
			       CORBA_Environment * ev);
CORBA_ContainedSeq *
 impl_CORBA_ModuleDef_lookup_name(impl_POA_CORBA_ModuleDef * servant,
				  CORBA_Identifier search_name,
				  CORBA_long levels_to_search,
				  CORBA_DefinitionKind limit_type,
				  CORBA_boolean exclude_inherited,
				  CORBA_Environment * ev);
CORBA_Container_DescriptionSeq *
 impl_CORBA_ModuleDef_describe_contents(impl_POA_CORBA_ModuleDef * servant,
					CORBA_DefinitionKind limit_type,
					CORBA_boolean exclude_inherited,
					CORBA_long max_returned_objs,
					CORBA_Environment * ev);

CORBA_ModuleDef
impl_CORBA_ModuleDef_create_module(impl_POA_CORBA_ModuleDef * servant,
				   CORBA_RepositoryId id,
				   CORBA_Identifier name,
				   CORBA_VersionSpec version,
				   CORBA_Environment * ev);
CORBA_ConstantDef
impl_CORBA_ModuleDef_create_constant(impl_POA_CORBA_ModuleDef * servant,
				     CORBA_RepositoryId id,
				     CORBA_Identifier name,
				     CORBA_VersionSpec version,
				     CORBA_IDLType type,
				     CORBA_any * value,
				     CORBA_Environment * ev);
CORBA_StructDef
impl_CORBA_ModuleDef_create_struct(impl_POA_CORBA_ModuleDef * servant,
				   CORBA_RepositoryId id,
				   CORBA_Identifier name,
				   CORBA_VersionSpec version,
				   CORBA_StructMemberSeq * members,
				   CORBA_Environment * ev);
CORBA_UnionDef
impl_CORBA_ModuleDef_create_union(impl_POA_CORBA_ModuleDef * servant,
				  CORBA_RepositoryId id,
				  CORBA_Identifier name,
				  CORBA_VersionSpec version,
				  CORBA_IDLType discriminator_type,
				  CORBA_UnionMemberSeq * members,
				  CORBA_Environment * ev);
CORBA_EnumDef
impl_CORBA_ModuleDef_create_enum(impl_POA_CORBA_ModuleDef * servant,
				 CORBA_RepositoryId id,
				 CORBA_Identifier name,
				 CORBA_VersionSpec version,
				 CORBA_EnumMemberSeq * members,
				 CORBA_Environment * ev);
CORBA_AliasDef
impl_CORBA_ModuleDef_create_alias(impl_POA_CORBA_ModuleDef * servant,
				  CORBA_RepositoryId id,
				  CORBA_Identifier name,
				  CORBA_VersionSpec version,
				  CORBA_IDLType original_type,
				  CORBA_Environment * ev);
CORBA_InterfaceDef
impl_CORBA_ModuleDef_create_interface(impl_POA_CORBA_ModuleDef * servant,
				      CORBA_RepositoryId id,
				      CORBA_Identifier name,
				      CORBA_VersionSpec version,
				 CORBA_InterfaceDefSeq * base_interfaces,
				      CORBA_Environment * ev);
CORBA_ExceptionDef
impl_CORBA_ModuleDef_create_exception(impl_POA_CORBA_ModuleDef * servant,
				      CORBA_RepositoryId id,
				      CORBA_Identifier name,
				      CORBA_VersionSpec version,
				      CORBA_StructMemberSeq * members,
				      CORBA_Environment * ev);
CORBA_RepositoryId
impl_CORBA_ModuleDef__get_id(impl_POA_CORBA_ModuleDef * servant,
			     CORBA_Environment * ev);
void
 impl_CORBA_ModuleDef__set_id(impl_POA_CORBA_ModuleDef * servant,
			      CORBA_RepositoryId value,
			      CORBA_Environment * ev);

CORBA_Identifier
impl_CORBA_ModuleDef__get_name(impl_POA_CORBA_ModuleDef * servant,
			       CORBA_Environment * ev);
void
 impl_CORBA_ModuleDef__set_name(impl_POA_CORBA_ModuleDef * servant,
				CORBA_Identifier value,
				CORBA_Environment * ev);

CORBA_VersionSpec
impl_CORBA_ModuleDef__get_version(impl_POA_CORBA_ModuleDef * servant,
				  CORBA_Environment * ev);
void
 impl_CORBA_ModuleDef__set_version(impl_POA_CORBA_ModuleDef * servant,
				   CORBA_VersionSpec value,
				   CORBA_Environment * ev);

CORBA_Container
impl_CORBA_ModuleDef__get_defined_in(impl_POA_CORBA_ModuleDef * servant,
				     CORBA_Environment * ev);
CORBA_ScopedName
impl_CORBA_ModuleDef__get_absolute_name(impl_POA_CORBA_ModuleDef * servant,
					CORBA_Environment * ev);
CORBA_Repository
impl_CORBA_ModuleDef__get_containing_repository(impl_POA_CORBA_ModuleDef * servant,
						CORBA_Environment * ev);
CORBA_Contained_Description *
 impl_CORBA_ModuleDef_describe(impl_POA_CORBA_ModuleDef * servant,
			       CORBA_Environment * ev);
void
 impl_CORBA_ModuleDef_move(impl_POA_CORBA_ModuleDef * servant,
			   CORBA_Container new_container,
			   CORBA_Identifier new_name,
			   CORBA_VersionSpec new_version,
			   CORBA_Environment * ev);

static void impl_CORBA_ConstantDef__destroy(impl_POA_CORBA_ConstantDef * servant,
					    CORBA_Environment * ev);

CORBA_TypeCode
impl_CORBA_ConstantDef__get_type(impl_POA_CORBA_ConstantDef * servant,
				 CORBA_Environment * ev);

CORBA_IDLType
impl_CORBA_ConstantDef__get_type_def(impl_POA_CORBA_ConstantDef * servant,
				     CORBA_Environment * ev);
void
 impl_CORBA_ConstantDef__set_type_def(impl_POA_CORBA_ConstantDef * servant,
				      CORBA_IDLType value,
				      CORBA_Environment * ev);

CORBA_any *
 impl_CORBA_ConstantDef__get_value(impl_POA_CORBA_ConstantDef * servant,
				   CORBA_Environment * ev);
void
 impl_CORBA_ConstantDef__set_value(impl_POA_CORBA_ConstantDef * servant,
				   CORBA_any * value,
				   CORBA_Environment * ev);

CORBA_DefinitionKind
impl_CORBA_ConstantDef__get_def_kind(impl_POA_CORBA_ConstantDef * servant,
				     CORBA_Environment * ev);
void
 impl_CORBA_ConstantDef_destroy(impl_POA_CORBA_ConstantDef * servant,
				CORBA_Environment * ev);

CORBA_RepositoryId
impl_CORBA_ConstantDef__get_id(impl_POA_CORBA_ConstantDef * servant,
			       CORBA_Environment * ev);
void
 impl_CORBA_ConstantDef__set_id(impl_POA_CORBA_ConstantDef * servant,
				CORBA_RepositoryId value,
				CORBA_Environment * ev);

CORBA_Identifier
impl_CORBA_ConstantDef__get_name(impl_POA_CORBA_ConstantDef * servant,
				 CORBA_Environment * ev);
void
 impl_CORBA_ConstantDef__set_name(impl_POA_CORBA_ConstantDef * servant,
				  CORBA_Identifier value,
				  CORBA_Environment * ev);

CORBA_VersionSpec
impl_CORBA_ConstantDef__get_version(impl_POA_CORBA_ConstantDef * servant,
				    CORBA_Environment * ev);
void
 impl_CORBA_ConstantDef__set_version(impl_POA_CORBA_ConstantDef * servant,
				     CORBA_VersionSpec value,
				     CORBA_Environment * ev);

CORBA_Container
impl_CORBA_ConstantDef__get_defined_in(impl_POA_CORBA_ConstantDef * servant,
				       CORBA_Environment * ev);
CORBA_ScopedName
impl_CORBA_ConstantDef__get_absolute_name(impl_POA_CORBA_ConstantDef * servant,
					  CORBA_Environment * ev);
CORBA_Repository
impl_CORBA_ConstantDef__get_containing_repository(impl_POA_CORBA_ConstantDef * servant,
						  CORBA_Environment * ev);
CORBA_Contained_Description *
 impl_CORBA_ConstantDef_describe(impl_POA_CORBA_ConstantDef * servant,
				 CORBA_Environment * ev);
void
 impl_CORBA_ConstantDef_move(impl_POA_CORBA_ConstantDef * servant,
			     CORBA_Container new_container,
			     CORBA_Identifier new_name,
			     CORBA_VersionSpec new_version,
			     CORBA_Environment * ev);

static void impl_CORBA_TypedefDef__destroy(impl_POA_CORBA_TypedefDef * servant,
					   CORBA_Environment * ev);

CORBA_DefinitionKind
impl_CORBA_TypedefDef__get_def_kind(impl_POA_CORBA_TypedefDef * servant,
				    CORBA_Environment * ev);
void
 impl_CORBA_TypedefDef_destroy(impl_POA_CORBA_TypedefDef * servant,
 			       CORBA_Environment * ev);

CORBA_RepositoryId
impl_CORBA_TypedefDef__get_id(impl_POA_CORBA_TypedefDef * servant,
			      CORBA_Environment * ev);
void
 impl_CORBA_TypedefDef__set_id(impl_POA_CORBA_TypedefDef * servant,
 			       CORBA_RepositoryId value,
			       CORBA_Environment * ev);

CORBA_Identifier
impl_CORBA_TypedefDef__get_name(impl_POA_CORBA_TypedefDef * servant,
				CORBA_Environment * ev);
void
 impl_CORBA_TypedefDef__set_name(impl_POA_CORBA_TypedefDef * servant,
 				 CORBA_Identifier value,
				 CORBA_Environment * ev);

CORBA_VersionSpec
impl_CORBA_TypedefDef__get_version(impl_POA_CORBA_TypedefDef * servant,
				   CORBA_Environment * ev);
void
 impl_CORBA_TypedefDef__set_version(impl_POA_CORBA_TypedefDef * servant,
 				    CORBA_VersionSpec value,
				    CORBA_Environment * ev);

CORBA_Container
impl_CORBA_TypedefDef__get_defined_in(impl_POA_CORBA_TypedefDef * servant,
				      CORBA_Environment * ev);
CORBA_ScopedName
impl_CORBA_TypedefDef__get_absolute_name(impl_POA_CORBA_TypedefDef * servant,
					 CORBA_Environment * ev);
CORBA_Repository
impl_CORBA_TypedefDef__get_containing_repository(impl_POA_CORBA_TypedefDef * servant,
						 CORBA_Environment * ev);
CORBA_Contained_Description *
 impl_CORBA_TypedefDef_describe(impl_POA_CORBA_TypedefDef * servant,
 				CORBA_Environment * ev);
void
 impl_CORBA_TypedefDef_move(impl_POA_CORBA_TypedefDef * servant,
 			    CORBA_Container new_container,
			    CORBA_Identifier new_name,
			    CORBA_VersionSpec new_version,
			    CORBA_Environment * ev);

CORBA_TypeCode
impl_CORBA_TypedefDef__get_type(impl_POA_CORBA_TypedefDef * servant,
				CORBA_Environment * ev);

static void impl_CORBA_StructDef__destroy(impl_POA_CORBA_StructDef * servant,
					  CORBA_Environment * ev);
CORBA_StructMemberSeq *
 impl_CORBA_StructDef__get_members(impl_POA_CORBA_StructDef * servant,
				   CORBA_Environment * ev);
void
 impl_CORBA_StructDef__set_members(impl_POA_CORBA_StructDef * servant,
				   CORBA_StructMemberSeq * value,
				   CORBA_Environment * ev);

CORBA_DefinitionKind
impl_CORBA_StructDef__get_def_kind(impl_POA_CORBA_StructDef * servant,
				   CORBA_Environment * ev);
void
 impl_CORBA_StructDef_destroy(impl_POA_CORBA_StructDef * servant,
			      CORBA_Environment * ev);

CORBA_RepositoryId
impl_CORBA_StructDef__get_id(impl_POA_CORBA_StructDef * servant,
			     CORBA_Environment * ev);
void
 impl_CORBA_StructDef__set_id(impl_POA_CORBA_StructDef * servant,
			      CORBA_RepositoryId value,
			      CORBA_Environment * ev);

CORBA_Identifier
impl_CORBA_StructDef__get_name(impl_POA_CORBA_StructDef * servant,
			       CORBA_Environment * ev);
void
 impl_CORBA_StructDef__set_name(impl_POA_CORBA_StructDef * servant,
				CORBA_Identifier value,
				CORBA_Environment * ev);

CORBA_VersionSpec
impl_CORBA_StructDef__get_version(impl_POA_CORBA_StructDef * servant,
				  CORBA_Environment * ev);
void
 impl_CORBA_StructDef__set_version(impl_POA_CORBA_StructDef * servant,
				   CORBA_VersionSpec value,
				   CORBA_Environment * ev);

CORBA_Container
impl_CORBA_StructDef__get_defined_in(impl_POA_CORBA_StructDef * servant,
				     CORBA_Environment * ev);
CORBA_ScopedName
impl_CORBA_StructDef__get_absolute_name(impl_POA_CORBA_StructDef * servant,
					CORBA_Environment * ev);
CORBA_Repository
impl_CORBA_StructDef__get_containing_repository(impl_POA_CORBA_StructDef * servant,
						CORBA_Environment * ev);
CORBA_Contained_Description *
 impl_CORBA_StructDef_describe(impl_POA_CORBA_StructDef * servant,
			       CORBA_Environment * ev);
void
 impl_CORBA_StructDef_move(impl_POA_CORBA_StructDef * servant,
			   CORBA_Container new_container,
			   CORBA_Identifier new_name,
			   CORBA_VersionSpec new_version,
			   CORBA_Environment * ev);

CORBA_TypeCode
impl_CORBA_StructDef__get_type(impl_POA_CORBA_StructDef * servant,
			       CORBA_Environment * ev);
CORBA_Contained
impl_CORBA_StructDef_lookup(impl_POA_CORBA_StructDef * servant,
			    CORBA_ScopedName search_name,
			    CORBA_Environment * ev);
CORBA_ContainedSeq *
 impl_CORBA_StructDef_contents(impl_POA_CORBA_StructDef * servant,
			       CORBA_DefinitionKind limit_type,
			       CORBA_boolean exclude_inherited,
			       CORBA_Environment * ev);
CORBA_ContainedSeq *
 impl_CORBA_StructDef_lookup_name(impl_POA_CORBA_StructDef * servant,
				  CORBA_Identifier search_name,
				  CORBA_long levels_to_search,
				  CORBA_DefinitionKind limit_type,
				  CORBA_boolean exclude_inherited,
				  CORBA_Environment * ev);
CORBA_Container_DescriptionSeq *
 impl_CORBA_StructDef_describe_contents(impl_POA_CORBA_StructDef * servant,
					CORBA_DefinitionKind limit_type,
					CORBA_boolean exclude_inherited,
					CORBA_long max_returned_objs,
					CORBA_Environment * ev);

CORBA_ModuleDef
impl_CORBA_StructDef_create_module(impl_POA_CORBA_StructDef * servant,
				   CORBA_RepositoryId id,
				   CORBA_Identifier name,
				   CORBA_VersionSpec version,
				   CORBA_Environment * ev);
CORBA_ConstantDef
impl_CORBA_StructDef_create_constant(impl_POA_CORBA_StructDef * servant,
				     CORBA_RepositoryId id,
				     CORBA_Identifier name,
				     CORBA_VersionSpec version,
				     CORBA_IDLType type,
				     CORBA_any * value,
				     CORBA_Environment * ev);
CORBA_StructDef
impl_CORBA_StructDef_create_struct(impl_POA_CORBA_StructDef * servant,
				   CORBA_RepositoryId id,
				   CORBA_Identifier name,
				   CORBA_VersionSpec version,
				   CORBA_StructMemberSeq * members,
				   CORBA_Environment * ev);
CORBA_UnionDef
impl_CORBA_StructDef_create_union(impl_POA_CORBA_StructDef * servant,
				  CORBA_RepositoryId id,
				  CORBA_Identifier name,
				  CORBA_VersionSpec version,
				  CORBA_IDLType discriminator_type,
				  CORBA_UnionMemberSeq * members,
				  CORBA_Environment * ev);
CORBA_EnumDef
impl_CORBA_StructDef_create_enum(impl_POA_CORBA_StructDef * servant,
				 CORBA_RepositoryId id,
				 CORBA_Identifier name,
				 CORBA_VersionSpec version,
				 CORBA_EnumMemberSeq * members,
				 CORBA_Environment * ev);
CORBA_AliasDef
impl_CORBA_StructDef_create_alias(impl_POA_CORBA_StructDef * servant,
				  CORBA_RepositoryId id,
				  CORBA_Identifier name,
				  CORBA_VersionSpec version,
				  CORBA_IDLType original_type,
				  CORBA_Environment * ev);
CORBA_InterfaceDef
impl_CORBA_StructDef_create_interface(impl_POA_CORBA_StructDef * servant,
				      CORBA_RepositoryId id,
				      CORBA_Identifier name,
				      CORBA_VersionSpec version,
				 CORBA_InterfaceDefSeq * base_interfaces,
				      CORBA_Environment * ev);
CORBA_ExceptionDef
impl_CORBA_StructDef_create_exception(impl_POA_CORBA_StructDef * servant,
				      CORBA_RepositoryId id,
				      CORBA_Identifier name,
				      CORBA_VersionSpec version,
				      CORBA_StructMemberSeq * members,
				      CORBA_Environment * ev);

static void impl_CORBA_UnionDef__destroy(impl_POA_CORBA_UnionDef * servant,
					 CORBA_Environment * ev);

CORBA_TypeCode
impl_CORBA_UnionDef__get_discriminator_type(impl_POA_CORBA_UnionDef * servant,
					    CORBA_Environment * ev);

CORBA_IDLType
impl_CORBA_UnionDef__get_discriminator_type_def(impl_POA_CORBA_UnionDef * servant,
						CORBA_Environment * ev);
void
 impl_CORBA_UnionDef__set_discriminator_type_def(impl_POA_CORBA_UnionDef * servant,
						 CORBA_IDLType value,
						 CORBA_Environment * ev);

CORBA_UnionMemberSeq *
 impl_CORBA_UnionDef__get_members(impl_POA_CORBA_UnionDef * servant,
				  CORBA_Environment * ev);
void
 impl_CORBA_UnionDef__set_members(impl_POA_CORBA_UnionDef * servant,
				  CORBA_UnionMemberSeq * value,
				  CORBA_Environment * ev);

CORBA_DefinitionKind
impl_CORBA_UnionDef__get_def_kind(impl_POA_CORBA_UnionDef * servant,
				  CORBA_Environment * ev);
void
 impl_CORBA_UnionDef_destroy(impl_POA_CORBA_UnionDef * servant,
			     CORBA_Environment * ev);

CORBA_RepositoryId
impl_CORBA_UnionDef__get_id(impl_POA_CORBA_UnionDef * servant,
			    CORBA_Environment * ev);
void
 impl_CORBA_UnionDef__set_id(impl_POA_CORBA_UnionDef * servant,
			     CORBA_RepositoryId value,
			     CORBA_Environment * ev);

CORBA_Identifier
impl_CORBA_UnionDef__get_name(impl_POA_CORBA_UnionDef * servant,
			      CORBA_Environment * ev);
void
 impl_CORBA_UnionDef__set_name(impl_POA_CORBA_UnionDef * servant,
			       CORBA_Identifier value,
			       CORBA_Environment * ev);

CORBA_VersionSpec
impl_CORBA_UnionDef__get_version(impl_POA_CORBA_UnionDef * servant,
				 CORBA_Environment * ev);
void
 impl_CORBA_UnionDef__set_version(impl_POA_CORBA_UnionDef * servant,
				  CORBA_VersionSpec value,
				  CORBA_Environment * ev);

CORBA_Container
impl_CORBA_UnionDef__get_defined_in(impl_POA_CORBA_UnionDef * servant,
				    CORBA_Environment * ev);
CORBA_ScopedName
impl_CORBA_UnionDef__get_absolute_name(impl_POA_CORBA_UnionDef * servant,
				       CORBA_Environment * ev);
CORBA_Repository
impl_CORBA_UnionDef__get_containing_repository(impl_POA_CORBA_UnionDef * servant,
					       CORBA_Environment * ev);
CORBA_Contained_Description *
 impl_CORBA_UnionDef_describe(impl_POA_CORBA_UnionDef * servant,
			      CORBA_Environment * ev);
void
 impl_CORBA_UnionDef_move(impl_POA_CORBA_UnionDef * servant,
			  CORBA_Container new_container,
			  CORBA_Identifier new_name,
			  CORBA_VersionSpec new_version,
			  CORBA_Environment * ev);

CORBA_TypeCode
impl_CORBA_UnionDef__get_type(impl_POA_CORBA_UnionDef * servant,
			      CORBA_Environment * ev);
CORBA_Contained
impl_CORBA_UnionDef_lookup(impl_POA_CORBA_UnionDef * servant,
			   CORBA_ScopedName search_name,
			   CORBA_Environment * ev);
CORBA_ContainedSeq *
 impl_CORBA_UnionDef_contents(impl_POA_CORBA_UnionDef * servant,
			      CORBA_DefinitionKind limit_type,
			      CORBA_boolean exclude_inherited,
			      CORBA_Environment * ev);
CORBA_ContainedSeq *
 impl_CORBA_UnionDef_lookup_name(impl_POA_CORBA_UnionDef * servant,
				 CORBA_Identifier search_name,
				 CORBA_long levels_to_search,
				 CORBA_DefinitionKind limit_type,
				 CORBA_boolean exclude_inherited,
				 CORBA_Environment * ev);
CORBA_Container_DescriptionSeq *
 impl_CORBA_UnionDef_describe_contents(impl_POA_CORBA_UnionDef * servant,
				       CORBA_DefinitionKind limit_type,
				       CORBA_boolean exclude_inherited,
				       CORBA_long max_returned_objs,
				       CORBA_Environment * ev);

CORBA_ModuleDef
impl_CORBA_UnionDef_create_module(impl_POA_CORBA_UnionDef * servant,
				  CORBA_RepositoryId id,
				  CORBA_Identifier name,
				  CORBA_VersionSpec version,
				  CORBA_Environment * ev);
CORBA_ConstantDef
impl_CORBA_UnionDef_create_constant(impl_POA_CORBA_UnionDef * servant,
				    CORBA_RepositoryId id,
				    CORBA_Identifier name,
				    CORBA_VersionSpec version,
				    CORBA_IDLType type,
				    CORBA_any * value,
				    CORBA_Environment * ev);
CORBA_StructDef
impl_CORBA_UnionDef_create_struct(impl_POA_CORBA_UnionDef * servant,
				  CORBA_RepositoryId id,
				  CORBA_Identifier name,
				  CORBA_VersionSpec version,
				  CORBA_StructMemberSeq * members,
				  CORBA_Environment * ev);
CORBA_UnionDef
impl_CORBA_UnionDef_create_union(impl_POA_CORBA_UnionDef * servant,
				 CORBA_RepositoryId id,
				 CORBA_Identifier name,
				 CORBA_VersionSpec version,
				 CORBA_IDLType discriminator_type,
				 CORBA_UnionMemberSeq * members,
				 CORBA_Environment * ev);
CORBA_EnumDef
impl_CORBA_UnionDef_create_enum(impl_POA_CORBA_UnionDef * servant,
				CORBA_RepositoryId id,
				CORBA_Identifier name,
				CORBA_VersionSpec version,
				CORBA_EnumMemberSeq * members,
				CORBA_Environment * ev);
CORBA_AliasDef
impl_CORBA_UnionDef_create_alias(impl_POA_CORBA_UnionDef * servant,
				 CORBA_RepositoryId id,
				 CORBA_Identifier name,
				 CORBA_VersionSpec version,
				 CORBA_IDLType original_type,
				 CORBA_Environment * ev);
CORBA_InterfaceDef
impl_CORBA_UnionDef_create_interface(impl_POA_CORBA_UnionDef * servant,
				     CORBA_RepositoryId id,
				     CORBA_Identifier name,
				     CORBA_VersionSpec version,
				 CORBA_InterfaceDefSeq * base_interfaces,
				     CORBA_Environment * ev);
CORBA_ExceptionDef
impl_CORBA_UnionDef_create_exception(impl_POA_CORBA_UnionDef * servant,
				     CORBA_RepositoryId id,
				     CORBA_Identifier name,
				     CORBA_VersionSpec version,
				     CORBA_StructMemberSeq * members,
				     CORBA_Environment * ev);

static void impl_CORBA_EnumDef__destroy(impl_POA_CORBA_EnumDef * servant,
					CORBA_Environment * ev);
CORBA_EnumMemberSeq *
 impl_CORBA_EnumDef__get_members(impl_POA_CORBA_EnumDef * servant,
				 CORBA_Environment * ev);
void
 impl_CORBA_EnumDef__set_members(impl_POA_CORBA_EnumDef * servant,
				 CORBA_EnumMemberSeq * value,
				 CORBA_Environment * ev);

CORBA_DefinitionKind
impl_CORBA_EnumDef__get_def_kind(impl_POA_CORBA_EnumDef * servant,
				 CORBA_Environment * ev);
void
 impl_CORBA_EnumDef_destroy(impl_POA_CORBA_EnumDef * servant,
			    CORBA_Environment * ev);

CORBA_RepositoryId
impl_CORBA_EnumDef__get_id(impl_POA_CORBA_EnumDef * servant,
			   CORBA_Environment * ev);
void
 impl_CORBA_EnumDef__set_id(impl_POA_CORBA_EnumDef * servant,
			    CORBA_RepositoryId value,
			    CORBA_Environment * ev);

CORBA_Identifier
impl_CORBA_EnumDef__get_name(impl_POA_CORBA_EnumDef * servant,
			     CORBA_Environment * ev);
void
 impl_CORBA_EnumDef__set_name(impl_POA_CORBA_EnumDef * servant,
			      CORBA_Identifier value,
			      CORBA_Environment * ev);

CORBA_VersionSpec
impl_CORBA_EnumDef__get_version(impl_POA_CORBA_EnumDef * servant,
				CORBA_Environment * ev);
void
 impl_CORBA_EnumDef__set_version(impl_POA_CORBA_EnumDef * servant,
				 CORBA_VersionSpec value,
				 CORBA_Environment * ev);

CORBA_Container
impl_CORBA_EnumDef__get_defined_in(impl_POA_CORBA_EnumDef * servant,
				   CORBA_Environment * ev);
CORBA_ScopedName
impl_CORBA_EnumDef__get_absolute_name(impl_POA_CORBA_EnumDef * servant,
				      CORBA_Environment * ev);
CORBA_Repository
impl_CORBA_EnumDef__get_containing_repository(impl_POA_CORBA_EnumDef * servant,
					      CORBA_Environment * ev);
CORBA_Contained_Description *
 impl_CORBA_EnumDef_describe(impl_POA_CORBA_EnumDef * servant,
			     CORBA_Environment * ev);
void
 impl_CORBA_EnumDef_move(impl_POA_CORBA_EnumDef * servant,
			 CORBA_Container new_container,
			 CORBA_Identifier new_name,
			 CORBA_VersionSpec new_version,
			 CORBA_Environment * ev);

CORBA_TypeCode
impl_CORBA_EnumDef__get_type(impl_POA_CORBA_EnumDef * servant,
			     CORBA_Environment * ev);

static void impl_CORBA_AliasDef__destroy(impl_POA_CORBA_AliasDef * servant,
					 CORBA_Environment * ev);

CORBA_IDLType
impl_CORBA_AliasDef__get_original_type_def(impl_POA_CORBA_AliasDef * servant,
					   CORBA_Environment * ev);
void
 impl_CORBA_AliasDef__set_original_type_def(impl_POA_CORBA_AliasDef * servant,
					    CORBA_IDLType value,
					    CORBA_Environment * ev);

CORBA_DefinitionKind
impl_CORBA_AliasDef__get_def_kind(impl_POA_CORBA_AliasDef * servant,
				  CORBA_Environment * ev);
void
 impl_CORBA_AliasDef_destroy(impl_POA_CORBA_AliasDef * servant,
			     CORBA_Environment * ev);

CORBA_RepositoryId
impl_CORBA_AliasDef__get_id(impl_POA_CORBA_AliasDef * servant,
			    CORBA_Environment * ev);
void
 impl_CORBA_AliasDef__set_id(impl_POA_CORBA_AliasDef * servant,
			     CORBA_RepositoryId value,
			     CORBA_Environment * ev);

CORBA_Identifier
impl_CORBA_AliasDef__get_name(impl_POA_CORBA_AliasDef * servant,
			      CORBA_Environment * ev);
void
 impl_CORBA_AliasDef__set_name(impl_POA_CORBA_AliasDef * servant,
			       CORBA_Identifier value,
			       CORBA_Environment * ev);

CORBA_VersionSpec
impl_CORBA_AliasDef__get_version(impl_POA_CORBA_AliasDef * servant,
				 CORBA_Environment * ev);
void
 impl_CORBA_AliasDef__set_version(impl_POA_CORBA_AliasDef * servant,
				  CORBA_VersionSpec value,
				  CORBA_Environment * ev);

CORBA_Container
impl_CORBA_AliasDef__get_defined_in(impl_POA_CORBA_AliasDef * servant,
				    CORBA_Environment * ev);
CORBA_ScopedName
impl_CORBA_AliasDef__get_absolute_name(impl_POA_CORBA_AliasDef * servant,
				       CORBA_Environment * ev);
CORBA_Repository
impl_CORBA_AliasDef__get_containing_repository(impl_POA_CORBA_AliasDef * servant,
					       CORBA_Environment * ev);
CORBA_Contained_Description *
 impl_CORBA_AliasDef_describe(impl_POA_CORBA_AliasDef * servant,
			      CORBA_Environment * ev);
void
 impl_CORBA_AliasDef_move(impl_POA_CORBA_AliasDef * servant,
			  CORBA_Container new_container,
			  CORBA_Identifier new_name,
			  CORBA_VersionSpec new_version,
			  CORBA_Environment * ev);

CORBA_TypeCode
impl_CORBA_AliasDef__get_type(impl_POA_CORBA_AliasDef * servant,
			      CORBA_Environment * ev);

static void impl_CORBA_PrimitiveDef__destroy(impl_POA_CORBA_PrimitiveDef * servant,
					     CORBA_Environment * ev);

CORBA_PrimitiveKind
impl_CORBA_PrimitiveDef__get_kind(impl_POA_CORBA_PrimitiveDef * servant,
				  CORBA_Environment * ev);

CORBA_DefinitionKind
impl_CORBA_PrimitiveDef__get_def_kind(impl_POA_CORBA_PrimitiveDef * servant,
				      CORBA_Environment * ev);
void
 impl_CORBA_PrimitiveDef_destroy(impl_POA_CORBA_PrimitiveDef * servant,
				 CORBA_Environment * ev);

CORBA_TypeCode
impl_CORBA_PrimitiveDef__get_type(impl_POA_CORBA_PrimitiveDef * servant,
				  CORBA_Environment * ev);

static void impl_CORBA_StringDef__destroy(impl_POA_CORBA_StringDef * servant,
					  CORBA_Environment * ev);

CORBA_unsigned_long
impl_CORBA_StringDef__get_bound(impl_POA_CORBA_StringDef * servant,
				CORBA_Environment * ev);
void
 impl_CORBA_StringDef__set_bound(impl_POA_CORBA_StringDef * servant,
				 CORBA_unsigned_long value,
				 CORBA_Environment * ev);

CORBA_DefinitionKind
impl_CORBA_StringDef__get_def_kind(impl_POA_CORBA_StringDef * servant,
				   CORBA_Environment * ev);
void
 impl_CORBA_StringDef_destroy(impl_POA_CORBA_StringDef * servant,
			      CORBA_Environment * ev);

CORBA_TypeCode
impl_CORBA_StringDef__get_type(impl_POA_CORBA_StringDef * servant,
			       CORBA_Environment * ev);

static void impl_CORBA_WstringDef__destroy(impl_POA_CORBA_WstringDef * servant,
					   CORBA_Environment * ev);

CORBA_unsigned_long
impl_CORBA_WstringDef__get_bound(impl_POA_CORBA_WstringDef * servant,
				 CORBA_Environment * ev);
void
 impl_CORBA_WstringDef__set_bound(impl_POA_CORBA_WstringDef * servant,
				  CORBA_unsigned_long value,
				  CORBA_Environment * ev);

CORBA_DefinitionKind
impl_CORBA_WstringDef__get_def_kind(impl_POA_CORBA_WstringDef * servant,
				    CORBA_Environment * ev);
void
 impl_CORBA_WstringDef_destroy(impl_POA_CORBA_WstringDef * servant,
			       CORBA_Environment * ev);

CORBA_TypeCode
impl_CORBA_WstringDef__get_type(impl_POA_CORBA_WstringDef * servant,
				CORBA_Environment * ev);

static void impl_CORBA_FixedDef__destroy(impl_POA_CORBA_FixedDef * servant,
					 CORBA_Environment * ev);

CORBA_unsigned_short
impl_CORBA_FixedDef__get_digits(impl_POA_CORBA_FixedDef * servant,
				CORBA_Environment * ev);
void
 impl_CORBA_FixedDef__set_digits(impl_POA_CORBA_FixedDef * servant,
				 CORBA_unsigned_short value,
				 CORBA_Environment * ev);

CORBA_short
impl_CORBA_FixedDef__get_scale(impl_POA_CORBA_FixedDef * servant,
			       CORBA_Environment * ev);
void
 impl_CORBA_FixedDef__set_scale(impl_POA_CORBA_FixedDef * servant,
				CORBA_short value,
				CORBA_Environment * ev);

CORBA_DefinitionKind
impl_CORBA_FixedDef__get_def_kind(impl_POA_CORBA_FixedDef * servant,
				  CORBA_Environment * ev);
void
 impl_CORBA_FixedDef_destroy(impl_POA_CORBA_FixedDef * servant,
			     CORBA_Environment * ev);

CORBA_TypeCode
impl_CORBA_FixedDef__get_type(impl_POA_CORBA_FixedDef * servant,
			      CORBA_Environment * ev);

static void impl_CORBA_SequenceDef__destroy(impl_POA_CORBA_SequenceDef * servant,
					    CORBA_Environment * ev);

CORBA_unsigned_long
impl_CORBA_SequenceDef__get_bound(impl_POA_CORBA_SequenceDef * servant,
				  CORBA_Environment * ev);
void
 impl_CORBA_SequenceDef__set_bound(impl_POA_CORBA_SequenceDef * servant,
				   CORBA_unsigned_long value,
				   CORBA_Environment * ev);

CORBA_TypeCode
impl_CORBA_SequenceDef__get_element_type(impl_POA_CORBA_SequenceDef * servant,
					 CORBA_Environment * ev);

CORBA_IDLType
impl_CORBA_SequenceDef__get_element_type_def(impl_POA_CORBA_SequenceDef * servant,
					     CORBA_Environment * ev);
void
 impl_CORBA_SequenceDef__set_element_type_def(impl_POA_CORBA_SequenceDef * servant,
					      CORBA_IDLType value,
					      CORBA_Environment * ev);

CORBA_DefinitionKind
impl_CORBA_SequenceDef__get_def_kind(impl_POA_CORBA_SequenceDef * servant,
				     CORBA_Environment * ev);
void
 impl_CORBA_SequenceDef_destroy(impl_POA_CORBA_SequenceDef * servant,
				CORBA_Environment * ev);

CORBA_TypeCode
impl_CORBA_SequenceDef__get_type(impl_POA_CORBA_SequenceDef * servant,
				 CORBA_Environment * ev);

static void impl_CORBA_ArrayDef__destroy(impl_POA_CORBA_ArrayDef * servant,
					 CORBA_Environment * ev);

CORBA_unsigned_long
impl_CORBA_ArrayDef__get_length(impl_POA_CORBA_ArrayDef * servant,
				CORBA_Environment * ev);
void
 impl_CORBA_ArrayDef__set_length(impl_POA_CORBA_ArrayDef * servant,
				 CORBA_unsigned_long value,
				 CORBA_Environment * ev);

CORBA_TypeCode
impl_CORBA_ArrayDef__get_element_type(impl_POA_CORBA_ArrayDef * servant,
				      CORBA_Environment * ev);

CORBA_IDLType
impl_CORBA_ArrayDef__get_element_type_def(impl_POA_CORBA_ArrayDef * servant,
					  CORBA_Environment * ev);
void
 impl_CORBA_ArrayDef__set_element_type_def(impl_POA_CORBA_ArrayDef * servant,
					   CORBA_IDLType value,
					   CORBA_Environment * ev);

CORBA_DefinitionKind
impl_CORBA_ArrayDef__get_def_kind(impl_POA_CORBA_ArrayDef * servant,
				  CORBA_Environment * ev);
void
 impl_CORBA_ArrayDef_destroy(impl_POA_CORBA_ArrayDef * servant,
			     CORBA_Environment * ev);

CORBA_TypeCode
impl_CORBA_ArrayDef__get_type(impl_POA_CORBA_ArrayDef * servant,
			      CORBA_Environment * ev);

static void impl_CORBA_ExceptionDef__destroy(impl_POA_CORBA_ExceptionDef * servant,
					     CORBA_Environment * ev);

CORBA_TypeCode
impl_CORBA_ExceptionDef__get_type(impl_POA_CORBA_ExceptionDef * servant,
				  CORBA_Environment * ev);

CORBA_StructMemberSeq *
 impl_CORBA_ExceptionDef__get_members(impl_POA_CORBA_ExceptionDef * servant,
				      CORBA_Environment * ev);
void
 impl_CORBA_ExceptionDef__set_members(impl_POA_CORBA_ExceptionDef * servant,
				      CORBA_StructMemberSeq * value,
				      CORBA_Environment * ev);

CORBA_DefinitionKind
impl_CORBA_ExceptionDef__get_def_kind(impl_POA_CORBA_ExceptionDef * servant,
				      CORBA_Environment * ev);
void
 impl_CORBA_ExceptionDef_destroy(impl_POA_CORBA_ExceptionDef * servant,
				 CORBA_Environment * ev);

CORBA_RepositoryId
impl_CORBA_ExceptionDef__get_id(impl_POA_CORBA_ExceptionDef * servant,
				CORBA_Environment * ev);
void
 impl_CORBA_ExceptionDef__set_id(impl_POA_CORBA_ExceptionDef * servant,
				 CORBA_RepositoryId value,
				 CORBA_Environment * ev);

CORBA_Identifier
impl_CORBA_ExceptionDef__get_name(impl_POA_CORBA_ExceptionDef * servant,
				  CORBA_Environment * ev);
void
 impl_CORBA_ExceptionDef__set_name(impl_POA_CORBA_ExceptionDef * servant,
				   CORBA_Identifier value,
				   CORBA_Environment * ev);

CORBA_VersionSpec
impl_CORBA_ExceptionDef__get_version(impl_POA_CORBA_ExceptionDef * servant,
				     CORBA_Environment * ev);
void
 impl_CORBA_ExceptionDef__set_version(impl_POA_CORBA_ExceptionDef * servant,
				      CORBA_VersionSpec value,
				      CORBA_Environment * ev);

CORBA_Container
impl_CORBA_ExceptionDef__get_defined_in(impl_POA_CORBA_ExceptionDef * servant,
					CORBA_Environment * ev);
CORBA_ScopedName
impl_CORBA_ExceptionDef__get_absolute_name(impl_POA_CORBA_ExceptionDef * servant,
					   CORBA_Environment * ev);
CORBA_Repository
impl_CORBA_ExceptionDef__get_containing_repository(impl_POA_CORBA_ExceptionDef * servant,
						 CORBA_Environment * ev);
CORBA_Contained_Description *
 impl_CORBA_ExceptionDef_describe(impl_POA_CORBA_ExceptionDef * servant,
				  CORBA_Environment * ev);
void
 impl_CORBA_ExceptionDef_move(impl_POA_CORBA_ExceptionDef * servant,
			      CORBA_Container new_container,
			      CORBA_Identifier new_name,
			      CORBA_VersionSpec new_version,
			      CORBA_Environment * ev);

CORBA_Contained
impl_CORBA_ExceptionDef_lookup(impl_POA_CORBA_ExceptionDef * servant,
			       CORBA_ScopedName search_name,
			       CORBA_Environment * ev);
CORBA_ContainedSeq *
 impl_CORBA_ExceptionDef_contents(impl_POA_CORBA_ExceptionDef * servant,
				  CORBA_DefinitionKind limit_type,
				  CORBA_boolean exclude_inherited,
				  CORBA_Environment * ev);
CORBA_ContainedSeq *
 impl_CORBA_ExceptionDef_lookup_name(impl_POA_CORBA_ExceptionDef * servant,
				     CORBA_Identifier search_name,
				     CORBA_long levels_to_search,
				     CORBA_DefinitionKind limit_type,
				     CORBA_boolean exclude_inherited,
				     CORBA_Environment * ev);
CORBA_Container_DescriptionSeq *
 impl_CORBA_ExceptionDef_describe_contents(impl_POA_CORBA_ExceptionDef * servant,
					 CORBA_DefinitionKind limit_type,
					 CORBA_boolean exclude_inherited,
					   CORBA_long max_returned_objs,
					   CORBA_Environment * ev);

CORBA_ModuleDef
impl_CORBA_ExceptionDef_create_module(impl_POA_CORBA_ExceptionDef * servant,
				      CORBA_RepositoryId id,
				      CORBA_Identifier name,
				      CORBA_VersionSpec version,
				      CORBA_Environment * ev);
CORBA_ConstantDef
impl_CORBA_ExceptionDef_create_constant(impl_POA_CORBA_ExceptionDef * servant,
					CORBA_RepositoryId id,
					CORBA_Identifier name,
					CORBA_VersionSpec version,
					CORBA_IDLType type,
					CORBA_any * value,
					CORBA_Environment * ev);
CORBA_StructDef
impl_CORBA_ExceptionDef_create_struct(impl_POA_CORBA_ExceptionDef * servant,
				      CORBA_RepositoryId id,
				      CORBA_Identifier name,
				      CORBA_VersionSpec version,
				      CORBA_StructMemberSeq * members,
				      CORBA_Environment * ev);
CORBA_UnionDef
impl_CORBA_ExceptionDef_create_union(impl_POA_CORBA_ExceptionDef * servant,
				     CORBA_RepositoryId id,
				     CORBA_Identifier name,
				     CORBA_VersionSpec version,
				     CORBA_IDLType discriminator_type,
				     CORBA_UnionMemberSeq * members,
				     CORBA_Environment * ev);
CORBA_EnumDef
impl_CORBA_ExceptionDef_create_enum(impl_POA_CORBA_ExceptionDef * servant,
				    CORBA_RepositoryId id,
				    CORBA_Identifier name,
				    CORBA_VersionSpec version,
				    CORBA_EnumMemberSeq * members,
				    CORBA_Environment * ev);
CORBA_AliasDef
impl_CORBA_ExceptionDef_create_alias(impl_POA_CORBA_ExceptionDef * servant,
				     CORBA_RepositoryId id,
				     CORBA_Identifier name,
				     CORBA_VersionSpec version,
				     CORBA_IDLType original_type,
				     CORBA_Environment * ev);
CORBA_InterfaceDef
impl_CORBA_ExceptionDef_create_interface(impl_POA_CORBA_ExceptionDef * servant,
					 CORBA_RepositoryId id,
					 CORBA_Identifier name,
					 CORBA_VersionSpec version,
				 CORBA_InterfaceDefSeq * base_interfaces,
					 CORBA_Environment * ev);
CORBA_ExceptionDef
impl_CORBA_ExceptionDef_create_exception(impl_POA_CORBA_ExceptionDef * servant,
					 CORBA_RepositoryId id,
					 CORBA_Identifier name,
					 CORBA_VersionSpec version,
					 CORBA_StructMemberSeq * members,
					 CORBA_Environment * ev);

static void impl_CORBA_AttributeDef__destroy(impl_POA_CORBA_AttributeDef * servant,
					     CORBA_Environment * ev);

CORBA_TypeCode
impl_CORBA_AttributeDef__get_type(impl_POA_CORBA_AttributeDef * servant,
				  CORBA_Environment * ev);

CORBA_IDLType
impl_CORBA_AttributeDef__get_type_def(impl_POA_CORBA_AttributeDef * servant,
				      CORBA_Environment * ev);
void
 impl_CORBA_AttributeDef__set_type_def(impl_POA_CORBA_AttributeDef * servant,
				       CORBA_IDLType value,
				       CORBA_Environment * ev);

CORBA_AttributeMode
impl_CORBA_AttributeDef__get_mode(impl_POA_CORBA_AttributeDef * servant,
				  CORBA_Environment * ev);
void
 impl_CORBA_AttributeDef__set_mode(impl_POA_CORBA_AttributeDef * servant,
				   CORBA_AttributeMode value,
				   CORBA_Environment * ev);

CORBA_DefinitionKind
impl_CORBA_AttributeDef__get_def_kind(impl_POA_CORBA_AttributeDef * servant,
				      CORBA_Environment * ev);
void
 impl_CORBA_AttributeDef_destroy(impl_POA_CORBA_AttributeDef * servant,
				 CORBA_Environment * ev);

CORBA_RepositoryId
impl_CORBA_AttributeDef__get_id(impl_POA_CORBA_AttributeDef * servant,
				CORBA_Environment * ev);
void
 impl_CORBA_AttributeDef__set_id(impl_POA_CORBA_AttributeDef * servant,
				 CORBA_RepositoryId value,
				 CORBA_Environment * ev);

CORBA_Identifier
impl_CORBA_AttributeDef__get_name(impl_POA_CORBA_AttributeDef * servant,
				  CORBA_Environment * ev);
void
 impl_CORBA_AttributeDef__set_name(impl_POA_CORBA_AttributeDef * servant,
				   CORBA_Identifier value,
				   CORBA_Environment * ev);

CORBA_VersionSpec
impl_CORBA_AttributeDef__get_version(impl_POA_CORBA_AttributeDef * servant,
				     CORBA_Environment * ev);
void
 impl_CORBA_AttributeDef__set_version(impl_POA_CORBA_AttributeDef * servant,
				      CORBA_VersionSpec value,
				      CORBA_Environment * ev);

CORBA_Container
impl_CORBA_AttributeDef__get_defined_in(impl_POA_CORBA_AttributeDef * servant,
					CORBA_Environment * ev);
CORBA_ScopedName
impl_CORBA_AttributeDef__get_absolute_name(impl_POA_CORBA_AttributeDef * servant,
					   CORBA_Environment * ev);
CORBA_Repository
impl_CORBA_AttributeDef__get_containing_repository(impl_POA_CORBA_AttributeDef * servant,
						 CORBA_Environment * ev);
CORBA_Contained_Description *
 impl_CORBA_AttributeDef_describe(impl_POA_CORBA_AttributeDef * servant,
				  CORBA_Environment * ev);
void
 impl_CORBA_AttributeDef_move(impl_POA_CORBA_AttributeDef * servant,
			      CORBA_Container new_container,
			      CORBA_Identifier new_name,
			      CORBA_VersionSpec new_version,
			      CORBA_Environment * ev);

static void impl_CORBA_OperationDef__destroy(impl_POA_CORBA_OperationDef * servant,
					     CORBA_Environment * ev);

CORBA_TypeCode
impl_CORBA_OperationDef__get_result(impl_POA_CORBA_OperationDef * servant,
				    CORBA_Environment * ev);

CORBA_IDLType
impl_CORBA_OperationDef__get_result_def(impl_POA_CORBA_OperationDef * servant,
					CORBA_Environment * ev);
void
 impl_CORBA_OperationDef__set_result_def(impl_POA_CORBA_OperationDef * servant,
					 CORBA_IDLType value,
					 CORBA_Environment * ev);

CORBA_ParDescriptionSeq *
 impl_CORBA_OperationDef__get_params(impl_POA_CORBA_OperationDef * servant,
				     CORBA_Environment * ev);
void
 impl_CORBA_OperationDef__set_params(impl_POA_CORBA_OperationDef * servant,
				     CORBA_ParDescriptionSeq * value,
				     CORBA_Environment * ev);

CORBA_OperationMode
impl_CORBA_OperationDef__get_mode(impl_POA_CORBA_OperationDef * servant,
				  CORBA_Environment * ev);
void
 impl_CORBA_OperationDef__set_mode(impl_POA_CORBA_OperationDef * servant,
				   CORBA_OperationMode value,
				   CORBA_Environment * ev);

CORBA_ContextIdSeq *
 impl_CORBA_OperationDef__get_contexts(impl_POA_CORBA_OperationDef * servant,
				       CORBA_Environment * ev);
void
 impl_CORBA_OperationDef__set_contexts(impl_POA_CORBA_OperationDef * servant,
				       CORBA_ContextIdSeq * value,
				       CORBA_Environment * ev);

CORBA_ExceptionDefSeq *
 impl_CORBA_OperationDef__get_exceptions(impl_POA_CORBA_OperationDef * servant,
					 CORBA_Environment * ev);
void
 impl_CORBA_OperationDef__set_exceptions(impl_POA_CORBA_OperationDef * servant,
					 CORBA_ExceptionDefSeq * value,
					 CORBA_Environment * ev);

CORBA_DefinitionKind
impl_CORBA_OperationDef__get_def_kind(impl_POA_CORBA_OperationDef * servant,
				      CORBA_Environment * ev);
void
 impl_CORBA_OperationDef_destroy(impl_POA_CORBA_OperationDef * servant,
				 CORBA_Environment * ev);

CORBA_RepositoryId
impl_CORBA_OperationDef__get_id(impl_POA_CORBA_OperationDef * servant,
				CORBA_Environment * ev);
void
 impl_CORBA_OperationDef__set_id(impl_POA_CORBA_OperationDef * servant,
				 CORBA_RepositoryId value,
				 CORBA_Environment * ev);

CORBA_Identifier
impl_CORBA_OperationDef__get_name(impl_POA_CORBA_OperationDef * servant,
				  CORBA_Environment * ev);
void
 impl_CORBA_OperationDef__set_name(impl_POA_CORBA_OperationDef * servant,
				   CORBA_Identifier value,
				   CORBA_Environment * ev);

CORBA_VersionSpec
impl_CORBA_OperationDef__get_version(impl_POA_CORBA_OperationDef * servant,
				     CORBA_Environment * ev);
void
 impl_CORBA_OperationDef__set_version(impl_POA_CORBA_OperationDef * servant,
				      CORBA_VersionSpec value,
				      CORBA_Environment * ev);

CORBA_Container
impl_CORBA_OperationDef__get_defined_in(impl_POA_CORBA_OperationDef * servant,
					CORBA_Environment * ev);
CORBA_ScopedName
impl_CORBA_OperationDef__get_absolute_name(impl_POA_CORBA_OperationDef * servant,
					   CORBA_Environment * ev);
CORBA_Repository
impl_CORBA_OperationDef__get_containing_repository(impl_POA_CORBA_OperationDef * servant,
						 CORBA_Environment * ev);
CORBA_Contained_Description *
 impl_CORBA_OperationDef_describe(impl_POA_CORBA_OperationDef * servant,
				  CORBA_Environment * ev);
void
 impl_CORBA_OperationDef_move(impl_POA_CORBA_OperationDef * servant,
			      CORBA_Container new_container,
			      CORBA_Identifier new_name,
			      CORBA_VersionSpec new_version,
			      CORBA_Environment * ev);

static void impl_CORBA_InterfaceDef__destroy(impl_POA_CORBA_InterfaceDef * servant,
					     CORBA_Environment * ev);
CORBA_InterfaceDefSeq *
 impl_CORBA_InterfaceDef__get_base_interfaces(impl_POA_CORBA_InterfaceDef * servant,
					      CORBA_Environment * ev);
void
 impl_CORBA_InterfaceDef__set_base_interfaces(impl_POA_CORBA_InterfaceDef * servant,
					   CORBA_InterfaceDefSeq * value,
					      CORBA_Environment * ev);

CORBA_boolean
impl_CORBA_InterfaceDef_is_a(impl_POA_CORBA_InterfaceDef * servant,
			     CORBA_RepositoryId interface_id,
			     CORBA_Environment * ev);

CORBA_InterfaceDef_FullInterfaceDescription *
 impl_CORBA_InterfaceDef_describe_interface(impl_POA_CORBA_InterfaceDef * servant,
					    CORBA_Environment * ev);

CORBA_AttributeDef
impl_CORBA_InterfaceDef_create_attribute(impl_POA_CORBA_InterfaceDef * servant,
					 CORBA_RepositoryId id,
					 CORBA_Identifier name,
					 CORBA_VersionSpec version,
					 CORBA_IDLType type,
					 CORBA_AttributeMode mode,
					 CORBA_Environment * ev);

CORBA_OperationDef
impl_CORBA_InterfaceDef_create_operation(impl_POA_CORBA_InterfaceDef * servant,
					 CORBA_RepositoryId id,
					 CORBA_Identifier name,
					 CORBA_VersionSpec version,
					 CORBA_IDLType result,
					 CORBA_OperationMode mode,
					 CORBA_ParDescriptionSeq * params,
				      CORBA_ExceptionDefSeq * exceptions,
					 CORBA_ContextIdSeq * contexts,
					 CORBA_Environment * ev);

CORBA_DefinitionKind
impl_CORBA_InterfaceDef__get_def_kind(impl_POA_CORBA_InterfaceDef * servant,
				      CORBA_Environment * ev);
void
 impl_CORBA_InterfaceDef_destroy(impl_POA_CORBA_InterfaceDef * servant,
				 CORBA_Environment * ev);

CORBA_Contained
impl_CORBA_InterfaceDef_lookup(impl_POA_CORBA_InterfaceDef * servant,
			       CORBA_ScopedName search_name,
			       CORBA_Environment * ev);
CORBA_ContainedSeq *
 impl_CORBA_InterfaceDef_contents(impl_POA_CORBA_InterfaceDef * servant,
				  CORBA_DefinitionKind limit_type,
				  CORBA_boolean exclude_inherited,
				  CORBA_Environment * ev);
CORBA_ContainedSeq *
 impl_CORBA_InterfaceDef_lookup_name(impl_POA_CORBA_InterfaceDef * servant,
				     CORBA_Identifier search_name,
				     CORBA_long levels_to_search,
				     CORBA_DefinitionKind limit_type,
				     CORBA_boolean exclude_inherited,
				     CORBA_Environment * ev);
CORBA_Container_DescriptionSeq *
 impl_CORBA_InterfaceDef_describe_contents(impl_POA_CORBA_InterfaceDef * servant,
					 CORBA_DefinitionKind limit_type,
					 CORBA_boolean exclude_inherited,
					   CORBA_long max_returned_objs,
					   CORBA_Environment * ev);

CORBA_ModuleDef
impl_CORBA_InterfaceDef_create_module(impl_POA_CORBA_InterfaceDef * servant,
				      CORBA_RepositoryId id,
				      CORBA_Identifier name,
				      CORBA_VersionSpec version,
				      CORBA_Environment * ev);
CORBA_ConstantDef
impl_CORBA_InterfaceDef_create_constant(impl_POA_CORBA_InterfaceDef * servant,
					CORBA_RepositoryId id,
					CORBA_Identifier name,
					CORBA_VersionSpec version,
					CORBA_IDLType type,
					CORBA_any * value,
					CORBA_Environment * ev);
CORBA_StructDef
impl_CORBA_InterfaceDef_create_struct(impl_POA_CORBA_InterfaceDef * servant,
				      CORBA_RepositoryId id,
				      CORBA_Identifier name,
				      CORBA_VersionSpec version,
				      CORBA_StructMemberSeq * members,
				      CORBA_Environment * ev);
CORBA_UnionDef
impl_CORBA_InterfaceDef_create_union(impl_POA_CORBA_InterfaceDef * servant,
				     CORBA_RepositoryId id,
				     CORBA_Identifier name,
				     CORBA_VersionSpec version,
				     CORBA_IDLType discriminator_type,
				     CORBA_UnionMemberSeq * members,
				     CORBA_Environment * ev);
CORBA_EnumDef
impl_CORBA_InterfaceDef_create_enum(impl_POA_CORBA_InterfaceDef * servant,
				    CORBA_RepositoryId id,
				    CORBA_Identifier name,
				    CORBA_VersionSpec version,
				    CORBA_EnumMemberSeq * members,
				    CORBA_Environment * ev);
CORBA_AliasDef
impl_CORBA_InterfaceDef_create_alias(impl_POA_CORBA_InterfaceDef * servant,
				     CORBA_RepositoryId id,
				     CORBA_Identifier name,
				     CORBA_VersionSpec version,
				     CORBA_IDLType original_type,
				     CORBA_Environment * ev);
CORBA_InterfaceDef
impl_CORBA_InterfaceDef_create_interface(impl_POA_CORBA_InterfaceDef * servant,
					 CORBA_RepositoryId id,
					 CORBA_Identifier name,
					 CORBA_VersionSpec version,
				 CORBA_InterfaceDefSeq * base_interfaces,
					 CORBA_Environment * ev);
CORBA_ExceptionDef
impl_CORBA_InterfaceDef_create_exception(impl_POA_CORBA_InterfaceDef * servant,
					 CORBA_RepositoryId id,
					 CORBA_Identifier name,
					 CORBA_VersionSpec version,
					 CORBA_StructMemberSeq * members,
					 CORBA_Environment * ev);
CORBA_RepositoryId
impl_CORBA_InterfaceDef__get_id(impl_POA_CORBA_InterfaceDef * servant,
				CORBA_Environment * ev);
void
 impl_CORBA_InterfaceDef__set_id(impl_POA_CORBA_InterfaceDef * servant,
				 CORBA_RepositoryId value,
				 CORBA_Environment * ev);

CORBA_Identifier
impl_CORBA_InterfaceDef__get_name(impl_POA_CORBA_InterfaceDef * servant,
				  CORBA_Environment * ev);
void
 impl_CORBA_InterfaceDef__set_name(impl_POA_CORBA_InterfaceDef * servant,
				   CORBA_Identifier value,
				   CORBA_Environment * ev);

CORBA_VersionSpec
impl_CORBA_InterfaceDef__get_version(impl_POA_CORBA_InterfaceDef * servant,
				     CORBA_Environment * ev);
void
 impl_CORBA_InterfaceDef__set_version(impl_POA_CORBA_InterfaceDef * servant,
				      CORBA_VersionSpec value,
				      CORBA_Environment * ev);

CORBA_Container
impl_CORBA_InterfaceDef__get_defined_in(impl_POA_CORBA_InterfaceDef * servant,
					CORBA_Environment * ev);
CORBA_ScopedName
impl_CORBA_InterfaceDef__get_absolute_name(impl_POA_CORBA_InterfaceDef * servant,
					   CORBA_Environment * ev);
CORBA_Repository
impl_CORBA_InterfaceDef__get_containing_repository(impl_POA_CORBA_InterfaceDef * servant,
						 CORBA_Environment * ev);
CORBA_Contained_Description *
 impl_CORBA_InterfaceDef_describe(impl_POA_CORBA_InterfaceDef * servant,
				  CORBA_Environment * ev);
void
 impl_CORBA_InterfaceDef_move(impl_POA_CORBA_InterfaceDef * servant,
			      CORBA_Container new_container,
			      CORBA_Identifier new_name,
			      CORBA_VersionSpec new_version,
			      CORBA_Environment * ev);

CORBA_TypeCode
impl_CORBA_InterfaceDef__get_type(impl_POA_CORBA_InterfaceDef * servant,
				  CORBA_Environment * ev);

/*** epv structures ***/

static PortableServer_ServantBase__epv impl_CORBA_IDLType_base_epv =
{
	NULL,			/* _private data */
	(gpointer) & impl_CORBA_IDLType__destroy,	/* finalize
							 * routine */
	NULL,			/* default_POA routine */
};
static POA_CORBA_IDLType__epv impl_CORBA_IDLType_epv =
{
	NULL,			/* _private */
	(gpointer) & impl_CORBA_IDLType__get_type,

};
static POA_CORBA_IRObject__epv impl_CORBA_IDLType_CORBA_IRObject_epv =
{
	NULL,			/* _private */
	(gpointer) & impl_CORBA_IDLType__get_def_kind,
	(gpointer) & impl_CORBA_IDLType_destroy,
};

static PortableServer_ServantBase__epv impl_CORBA_Repository_base_epv =
{
	NULL,			/* _private data */
	(gpointer) & impl_CORBA_Repository__destroy,	/* finalize
							 * routine */
	NULL,			/* default_POA routine */
};
static POA_CORBA_Repository__epv impl_CORBA_Repository_epv =
{
	NULL,			/* _private */
	(gpointer) & impl_CORBA_Repository_lookup_id,

	(gpointer) & impl_CORBA_Repository_get_primitive,

	(gpointer) & impl_CORBA_Repository_create_string,

	(gpointer) & impl_CORBA_Repository_create_wstring,

	(gpointer) & impl_CORBA_Repository_create_sequence,

	(gpointer) & impl_CORBA_Repository_create_array,

	(gpointer) & impl_CORBA_Repository_create_fixed,

};
static POA_CORBA_IRObject__epv impl_CORBA_Repository_CORBA_IRObject_epv =
{
	NULL,			/* _private */
	(gpointer) & impl_CORBA_Repository__get_def_kind,
	(gpointer) & impl_CORBA_Repository_destroy,
};
static POA_CORBA_Container__epv impl_CORBA_Repository_CORBA_Container_epv =
{
	NULL,			/* _private */
	(gpointer) & impl_CORBA_Repository_lookup,
	(gpointer) & impl_CORBA_Repository_contents,
	(gpointer) & impl_CORBA_Repository_lookup_name,
	(gpointer) & impl_CORBA_Repository_describe_contents,
	(gpointer) & impl_CORBA_Repository_create_module,
	(gpointer) & impl_CORBA_Repository_create_constant,
	(gpointer) & impl_CORBA_Repository_create_struct,
	(gpointer) & impl_CORBA_Repository_create_union,
	(gpointer) & impl_CORBA_Repository_create_enum,
	(gpointer) & impl_CORBA_Repository_create_alias,
	(gpointer) & impl_CORBA_Repository_create_interface,
	(gpointer) & impl_CORBA_Repository_create_exception,
};
static PortableServer_ServantBase__epv impl_CORBA_ModuleDef_base_epv =
{
	NULL,			/* _private data */
	(gpointer) & impl_CORBA_ModuleDef__destroy,	/* finalize
							 * routine */
	NULL,			/* default_POA routine */
};
static POA_CORBA_ModuleDef__epv impl_CORBA_ModuleDef_epv =
{
	NULL,			/* _private */
};
static POA_CORBA_IRObject__epv impl_CORBA_ModuleDef_CORBA_IRObject_epv =
{
	NULL,			/* _private */
	(gpointer) & impl_CORBA_ModuleDef__get_def_kind,
	(gpointer) & impl_CORBA_ModuleDef_destroy,
};
static POA_CORBA_Container__epv impl_CORBA_ModuleDef_CORBA_Container_epv =
{
	NULL,			/* _private */
	(gpointer) & impl_CORBA_ModuleDef_lookup,
	(gpointer) & impl_CORBA_ModuleDef_contents,
	(gpointer) & impl_CORBA_ModuleDef_lookup_name,
	(gpointer) & impl_CORBA_ModuleDef_describe_contents,
	(gpointer) & impl_CORBA_ModuleDef_create_module,
	(gpointer) & impl_CORBA_ModuleDef_create_constant,
	(gpointer) & impl_CORBA_ModuleDef_create_struct,
	(gpointer) & impl_CORBA_ModuleDef_create_union,
	(gpointer) & impl_CORBA_ModuleDef_create_enum,
	(gpointer) & impl_CORBA_ModuleDef_create_alias,
	(gpointer) & impl_CORBA_ModuleDef_create_interface,
	(gpointer) & impl_CORBA_ModuleDef_create_exception,
};
static POA_CORBA_Contained__epv impl_CORBA_ModuleDef_CORBA_Contained_epv =
{
	NULL,			/* _private */
	(gpointer) & impl_CORBA_ModuleDef__get_id,
	(gpointer) & impl_CORBA_ModuleDef__set_id,
	(gpointer) & impl_CORBA_ModuleDef__get_name,
	(gpointer) & impl_CORBA_ModuleDef__set_name,
	(gpointer) & impl_CORBA_ModuleDef__get_version,
	(gpointer) & impl_CORBA_ModuleDef__set_version,
	(gpointer) & impl_CORBA_ModuleDef__get_defined_in,
	(gpointer) & impl_CORBA_ModuleDef__get_absolute_name,
	(gpointer) & impl_CORBA_ModuleDef__get_containing_repository,
	(gpointer) & impl_CORBA_ModuleDef_describe,
	(gpointer) & impl_CORBA_ModuleDef_move,
};

static PortableServer_ServantBase__epv impl_CORBA_ConstantDef_base_epv =
{
	NULL,			/* _private data */
	(gpointer) & impl_CORBA_ConstantDef__destroy,	/* finalize
							 * routine */
	NULL,			/* default_POA routine */
};
static POA_CORBA_ConstantDef__epv impl_CORBA_ConstantDef_epv =
{
	NULL,			/* _private */
	(gpointer) & impl_CORBA_ConstantDef__get_type,

	(gpointer) & impl_CORBA_ConstantDef__get_type_def,
	(gpointer) & impl_CORBA_ConstantDef__set_type_def,

	(gpointer) & impl_CORBA_ConstantDef__get_value,
	(gpointer) & impl_CORBA_ConstantDef__set_value,

};
static POA_CORBA_IRObject__epv impl_CORBA_ConstantDef_CORBA_IRObject_epv =
{
	NULL,			/* _private */
	(gpointer) & impl_CORBA_ConstantDef__get_def_kind,
	(gpointer) & impl_CORBA_ConstantDef_destroy,
};
static POA_CORBA_Contained__epv impl_CORBA_ConstantDef_CORBA_Contained_epv =
{
	NULL,			/* _private */
	(gpointer) & impl_CORBA_ConstantDef__get_id,
	(gpointer) & impl_CORBA_ConstantDef__set_id,
	(gpointer) & impl_CORBA_ConstantDef__get_name,
	(gpointer) & impl_CORBA_ConstantDef__set_name,
	(gpointer) & impl_CORBA_ConstantDef__get_version,
	(gpointer) & impl_CORBA_ConstantDef__set_version,
	(gpointer) & impl_CORBA_ConstantDef__get_defined_in,
	(gpointer) & impl_CORBA_ConstantDef__get_absolute_name,
	(gpointer) & impl_CORBA_ConstantDef__get_containing_repository,
	(gpointer) & impl_CORBA_ConstantDef_describe,
	(gpointer) & impl_CORBA_ConstantDef_move,
};

static PortableServer_ServantBase__epv impl_CORBA_TypedefDef_base_epv =
{
	NULL,			/* _private data */
	(gpointer) & impl_CORBA_TypedefDef__destroy,	/* finalize
							 * routine */
	NULL,			/* default_POA routine */
};
static POA_CORBA_TypedefDef__epv impl_CORBA_TypedefDef_epv =
{
	NULL,			/* _private */
};
static POA_CORBA_IRObject__epv impl_CORBA_TypedefDef_CORBA_IRObject_epv =
{
	NULL,			/* _private */
	(gpointer) & impl_CORBA_TypedefDef__get_def_kind,
	(gpointer) & impl_CORBA_TypedefDef_destroy,
};
static POA_CORBA_Contained__epv impl_CORBA_TypedefDef_CORBA_Contained_epv =
{
	NULL,			/* _private */
	(gpointer) & impl_CORBA_TypedefDef__get_id,
	(gpointer) & impl_CORBA_TypedefDef__set_id,
	(gpointer) & impl_CORBA_TypedefDef__get_name,
	(gpointer) & impl_CORBA_TypedefDef__set_name,
	(gpointer) & impl_CORBA_TypedefDef__get_version,
	(gpointer) & impl_CORBA_TypedefDef__set_version,
	(gpointer) & impl_CORBA_TypedefDef__get_defined_in,
	(gpointer) & impl_CORBA_TypedefDef__get_absolute_name,
	(gpointer) & impl_CORBA_TypedefDef__get_containing_repository,
	(gpointer) & impl_CORBA_TypedefDef_describe,
	(gpointer) & impl_CORBA_TypedefDef_move,
};
static POA_CORBA_IDLType__epv impl_CORBA_TypedefDef_CORBA_IDLType_epv =
{
	NULL,			/* _private */
	(gpointer) & impl_CORBA_TypedefDef__get_type,
};

static PortableServer_ServantBase__epv impl_CORBA_StructDef_base_epv =
{
	NULL,			/* _private data */
	(gpointer) & impl_CORBA_StructDef__destroy,	/* finalize
							 * routine */
	NULL,			/* default_POA routine */
};
static POA_CORBA_StructDef__epv impl_CORBA_StructDef_epv =
{
	NULL,			/* _private */
	(gpointer) & impl_CORBA_StructDef__get_members,
	(gpointer) & impl_CORBA_StructDef__set_members,

};
static POA_CORBA_IRObject__epv impl_CORBA_StructDef_CORBA_IRObject_epv =
{
	NULL,			/* _private */
	(gpointer) & impl_CORBA_StructDef__get_def_kind,
	(gpointer) & impl_CORBA_StructDef_destroy,
};
static POA_CORBA_Contained__epv impl_CORBA_StructDef_CORBA_Contained_epv =
{
	NULL,			/* _private */
	(gpointer) & impl_CORBA_StructDef__get_id,
	(gpointer) & impl_CORBA_StructDef__set_id,
	(gpointer) & impl_CORBA_StructDef__get_name,
	(gpointer) & impl_CORBA_StructDef__set_name,
	(gpointer) & impl_CORBA_StructDef__get_version,
	(gpointer) & impl_CORBA_StructDef__set_version,
	(gpointer) & impl_CORBA_StructDef__get_defined_in,
	(gpointer) & impl_CORBA_StructDef__get_absolute_name,
	(gpointer) & impl_CORBA_StructDef__get_containing_repository,
	(gpointer) & impl_CORBA_StructDef_describe,
	(gpointer) & impl_CORBA_StructDef_move,
};
static POA_CORBA_IDLType__epv impl_CORBA_StructDef_CORBA_IDLType_epv =
{
	NULL,			/* _private */
	(gpointer) & impl_CORBA_StructDef__get_type,
};
static POA_CORBA_TypedefDef__epv impl_CORBA_StructDef_CORBA_TypedefDef_epv =
{
	NULL,			/* _private */
};
static POA_CORBA_Container__epv impl_CORBA_StructDef_CORBA_Container_epv =
{
	NULL,			/* _private */
	(gpointer) & impl_CORBA_StructDef_lookup,
	(gpointer) & impl_CORBA_StructDef_contents,
	(gpointer) & impl_CORBA_StructDef_lookup_name,
	(gpointer) & impl_CORBA_StructDef_describe_contents,
	(gpointer) & impl_CORBA_StructDef_create_module,
	(gpointer) & impl_CORBA_StructDef_create_constant,
	(gpointer) & impl_CORBA_StructDef_create_struct,
	(gpointer) & impl_CORBA_StructDef_create_union,
	(gpointer) & impl_CORBA_StructDef_create_enum,
	(gpointer) & impl_CORBA_StructDef_create_alias,
	(gpointer) & impl_CORBA_StructDef_create_interface,
	(gpointer) & impl_CORBA_StructDef_create_exception,
};
static PortableServer_ServantBase__epv impl_CORBA_UnionDef_base_epv =
{
	NULL,			/* _private data */
	(gpointer) & impl_CORBA_UnionDef__destroy,	/* finalize
							 * routine */
	NULL,			/* default_POA routine */
};
static POA_CORBA_UnionDef__epv impl_CORBA_UnionDef_epv =
{
	NULL,			/* _private */
	(gpointer) & impl_CORBA_UnionDef__get_discriminator_type,

	(gpointer) & impl_CORBA_UnionDef__get_discriminator_type_def,
	(gpointer) & impl_CORBA_UnionDef__set_discriminator_type_def,

	(gpointer) & impl_CORBA_UnionDef__get_members,
	(gpointer) & impl_CORBA_UnionDef__set_members,

};
static POA_CORBA_IRObject__epv impl_CORBA_UnionDef_CORBA_IRObject_epv =
{
	NULL,			/* _private */
	(gpointer) & impl_CORBA_UnionDef__get_def_kind,
	(gpointer) & impl_CORBA_UnionDef_destroy,
};
static POA_CORBA_Contained__epv impl_CORBA_UnionDef_CORBA_Contained_epv =
{
	NULL,			/* _private */
	(gpointer) & impl_CORBA_UnionDef__get_id,
	(gpointer) & impl_CORBA_UnionDef__set_id,
	(gpointer) & impl_CORBA_UnionDef__get_name,
	(gpointer) & impl_CORBA_UnionDef__set_name,
	(gpointer) & impl_CORBA_UnionDef__get_version,
	(gpointer) & impl_CORBA_UnionDef__set_version,
	(gpointer) & impl_CORBA_UnionDef__get_defined_in,
	(gpointer) & impl_CORBA_UnionDef__get_absolute_name,
	(gpointer) & impl_CORBA_UnionDef__get_containing_repository,
	(gpointer) & impl_CORBA_UnionDef_describe,
	(gpointer) & impl_CORBA_UnionDef_move,
};
static POA_CORBA_IDLType__epv impl_CORBA_UnionDef_CORBA_IDLType_epv =
{
	NULL,			/* _private */
	(gpointer) & impl_CORBA_UnionDef__get_type,
};
static POA_CORBA_TypedefDef__epv impl_CORBA_UnionDef_CORBA_TypedefDef_epv =
{
	NULL,			/* _private */
};
static POA_CORBA_Container__epv impl_CORBA_UnionDef_CORBA_Container_epv =
{
	NULL,			/* _private */
	(gpointer) & impl_CORBA_UnionDef_lookup,
	(gpointer) & impl_CORBA_UnionDef_contents,
	(gpointer) & impl_CORBA_UnionDef_lookup_name,
	(gpointer) & impl_CORBA_UnionDef_describe_contents,
	(gpointer) & impl_CORBA_UnionDef_create_module,
	(gpointer) & impl_CORBA_UnionDef_create_constant,
	(gpointer) & impl_CORBA_UnionDef_create_struct,
	(gpointer) & impl_CORBA_UnionDef_create_union,
	(gpointer) & impl_CORBA_UnionDef_create_enum,
	(gpointer) & impl_CORBA_UnionDef_create_alias,
	(gpointer) & impl_CORBA_UnionDef_create_interface,
	(gpointer) & impl_CORBA_UnionDef_create_exception,
};
static PortableServer_ServantBase__epv impl_CORBA_EnumDef_base_epv =
{
	NULL,			/* _private data */
	(gpointer) & impl_CORBA_EnumDef__destroy,	/* finalize
							 * routine */
	NULL,			/* default_POA routine */
};
static POA_CORBA_EnumDef__epv impl_CORBA_EnumDef_epv =
{
	NULL,			/* _private */
	(gpointer) & impl_CORBA_EnumDef__get_members,
	(gpointer) & impl_CORBA_EnumDef__set_members,

};
static POA_CORBA_IRObject__epv impl_CORBA_EnumDef_CORBA_IRObject_epv =
{
	NULL,			/* _private */
	(gpointer) & impl_CORBA_EnumDef__get_def_kind,
	(gpointer) & impl_CORBA_EnumDef_destroy,
};
static POA_CORBA_Contained__epv impl_CORBA_EnumDef_CORBA_Contained_epv =
{
	NULL,			/* _private */
	(gpointer) & impl_CORBA_EnumDef__get_id,
	(gpointer) & impl_CORBA_EnumDef__set_id,
	(gpointer) & impl_CORBA_EnumDef__get_name,
	(gpointer) & impl_CORBA_EnumDef__set_name,
	(gpointer) & impl_CORBA_EnumDef__get_version,
	(gpointer) & impl_CORBA_EnumDef__set_version,
	(gpointer) & impl_CORBA_EnumDef__get_defined_in,
	(gpointer) & impl_CORBA_EnumDef__get_absolute_name,
	(gpointer) & impl_CORBA_EnumDef__get_containing_repository,
	(gpointer) & impl_CORBA_EnumDef_describe,
	(gpointer) & impl_CORBA_EnumDef_move,
};
static POA_CORBA_IDLType__epv impl_CORBA_EnumDef_CORBA_IDLType_epv =
{
	NULL,			/* _private */
	(gpointer) & impl_CORBA_EnumDef__get_type,
};
static POA_CORBA_TypedefDef__epv impl_CORBA_EnumDef_CORBA_TypedefDef_epv =
{
	NULL,			/* _private */
};
static PortableServer_ServantBase__epv impl_CORBA_AliasDef_base_epv =
{
	NULL,			/* _private data */
	(gpointer) & impl_CORBA_AliasDef__destroy,	/* finalize
							 * routine */
	NULL,			/* default_POA routine */
};
static POA_CORBA_AliasDef__epv impl_CORBA_AliasDef_epv =
{
	NULL,			/* _private */
	(gpointer) & impl_CORBA_AliasDef__get_original_type_def,
	(gpointer) & impl_CORBA_AliasDef__set_original_type_def,

};
static POA_CORBA_IRObject__epv impl_CORBA_AliasDef_CORBA_IRObject_epv =
{
	NULL,			/* _private */
	(gpointer) & impl_CORBA_AliasDef__get_def_kind,
	(gpointer) & impl_CORBA_AliasDef_destroy,
};
static POA_CORBA_Contained__epv impl_CORBA_AliasDef_CORBA_Contained_epv =
{
	NULL,			/* _private */
	(gpointer) & impl_CORBA_AliasDef__get_id,
	(gpointer) & impl_CORBA_AliasDef__set_id,
	(gpointer) & impl_CORBA_AliasDef__get_name,
	(gpointer) & impl_CORBA_AliasDef__set_name,
	(gpointer) & impl_CORBA_AliasDef__get_version,
	(gpointer) & impl_CORBA_AliasDef__set_version,
	(gpointer) & impl_CORBA_AliasDef__get_defined_in,
	(gpointer) & impl_CORBA_AliasDef__get_absolute_name,
	(gpointer) & impl_CORBA_AliasDef__get_containing_repository,
	(gpointer) & impl_CORBA_AliasDef_describe,
	(gpointer) & impl_CORBA_AliasDef_move,
};
static POA_CORBA_IDLType__epv impl_CORBA_AliasDef_CORBA_IDLType_epv =
{
	NULL,			/* _private */
	(gpointer) & impl_CORBA_AliasDef__get_type,
};
static POA_CORBA_TypedefDef__epv impl_CORBA_AliasDef_CORBA_TypedefDef_epv =
{
	NULL,			/* _private */
};
static PortableServer_ServantBase__epv impl_CORBA_PrimitiveDef_base_epv =
{
	NULL,			/* _private data */
	(gpointer) & impl_CORBA_PrimitiveDef__destroy,	/* finalize
							 * routine */
	NULL,			/* default_POA routine */
};
static POA_CORBA_PrimitiveDef__epv impl_CORBA_PrimitiveDef_epv =
{
	NULL,			/* _private */
	(gpointer) & impl_CORBA_PrimitiveDef__get_kind,

};
static POA_CORBA_IRObject__epv impl_CORBA_PrimitiveDef_CORBA_IRObject_epv =
{
	NULL,			/* _private */
	(gpointer) & impl_CORBA_PrimitiveDef__get_def_kind,
	(gpointer) & impl_CORBA_PrimitiveDef_destroy,
};
static POA_CORBA_IDLType__epv impl_CORBA_PrimitiveDef_CORBA_IDLType_epv =
{
	NULL,			/* _private */
	(gpointer) & impl_CORBA_PrimitiveDef__get_type,
};
static PortableServer_ServantBase__epv impl_CORBA_StringDef_base_epv =
{
	NULL,			/* _private data */
	(gpointer) & impl_CORBA_StringDef__destroy,	/* finalize
							 * routine */
	NULL,			/* default_POA routine */
};
static POA_CORBA_StringDef__epv impl_CORBA_StringDef_epv =
{
	NULL,			/* _private */
	(gpointer) & impl_CORBA_StringDef__get_bound,
	(gpointer) & impl_CORBA_StringDef__set_bound,

};
static POA_CORBA_IRObject__epv impl_CORBA_StringDef_CORBA_IRObject_epv =
{
	NULL,			/* _private */
	(gpointer) & impl_CORBA_StringDef__get_def_kind,
	(gpointer) & impl_CORBA_StringDef_destroy,
};
static POA_CORBA_IDLType__epv impl_CORBA_StringDef_CORBA_IDLType_epv =
{
	NULL,			/* _private */
	(gpointer) & impl_CORBA_StringDef__get_type,
};
static PortableServer_ServantBase__epv impl_CORBA_WstringDef_base_epv =
{
	NULL,			/* _private data */
	(gpointer) & impl_CORBA_WstringDef__destroy,	/* finalize
							 * routine */
	NULL,			/* default_POA routine */
};
static POA_CORBA_WstringDef__epv impl_CORBA_WstringDef_epv =
{
	NULL,			/* _private */
	(gpointer) & impl_CORBA_WstringDef__get_bound,
	(gpointer) & impl_CORBA_WstringDef__set_bound,

};
static POA_CORBA_IRObject__epv impl_CORBA_WstringDef_CORBA_IRObject_epv =
{
	NULL,			/* _private */
	(gpointer) & impl_CORBA_WstringDef__get_def_kind,
	(gpointer) & impl_CORBA_WstringDef_destroy,
};
static POA_CORBA_IDLType__epv impl_CORBA_WstringDef_CORBA_IDLType_epv =
{
	NULL,			/* _private */
	(gpointer) & impl_CORBA_WstringDef__get_type,
};
static PortableServer_ServantBase__epv impl_CORBA_FixedDef_base_epv =
{
	NULL,			/* _private data */
	(gpointer) & impl_CORBA_FixedDef__destroy,	/* finalize
							 * routine */
	NULL,			/* default_POA routine */
};
static POA_CORBA_FixedDef__epv impl_CORBA_FixedDef_epv =
{
	NULL,			/* _private */
	(gpointer) & impl_CORBA_FixedDef__get_digits,
	(gpointer) & impl_CORBA_FixedDef__set_digits,

	(gpointer) & impl_CORBA_FixedDef__get_scale,
	(gpointer) & impl_CORBA_FixedDef__set_scale,

};
static POA_CORBA_IRObject__epv impl_CORBA_FixedDef_CORBA_IRObject_epv =
{
	NULL,			/* _private */
	(gpointer) & impl_CORBA_FixedDef__get_def_kind,
	(gpointer) & impl_CORBA_FixedDef_destroy,
};
static POA_CORBA_IDLType__epv impl_CORBA_FixedDef_CORBA_IDLType_epv =
{
	NULL,			/* _private */
	(gpointer) & impl_CORBA_FixedDef__get_type,
};
static PortableServer_ServantBase__epv impl_CORBA_SequenceDef_base_epv =
{
	NULL,			/* _private data */
	(gpointer) & impl_CORBA_SequenceDef__destroy,	/* finalize
							 * routine */
	NULL,			/* default_POA routine */
};
static POA_CORBA_SequenceDef__epv impl_CORBA_SequenceDef_epv =
{
	NULL,			/* _private */
	(gpointer) & impl_CORBA_SequenceDef__get_bound,
	(gpointer) & impl_CORBA_SequenceDef__set_bound,

	(gpointer) & impl_CORBA_SequenceDef__get_element_type,

	(gpointer) & impl_CORBA_SequenceDef__get_element_type_def,
	(gpointer) & impl_CORBA_SequenceDef__set_element_type_def,

};
static POA_CORBA_IRObject__epv impl_CORBA_SequenceDef_CORBA_IRObject_epv =
{
	NULL,			/* _private */
	(gpointer) & impl_CORBA_SequenceDef__get_def_kind,
	(gpointer) & impl_CORBA_SequenceDef_destroy,
};
static POA_CORBA_IDLType__epv impl_CORBA_SequenceDef_CORBA_IDLType_epv =
{
	NULL,			/* _private */
	(gpointer) & impl_CORBA_SequenceDef__get_type,
};
static PortableServer_ServantBase__epv impl_CORBA_ArrayDef_base_epv =
{
	NULL,			/* _private data */
	(gpointer) & impl_CORBA_ArrayDef__destroy,	/* finalize
							 * routine */
	NULL,			/* default_POA routine */
};
static POA_CORBA_ArrayDef__epv impl_CORBA_ArrayDef_epv =
{
	NULL,			/* _private */
	(gpointer) & impl_CORBA_ArrayDef__get_length,
	(gpointer) & impl_CORBA_ArrayDef__set_length,

	(gpointer) & impl_CORBA_ArrayDef__get_element_type,

	(gpointer) & impl_CORBA_ArrayDef__get_element_type_def,
	(gpointer) & impl_CORBA_ArrayDef__set_element_type_def,

};
static POA_CORBA_IRObject__epv impl_CORBA_ArrayDef_CORBA_IRObject_epv =
{
	NULL,			/* _private */
	(gpointer) & impl_CORBA_ArrayDef__get_def_kind,
	(gpointer) & impl_CORBA_ArrayDef_destroy,
};
static POA_CORBA_IDLType__epv impl_CORBA_ArrayDef_CORBA_IDLType_epv =
{
	NULL,			/* _private */
	(gpointer) & impl_CORBA_ArrayDef__get_type,
};
static PortableServer_ServantBase__epv impl_CORBA_ExceptionDef_base_epv =
{
	NULL,			/* _private data */
	(gpointer) & impl_CORBA_ExceptionDef__destroy,	/* finalize
							 * routine */
	NULL,			/* default_POA routine */
};
static POA_CORBA_ExceptionDef__epv impl_CORBA_ExceptionDef_epv =
{
	NULL,			/* _private */
	(gpointer) & impl_CORBA_ExceptionDef__get_type,

	(gpointer) & impl_CORBA_ExceptionDef__get_members,
	(gpointer) & impl_CORBA_ExceptionDef__set_members,

};
static POA_CORBA_IRObject__epv impl_CORBA_ExceptionDef_CORBA_IRObject_epv =
{
	NULL,			/* _private */
	(gpointer) & impl_CORBA_ExceptionDef__get_def_kind,
	(gpointer) & impl_CORBA_ExceptionDef_destroy,
};
static POA_CORBA_Contained__epv impl_CORBA_ExceptionDef_CORBA_Contained_epv =
{
	NULL,			/* _private */
	(gpointer) & impl_CORBA_ExceptionDef__get_id,
	(gpointer) & impl_CORBA_ExceptionDef__set_id,
	(gpointer) & impl_CORBA_ExceptionDef__get_name,
	(gpointer) & impl_CORBA_ExceptionDef__set_name,
	(gpointer) & impl_CORBA_ExceptionDef__get_version,
	(gpointer) & impl_CORBA_ExceptionDef__set_version,
	(gpointer) & impl_CORBA_ExceptionDef__get_defined_in,
	(gpointer) & impl_CORBA_ExceptionDef__get_absolute_name,
	(gpointer) & impl_CORBA_ExceptionDef__get_containing_repository,
	(gpointer) & impl_CORBA_ExceptionDef_describe,
	(gpointer) & impl_CORBA_ExceptionDef_move,
};
static POA_CORBA_Container__epv impl_CORBA_ExceptionDef_CORBA_Container_epv =
{
	NULL,			/* _private */
	(gpointer) & impl_CORBA_ExceptionDef_lookup,
	(gpointer) & impl_CORBA_ExceptionDef_contents,
	(gpointer) & impl_CORBA_ExceptionDef_lookup_name,
	(gpointer) & impl_CORBA_ExceptionDef_describe_contents,
	(gpointer) & impl_CORBA_ExceptionDef_create_module,
	(gpointer) & impl_CORBA_ExceptionDef_create_constant,
	(gpointer) & impl_CORBA_ExceptionDef_create_struct,
	(gpointer) & impl_CORBA_ExceptionDef_create_union,
	(gpointer) & impl_CORBA_ExceptionDef_create_enum,
	(gpointer) & impl_CORBA_ExceptionDef_create_alias,
	(gpointer) & impl_CORBA_ExceptionDef_create_interface,
	(gpointer) & impl_CORBA_ExceptionDef_create_exception,
};

static PortableServer_ServantBase__epv impl_CORBA_AttributeDef_base_epv =
{
	NULL,			/* _private data */
	(gpointer) & impl_CORBA_AttributeDef__destroy,	/* finalize
							 * routine */
	NULL,			/* default_POA routine */
};
static POA_CORBA_AttributeDef__epv impl_CORBA_AttributeDef_epv =
{
	NULL,			/* _private */
	(gpointer) & impl_CORBA_AttributeDef__get_type,

	(gpointer) & impl_CORBA_AttributeDef__get_type_def,
	(gpointer) & impl_CORBA_AttributeDef__set_type_def,

	(gpointer) & impl_CORBA_AttributeDef__get_mode,
	(gpointer) & impl_CORBA_AttributeDef__set_mode,

};
static POA_CORBA_IRObject__epv impl_CORBA_AttributeDef_CORBA_IRObject_epv =
{
	NULL,			/* _private */
	(gpointer) & impl_CORBA_AttributeDef__get_def_kind,
	(gpointer) & impl_CORBA_AttributeDef_destroy,
};
static POA_CORBA_Contained__epv impl_CORBA_AttributeDef_CORBA_Contained_epv =
{
	NULL,			/* _private */
	(gpointer) & impl_CORBA_AttributeDef__get_id,
	(gpointer) & impl_CORBA_AttributeDef__set_id,
	(gpointer) & impl_CORBA_AttributeDef__get_name,
	(gpointer) & impl_CORBA_AttributeDef__set_name,
	(gpointer) & impl_CORBA_AttributeDef__get_version,
	(gpointer) & impl_CORBA_AttributeDef__set_version,
	(gpointer) & impl_CORBA_AttributeDef__get_defined_in,
	(gpointer) & impl_CORBA_AttributeDef__get_absolute_name,
	(gpointer) & impl_CORBA_AttributeDef__get_containing_repository,
	(gpointer) & impl_CORBA_AttributeDef_describe,
	(gpointer) & impl_CORBA_AttributeDef_move,
};

static PortableServer_ServantBase__epv impl_CORBA_OperationDef_base_epv =
{
	NULL,			/* _private data */
	(gpointer) & impl_CORBA_OperationDef__destroy,	/* finalize
							 * routine */
	NULL,			/* default_POA routine */
};
static POA_CORBA_OperationDef__epv impl_CORBA_OperationDef_epv =
{
	NULL,			/* _private */
	(gpointer) & impl_CORBA_OperationDef__get_result,

	(gpointer) & impl_CORBA_OperationDef__get_result_def,
	(gpointer) & impl_CORBA_OperationDef__set_result_def,

	(gpointer) & impl_CORBA_OperationDef__get_params,
	(gpointer) & impl_CORBA_OperationDef__set_params,

	(gpointer) & impl_CORBA_OperationDef__get_mode,
	(gpointer) & impl_CORBA_OperationDef__set_mode,

	(gpointer) & impl_CORBA_OperationDef__get_contexts,
	(gpointer) & impl_CORBA_OperationDef__set_contexts,

	(gpointer) & impl_CORBA_OperationDef__get_exceptions,
	(gpointer) & impl_CORBA_OperationDef__set_exceptions,

};
static POA_CORBA_IRObject__epv impl_CORBA_OperationDef_CORBA_IRObject_epv =
{
	NULL,			/* _private */
	(gpointer) & impl_CORBA_OperationDef__get_def_kind,
	(gpointer) & impl_CORBA_OperationDef_destroy,
};
static POA_CORBA_Contained__epv impl_CORBA_OperationDef_CORBA_Contained_epv =
{
	NULL,			/* _private */
	(gpointer) & impl_CORBA_OperationDef__get_id,
	(gpointer) & impl_CORBA_OperationDef__set_id,
	(gpointer) & impl_CORBA_OperationDef__get_name,
	(gpointer) & impl_CORBA_OperationDef__set_name,
	(gpointer) & impl_CORBA_OperationDef__get_version,
	(gpointer) & impl_CORBA_OperationDef__set_version,
	(gpointer) & impl_CORBA_OperationDef__get_defined_in,
	(gpointer) & impl_CORBA_OperationDef__get_absolute_name,
	(gpointer) & impl_CORBA_OperationDef__get_containing_repository,
	(gpointer) & impl_CORBA_OperationDef_describe,
	(gpointer) & impl_CORBA_OperationDef_move,
};

static PortableServer_ServantBase__epv impl_CORBA_InterfaceDef_base_epv =
{
	NULL,			/* _private data */
	(gpointer) & impl_CORBA_InterfaceDef__destroy,	/* finalize
							 * routine */
	NULL,			/* default_POA routine */
};
static POA_CORBA_InterfaceDef__epv impl_CORBA_InterfaceDef_epv =
{
	NULL,			/* _private */
	(gpointer) & impl_CORBA_InterfaceDef__get_base_interfaces,
	(gpointer) & impl_CORBA_InterfaceDef__set_base_interfaces,

	(gpointer) & impl_CORBA_InterfaceDef_is_a,

	(gpointer) & impl_CORBA_InterfaceDef_describe_interface,

	(gpointer) & impl_CORBA_InterfaceDef_create_attribute,

	(gpointer) & impl_CORBA_InterfaceDef_create_operation,

};
static POA_CORBA_IRObject__epv impl_CORBA_InterfaceDef_CORBA_IRObject_epv =
{
	NULL,			/* _private */
	(gpointer) & impl_CORBA_InterfaceDef__get_def_kind,
	(gpointer) & impl_CORBA_InterfaceDef_destroy,
};
static POA_CORBA_Container__epv impl_CORBA_InterfaceDef_CORBA_Container_epv =
{
	NULL,			/* _private */
	(gpointer) & impl_CORBA_InterfaceDef_lookup,
	(gpointer) & impl_CORBA_InterfaceDef_contents,
	(gpointer) & impl_CORBA_InterfaceDef_lookup_name,
	(gpointer) & impl_CORBA_InterfaceDef_describe_contents,
	(gpointer) & impl_CORBA_InterfaceDef_create_module,
	(gpointer) & impl_CORBA_InterfaceDef_create_constant,
	(gpointer) & impl_CORBA_InterfaceDef_create_struct,
	(gpointer) & impl_CORBA_InterfaceDef_create_union,
	(gpointer) & impl_CORBA_InterfaceDef_create_enum,
	(gpointer) & impl_CORBA_InterfaceDef_create_alias,
	(gpointer) & impl_CORBA_InterfaceDef_create_interface,
	(gpointer) & impl_CORBA_InterfaceDef_create_exception,
};
static POA_CORBA_Contained__epv impl_CORBA_InterfaceDef_CORBA_Contained_epv =
{
	NULL,			/* _private */
	(gpointer) & impl_CORBA_InterfaceDef__get_id,
	(gpointer) & impl_CORBA_InterfaceDef__set_id,
	(gpointer) & impl_CORBA_InterfaceDef__get_name,
	(gpointer) & impl_CORBA_InterfaceDef__set_name,
	(gpointer) & impl_CORBA_InterfaceDef__get_version,
	(gpointer) & impl_CORBA_InterfaceDef__set_version,
	(gpointer) & impl_CORBA_InterfaceDef__get_defined_in,
	(gpointer) & impl_CORBA_InterfaceDef__get_absolute_name,
	(gpointer) & impl_CORBA_InterfaceDef__get_containing_repository,
	(gpointer) & impl_CORBA_InterfaceDef_describe,
	(gpointer) & impl_CORBA_InterfaceDef_move,
};
static POA_CORBA_IDLType__epv impl_CORBA_InterfaceDef_CORBA_IDLType_epv =
{
	NULL,			/* _private */
	(gpointer) & impl_CORBA_InterfaceDef__get_type,
};

/*** vepv structures ***/

static POA_CORBA_IDLType__vepv impl_CORBA_IDLType_vepv =
{
	&impl_CORBA_IDLType_base_epv,
	&impl_CORBA_IDLType_CORBA_IRObject_epv,
	&impl_CORBA_IDLType_epv,
};

static POA_CORBA_Repository__vepv impl_CORBA_Repository_vepv =
{
	&impl_CORBA_Repository_base_epv,
	&impl_CORBA_Repository_CORBA_IRObject_epv,
	&impl_CORBA_Repository_CORBA_Container_epv,
	&impl_CORBA_Repository_epv,
};
static POA_CORBA_ModuleDef__vepv impl_CORBA_ModuleDef_vepv =
{
	&impl_CORBA_ModuleDef_base_epv,
	&impl_CORBA_ModuleDef_CORBA_IRObject_epv,
	&impl_CORBA_ModuleDef_CORBA_Container_epv,
	&impl_CORBA_ModuleDef_CORBA_Contained_epv,
	&impl_CORBA_ModuleDef_epv,
};

static POA_CORBA_ConstantDef__vepv impl_CORBA_ConstantDef_vepv =
{
	&impl_CORBA_ConstantDef_base_epv,
	&impl_CORBA_ConstantDef_CORBA_IRObject_epv,
	&impl_CORBA_ConstantDef_CORBA_Contained_epv,
	&impl_CORBA_ConstantDef_epv,
};

static POA_CORBA_TypedefDef__vepv impl_CORBA_TypedefDef_vepv =
{
	&impl_CORBA_TypedefDef_base_epv,
	&impl_CORBA_TypedefDef_CORBA_IRObject_epv,
	&impl_CORBA_TypedefDef_CORBA_Contained_epv,
	&impl_CORBA_TypedefDef_CORBA_IDLType_epv,
	&impl_CORBA_TypedefDef_epv,
};

static POA_CORBA_StructDef__vepv impl_CORBA_StructDef_vepv =
{
	&impl_CORBA_StructDef_base_epv,
	&impl_CORBA_StructDef_CORBA_IRObject_epv,
	&impl_CORBA_StructDef_CORBA_Contained_epv,
	&impl_CORBA_StructDef_CORBA_IDLType_epv,
	&impl_CORBA_StructDef_CORBA_TypedefDef_epv,
	&impl_CORBA_StructDef_CORBA_Container_epv,
	&impl_CORBA_StructDef_epv,
};
static POA_CORBA_UnionDef__vepv impl_CORBA_UnionDef_vepv =
{
	&impl_CORBA_UnionDef_base_epv,
	&impl_CORBA_UnionDef_CORBA_IRObject_epv,
	&impl_CORBA_UnionDef_CORBA_Contained_epv,
	&impl_CORBA_UnionDef_CORBA_IDLType_epv,
	&impl_CORBA_UnionDef_CORBA_TypedefDef_epv,
	&impl_CORBA_UnionDef_CORBA_Container_epv,
	&impl_CORBA_UnionDef_epv,
};
static POA_CORBA_EnumDef__vepv impl_CORBA_EnumDef_vepv =
{
	&impl_CORBA_EnumDef_base_epv,
	&impl_CORBA_EnumDef_CORBA_IRObject_epv,
	&impl_CORBA_EnumDef_CORBA_Contained_epv,
	&impl_CORBA_EnumDef_CORBA_IDLType_epv,
	&impl_CORBA_EnumDef_CORBA_TypedefDef_epv,
	&impl_CORBA_EnumDef_epv,
};
static POA_CORBA_AliasDef__vepv impl_CORBA_AliasDef_vepv =
{
	&impl_CORBA_AliasDef_base_epv,
	&impl_CORBA_AliasDef_CORBA_IRObject_epv,
	&impl_CORBA_AliasDef_CORBA_Contained_epv,
	&impl_CORBA_AliasDef_CORBA_IDLType_epv,
	&impl_CORBA_AliasDef_CORBA_TypedefDef_epv,
	&impl_CORBA_AliasDef_epv,
};
static POA_CORBA_PrimitiveDef__vepv impl_CORBA_PrimitiveDef_vepv =
{
	&impl_CORBA_PrimitiveDef_base_epv,
	&impl_CORBA_PrimitiveDef_CORBA_IRObject_epv,
	&impl_CORBA_PrimitiveDef_CORBA_IDLType_epv,
	&impl_CORBA_PrimitiveDef_epv,
};
static POA_CORBA_StringDef__vepv impl_CORBA_StringDef_vepv =
{
	&impl_CORBA_StringDef_base_epv,
	&impl_CORBA_StringDef_CORBA_IRObject_epv,
	&impl_CORBA_StringDef_CORBA_IDLType_epv,
	&impl_CORBA_StringDef_epv,
};
static POA_CORBA_WstringDef__vepv impl_CORBA_WstringDef_vepv =
{
	&impl_CORBA_WstringDef_base_epv,
	&impl_CORBA_WstringDef_CORBA_IRObject_epv,
	&impl_CORBA_WstringDef_CORBA_IDLType_epv,
	&impl_CORBA_WstringDef_epv,
};
static POA_CORBA_FixedDef__vepv impl_CORBA_FixedDef_vepv =
{
	&impl_CORBA_FixedDef_base_epv,
	&impl_CORBA_FixedDef_CORBA_IRObject_epv,
	&impl_CORBA_FixedDef_CORBA_IDLType_epv,
	&impl_CORBA_FixedDef_epv,
};
static POA_CORBA_SequenceDef__vepv impl_CORBA_SequenceDef_vepv =
{
	&impl_CORBA_SequenceDef_base_epv,
	&impl_CORBA_SequenceDef_CORBA_IRObject_epv,
	&impl_CORBA_SequenceDef_CORBA_IDLType_epv,
	&impl_CORBA_SequenceDef_epv,
};
static POA_CORBA_ArrayDef__vepv impl_CORBA_ArrayDef_vepv =
{
	&impl_CORBA_ArrayDef_base_epv,
	&impl_CORBA_ArrayDef_CORBA_IRObject_epv,
	&impl_CORBA_ArrayDef_CORBA_IDLType_epv,
	&impl_CORBA_ArrayDef_epv,
};
static POA_CORBA_ExceptionDef__vepv impl_CORBA_ExceptionDef_vepv =
{
	&impl_CORBA_ExceptionDef_base_epv,
	&impl_CORBA_ExceptionDef_CORBA_IRObject_epv,
	&impl_CORBA_ExceptionDef_CORBA_Contained_epv,
	&impl_CORBA_ExceptionDef_CORBA_Container_epv,
	&impl_CORBA_ExceptionDef_epv,
};

static POA_CORBA_AttributeDef__vepv impl_CORBA_AttributeDef_vepv =
{
	&impl_CORBA_AttributeDef_base_epv,
	&impl_CORBA_AttributeDef_CORBA_IRObject_epv,
	&impl_CORBA_AttributeDef_CORBA_Contained_epv,
	&impl_CORBA_AttributeDef_epv,
};

static POA_CORBA_OperationDef__vepv impl_CORBA_OperationDef_vepv =
{
	&impl_CORBA_OperationDef_base_epv,
	&impl_CORBA_OperationDef_CORBA_IRObject_epv,
	&impl_CORBA_OperationDef_CORBA_Contained_epv,
	&impl_CORBA_OperationDef_epv,
};

static POA_CORBA_InterfaceDef__vepv impl_CORBA_InterfaceDef_vepv =
{
	&impl_CORBA_InterfaceDef_base_epv,
	&impl_CORBA_InterfaceDef_CORBA_IRObject_epv,
	&impl_CORBA_InterfaceDef_CORBA_Container_epv,
	&impl_CORBA_InterfaceDef_CORBA_Contained_epv,
	&impl_CORBA_InterfaceDef_CORBA_IDLType_epv,
	&impl_CORBA_InterfaceDef_epv,
};

/*** Stub implementations ***/

static CORBA_ConstantDef impl_CORBA_ConstantDef__create(PortableServer_POA poa,
							CORBA_RepositoryId id,
							CORBA_Identifier name,
							CORBA_VersionSpec version,
							CORBA_IDLType type_def,
							CORBA_any *value,
							CORBA_Container defined_in,
							CORBA_Environment * ev);
static CORBA_StructDef impl_CORBA_StructDef__create(PortableServer_POA poa,
						    CORBA_RepositoryId id,
						    CORBA_Identifier name,
						    CORBA_VersionSpec version,
						    CORBA_StructMemberSeq * members,
						    CORBA_Container defined_in,
						    CORBA_Environment * ev);
static CORBA_UnionDef impl_CORBA_UnionDef__create(PortableServer_POA poa,
						  CORBA_RepositoryId id,
						  CORBA_Identifier name,
						  CORBA_VersionSpec version,
						  CORBA_IDLType discriminator_type,
						  CORBA_UnionMemberSeq * members,
						  CORBA_Container defined_in,
						  CORBA_Environment * ev);
static CORBA_EnumDef impl_CORBA_EnumDef__create(PortableServer_POA poa,
						CORBA_RepositoryId id,
						CORBA_Identifier name,
						CORBA_VersionSpec version,
						CORBA_EnumMemberSeq * members,
						CORBA_Container defined_in,
						CORBA_Environment * ev);
static CORBA_ModuleDef impl_CORBA_ModuleDef__create(PortableServer_POA poa,
						    CORBA_RepositoryId id,
						    CORBA_Identifier name,
						    CORBA_VersionSpec version,
						    CORBA_Container defined_in,
						    CORBA_Environment * ev);
static CORBA_InterfaceDef impl_CORBA_InterfaceDef__create(PortableServer_POA poa,
							  CORBA_RepositoryId id,
							  CORBA_Identifier name,
							  CORBA_VersionSpec version,
							  CORBA_InterfaceDefSeq *base_interfaces,
							  CORBA_Container defined_in,
							  CORBA_Environment * ev);
static CORBA_ExceptionDef impl_CORBA_ExceptionDef__create(PortableServer_POA poa,
							  CORBA_RepositoryId id,
							  CORBA_Identifier name,
							  CORBA_VersionSpec version,
							  CORBA_StructMemberSeq * members,
							  CORBA_Container defined_in,
							  CORBA_Environment * ev);
static CORBA_AttributeDef impl_CORBA_AttributeDef__create(PortableServer_POA poa,
							  CORBA_RepositoryId id,
							  CORBA_Identifier name,
							  CORBA_VersionSpec version,
							  CORBA_IDLType type,
							  CORBA_AttributeMode mode,
							  CORBA_Container defined_in,
							  CORBA_Environment * ev);
static CORBA_AliasDef impl_CORBA_AliasDef__create(PortableServer_POA poa, 
						  CORBA_RepositoryId id,
						  CORBA_Identifier name,
						  CORBA_VersionSpec version,
						  CORBA_IDLType original_type,
						  CORBA_Container defined_in,
						  CORBA_Environment * ev);

static CORBA_IDLType impl_CORBA_IDLType__create(PortableServer_POA poa,
						CORBA_TypeCode type,
						CORBA_Environment * ev)
{
	CORBA_IDLType retval;
	impl_POA_CORBA_IDLType *newservant;
	PortableServer_ObjectId *objid;

	newservant = g_new0(impl_POA_CORBA_IDLType, 1);
	newservant->servant.vepv = &impl_CORBA_IDLType_vepv;
	newservant->poa = poa;

	newservant->attr_type=type;
	newservant->attr_def_kind=CORBA_dk_none;

	POA_CORBA_IDLType__init((PortableServer_Servant) newservant, ev);
	objid = PortableServer_POA_activate_object(poa, newservant, ev);
	CORBA_free(objid);
	retval = PortableServer_POA_servant_to_reference(poa, newservant, ev);
	
	return retval;
}

/* You shouldn'y call this routine directly without first deactivating the servant... */
static void impl_CORBA_IDLType__destroy(impl_POA_CORBA_IDLType * servant, CORBA_Environment * ev)
{

	POA_CORBA_IDLType__fini((PortableServer_Servant) servant, ev);
	g_free(servant);
}

CORBA_TypeCode
impl_CORBA_IDLType__get_type(impl_POA_CORBA_IDLType * servant,
			     CORBA_Environment * ev)
{
	return(servant->attr_type);
}

CORBA_DefinitionKind
impl_CORBA_IDLType__get_def_kind(impl_POA_CORBA_IDLType * servant,
				 CORBA_Environment * ev)
{
	return(servant->attr_def_kind);
}

void impl_CORBA_IDLType_destroy(impl_POA_CORBA_IDLType * servant,
				CORBA_Environment * ev)
{
}

static CORBA_Repository repo=CORBA_OBJECT_NIL;
static CORBA_PrimitiveDef prim_null=CORBA_OBJECT_NIL;
static CORBA_PrimitiveDef prim_void=CORBA_OBJECT_NIL;
static CORBA_PrimitiveDef prim_short=CORBA_OBJECT_NIL;
static CORBA_PrimitiveDef prim_long=CORBA_OBJECT_NIL;
static CORBA_PrimitiveDef prim_ushort=CORBA_OBJECT_NIL;
static CORBA_PrimitiveDef prim_ulong=CORBA_OBJECT_NIL;
static CORBA_PrimitiveDef prim_float=CORBA_OBJECT_NIL;
static CORBA_PrimitiveDef prim_double=CORBA_OBJECT_NIL;
static CORBA_PrimitiveDef prim_boolean=CORBA_OBJECT_NIL;
static CORBA_PrimitiveDef prim_char=CORBA_OBJECT_NIL;
static CORBA_PrimitiveDef prim_octet=CORBA_OBJECT_NIL;
static CORBA_PrimitiveDef prim_any=CORBA_OBJECT_NIL;
static CORBA_PrimitiveDef prim_TypeCode=CORBA_OBJECT_NIL;
static CORBA_PrimitiveDef prim_Principal=CORBA_OBJECT_NIL;
static CORBA_PrimitiveDef prim_string=CORBA_OBJECT_NIL;
static CORBA_PrimitiveDef prim_objref=CORBA_OBJECT_NIL;
static CORBA_PrimitiveDef prim_longlong=CORBA_OBJECT_NIL;
static CORBA_PrimitiveDef prim_ulonglong=CORBA_OBJECT_NIL;
static CORBA_PrimitiveDef prim_longdouble=CORBA_OBJECT_NIL;
static CORBA_PrimitiveDef prim_wchar=CORBA_OBJECT_NIL;
static CORBA_PrimitiveDef prim_wstring=CORBA_OBJECT_NIL;

static CORBA_Repository impl_CORBA_Repository__create(PortableServer_POA poa, CORBA_Environment * ev)
{
	CORBA_Repository retval;
	impl_POA_CORBA_Repository *newservant;
	PortableServer_ObjectId *objid;

	newservant = g_new0(impl_POA_CORBA_Repository, 1);
	newservant->servant.vepv = &impl_CORBA_Repository_vepv;
	newservant->poa = poa;

	newservant->attr_def_kind=CORBA_dk_Repository;
	newservant->id_hash=g_hash_table_new(g_str_hash, g_str_equal);
	newservant->contents=NULL;

	POA_CORBA_Repository__init((PortableServer_Servant) newservant, ev);
	objid = PortableServer_POA_activate_object(poa, newservant, ev);
	CORBA_free(objid);
	retval = PortableServer_POA_servant_to_reference(poa, newservant, ev);

	return retval;
}

/* You shouldn't call this routine directly without first deactivating the servant... */
static void impl_CORBA_Repository__destroy(impl_POA_CORBA_Repository * servant, CORBA_Environment * ev)
{

	g_hash_table_destroy(servant->id_hash);
	g_slist_free(servant->contents);
	POA_CORBA_Repository__fini((PortableServer_Servant) servant, ev);
	g_free(servant);
}

CORBA_Contained
impl_CORBA_Repository_lookup_id(impl_POA_CORBA_Repository * servant,
				CORBA_RepositoryId search_id,
				CORBA_Environment * ev)
{
	CORBA_Contained retval;

	retval = g_hash_table_lookup(servant->id_hash, search_id);

	return retval;
}

CORBA_PrimitiveDef
impl_CORBA_Repository_get_primitive(impl_POA_CORBA_Repository * servant,
				    CORBA_PrimitiveKind kind,
				    CORBA_Environment * ev)
{
	CORBA_PrimitiveDef retval;

	switch(kind) {
	case CORBA_pk_null:
		retval=prim_null;
		break;
		
	case CORBA_pk_void:
		retval=prim_void;
		break;

	case CORBA_pk_short:
		retval=prim_short;
		break;

	case CORBA_pk_long:
		retval=prim_long;
		break;

	case CORBA_pk_ushort:
		retval=prim_ushort;
		break;

	case CORBA_pk_ulong:
		retval=prim_ulong;
		break;

	case CORBA_pk_float:
		retval=prim_float;
		break;

	case CORBA_pk_double:
		retval=prim_double;
		break;

	case CORBA_pk_boolean:
		retval=prim_boolean;
		break;

	case CORBA_pk_char:
		retval=prim_char;
		break;

	case CORBA_pk_octet:
		retval=prim_octet;
		break;

	case CORBA_pk_any:
		retval=prim_any;
		break;

	case CORBA_pk_TypeCode:
		retval=prim_TypeCode;
		break;

	case CORBA_pk_Principal:
		retval=prim_Principal;
		break;

	case CORBA_pk_string:
		retval=prim_string;
		break;

	case CORBA_pk_objref:
		retval=prim_objref;
		break;

	case CORBA_pk_longlong:
		retval=prim_longlong;
		break;

	case CORBA_pk_ulonglong:
		retval=prim_ulonglong;
		break;

	case CORBA_pk_longdouble:
		retval=prim_longdouble;
		break;

	case CORBA_pk_wchar:
		retval=prim_wchar;
		break;

	case CORBA_pk_wstring:
		retval=prim_wstring;
		break;
	}
		
	return(CORBA_Object_duplicate(retval, ev));
}

CORBA_StringDef
impl_CORBA_Repository_create_string(impl_POA_CORBA_Repository * servant,
				    CORBA_unsigned_long bound,
				    CORBA_Environment * ev)
{
	CORBA_StringDef retval;

	return retval;
}

CORBA_WstringDef
impl_CORBA_Repository_create_wstring(impl_POA_CORBA_Repository * servant,
				     CORBA_unsigned_long bound,
				     CORBA_Environment * ev)
{
	CORBA_WstringDef retval;

	return retval;
}

CORBA_SequenceDef
impl_CORBA_Repository_create_sequence(impl_POA_CORBA_Repository * servant,
				      CORBA_unsigned_long bound,
				      CORBA_IDLType element_type,
				      CORBA_Environment * ev)
{
	CORBA_SequenceDef retval;

	return retval;
}

CORBA_ArrayDef
impl_CORBA_Repository_create_array(impl_POA_CORBA_Repository * servant,
				   CORBA_unsigned_long length,
				   CORBA_IDLType element_type,
				   CORBA_Environment * ev)
{
	CORBA_ArrayDef retval;

	return retval;
}

CORBA_FixedDef
impl_CORBA_Repository_create_fixed(impl_POA_CORBA_Repository * servant,
				   CORBA_unsigned_short digits,
				   CORBA_short scale,
				   CORBA_Environment * ev)
{
	CORBA_FixedDef retval;

	return retval;
}

CORBA_DefinitionKind
impl_CORBA_Repository__get_def_kind(impl_POA_CORBA_Repository * servant,
				    CORBA_Environment * ev)
{
	return(servant->attr_def_kind);
}

void impl_CORBA_Repository_destroy(impl_POA_CORBA_Repository * servant,
				   CORBA_Environment * ev)
{
	PortableServer_POA_deactivate_object(servant->poa, PortableServer_POA_servant_to_id(servant->poa, servant, ev), ev);
	impl_CORBA_Repository__destroy(servant, ev);
}

CORBA_Contained
impl_CORBA_Repository_lookup(impl_POA_CORBA_Repository * servant,
			     CORBA_ScopedName search_name,
			     CORBA_Environment * ev)
{
	CORBA_Contained retval;

	retval=g_hash_table_lookup(servant->id_hash, search_name);
	if(retval!=NULL) {
		return(CORBA_Object_duplicate(retval, ev));
	} else {
		return(CORBA_OBJECT_NIL);
	}
}

CORBA_ContainedSeq *
 impl_CORBA_Repository_contents(impl_POA_CORBA_Repository * servant,
				CORBA_DefinitionKind limit_type,
				CORBA_boolean exclude_inherited,
				CORBA_Environment * ev)
{
	CORBA_ContainedSeq *retval;

	return retval;
}

CORBA_ContainedSeq *
 impl_CORBA_Repository_lookup_name(impl_POA_CORBA_Repository * servant,
				   CORBA_Identifier search_name,
				   CORBA_long levels_to_search,
				   CORBA_DefinitionKind limit_type,
				   CORBA_boolean exclude_inherited,
				   CORBA_Environment * ev)
{
	CORBA_ContainedSeq *retval;

	return retval;
}

CORBA_Container_DescriptionSeq *
 impl_CORBA_Repository_describe_contents(impl_POA_CORBA_Repository * servant,
					 CORBA_DefinitionKind limit_type,
					 CORBA_boolean exclude_inherited,
					 CORBA_long max_returned_objs,
					 CORBA_Environment * ev)
{
	CORBA_Container_DescriptionSeq *retval;

	return retval;
}

CORBA_ModuleDef
impl_CORBA_Repository_create_module(impl_POA_CORBA_Repository * servant,
				    CORBA_RepositoryId id,
				    CORBA_Identifier name,
				    CORBA_VersionSpec version,
				    CORBA_Environment * ev)
{
	CORBA_ModuleDef retval;

	retval=impl_CORBA_ModuleDef__create(servant->poa, id, name, version, repo, ev);
	/* Add to contents list */
	g_slist_append(servant->contents, retval);

	return(CORBA_Object_duplicate(retval, ev));
}

CORBA_ConstantDef
impl_CORBA_Repository_create_constant(impl_POA_CORBA_Repository * servant,
				      CORBA_RepositoryId id,
				      CORBA_Identifier name,
				      CORBA_VersionSpec version,
				      CORBA_IDLType type,
				      CORBA_any * value,
				      CORBA_Environment * ev)
{
	CORBA_ConstantDef retval;

	retval=impl_CORBA_ConstantDef__create(servant->poa, id, name, version, type, value, repo, ev);
	/* Add to contents list */
	g_slist_append(servant->contents, retval);

	return(CORBA_Object_duplicate(retval, ev));
}

CORBA_StructDef
impl_CORBA_Repository_create_struct(impl_POA_CORBA_Repository * servant,
				    CORBA_RepositoryId id,
				    CORBA_Identifier name,
				    CORBA_VersionSpec version,
				    CORBA_StructMemberSeq * members,
				    CORBA_Environment * ev)
{
	CORBA_StructDef retval;

	retval=impl_CORBA_StructDef__create(servant->poa, id, name, version, members, repo, ev);
	/* Add to contents list */
	g_slist_append(servant->contents, retval);

	return(CORBA_Object_duplicate(retval, ev));
}

CORBA_UnionDef
impl_CORBA_Repository_create_union(impl_POA_CORBA_Repository * servant,
				   CORBA_RepositoryId id,
				   CORBA_Identifier name,
				   CORBA_VersionSpec version,
				   CORBA_IDLType discriminator_type,
				   CORBA_UnionMemberSeq * members,
				   CORBA_Environment * ev)
{
	CORBA_UnionDef retval;

	retval=impl_CORBA_UnionDef__create(servant->poa, id, name, version, discriminator_type, members, repo, ev);
	/* Add to contents list */
	g_slist_append(servant->contents, retval);

	return(CORBA_Object_duplicate(retval, ev));
}

CORBA_EnumDef
impl_CORBA_Repository_create_enum(impl_POA_CORBA_Repository * servant,
				  CORBA_RepositoryId id,
				  CORBA_Identifier name,
				  CORBA_VersionSpec version,
				  CORBA_EnumMemberSeq * members,
				  CORBA_Environment * ev)
{
	CORBA_EnumDef retval;

	retval=impl_CORBA_EnumDef__create(servant->poa, id, name, version, members, repo, ev);
	/* Add to contents list */
	g_slist_append(servant->contents, retval);

	return(CORBA_Object_duplicate(retval, ev));
}

CORBA_AliasDef
impl_CORBA_Repository_create_alias(impl_POA_CORBA_Repository * servant,
				   CORBA_RepositoryId id,
				   CORBA_Identifier name,
				   CORBA_VersionSpec version,
				   CORBA_IDLType original_type,
				   CORBA_Environment * ev)
{
	CORBA_AliasDef retval;

	retval=impl_CORBA_AliasDef__create(servant->poa, id, name, version, original_type, repo, ev);
	/* Add to contents list */
	g_slist_append(servant->contents, retval);

	return(CORBA_Object_duplicate(retval, ev));
}

CORBA_InterfaceDef
impl_CORBA_Repository_create_interface(impl_POA_CORBA_Repository * servant,
				       CORBA_RepositoryId id,
				       CORBA_Identifier name,
				       CORBA_VersionSpec version,
				 CORBA_InterfaceDefSeq * base_interfaces,
				       CORBA_Environment * ev)
{
	CORBA_InterfaceDef retval;

	retval=impl_CORBA_InterfaceDef__create(servant->poa, id, name, version, base_interfaces, repo, ev);
	/* Add to contents list */
	g_slist_append(servant->contents, retval);

	return(CORBA_Object_duplicate(retval, ev));
}

CORBA_ExceptionDef
impl_CORBA_Repository_create_exception(impl_POA_CORBA_Repository * servant,
				       CORBA_RepositoryId id,
				       CORBA_Identifier name,
				       CORBA_VersionSpec version,
				       CORBA_StructMemberSeq * members,
				       CORBA_Environment * ev)
{
	CORBA_ExceptionDef retval;

	retval=impl_CORBA_ExceptionDef__create(servant->poa, id, name, version, members, repo, ev);
	/* Add to contents list */
	g_slist_append(servant->contents, retval);

	return(CORBA_Object_duplicate(retval, ev));
}

static CORBA_ModuleDef impl_CORBA_ModuleDef__create(PortableServer_POA poa,
						    CORBA_RepositoryId id,
						    CORBA_Identifier name,
						    CORBA_VersionSpec version,
						    CORBA_Container defined_in,
						    CORBA_Environment * ev)
{
	CORBA_ModuleDef retval;
	impl_POA_CORBA_ModuleDef *newservant;
	PortableServer_ObjectId *objid;

	newservant = g_new0(impl_POA_CORBA_ModuleDef, 1);
	newservant->servant.vepv = &impl_CORBA_ModuleDef_vepv;
	newservant->poa = poa;

	newservant->attr_def_kind=CORBA_dk_Module;
	newservant->contents=NULL;

	newservant->attr_id=CORBA_string_dup(id);
	newservant->attr_name=CORBA_string_dup(name);
	newservant->attr_version=CORBA_string_dup(version);
	newservant->attr_defined_in=CORBA_Object_duplicate(defined_in, ev);

	POA_CORBA_ModuleDef__init((PortableServer_Servant) newservant, ev);
	objid = PortableServer_POA_activate_object(poa, newservant, ev);
	CORBA_free(objid);
	retval = PortableServer_POA_servant_to_reference(poa, newservant, ev);

	return retval;
}

/* You shouldn't call this routine directly without first deactivating the servant... */
static void impl_CORBA_ModuleDef__destroy(impl_POA_CORBA_ModuleDef * servant, CORBA_Environment * ev)
{

	POA_CORBA_ModuleDef__fini((PortableServer_Servant) servant, ev);
	g_free(servant);
}

CORBA_DefinitionKind
impl_CORBA_ModuleDef__get_def_kind(impl_POA_CORBA_ModuleDef * servant,
				   CORBA_Environment * ev)
{
	return(servant->attr_def_kind);
}

void impl_CORBA_ModuleDef_destroy(impl_POA_CORBA_ModuleDef * servant,
				  CORBA_Environment * ev)
{
}

CORBA_Contained
impl_CORBA_ModuleDef_lookup(impl_POA_CORBA_ModuleDef * servant,
			    CORBA_ScopedName search_name,
			    CORBA_Environment * ev)
{
	CORBA_Contained retval;

	return retval;
}

CORBA_ContainedSeq *
 impl_CORBA_ModuleDef_contents(impl_POA_CORBA_ModuleDef * servant,
			       CORBA_DefinitionKind limit_type,
			       CORBA_boolean exclude_inherited,
			       CORBA_Environment * ev)
{
	CORBA_ContainedSeq *retval;

	return retval;
}

CORBA_ContainedSeq *
 impl_CORBA_ModuleDef_lookup_name(impl_POA_CORBA_ModuleDef * servant,
				  CORBA_Identifier search_name,
				  CORBA_long levels_to_search,
				  CORBA_DefinitionKind limit_type,
				  CORBA_boolean exclude_inherited,
				  CORBA_Environment * ev)
{
	CORBA_ContainedSeq *retval;

	return retval;
}

CORBA_Container_DescriptionSeq *
 impl_CORBA_ModuleDef_describe_contents(impl_POA_CORBA_ModuleDef * servant,
					CORBA_DefinitionKind limit_type,
					CORBA_boolean exclude_inherited,
					CORBA_long max_returned_objs,
					CORBA_Environment * ev)
{
	CORBA_Container_DescriptionSeq *retval;

	return retval;
}

CORBA_ModuleDef
impl_CORBA_ModuleDef_create_module(impl_POA_CORBA_ModuleDef * servant,
				   CORBA_RepositoryId id,
				   CORBA_Identifier name,
				   CORBA_VersionSpec version,
				   CORBA_Environment * ev)
{
	CORBA_ModuleDef retval;

	retval=impl_CORBA_ModuleDef__create(servant->poa, id, name, version, PortableServer_POA_servant_to_reference(servant->poa, servant, ev), ev);
	/* Add to contents list */
	g_slist_append(servant->contents, retval);

	return(CORBA_Object_duplicate(retval, ev));
}

CORBA_ConstantDef
impl_CORBA_ModuleDef_create_constant(impl_POA_CORBA_ModuleDef * servant,
				     CORBA_RepositoryId id,
				     CORBA_Identifier name,
				     CORBA_VersionSpec version,
				     CORBA_IDLType type,
				     CORBA_any * value,
				     CORBA_Environment * ev)
{
	CORBA_ConstantDef retval;

	retval=impl_CORBA_ConstantDef__create(servant->poa, id, name, version, type, value, PortableServer_POA_servant_to_reference(servant->poa, servant, ev), ev);
	/* Add to contents list */
	g_slist_append(servant->contents, retval);

	return(CORBA_Object_duplicate(retval, ev));
}

CORBA_StructDef
impl_CORBA_ModuleDef_create_struct(impl_POA_CORBA_ModuleDef * servant,
				   CORBA_RepositoryId id,
				   CORBA_Identifier name,
				   CORBA_VersionSpec version,
				   CORBA_StructMemberSeq * members,
				   CORBA_Environment * ev)
{
	CORBA_StructDef retval;

	retval=impl_CORBA_StructDef__create(servant->poa, id, name, version, members, PortableServer_POA_servant_to_reference(servant->poa, servant, ev), ev);
	/* Add to contents list */
	g_slist_append(servant->contents, retval);

	return(CORBA_Object_duplicate(retval, ev));
}

CORBA_UnionDef
impl_CORBA_ModuleDef_create_union(impl_POA_CORBA_ModuleDef * servant,
				  CORBA_RepositoryId id,
				  CORBA_Identifier name,
				  CORBA_VersionSpec version,
				  CORBA_IDLType discriminator_type,
				  CORBA_UnionMemberSeq * members,
				  CORBA_Environment * ev)
{
	CORBA_UnionDef retval;

	retval=impl_CORBA_UnionDef__create(servant->poa, id, name, version, discriminator_type, members, PortableServer_POA_servant_to_reference(servant->poa, servant, ev), ev);
	/* Add to contents list */
	g_slist_append(servant->contents, retval);

	return(CORBA_Object_duplicate(retval, ev));
}

CORBA_EnumDef
impl_CORBA_ModuleDef_create_enum(impl_POA_CORBA_ModuleDef * servant,
				 CORBA_RepositoryId id,
				 CORBA_Identifier name,
				 CORBA_VersionSpec version,
				 CORBA_EnumMemberSeq * members,
				 CORBA_Environment * ev)
{
	CORBA_EnumDef retval;

	retval=impl_CORBA_EnumDef__create(servant->poa, id, name, version, members, PortableServer_POA_servant_to_reference(servant->poa, servant, ev), ev);
	/* Add to contents list */
	g_slist_append(servant->contents, retval);

	return(CORBA_Object_duplicate(retval, ev));
}

CORBA_AliasDef
impl_CORBA_ModuleDef_create_alias(impl_POA_CORBA_ModuleDef * servant,
				  CORBA_RepositoryId id,
				  CORBA_Identifier name,
				  CORBA_VersionSpec version,
				  CORBA_IDLType original_type,
				  CORBA_Environment * ev)
{
	CORBA_AliasDef retval;

	retval=impl_CORBA_AliasDef__create(servant->poa, id, name, version, original_type, PortableServer_POA_servant_to_reference(servant->poa, servant, ev), ev);
	/* Add to contents list */
	g_slist_append(servant->contents, retval);

	return(CORBA_Object_duplicate(retval, ev));
}

CORBA_InterfaceDef
impl_CORBA_ModuleDef_create_interface(impl_POA_CORBA_ModuleDef * servant,
				      CORBA_RepositoryId id,
				      CORBA_Identifier name,
				      CORBA_VersionSpec version,
				      CORBA_InterfaceDefSeq * base_interfaces,
				      CORBA_Environment * ev)
{
	CORBA_InterfaceDef retval;

	retval=impl_CORBA_InterfaceDef__create(servant->poa, id, name, version, base_interfaces, PortableServer_POA_servant_to_reference(servant->poa, servant, ev), ev);
	/* Add to contents list */
	g_slist_append(servant->contents, retval);
	
	return(CORBA_Object_duplicate(retval, ev));
}

CORBA_ExceptionDef
impl_CORBA_ModuleDef_create_exception(impl_POA_CORBA_ModuleDef * servant,
				      CORBA_RepositoryId id,
				      CORBA_Identifier name,
				      CORBA_VersionSpec version,
				      CORBA_StructMemberSeq * members,
				      CORBA_Environment * ev)
{
	CORBA_ExceptionDef retval;

	retval=impl_CORBA_ExceptionDef__create(servant->poa, id, name, version, members, PortableServer_POA_servant_to_reference(servant->poa, servant, ev), ev);
	/* Add to contents list */
	g_slist_append(servant->contents, retval);

	return(CORBA_Object_duplicate(retval, ev));
}

CORBA_RepositoryId
impl_CORBA_ModuleDef__get_id(impl_POA_CORBA_ModuleDef * servant,
			     CORBA_Environment * ev)
{
	return(CORBA_string_dup(servant->attr_id));
}

void impl_CORBA_ModuleDef__set_id(impl_POA_CORBA_ModuleDef * servant,
				  CORBA_RepositoryId value,
				  CORBA_Environment * ev)
{
}

CORBA_Identifier
impl_CORBA_ModuleDef__get_name(impl_POA_CORBA_ModuleDef * servant,
			       CORBA_Environment * ev)
{
	return(CORBA_string_dup(servant->attr_name));
}

void impl_CORBA_ModuleDef__set_name(impl_POA_CORBA_ModuleDef * servant,
				    CORBA_Identifier value,
				    CORBA_Environment * ev)
{
}

CORBA_VersionSpec
impl_CORBA_ModuleDef__get_version(impl_POA_CORBA_ModuleDef * servant,
				  CORBA_Environment * ev)
{
	return(CORBA_string_dup(servant->attr_version));
}

void impl_CORBA_ModuleDef__set_version(impl_POA_CORBA_ModuleDef * servant,
				       CORBA_VersionSpec value,
				       CORBA_Environment * ev)
{
}

CORBA_Container
impl_CORBA_ModuleDef__get_defined_in(impl_POA_CORBA_ModuleDef * servant,
				     CORBA_Environment * ev)
{
	return(CORBA_Object_duplicate(servant->attr_defined_in, ev));
}

CORBA_ScopedName
impl_CORBA_ModuleDef__get_absolute_name(impl_POA_CORBA_ModuleDef * servant,
					CORBA_Environment * ev)
{
	CORBA_ScopedName retval;

	return retval;
}

CORBA_Repository
impl_CORBA_ModuleDef__get_containing_repository(impl_POA_CORBA_ModuleDef * servant,
						CORBA_Environment * ev)
{
	return(CORBA_Object_duplicate(repo, ev));
}

CORBA_Contained_Description *
 impl_CORBA_ModuleDef_describe(impl_POA_CORBA_ModuleDef * servant,
			       CORBA_Environment * ev)
{
	CORBA_Contained_Description *retval;

	return retval;
}

void impl_CORBA_ModuleDef_move(impl_POA_CORBA_ModuleDef * servant,
			       CORBA_Container new_container,
			       CORBA_Identifier new_name,
			       CORBA_VersionSpec new_version,
			       CORBA_Environment * ev)
{
}

static CORBA_ConstantDef impl_CORBA_ConstantDef__create(PortableServer_POA poa,
							CORBA_RepositoryId id,
							CORBA_Identifier name,
							CORBA_VersionSpec version,
							CORBA_IDLType type_def,
							CORBA_any *value,
							CORBA_Container defined_in,
							CORBA_Environment * ev)
{
	CORBA_ConstantDef retval;
	impl_POA_CORBA_ConstantDef *newservant;
	PortableServer_ObjectId *objid;

	newservant = g_new0(impl_POA_CORBA_ConstantDef, 1);
	newservant->servant.vepv = &impl_CORBA_ConstantDef_vepv;
	newservant->poa = poa;

	newservant->attr_def_kind=CORBA_dk_Constant;
	newservant->attr_id=CORBA_string_dup(id);
	newservant->attr_name=CORBA_string_dup(name);
	newservant->attr_version=CORBA_string_dup(version);
	newservant->attr_type_def=CORBA_Object_duplicate(type_def, ev);
	newservant->attr_value=value;
	newservant->attr_defined_in=CORBA_Object_duplicate(defined_in, ev);

	POA_CORBA_ConstantDef__init((PortableServer_Servant) newservant, ev);
	objid = PortableServer_POA_activate_object(poa, newservant, ev);
	CORBA_free(objid);
	retval = PortableServer_POA_servant_to_reference(poa, newservant, ev);

	return retval;
}

/* You shouldn't call this routine directly without first deactivating the servant... */
static void impl_CORBA_ConstantDef__destroy(impl_POA_CORBA_ConstantDef * servant, CORBA_Environment * ev)
{

	POA_CORBA_ConstantDef__fini((PortableServer_Servant) servant, ev);
	g_free(servant);
}

CORBA_TypeCode
impl_CORBA_ConstantDef__get_type(impl_POA_CORBA_ConstantDef * servant,
				 CORBA_Environment * ev)
{
	return(CORBA_IDLType__get_type(servant->attr_type_def, ev));
}

CORBA_IDLType
impl_CORBA_ConstantDef__get_type_def(impl_POA_CORBA_ConstantDef * servant,
				     CORBA_Environment * ev)
{
	return(CORBA_Object_duplicate(servant->attr_type_def, ev));
}

void impl_CORBA_ConstantDef__set_type_def(impl_POA_CORBA_ConstantDef * servant,
					  CORBA_IDLType value,
					  CORBA_Environment * ev)
{
	if(!CORBA_Object_is_nil(servant->attr_type_def, ev)) {
		CORBA_Object_release(servant->attr_type_def, ev);
	}
	servant->attr_type_def=CORBA_Object_duplicate(value, ev);
}

CORBA_any *
 impl_CORBA_ConstantDef__get_value(impl_POA_CORBA_ConstantDef * servant,
				   CORBA_Environment * ev)
{
	CORBA_any *retval;

	return retval;
}

void impl_CORBA_ConstantDef__set_value(impl_POA_CORBA_ConstantDef * servant,
				       CORBA_any * value,
				       CORBA_Environment * ev)
{
}

CORBA_DefinitionKind
impl_CORBA_ConstantDef__get_def_kind(impl_POA_CORBA_ConstantDef * servant,
				     CORBA_Environment * ev)
{
	return(servant->attr_def_kind);
}

void impl_CORBA_ConstantDef_destroy(impl_POA_CORBA_ConstantDef * servant,
				    CORBA_Environment * ev)
{
}

CORBA_RepositoryId
impl_CORBA_ConstantDef__get_id(impl_POA_CORBA_ConstantDef * servant,
			       CORBA_Environment * ev)
{
	return(CORBA_string_dup(servant->attr_id));
}

void impl_CORBA_ConstantDef__set_id(impl_POA_CORBA_ConstantDef * servant,
				    CORBA_RepositoryId value,
				    CORBA_Environment * ev)
{
}

CORBA_Identifier
impl_CORBA_ConstantDef__get_name(impl_POA_CORBA_ConstantDef * servant,
				 CORBA_Environment * ev)
{
	return(CORBA_string_dup(servant->attr_name));
}

void impl_CORBA_ConstantDef__set_name(impl_POA_CORBA_ConstantDef * servant,
				      CORBA_Identifier value,
				      CORBA_Environment * ev)
{
}

CORBA_VersionSpec
impl_CORBA_ConstantDef__get_version(impl_POA_CORBA_ConstantDef * servant,
				    CORBA_Environment * ev)
{
	return(CORBA_string_dup(servant->attr_version));
}

void impl_CORBA_ConstantDef__set_version(impl_POA_CORBA_ConstantDef * servant,
					 CORBA_VersionSpec value,
					 CORBA_Environment * ev)
{
}

CORBA_Container
impl_CORBA_ConstantDef__get_defined_in(impl_POA_CORBA_ConstantDef * servant,
				       CORBA_Environment * ev)
{
	return(CORBA_Object_duplicate(servant->attr_defined_in, ev));
}

CORBA_ScopedName
impl_CORBA_ConstantDef__get_absolute_name(impl_POA_CORBA_ConstantDef * servant,
					  CORBA_Environment * ev)
{
	CORBA_ScopedName retval;

	return retval;
}

CORBA_Repository
impl_CORBA_ConstantDef__get_containing_repository(impl_POA_CORBA_ConstantDef * servant,
						  CORBA_Environment * ev)
{
	return(CORBA_Object_duplicate(repo, ev));
}

CORBA_Contained_Description *
 impl_CORBA_ConstantDef_describe(impl_POA_CORBA_ConstantDef * servant,
				 CORBA_Environment * ev)
{
	CORBA_Contained_Description *retval;

	return retval;
}

void impl_CORBA_ConstantDef_move(impl_POA_CORBA_ConstantDef * servant,
				 CORBA_Container new_container,
				 CORBA_Identifier new_name,
				 CORBA_VersionSpec new_version,
				 CORBA_Environment * ev)
{
}

static CORBA_TypedefDef impl_CORBA_TypedefDef__create(PortableServer_POA poa, CORBA_Environment * ev)
{
	CORBA_TypedefDef retval;
	impl_POA_CORBA_TypedefDef *newservant;
	PortableServer_ObjectId *objid;

	newservant = g_new0(impl_POA_CORBA_TypedefDef, 1);
	newservant->servant.vepv = &impl_CORBA_TypedefDef_vepv;
	newservant->poa = poa;

	newservant->attr_def_kind=CORBA_dk_Typedef;

	POA_CORBA_TypedefDef__init((PortableServer_Servant) newservant, ev);
	objid = PortableServer_POA_activate_object(poa, newservant, ev);
	CORBA_free(objid);
	retval = PortableServer_POA_servant_to_reference(poa, newservant, ev);

	return retval;
}

/* You shouldn't call this routine directly without first deactivating the servant... */
static void impl_CORBA_TypedefDef__destroy(impl_POA_CORBA_TypedefDef * servant, CORBA_Environment * ev)
{

	POA_CORBA_TypedefDef__fini((PortableServer_Servant) servant, ev);
	g_free(servant);
}

CORBA_DefinitionKind
impl_CORBA_TypedefDef__get_def_kind(impl_POA_CORBA_TypedefDef * servant,
				    CORBA_Environment * ev)
{
	return(servant->attr_def_kind);
}

void impl_CORBA_TypedefDef_destroy(impl_POA_CORBA_TypedefDef * servant,
				   CORBA_Environment * ev)
{
}

CORBA_RepositoryId
impl_CORBA_TypedefDef__get_id(impl_POA_CORBA_TypedefDef * servant,
			      CORBA_Environment * ev)
{
	return(CORBA_string_dup(servant->attr_id));
}

void impl_CORBA_TypedefDef__set_id(impl_POA_CORBA_TypedefDef * servant,
				   CORBA_RepositoryId value,
				   CORBA_Environment * ev)
{
}

CORBA_Identifier
impl_CORBA_TypedefDef__get_name(impl_POA_CORBA_TypedefDef * servant,
				CORBA_Environment * ev)
{
	return(CORBA_string_dup(servant->attr_name));
}

void impl_CORBA_TypedefDef__set_name(impl_POA_CORBA_TypedefDef * servant,
				     CORBA_Identifier value,
				     CORBA_Environment * ev)
{
}

CORBA_VersionSpec
impl_CORBA_TypedefDef__get_version(impl_POA_CORBA_TypedefDef * servant,
				   CORBA_Environment * ev)
{
	return(CORBA_string_dup(servant->attr_version));
}

void impl_CORBA_TypedefDef__set_version(impl_POA_CORBA_TypedefDef * servant,
					CORBA_VersionSpec value,
					CORBA_Environment * ev)
{
}

CORBA_Container
impl_CORBA_TypedefDef__get_defined_in(impl_POA_CORBA_TypedefDef * servant,
				      CORBA_Environment * ev)
{
	return(CORBA_Object_duplicate(servant->attr_defined_in, ev));
}

CORBA_ScopedName
impl_CORBA_TypedefDef__get_absolute_name(impl_POA_CORBA_TypedefDef * servant,
					 CORBA_Environment * ev)
{
	CORBA_ScopedName retval;

	return retval;
}

CORBA_Repository
impl_CORBA_TypedefDef__get_containing_repository(impl_POA_CORBA_TypedefDef * servant,
						 CORBA_Environment * ev)
{
	return(CORBA_Object_duplicate(repo, ev));
}

CORBA_Contained_Description *
 impl_CORBA_TypedefDef_describe(impl_POA_CORBA_TypedefDef * servant,
 				CORBA_Environment * ev)
{
	CORBA_Contained_Description *retval;

	return retval;
}

void impl_CORBA_TypedefDef_move(impl_POA_CORBA_TypedefDef * servant,
				CORBA_Container new_container,
				CORBA_Identifier new_name,
				CORBA_VersionSpec new_version,
				CORBA_Environment * ev)
{
}

CORBA_TypeCode
impl_CORBA_TypedefDef__get_type(impl_POA_CORBA_TypedefDef * servant,
				CORBA_Environment * ev)
{
	CORBA_TypeCode retval;

	return retval;
}

static CORBA_StructDef impl_CORBA_StructDef__create(PortableServer_POA poa,
						    CORBA_RepositoryId id,
						    CORBA_Identifier name,
						    CORBA_VersionSpec version,
						    CORBA_StructMemberSeq * members,
						    CORBA_Container defined_in,
						    CORBA_Environment * ev)
{
	CORBA_StructDef retval;
	impl_POA_CORBA_StructDef *newservant;
	PortableServer_ObjectId *objid;

	newservant = g_new0(impl_POA_CORBA_StructDef, 1);
	newservant->servant.vepv = &impl_CORBA_StructDef_vepv;
	newservant->poa = poa;

	newservant->attr_members= *members;
	newservant->attr_def_kind=CORBA_dk_Struct;
	newservant->attr_id=CORBA_string_dup(id);
	newservant->attr_name=CORBA_string_dup(name);
	newservant->attr_version=CORBA_string_dup(version);
	newservant->attr_defined_in=CORBA_Object_duplicate(defined_in, ev);
	
	newservant->contents=NULL;
	
	POA_CORBA_StructDef__init((PortableServer_Servant) newservant, ev);
	objid = PortableServer_POA_activate_object(poa, newservant, ev);
	CORBA_free(objid);
	retval = PortableServer_POA_servant_to_reference(poa, newservant, ev);

	return retval;
}

/* You shouldn't call this routine directly without first deactivating the servant... */
static void impl_CORBA_StructDef__destroy(impl_POA_CORBA_StructDef * servant, CORBA_Environment * ev)
{

	g_slist_free(servant->contents);
	
	POA_CORBA_StructDef__fini((PortableServer_Servant) servant, ev);
	g_free(servant);
}

CORBA_StructMemberSeq *
 impl_CORBA_StructDef__get_members(impl_POA_CORBA_StructDef * servant,
				   CORBA_Environment * ev)
{
	CORBA_StructMemberSeq *retval;

	return retval;
}

void impl_CORBA_StructDef__set_members(impl_POA_CORBA_StructDef * servant,
				       CORBA_StructMemberSeq * value,
				       CORBA_Environment * ev)
{
}

CORBA_DefinitionKind
impl_CORBA_StructDef__get_def_kind(impl_POA_CORBA_StructDef * servant,
				   CORBA_Environment * ev)
{
	return(servant->attr_def_kind);
}

void impl_CORBA_StructDef_destroy(impl_POA_CORBA_StructDef * servant,
				  CORBA_Environment * ev)
{
}

CORBA_RepositoryId
impl_CORBA_StructDef__get_id(impl_POA_CORBA_StructDef * servant,
			     CORBA_Environment * ev)
{
	return(CORBA_string_dup(servant->attr_id));
}

void impl_CORBA_StructDef__set_id(impl_POA_CORBA_StructDef * servant,
				  CORBA_RepositoryId value,
				  CORBA_Environment * ev)
{
}

CORBA_Identifier
impl_CORBA_StructDef__get_name(impl_POA_CORBA_StructDef * servant,
			       CORBA_Environment * ev)
{
	return(CORBA_string_dup(servant->attr_name));
}

void impl_CORBA_StructDef__set_name(impl_POA_CORBA_StructDef * servant,
				    CORBA_Identifier value,
				    CORBA_Environment * ev)
{
}

CORBA_VersionSpec
impl_CORBA_StructDef__get_version(impl_POA_CORBA_StructDef * servant,
				  CORBA_Environment * ev)
{
	return(CORBA_string_dup(servant->attr_version));
}

void impl_CORBA_StructDef__set_version(impl_POA_CORBA_StructDef * servant,
				       CORBA_VersionSpec value,
				       CORBA_Environment * ev)
{
}

CORBA_Container
impl_CORBA_StructDef__get_defined_in(impl_POA_CORBA_StructDef * servant,
				     CORBA_Environment * ev)
{
	return(CORBA_Object_duplicate(servant->attr_defined_in, ev));
}

CORBA_ScopedName
impl_CORBA_StructDef__get_absolute_name(impl_POA_CORBA_StructDef * servant,
					CORBA_Environment * ev)
{
	CORBA_ScopedName retval;

	return retval;
}

CORBA_Repository
impl_CORBA_StructDef__get_containing_repository(impl_POA_CORBA_StructDef * servant,
						CORBA_Environment * ev)
{
	return(CORBA_Object_duplicate(repo, ev));
}

CORBA_Contained_Description *
 impl_CORBA_StructDef_describe(impl_POA_CORBA_StructDef * servant,
			       CORBA_Environment * ev)
{
	CORBA_Contained_Description *retval;

	return retval;
}

void impl_CORBA_StructDef_move(impl_POA_CORBA_StructDef * servant,
			       CORBA_Container new_container,
			       CORBA_Identifier new_name,
			       CORBA_VersionSpec new_version,
			       CORBA_Environment * ev)
{
}

CORBA_TypeCode
impl_CORBA_StructDef__get_type(impl_POA_CORBA_StructDef * servant,
			       CORBA_Environment * ev)
{
	CORBA_TypeCode retval;

	return retval;
}

CORBA_Contained
impl_CORBA_StructDef_lookup(impl_POA_CORBA_StructDef * servant,
			    CORBA_ScopedName search_name,
			    CORBA_Environment * ev)
{
	CORBA_Contained retval;

	return retval;
}

CORBA_ContainedSeq *
 impl_CORBA_StructDef_contents(impl_POA_CORBA_StructDef * servant,
			       CORBA_DefinitionKind limit_type,
			       CORBA_boolean exclude_inherited,
			       CORBA_Environment * ev)
{
	CORBA_ContainedSeq *retval;

	return retval;
}

CORBA_ContainedSeq *
 impl_CORBA_StructDef_lookup_name(impl_POA_CORBA_StructDef * servant,
				  CORBA_Identifier search_name,
				  CORBA_long levels_to_search,
				  CORBA_DefinitionKind limit_type,
				  CORBA_boolean exclude_inherited,
				  CORBA_Environment * ev)
{
	CORBA_ContainedSeq *retval;

	return retval;
}

CORBA_Container_DescriptionSeq *
 impl_CORBA_StructDef_describe_contents(impl_POA_CORBA_StructDef * servant,
					CORBA_DefinitionKind limit_type,
					CORBA_boolean exclude_inherited,
					CORBA_long max_returned_objs,
					CORBA_Environment * ev)
{
	CORBA_Container_DescriptionSeq *retval;

	return retval;
}

CORBA_ModuleDef
impl_CORBA_StructDef_create_module(impl_POA_CORBA_StructDef * servant,
				   CORBA_RepositoryId id,
				   CORBA_Identifier name,
				   CORBA_VersionSpec version,
				   CORBA_Environment * ev)
{
	/* Structs can only contain structs, unions and
           enums. Unfortunately, the spec doesn't specify any
           exceptions, so I will just ignore the request for being
           silly */
	return(CORBA_OBJECT_NIL);
}

CORBA_ConstantDef
impl_CORBA_StructDef_create_constant(impl_POA_CORBA_StructDef * servant,
				     CORBA_RepositoryId id,
				     CORBA_Identifier name,
				     CORBA_VersionSpec version,
				     CORBA_IDLType type,
				     CORBA_any * value,
				     CORBA_Environment * ev)
{
	/* Structs can only contain structs, unions and
           enums. Unfortunately, the spec doesn't specify any
           exceptions, so I will just ignore the request for being
           silly */
	return(CORBA_OBJECT_NIL);
}

CORBA_StructDef
impl_CORBA_StructDef_create_struct(impl_POA_CORBA_StructDef * servant,
				   CORBA_RepositoryId id,
				   CORBA_Identifier name,
				   CORBA_VersionSpec version,
				   CORBA_StructMemberSeq * members,
				   CORBA_Environment * ev)
{
	CORBA_StructDef retval;

	retval=impl_CORBA_StructDef__create(servant->poa, id, name, version, members, PortableServer_POA_servant_to_reference(servant->poa, servant, ev), ev);
	/* Add to contents list */
	g_slist_append(servant->contents, retval);

	return(CORBA_Object_duplicate(retval, ev));
}

CORBA_UnionDef
impl_CORBA_StructDef_create_union(impl_POA_CORBA_StructDef * servant,
				  CORBA_RepositoryId id,
				  CORBA_Identifier name,
				  CORBA_VersionSpec version,
				  CORBA_IDLType discriminator_type,
				  CORBA_UnionMemberSeq * members,
				  CORBA_Environment * ev)
{
	CORBA_UnionDef retval;

	retval=impl_CORBA_UnionDef__create(servant->poa, id, name, version, discriminator_type, members, PortableServer_POA_servant_to_reference(servant->poa, servant, ev), ev);
	/* Add to contents list */
	g_slist_append(servant->contents, retval);

	return(CORBA_Object_duplicate(retval, ev));
}

CORBA_EnumDef
impl_CORBA_StructDef_create_enum(impl_POA_CORBA_StructDef * servant,
				 CORBA_RepositoryId id,
				 CORBA_Identifier name,
				 CORBA_VersionSpec version,
				 CORBA_EnumMemberSeq * members,
				 CORBA_Environment * ev)
{
	CORBA_EnumDef retval;

	retval=impl_CORBA_EnumDef__create(servant->poa, id, name, version, members, PortableServer_POA_servant_to_reference(servant->poa, servant, ev), ev);
	/* Add to contents list */
	g_slist_append(servant->contents, retval);
	
	return(CORBA_Object_duplicate(retval, ev));
}

CORBA_AliasDef
impl_CORBA_StructDef_create_alias(impl_POA_CORBA_StructDef * servant,
				  CORBA_RepositoryId id,
				  CORBA_Identifier name,
				  CORBA_VersionSpec version,
				  CORBA_IDLType original_type,
				  CORBA_Environment * ev)
{
	/* Structs can only contain structs, unions and
           enums. Unfortunately, the spec doesn't specify any
           exceptions, so I will just ignore the request for being
           silly */
	return(CORBA_OBJECT_NIL);
}

CORBA_InterfaceDef
impl_CORBA_StructDef_create_interface(impl_POA_CORBA_StructDef * servant,
				      CORBA_RepositoryId id,
				      CORBA_Identifier name,
				      CORBA_VersionSpec version,
				 CORBA_InterfaceDefSeq * base_interfaces,
				      CORBA_Environment * ev)
{
	/* Structs can only contain structs, unions and
           enums. Unfortunately, the spec doesn't specify any
           exceptions, so I will just ignore the request for being
           silly */
	return(CORBA_OBJECT_NIL);
}

CORBA_ExceptionDef
impl_CORBA_StructDef_create_exception(impl_POA_CORBA_StructDef * servant,
				      CORBA_RepositoryId id,
				      CORBA_Identifier name,
				      CORBA_VersionSpec version,
				      CORBA_StructMemberSeq * members,
				      CORBA_Environment * ev)
{
	/* Structs can only contain structs, unions and
           enums. Unfortunately, the spec doesn't specify any
           exceptions, so I will just ignore the request for being
           silly */
	return(CORBA_OBJECT_NIL);
}

static CORBA_UnionDef impl_CORBA_UnionDef__create(PortableServer_POA poa,
						  CORBA_RepositoryId id,
						  CORBA_Identifier name,
						  CORBA_VersionSpec version,
						  CORBA_IDLType discriminator_type,
						  CORBA_UnionMemberSeq * members,
						  CORBA_Container defined_in,
						  CORBA_Environment * ev)
{
	CORBA_UnionDef retval;
	impl_POA_CORBA_UnionDef *newservant;
	PortableServer_ObjectId *objid;

	newservant = g_new0(impl_POA_CORBA_UnionDef, 1);
	newservant->servant.vepv = &impl_CORBA_UnionDef_vepv;
	newservant->poa = poa;

	newservant->attr_members= *members;
	newservant->attr_discriminator_type_def=discriminator_type;
	
	newservant->attr_def_kind=CORBA_dk_Union;
	newservant->attr_id=CORBA_string_dup(id);
	newservant->attr_name=CORBA_string_dup(name);
	newservant->attr_version=CORBA_string_dup(version);
	newservant->attr_defined_in=CORBA_Object_duplicate(defined_in, ev);

	newservant->contents=NULL;
	
	POA_CORBA_UnionDef__init((PortableServer_Servant) newservant, ev);
	objid = PortableServer_POA_activate_object(poa, newservant, ev);
	CORBA_free(objid);
	retval = PortableServer_POA_servant_to_reference(poa, newservant, ev);

	return retval;
}

/* You shouldn't call this routine directly without first deactivating the servant... */
static void impl_CORBA_UnionDef__destroy(impl_POA_CORBA_UnionDef * servant, CORBA_Environment * ev)
{

	g_slist_free(servant->contents);
	
	POA_CORBA_UnionDef__fini((PortableServer_Servant) servant, ev);
	g_free(servant);
}

CORBA_TypeCode
impl_CORBA_UnionDef__get_discriminator_type(impl_POA_CORBA_UnionDef * servant,
					    CORBA_Environment * ev)
{
	CORBA_TypeCode retval;

	return retval;
}

CORBA_IDLType
impl_CORBA_UnionDef__get_discriminator_type_def(impl_POA_CORBA_UnionDef * servant,
						CORBA_Environment * ev)
{
	return(CORBA_Object_duplicate(servant->attr_discriminator_type_def, ev));
}

void impl_CORBA_UnionDef__set_discriminator_type_def(impl_POA_CORBA_UnionDef * servant,
						     CORBA_IDLType value,
						  CORBA_Environment * ev)
{
}

CORBA_UnionMemberSeq *
 impl_CORBA_UnionDef__get_members(impl_POA_CORBA_UnionDef * servant,
				  CORBA_Environment * ev)
{
	CORBA_UnionMemberSeq *retval;

	return retval;
}

void impl_CORBA_UnionDef__set_members(impl_POA_CORBA_UnionDef * servant,
				      CORBA_UnionMemberSeq * value,
				      CORBA_Environment * ev)
{
}

CORBA_DefinitionKind
impl_CORBA_UnionDef__get_def_kind(impl_POA_CORBA_UnionDef * servant,
				  CORBA_Environment * ev)
{
	return(servant->attr_def_kind);
}

void impl_CORBA_UnionDef_destroy(impl_POA_CORBA_UnionDef * servant,
				 CORBA_Environment * ev)
{
}

CORBA_RepositoryId
impl_CORBA_UnionDef__get_id(impl_POA_CORBA_UnionDef * servant,
			    CORBA_Environment * ev)
{
	return(CORBA_string_dup(servant->attr_id));
}

void impl_CORBA_UnionDef__set_id(impl_POA_CORBA_UnionDef * servant,
				 CORBA_RepositoryId value,
				 CORBA_Environment * ev)
{
}

CORBA_Identifier
impl_CORBA_UnionDef__get_name(impl_POA_CORBA_UnionDef * servant,
			      CORBA_Environment * ev)
{
	return(CORBA_string_dup(servant->attr_name));
}

void impl_CORBA_UnionDef__set_name(impl_POA_CORBA_UnionDef * servant,
				   CORBA_Identifier value,
				   CORBA_Environment * ev)
{
}

CORBA_VersionSpec
impl_CORBA_UnionDef__get_version(impl_POA_CORBA_UnionDef * servant,
				 CORBA_Environment * ev)
{
	return(CORBA_string_dup(servant->attr_version));
}

void impl_CORBA_UnionDef__set_version(impl_POA_CORBA_UnionDef * servant,
				      CORBA_VersionSpec value,
				      CORBA_Environment * ev)
{
}

CORBA_Container
impl_CORBA_UnionDef__get_defined_in(impl_POA_CORBA_UnionDef * servant,
				    CORBA_Environment * ev)
{
	return(CORBA_Object_duplicate(servant->attr_defined_in, ev));
}

CORBA_ScopedName
impl_CORBA_UnionDef__get_absolute_name(impl_POA_CORBA_UnionDef * servant,
				       CORBA_Environment * ev)
{
	CORBA_ScopedName retval;

	return retval;
}

CORBA_Repository
impl_CORBA_UnionDef__get_containing_repository(impl_POA_CORBA_UnionDef * servant,
					       CORBA_Environment * ev)
{
	return(CORBA_Object_duplicate(repo, ev));
}

CORBA_Contained_Description *
 impl_CORBA_UnionDef_describe(impl_POA_CORBA_UnionDef * servant,
			      CORBA_Environment * ev)
{
	CORBA_Contained_Description *retval;

	return retval;
}

void impl_CORBA_UnionDef_move(impl_POA_CORBA_UnionDef * servant,
			      CORBA_Container new_container,
			      CORBA_Identifier new_name,
			      CORBA_VersionSpec new_version,
			      CORBA_Environment * ev)
{
}

CORBA_TypeCode
impl_CORBA_UnionDef__get_type(impl_POA_CORBA_UnionDef * servant,
			      CORBA_Environment * ev)
{
	CORBA_TypeCode retval;

	return retval;
}

CORBA_Contained
impl_CORBA_UnionDef_lookup(impl_POA_CORBA_UnionDef * servant,
			   CORBA_ScopedName search_name,
			   CORBA_Environment * ev)
{
	CORBA_Contained retval;

	return retval;
}

CORBA_ContainedSeq *
 impl_CORBA_UnionDef_contents(impl_POA_CORBA_UnionDef * servant,
			      CORBA_DefinitionKind limit_type,
			      CORBA_boolean exclude_inherited,
			      CORBA_Environment * ev)
{
	CORBA_ContainedSeq *retval;

	return retval;
}

CORBA_ContainedSeq *
 impl_CORBA_UnionDef_lookup_name(impl_POA_CORBA_UnionDef * servant,
				 CORBA_Identifier search_name,
				 CORBA_long levels_to_search,
				 CORBA_DefinitionKind limit_type,
				 CORBA_boolean exclude_inherited,
				 CORBA_Environment * ev)
{
	CORBA_ContainedSeq *retval;

	return retval;
}

CORBA_Container_DescriptionSeq *
 impl_CORBA_UnionDef_describe_contents(impl_POA_CORBA_UnionDef * servant,
				       CORBA_DefinitionKind limit_type,
				       CORBA_boolean exclude_inherited,
				       CORBA_long max_returned_objs,
				       CORBA_Environment * ev)
{
	CORBA_Container_DescriptionSeq *retval;

	return retval;
}

CORBA_ModuleDef
impl_CORBA_UnionDef_create_module(impl_POA_CORBA_UnionDef * servant,
				  CORBA_RepositoryId id,
				  CORBA_Identifier name,
				  CORBA_VersionSpec version,
				  CORBA_Environment * ev)
{
	/* Unions can only contain structs, unions and
           enums. Unfortunately, the spec doesn't specify any
           exceptions, so I will just ignore the request for being
           silly */
	return(CORBA_OBJECT_NIL);
}

CORBA_ConstantDef
impl_CORBA_UnionDef_create_constant(impl_POA_CORBA_UnionDef * servant,
				    CORBA_RepositoryId id,
				    CORBA_Identifier name,
				    CORBA_VersionSpec version,
				    CORBA_IDLType type,
				    CORBA_any * value,
				    CORBA_Environment * ev)
{
	/* Unions can only contain structs, unions and
           enums. Unfortunately, the spec doesn't specify any
           exceptions, so I will just ignore the request for being
           silly */
	return(CORBA_OBJECT_NIL);
}

CORBA_StructDef
impl_CORBA_UnionDef_create_struct(impl_POA_CORBA_UnionDef * servant,
				  CORBA_RepositoryId id,
				  CORBA_Identifier name,
				  CORBA_VersionSpec version,
				  CORBA_StructMemberSeq * members,
				  CORBA_Environment * ev)
{
	CORBA_StructDef retval;

	retval=impl_CORBA_StructDef__create(servant->poa, id, name, version, members, PortableServer_POA_servant_to_reference(servant->poa, servant, ev), ev);
	/* Add to contents list */
	g_slist_append(servant->contents, retval);
	
	return(CORBA_Object_duplicate(retval, ev));
}

CORBA_UnionDef
impl_CORBA_UnionDef_create_union(impl_POA_CORBA_UnionDef * servant,
				 CORBA_RepositoryId id,
				 CORBA_Identifier name,
				 CORBA_VersionSpec version,
				 CORBA_IDLType discriminator_type,
				 CORBA_UnionMemberSeq * members,
				 CORBA_Environment * ev)
{
	CORBA_UnionDef retval;
	
	retval=impl_CORBA_UnionDef__create(servant->poa, id, name, version, discriminator_type, members, PortableServer_POA_servant_to_reference(servant->poa, servant, ev), ev);
	/* Add to contents list */
	g_slist_append(servant->contents, retval);
	
	return(CORBA_Object_duplicate(retval, ev));
}

CORBA_EnumDef
impl_CORBA_UnionDef_create_enum(impl_POA_CORBA_UnionDef * servant,
				CORBA_RepositoryId id,
				CORBA_Identifier name,
				CORBA_VersionSpec version,
				CORBA_EnumMemberSeq * members,
				CORBA_Environment * ev)
{
	CORBA_EnumDef retval;

	retval=impl_CORBA_EnumDef__create(servant->poa, id, name, version, members, PortableServer_POA_servant_to_reference(servant->poa, servant, ev), ev);
	/* Add to contents list */
	g_slist_append(servant->contents, retval);
	
	return(CORBA_Object_duplicate(retval, ev));
}

CORBA_AliasDef
impl_CORBA_UnionDef_create_alias(impl_POA_CORBA_UnionDef * servant,
				 CORBA_RepositoryId id,
				 CORBA_Identifier name,
				 CORBA_VersionSpec version,
				 CORBA_IDLType original_type,
				 CORBA_Environment * ev)
{
	/* Unions can only contain structs, unions and
           enums. Unfortunately, the spec doesn't specify any
           exceptions, so I will just ignore the request for being
           silly */
	return(CORBA_OBJECT_NIL);
}

CORBA_InterfaceDef
impl_CORBA_UnionDef_create_interface(impl_POA_CORBA_UnionDef * servant,
				     CORBA_RepositoryId id,
				     CORBA_Identifier name,
				     CORBA_VersionSpec version,
				 CORBA_InterfaceDefSeq * base_interfaces,
				     CORBA_Environment * ev)
{
	/* Unions can only contain structs, unions and
           enums. Unfortunately, the spec doesn't specify any
           exceptions, so I will just ignore the request for being
           silly */
	return(CORBA_OBJECT_NIL);
}

CORBA_ExceptionDef
impl_CORBA_UnionDef_create_exception(impl_POA_CORBA_UnionDef * servant,
				     CORBA_RepositoryId id,
				     CORBA_Identifier name,
				     CORBA_VersionSpec version,
				     CORBA_StructMemberSeq * members,
				     CORBA_Environment * ev)
{
	/* Unions can only contain structs, unions and
           enums. Unfortunately, the spec doesn't specify any
           exceptions, so I will just ignore the request for being
           silly */
	return(CORBA_OBJECT_NIL);
}

static CORBA_EnumDef impl_CORBA_EnumDef__create(PortableServer_POA poa,
						CORBA_RepositoryId id,
						CORBA_Identifier name,
						CORBA_VersionSpec version,
						CORBA_EnumMemberSeq * members,
						CORBA_Container defined_in,
						CORBA_Environment * ev)
{
	CORBA_EnumDef retval;
	impl_POA_CORBA_EnumDef *newservant;
	PortableServer_ObjectId *objid;

	newservant = g_new0(impl_POA_CORBA_EnumDef, 1);
	newservant->servant.vepv = &impl_CORBA_EnumDef_vepv;
	newservant->poa = poa;

	newservant->attr_members= *members;
	
	newservant->attr_def_kind=CORBA_dk_Enum;
	newservant->attr_id=CORBA_string_dup(id);
	newservant->attr_name=CORBA_string_dup(name);
	newservant->attr_version=CORBA_string_dup(version);
	newservant->attr_defined_in=CORBA_Object_duplicate(defined_in, ev);

	POA_CORBA_EnumDef__init((PortableServer_Servant) newservant, ev);
	objid = PortableServer_POA_activate_object(poa, newservant, ev);
	CORBA_free(objid);
	retval = PortableServer_POA_servant_to_reference(poa, newservant, ev);

	return retval;
}

/* You shouldn't call this routine directly without first deactivating the servant... */
static void impl_CORBA_EnumDef__destroy(impl_POA_CORBA_EnumDef * servant, CORBA_Environment * ev)
{

	POA_CORBA_EnumDef__fini((PortableServer_Servant) servant, ev);
	g_free(servant);
}

CORBA_EnumMemberSeq *
 impl_CORBA_EnumDef__get_members(impl_POA_CORBA_EnumDef * servant,
				 CORBA_Environment * ev)
{
	CORBA_EnumMemberSeq *retval;

	return retval;
}

void impl_CORBA_EnumDef__set_members(impl_POA_CORBA_EnumDef * servant,
				     CORBA_EnumMemberSeq * value,
				     CORBA_Environment * ev)
{
}

CORBA_DefinitionKind
impl_CORBA_EnumDef__get_def_kind(impl_POA_CORBA_EnumDef * servant,
				 CORBA_Environment * ev)
{
	return(servant->attr_def_kind);
}

void impl_CORBA_EnumDef_destroy(impl_POA_CORBA_EnumDef * servant,
				CORBA_Environment * ev)
{
}

CORBA_RepositoryId
impl_CORBA_EnumDef__get_id(impl_POA_CORBA_EnumDef * servant,
			   CORBA_Environment * ev)
{
	return(CORBA_string_dup(servant->attr_id));
}

void impl_CORBA_EnumDef__set_id(impl_POA_CORBA_EnumDef * servant,
				CORBA_RepositoryId value,
				CORBA_Environment * ev)
{
}

CORBA_Identifier
impl_CORBA_EnumDef__get_name(impl_POA_CORBA_EnumDef * servant,
			     CORBA_Environment * ev)
{
	return(CORBA_string_dup(servant->attr_name));
}

void impl_CORBA_EnumDef__set_name(impl_POA_CORBA_EnumDef * servant,
				  CORBA_Identifier value,
				  CORBA_Environment * ev)
{
}

CORBA_VersionSpec
impl_CORBA_EnumDef__get_version(impl_POA_CORBA_EnumDef * servant,
				CORBA_Environment * ev)
{
	return(CORBA_string_dup(servant->attr_version));
}

void impl_CORBA_EnumDef__set_version(impl_POA_CORBA_EnumDef * servant,
				     CORBA_VersionSpec value,
				     CORBA_Environment * ev)
{
}

CORBA_Container
impl_CORBA_EnumDef__get_defined_in(impl_POA_CORBA_EnumDef * servant,
				   CORBA_Environment * ev)
{
	return(CORBA_Object_duplicate(servant->attr_defined_in, ev));
}

CORBA_ScopedName
impl_CORBA_EnumDef__get_absolute_name(impl_POA_CORBA_EnumDef * servant,
				      CORBA_Environment * ev)
{
	CORBA_ScopedName retval;

	return retval;
}

CORBA_Repository
impl_CORBA_EnumDef__get_containing_repository(impl_POA_CORBA_EnumDef * servant,
					      CORBA_Environment * ev)
{
	return(CORBA_Object_duplicate(repo, ev));
}

CORBA_Contained_Description *
 impl_CORBA_EnumDef_describe(impl_POA_CORBA_EnumDef * servant,
			     CORBA_Environment * ev)
{
	CORBA_Contained_Description *retval;

	return retval;
}

void impl_CORBA_EnumDef_move(impl_POA_CORBA_EnumDef * servant,
			     CORBA_Container new_container,
			     CORBA_Identifier new_name,
			     CORBA_VersionSpec new_version,
			     CORBA_Environment * ev)
{
}

CORBA_TypeCode
impl_CORBA_EnumDef__get_type(impl_POA_CORBA_EnumDef * servant,
			     CORBA_Environment * ev)
{
	CORBA_TypeCode retval;

	return retval;
}

static CORBA_AliasDef impl_CORBA_AliasDef__create(PortableServer_POA poa, 
	CORBA_RepositoryId id, CORBA_Identifier name,
	CORBA_VersionSpec version, CORBA_IDLType original_type,
	CORBA_Container defined_in, CORBA_Environment * ev)
{
	CORBA_AliasDef retval;
	impl_POA_CORBA_AliasDef *newservant;
	PortableServer_ObjectId *objid;

	newservant = g_new0(impl_POA_CORBA_AliasDef, 1);
	newservant->servant.vepv = &impl_CORBA_AliasDef_vepv;
	newservant->poa = poa;

	newservant->attr_def_kind=CORBA_dk_Alias;
	newservant->attr_id=CORBA_string_dup(id);
	newservant->attr_name=CORBA_string_dup(name);
	newservant->attr_version=CORBA_string_dup(version);
	newservant->attr_original_type_def=CORBA_Object_duplicate(original_type, ev);
	newservant->attr_defined_in=CORBA_Object_duplicate(defined_in, ev);

	POA_CORBA_AliasDef__init((PortableServer_Servant) newservant, ev);
	objid = PortableServer_POA_activate_object(poa, newservant, ev);
	CORBA_free(objid);
	retval = PortableServer_POA_servant_to_reference(poa, newservant, ev);

	return retval;
}

/* You shouldn't call this routine directly without first deactivating the servant... */
static void impl_CORBA_AliasDef__destroy(impl_POA_CORBA_AliasDef * servant, CORBA_Environment * ev)
{

	POA_CORBA_AliasDef__fini((PortableServer_Servant) servant, ev);
	g_free(servant);
}

CORBA_IDLType
impl_CORBA_AliasDef__get_original_type_def(impl_POA_CORBA_AliasDef * servant,
					   CORBA_Environment * ev)
{
	return(CORBA_Object_duplicate(servant->attr_original_type_def, ev));
}

void impl_CORBA_AliasDef__set_original_type_def(impl_POA_CORBA_AliasDef * servant,
						CORBA_IDLType value,
						CORBA_Environment * ev)
{
}

CORBA_DefinitionKind
impl_CORBA_AliasDef__get_def_kind(impl_POA_CORBA_AliasDef * servant,
				  CORBA_Environment * ev)
{
	return(servant->attr_def_kind);
}

void impl_CORBA_AliasDef_destroy(impl_POA_CORBA_AliasDef * servant,
				 CORBA_Environment * ev)
{
}

CORBA_RepositoryId
impl_CORBA_AliasDef__get_id(impl_POA_CORBA_AliasDef * servant,
			    CORBA_Environment * ev)
{
	return(CORBA_string_dup(servant->attr_id));
}

void impl_CORBA_AliasDef__set_id(impl_POA_CORBA_AliasDef * servant,
				 CORBA_RepositoryId value,
				 CORBA_Environment * ev)
{
}

CORBA_Identifier
impl_CORBA_AliasDef__get_name(impl_POA_CORBA_AliasDef * servant,
			      CORBA_Environment * ev)
{
	return(CORBA_string_dup(servant->attr_name));
}

void impl_CORBA_AliasDef__set_name(impl_POA_CORBA_AliasDef * servant,
				   CORBA_Identifier value,
				   CORBA_Environment * ev)
{
}

CORBA_VersionSpec
impl_CORBA_AliasDef__get_version(impl_POA_CORBA_AliasDef * servant,
				 CORBA_Environment * ev)
{
	return(CORBA_string_dup(servant->attr_version));
}

void impl_CORBA_AliasDef__set_version(impl_POA_CORBA_AliasDef * servant,
				      CORBA_VersionSpec value,
				      CORBA_Environment * ev)
{
}

CORBA_Container
impl_CORBA_AliasDef__get_defined_in(impl_POA_CORBA_AliasDef * servant,
				    CORBA_Environment * ev)
{
	return(CORBA_Object_duplicate(servant->attr_defined_in, ev));
}

CORBA_ScopedName
impl_CORBA_AliasDef__get_absolute_name(impl_POA_CORBA_AliasDef * servant,
				       CORBA_Environment * ev)
{
	CORBA_ScopedName retval;

	return retval;
}

CORBA_Repository
impl_CORBA_AliasDef__get_containing_repository(impl_POA_CORBA_AliasDef * servant,
					       CORBA_Environment * ev)
{
	return(CORBA_Object_duplicate(repo, ev));
}

CORBA_Contained_Description *
 impl_CORBA_AliasDef_describe(impl_POA_CORBA_AliasDef * servant,
			      CORBA_Environment * ev)
{
	CORBA_Contained_Description *retval;

	return retval;
}

void impl_CORBA_AliasDef_move(impl_POA_CORBA_AliasDef * servant,
			      CORBA_Container new_container,
			      CORBA_Identifier new_name,
			      CORBA_VersionSpec new_version,
			      CORBA_Environment * ev)
{
}

CORBA_TypeCode
impl_CORBA_AliasDef__get_type(impl_POA_CORBA_AliasDef * servant,
			      CORBA_Environment * ev)
{
	CORBA_TypeCode retval;

	return retval;
}

static CORBA_PrimitiveDef impl_CORBA_PrimitiveDef__create(PortableServer_POA poa,
							  CORBA_PrimitiveKind kind,
							  CORBA_Environment * ev)
{
	CORBA_PrimitiveDef retval;
	impl_POA_CORBA_PrimitiveDef *newservant;
	PortableServer_ObjectId *objid;

	newservant = g_new0(impl_POA_CORBA_PrimitiveDef, 1);
	newservant->servant.vepv = &impl_CORBA_PrimitiveDef_vepv;
	newservant->poa = poa;

	newservant->attr_kind=kind;
	newservant->attr_def_kind=CORBA_dk_Primitive;

	POA_CORBA_PrimitiveDef__init((PortableServer_Servant) newservant, ev);
	objid = PortableServer_POA_activate_object(poa, newservant, ev);
	CORBA_free(objid);
	retval = PortableServer_POA_servant_to_reference(poa, newservant, ev);

	return retval;
}

/* You shouldn't call this routine directly without first deactivating the servant... */
static void impl_CORBA_PrimitiveDef__destroy(impl_POA_CORBA_PrimitiveDef * servant, CORBA_Environment * ev)
{

	POA_CORBA_PrimitiveDef__fini((PortableServer_Servant) servant, ev);
	g_free(servant);
}

CORBA_PrimitiveKind
impl_CORBA_PrimitiveDef__get_kind(impl_POA_CORBA_PrimitiveDef * servant,
				  CORBA_Environment * ev)
{
	return(servant->attr_kind);
}

CORBA_DefinitionKind
impl_CORBA_PrimitiveDef__get_def_kind(impl_POA_CORBA_PrimitiveDef * servant,
				      CORBA_Environment * ev)
{
	return(servant->attr_def_kind);
}

void impl_CORBA_PrimitiveDef_destroy(impl_POA_CORBA_PrimitiveDef * servant,
				     CORBA_Environment * ev)
{
}

CORBA_TypeCode
impl_CORBA_PrimitiveDef__get_type(impl_POA_CORBA_PrimitiveDef * servant,
				  CORBA_Environment * ev)
{
	CORBA_TypeCode retval;

	return retval;
}

static CORBA_StringDef impl_CORBA_StringDef__create(PortableServer_POA poa, CORBA_Environment * ev)
{
	CORBA_StringDef retval;
	impl_POA_CORBA_StringDef *newservant;
	PortableServer_ObjectId *objid;

	newservant = g_new0(impl_POA_CORBA_StringDef, 1);
	newservant->servant.vepv = &impl_CORBA_StringDef_vepv;
	newservant->poa = poa;

	newservant->attr_def_kind=CORBA_dk_String;

	POA_CORBA_StringDef__init((PortableServer_Servant) newservant, ev);
	objid = PortableServer_POA_activate_object(poa, newservant, ev);
	CORBA_free(objid);
	retval = PortableServer_POA_servant_to_reference(poa, newservant, ev);

	return retval;
}

/* You shouldn't call this routine directly without first deactivating the servant... */
static void impl_CORBA_StringDef__destroy(impl_POA_CORBA_StringDef * servant, CORBA_Environment * ev)
{

	POA_CORBA_StringDef__fini((PortableServer_Servant) servant, ev);
	g_free(servant);
}

CORBA_unsigned_long
impl_CORBA_StringDef__get_bound(impl_POA_CORBA_StringDef * servant,
				CORBA_Environment * ev)
{
	return(servant->attr_bound);
}

void impl_CORBA_StringDef__set_bound(impl_POA_CORBA_StringDef * servant,
				     CORBA_unsigned_long value,
				     CORBA_Environment * ev)
{
}

CORBA_DefinitionKind
impl_CORBA_StringDef__get_def_kind(impl_POA_CORBA_StringDef * servant,
				   CORBA_Environment * ev)
{
	return(servant->attr_def_kind);
}

void impl_CORBA_StringDef_destroy(impl_POA_CORBA_StringDef * servant,
				  CORBA_Environment * ev)
{
}

CORBA_TypeCode
impl_CORBA_StringDef__get_type(impl_POA_CORBA_StringDef * servant,
			       CORBA_Environment * ev)
{
	CORBA_TypeCode retval;

	return retval;
}

static CORBA_WstringDef impl_CORBA_WstringDef__create(PortableServer_POA poa, CORBA_Environment * ev)
{
	CORBA_WstringDef retval;
	impl_POA_CORBA_WstringDef *newservant;
	PortableServer_ObjectId *objid;

	newservant = g_new0(impl_POA_CORBA_WstringDef, 1);
	newservant->servant.vepv = &impl_CORBA_WstringDef_vepv;
	newservant->poa = poa;

	newservant->attr_def_kind=CORBA_dk_Wstring;

	POA_CORBA_WstringDef__init((PortableServer_Servant) newservant, ev);
	objid = PortableServer_POA_activate_object(poa, newservant, ev);
	CORBA_free(objid);
	retval = PortableServer_POA_servant_to_reference(poa, newservant, ev);

	return retval;
}

/* You shouldn't call this routine directly without first deactivating the servant... */
static void impl_CORBA_WstringDef__destroy(impl_POA_CORBA_WstringDef * servant, CORBA_Environment * ev)
{

	POA_CORBA_WstringDef__fini((PortableServer_Servant) servant, ev);
	g_free(servant);
}

CORBA_unsigned_long
impl_CORBA_WstringDef__get_bound(impl_POA_CORBA_WstringDef * servant,
				 CORBA_Environment * ev)
{
	return(servant->attr_bound);
}

void impl_CORBA_WstringDef__set_bound(impl_POA_CORBA_WstringDef * servant,
				      CORBA_unsigned_long value,
				      CORBA_Environment * ev)
{
}

CORBA_DefinitionKind
impl_CORBA_WstringDef__get_def_kind(impl_POA_CORBA_WstringDef * servant,
				    CORBA_Environment * ev)
{
	return(servant->attr_def_kind);
}

void impl_CORBA_WstringDef_destroy(impl_POA_CORBA_WstringDef * servant,
				   CORBA_Environment * ev)
{
}

CORBA_TypeCode
impl_CORBA_WstringDef__get_type(impl_POA_CORBA_WstringDef * servant,
				CORBA_Environment * ev)
{
	CORBA_TypeCode retval;

	return retval;
}

static CORBA_FixedDef impl_CORBA_FixedDef__create(PortableServer_POA poa, CORBA_Environment * ev)
{
	CORBA_FixedDef retval;
	impl_POA_CORBA_FixedDef *newservant;
	PortableServer_ObjectId *objid;

	newservant = g_new0(impl_POA_CORBA_FixedDef, 1);
	newservant->servant.vepv = &impl_CORBA_FixedDef_vepv;
	newservant->poa = poa;

	newservant->attr_def_kind=CORBA_dk_Fixed;

	POA_CORBA_FixedDef__init((PortableServer_Servant) newservant, ev);
	objid = PortableServer_POA_activate_object(poa, newservant, ev);
	CORBA_free(objid);
	retval = PortableServer_POA_servant_to_reference(poa, newservant, ev);

	return retval;
}

/* You shouldn't call this routine directly without first deactivating the servant... */
static void impl_CORBA_FixedDef__destroy(impl_POA_CORBA_FixedDef * servant, CORBA_Environment * ev)
{

	POA_CORBA_FixedDef__fini((PortableServer_Servant) servant, ev);
	g_free(servant);
}

CORBA_unsigned_short
impl_CORBA_FixedDef__get_digits(impl_POA_CORBA_FixedDef * servant,
				CORBA_Environment * ev)
{
	return(servant->attr_digits);
}

void impl_CORBA_FixedDef__set_digits(impl_POA_CORBA_FixedDef * servant,
				     CORBA_unsigned_short value,
				     CORBA_Environment * ev)
{
}

CORBA_short
impl_CORBA_FixedDef__get_scale(impl_POA_CORBA_FixedDef * servant,
			       CORBA_Environment * ev)
{
	return(servant->attr_scale);
}

void impl_CORBA_FixedDef__set_scale(impl_POA_CORBA_FixedDef * servant,
				    CORBA_short value,
				    CORBA_Environment * ev)
{
}

CORBA_DefinitionKind
impl_CORBA_FixedDef__get_def_kind(impl_POA_CORBA_FixedDef * servant,
				  CORBA_Environment * ev)
{
	return(servant->attr_def_kind);
}

void impl_CORBA_FixedDef_destroy(impl_POA_CORBA_FixedDef * servant,
				 CORBA_Environment * ev)
{
}

CORBA_TypeCode
impl_CORBA_FixedDef__get_type(impl_POA_CORBA_FixedDef * servant,
			      CORBA_Environment * ev)
{
	CORBA_TypeCode retval;

	return retval;
}

static CORBA_SequenceDef impl_CORBA_SequenceDef__create(PortableServer_POA poa, CORBA_Environment * ev)
{
	CORBA_SequenceDef retval;
	impl_POA_CORBA_SequenceDef *newservant;
	PortableServer_ObjectId *objid;

	newservant = g_new0(impl_POA_CORBA_SequenceDef, 1);
	newservant->servant.vepv = &impl_CORBA_SequenceDef_vepv;
	newservant->poa = poa;

	newservant->attr_def_kind=CORBA_dk_Sequence;

	POA_CORBA_SequenceDef__init((PortableServer_Servant) newservant, ev);
	objid = PortableServer_POA_activate_object(poa, newservant, ev);
	CORBA_free(objid);
	retval = PortableServer_POA_servant_to_reference(poa, newservant, ev);

	return retval;
}

/* You shouldn't call this routine directly without first deactivating the servant... */
static void impl_CORBA_SequenceDef__destroy(impl_POA_CORBA_SequenceDef * servant, CORBA_Environment * ev)
{

	POA_CORBA_SequenceDef__fini((PortableServer_Servant) servant, ev);
	g_free(servant);
}

CORBA_unsigned_long
impl_CORBA_SequenceDef__get_bound(impl_POA_CORBA_SequenceDef * servant,
				  CORBA_Environment * ev)
{
	return(servant->attr_bound);
}

void impl_CORBA_SequenceDef__set_bound(impl_POA_CORBA_SequenceDef * servant,
				       CORBA_unsigned_long value,
				       CORBA_Environment * ev)
{
}

CORBA_TypeCode
impl_CORBA_SequenceDef__get_element_type(impl_POA_CORBA_SequenceDef * servant,
					 CORBA_Environment * ev)
{
	CORBA_TypeCode retval;

	return retval;
}

CORBA_IDLType
impl_CORBA_SequenceDef__get_element_type_def(impl_POA_CORBA_SequenceDef * servant,
					     CORBA_Environment * ev)
{
	return(CORBA_Object_duplicate(servant->attr_element_type_def, ev));
}

void impl_CORBA_SequenceDef__set_element_type_def(impl_POA_CORBA_SequenceDef * servant,
						  CORBA_IDLType value,
						  CORBA_Environment * ev)
{
}

CORBA_DefinitionKind
impl_CORBA_SequenceDef__get_def_kind(impl_POA_CORBA_SequenceDef * servant,
				     CORBA_Environment * ev)
{
	return(servant->attr_def_kind);
}

void impl_CORBA_SequenceDef_destroy(impl_POA_CORBA_SequenceDef * servant,
				    CORBA_Environment * ev)
{
}

CORBA_TypeCode
impl_CORBA_SequenceDef__get_type(impl_POA_CORBA_SequenceDef * servant,
				 CORBA_Environment * ev)
{
	CORBA_TypeCode retval;

	return retval;
}

static CORBA_ArrayDef impl_CORBA_ArrayDef__create(PortableServer_POA poa, CORBA_Environment * ev)
{
	CORBA_ArrayDef retval;
	impl_POA_CORBA_ArrayDef *newservant;
	PortableServer_ObjectId *objid;

	newservant = g_new0(impl_POA_CORBA_ArrayDef, 1);
	newservant->servant.vepv = &impl_CORBA_ArrayDef_vepv;
	newservant->poa = poa;

	newservant->attr_def_kind=CORBA_dk_Array;

	POA_CORBA_ArrayDef__init((PortableServer_Servant) newservant, ev);
	objid = PortableServer_POA_activate_object(poa, newservant, ev);
	CORBA_free(objid);
	retval = PortableServer_POA_servant_to_reference(poa, newservant, ev);

	return retval;
}

/* You shouldn't call this routine directly without first deactivating the servant... */
static void impl_CORBA_ArrayDef__destroy(impl_POA_CORBA_ArrayDef * servant, CORBA_Environment * ev)
{

	POA_CORBA_ArrayDef__fini((PortableServer_Servant) servant, ev);
	g_free(servant);
}

CORBA_unsigned_long
impl_CORBA_ArrayDef__get_length(impl_POA_CORBA_ArrayDef * servant,
				CORBA_Environment * ev)
{
	return(servant->attr_length);
}

void impl_CORBA_ArrayDef__set_length(impl_POA_CORBA_ArrayDef * servant,
				     CORBA_unsigned_long value,
				     CORBA_Environment * ev)
{
}

CORBA_TypeCode
impl_CORBA_ArrayDef__get_element_type(impl_POA_CORBA_ArrayDef * servant,
				      CORBA_Environment * ev)
{
	CORBA_TypeCode retval;

	return retval;
}

CORBA_IDLType
impl_CORBA_ArrayDef__get_element_type_def(impl_POA_CORBA_ArrayDef * servant,
					  CORBA_Environment * ev)
{
	return(CORBA_Object_duplicate(servant->attr_element_type_def, ev));
}

void impl_CORBA_ArrayDef__set_element_type_def(impl_POA_CORBA_ArrayDef * servant,
					       CORBA_IDLType value,
					       CORBA_Environment * ev)
{
}

CORBA_DefinitionKind
impl_CORBA_ArrayDef__get_def_kind(impl_POA_CORBA_ArrayDef * servant,
				  CORBA_Environment * ev)
{
	return(servant->attr_def_kind);
}

void impl_CORBA_ArrayDef_destroy(impl_POA_CORBA_ArrayDef * servant,
				 CORBA_Environment * ev)
{
}

CORBA_TypeCode
impl_CORBA_ArrayDef__get_type(impl_POA_CORBA_ArrayDef * servant,
			      CORBA_Environment * ev)
{
	CORBA_TypeCode retval;

	return retval;
}

static CORBA_ExceptionDef impl_CORBA_ExceptionDef__create(PortableServer_POA poa,
	CORBA_RepositoryId id, CORBA_Identifier name,
	CORBA_VersionSpec version, CORBA_StructMemberSeq * members,
	CORBA_Container defined_in, CORBA_Environment * ev)
{
	CORBA_ExceptionDef retval;
	impl_POA_CORBA_ExceptionDef *newservant;
	PortableServer_ObjectId *objid;

	newservant = g_new0(impl_POA_CORBA_ExceptionDef, 1);
	newservant->servant.vepv = &impl_CORBA_ExceptionDef_vepv;
	newservant->poa = poa;

	newservant->attr_def_kind=CORBA_dk_Exception;
	newservant->attr_id=CORBA_string_dup(id);
	newservant->attr_name=CORBA_string_dup(name);
	newservant->attr_version=CORBA_string_dup(version);
	newservant->attr_defined_in=CORBA_Object_duplicate(defined_in, ev);
	newservant->attr_members=members;

	newservant->contents=NULL;
	
	POA_CORBA_ExceptionDef__init((PortableServer_Servant) newservant, ev);
	objid = PortableServer_POA_activate_object(poa, newservant, ev);
	CORBA_free(objid);
	retval = PortableServer_POA_servant_to_reference(poa, newservant, ev);

	return retval;
}

/* You shouldn't call this routine directly without first deactivating the servant... */
static void impl_CORBA_ExceptionDef__destroy(impl_POA_CORBA_ExceptionDef * servant, CORBA_Environment * ev)
{
	g_slist_free(servant->contents);

	POA_CORBA_ExceptionDef__fini((PortableServer_Servant) servant, ev);
	g_free(servant);
}

CORBA_TypeCode
impl_CORBA_ExceptionDef__get_type(impl_POA_CORBA_ExceptionDef * servant,
				  CORBA_Environment * ev)
{
	CORBA_TypeCode retval;

	return retval;
}

CORBA_StructMemberSeq *
 impl_CORBA_ExceptionDef__get_members(impl_POA_CORBA_ExceptionDef * servant,
				      CORBA_Environment * ev)
{
	CORBA_StructMemberSeq *retval;

	return retval;
}

void impl_CORBA_ExceptionDef__set_members(impl_POA_CORBA_ExceptionDef * servant,
					  CORBA_StructMemberSeq * value,
					  CORBA_Environment * ev)
{
}

CORBA_DefinitionKind
impl_CORBA_ExceptionDef__get_def_kind(impl_POA_CORBA_ExceptionDef * servant,
				      CORBA_Environment * ev)
{
	return(servant->attr_def_kind);
}

void impl_CORBA_ExceptionDef_destroy(impl_POA_CORBA_ExceptionDef * servant,
				     CORBA_Environment * ev)
{
}

CORBA_RepositoryId
impl_CORBA_ExceptionDef__get_id(impl_POA_CORBA_ExceptionDef * servant,
				CORBA_Environment * ev)
{
	return(CORBA_string_dup(servant->attr_id));
}

void impl_CORBA_ExceptionDef__set_id(impl_POA_CORBA_ExceptionDef * servant,
				     CORBA_RepositoryId value,
				     CORBA_Environment * ev)
{
}

CORBA_Identifier
impl_CORBA_ExceptionDef__get_name(impl_POA_CORBA_ExceptionDef * servant,
				  CORBA_Environment * ev)
{
	return(CORBA_string_dup(servant->attr_name));
}

void impl_CORBA_ExceptionDef__set_name(impl_POA_CORBA_ExceptionDef * servant,
				       CORBA_Identifier value,
				       CORBA_Environment * ev)
{
}

CORBA_VersionSpec
impl_CORBA_ExceptionDef__get_version(impl_POA_CORBA_ExceptionDef * servant,
				     CORBA_Environment * ev)
{
	return(CORBA_string_dup(servant->attr_version));
}

void impl_CORBA_ExceptionDef__set_version(impl_POA_CORBA_ExceptionDef * servant,
					  CORBA_VersionSpec value,
					  CORBA_Environment * ev)
{
}

CORBA_Container
impl_CORBA_ExceptionDef__get_defined_in(impl_POA_CORBA_ExceptionDef * servant,
					CORBA_Environment * ev)
{
	return(CORBA_Object_duplicate(servant->attr_defined_in, ev));
}

CORBA_ScopedName
impl_CORBA_ExceptionDef__get_absolute_name(impl_POA_CORBA_ExceptionDef * servant,
					   CORBA_Environment * ev)
{
	CORBA_ScopedName retval;

	return retval;
}

CORBA_Repository
impl_CORBA_ExceptionDef__get_containing_repository(impl_POA_CORBA_ExceptionDef * servant,
						   CORBA_Environment * ev)
{
	return(CORBA_Object_duplicate(repo, ev));
}

CORBA_Contained_Description *
 impl_CORBA_ExceptionDef_describe(impl_POA_CORBA_ExceptionDef * servant,
				  CORBA_Environment * ev)
{
	CORBA_Contained_Description *retval;

	return retval;
}

void impl_CORBA_ExceptionDef_move(impl_POA_CORBA_ExceptionDef * servant,
				  CORBA_Container new_container,
				  CORBA_Identifier new_name,
				  CORBA_VersionSpec new_version,
				  CORBA_Environment * ev)
{
}

CORBA_Contained
impl_CORBA_ExceptionDef_lookup(impl_POA_CORBA_ExceptionDef * servant,
			       CORBA_ScopedName search_name,
			       CORBA_Environment * ev)
{
	CORBA_Contained retval;

	return retval;
}

CORBA_ContainedSeq *
 impl_CORBA_ExceptionDef_contents(impl_POA_CORBA_ExceptionDef * servant,
				  CORBA_DefinitionKind limit_type,
				  CORBA_boolean exclude_inherited,
				  CORBA_Environment * ev)
{
	CORBA_ContainedSeq *retval;

	return retval;
}

CORBA_ContainedSeq *
 impl_CORBA_ExceptionDef_lookup_name(impl_POA_CORBA_ExceptionDef * servant,
				     CORBA_Identifier search_name,
				     CORBA_long levels_to_search,
				     CORBA_DefinitionKind limit_type,
				     CORBA_boolean exclude_inherited,
				     CORBA_Environment * ev)
{
	CORBA_ContainedSeq *retval;

	return retval;
}

CORBA_Container_DescriptionSeq *
 impl_CORBA_ExceptionDef_describe_contents(impl_POA_CORBA_ExceptionDef * servant,
					 CORBA_DefinitionKind limit_type,
					 CORBA_boolean exclude_inherited,
					   CORBA_long max_returned_objs,
					   CORBA_Environment * ev)
{
	CORBA_Container_DescriptionSeq *retval;

	return retval;
}

CORBA_ModuleDef
impl_CORBA_ExceptionDef_create_module(impl_POA_CORBA_ExceptionDef * servant,
				      CORBA_RepositoryId id,
				      CORBA_Identifier name,
				      CORBA_VersionSpec version,
				      CORBA_Environment * ev)
{
	/* Exceptions can only contain structs, unions and
           enums. Unfortunately, the spec doesn't specify any
           exceptions, so I will just ignore the request for being
           silly */
	return(CORBA_OBJECT_NIL);
}

CORBA_ConstantDef
impl_CORBA_ExceptionDef_create_constant(impl_POA_CORBA_ExceptionDef * servant,
					CORBA_RepositoryId id,
					CORBA_Identifier name,
					CORBA_VersionSpec version,
					CORBA_IDLType type,
					CORBA_any * value,
					CORBA_Environment * ev)
{
	/* Exceptions can only contain structs, unions and
           enums. Unfortunately, the spec doesn't specify any
           exceptions, so I will just ignore the request for being
           silly */
	return(CORBA_OBJECT_NIL);
}

CORBA_StructDef
impl_CORBA_ExceptionDef_create_struct(impl_POA_CORBA_ExceptionDef * servant,
				      CORBA_RepositoryId id,
				      CORBA_Identifier name,
				      CORBA_VersionSpec version,
				      CORBA_StructMemberSeq * members,
				      CORBA_Environment * ev)
{
	CORBA_StructDef retval;

	retval=impl_CORBA_StructDef__create(servant->poa, id, name, version, members, PortableServer_POA_servant_to_reference(servant->poa, servant, ev), ev);
	/* Add to contents list */
	g_slist_append(servant->contents, retval);
	
	return(CORBA_Object_duplicate(retval, ev));
}

CORBA_UnionDef
impl_CORBA_ExceptionDef_create_union(impl_POA_CORBA_ExceptionDef * servant,
				     CORBA_RepositoryId id,
				     CORBA_Identifier name,
				     CORBA_VersionSpec version,
				     CORBA_IDLType discriminator_type,
				     CORBA_UnionMemberSeq * members,
				     CORBA_Environment * ev)
{
	CORBA_UnionDef retval;

	retval=impl_CORBA_UnionDef__create(servant->poa, id, name, version, discriminator_type, members, PortableServer_POA_servant_to_reference(servant->poa, servant, ev), ev);
	/* Add to contents list */
	g_slist_append(servant->contents, retval);
	
	return(CORBA_Object_duplicate(retval, ev));
}

CORBA_EnumDef
impl_CORBA_ExceptionDef_create_enum(impl_POA_CORBA_ExceptionDef * servant,
				    CORBA_RepositoryId id,
				    CORBA_Identifier name,
				    CORBA_VersionSpec version,
				    CORBA_EnumMemberSeq * members,
				    CORBA_Environment * ev)
{
	CORBA_EnumDef retval;

	retval=impl_CORBA_EnumDef__create(servant->poa, id, name, version, members, PortableServer_POA_servant_to_reference(servant->poa, servant, ev), ev);
	/* Add to contents list */
	g_slist_append(servant->contents, retval);
	
	return(CORBA_Object_duplicate(retval, ev));
}

CORBA_AliasDef
impl_CORBA_ExceptionDef_create_alias(impl_POA_CORBA_ExceptionDef * servant,
				     CORBA_RepositoryId id,
				     CORBA_Identifier name,
				     CORBA_VersionSpec version,
				     CORBA_IDLType original_type,
				     CORBA_Environment * ev)
{
	/* Exceptions can only contain structs, unions and
           enums. Unfortunately, the spec doesn't specify any
           exceptions, so I will just ignore the request for being
           silly */
	return(CORBA_OBJECT_NIL);
}

CORBA_InterfaceDef
impl_CORBA_ExceptionDef_create_interface(impl_POA_CORBA_ExceptionDef * servant,
					 CORBA_RepositoryId id,
					 CORBA_Identifier name,
					 CORBA_VersionSpec version,
				 CORBA_InterfaceDefSeq * base_interfaces,
					 CORBA_Environment * ev)
{
	/* Exceptions can only contain structs, unions and
           enums. Unfortunately, the spec doesn't specify any
           exceptions, so I will just ignore the request for being
           silly */
	return(CORBA_OBJECT_NIL);
}

CORBA_ExceptionDef
impl_CORBA_ExceptionDef_create_exception(impl_POA_CORBA_ExceptionDef * servant,
					 CORBA_RepositoryId id,
					 CORBA_Identifier name,
					 CORBA_VersionSpec version,
					 CORBA_StructMemberSeq * members,
					 CORBA_Environment * ev)
{
	/* Exceptions can only contain structs, unions and
           enums. Unfortunately, the spec doesn't specify any
           exceptions, so I will just ignore the request for being
           silly */
	return(CORBA_OBJECT_NIL);
}

static CORBA_AttributeDef impl_CORBA_AttributeDef__create(PortableServer_POA poa,
							  CORBA_RepositoryId id,
							  CORBA_Identifier name,
							  CORBA_VersionSpec version,
							  CORBA_IDLType type,
							  CORBA_AttributeMode mode,
							  CORBA_Container defined_in,
							  CORBA_Environment * ev)
{
	CORBA_AttributeDef retval;
	impl_POA_CORBA_AttributeDef *newservant;
	PortableServer_ObjectId *objid;

	newservant = g_new0(impl_POA_CORBA_AttributeDef, 1);
	newservant->servant.vepv = &impl_CORBA_AttributeDef_vepv;
	newservant->poa = poa;

	newservant->attr_type_def=CORBA_Object_duplicate(type, ev);
	newservant->attr_mode=mode;

	newservant->attr_def_kind=CORBA_dk_Attribute;
	newservant->attr_id=CORBA_string_dup(id);
	newservant->attr_name=CORBA_string_dup(name);
	newservant->attr_version=CORBA_string_dup(version);
	newservant->attr_defined_in=CORBA_Object_duplicate(defined_in, ev);

	POA_CORBA_AttributeDef__init((PortableServer_Servant) newservant, ev);
	objid = PortableServer_POA_activate_object(poa, newservant, ev);
	CORBA_free(objid);
	retval = PortableServer_POA_servant_to_reference(poa, newservant, ev);

	return retval;
}

/* You shouldn't call this routine directly without first deactivating the servant... */
static void impl_CORBA_AttributeDef__destroy(impl_POA_CORBA_AttributeDef * servant, CORBA_Environment * ev)
{

	POA_CORBA_AttributeDef__fini((PortableServer_Servant) servant, ev);
	g_free(servant);
}

CORBA_TypeCode
impl_CORBA_AttributeDef__get_type(impl_POA_CORBA_AttributeDef * servant,
				  CORBA_Environment * ev)
{
	CORBA_TypeCode retval;

	return retval;
}

CORBA_IDLType
impl_CORBA_AttributeDef__get_type_def(impl_POA_CORBA_AttributeDef * servant,
				      CORBA_Environment * ev)
{
	return(CORBA_Object_duplicate(servant->attr_type_def, ev));
}

void impl_CORBA_AttributeDef__set_type_def(impl_POA_CORBA_AttributeDef * servant,
					   CORBA_IDLType value,
					   CORBA_Environment * ev)
{
}

CORBA_AttributeMode
impl_CORBA_AttributeDef__get_mode(impl_POA_CORBA_AttributeDef * servant,
				  CORBA_Environment * ev)
{
	return(servant->attr_mode);
}

void impl_CORBA_AttributeDef__set_mode(impl_POA_CORBA_AttributeDef * servant,
				       CORBA_AttributeMode value,
				       CORBA_Environment * ev)
{
}

CORBA_DefinitionKind
impl_CORBA_AttributeDef__get_def_kind(impl_POA_CORBA_AttributeDef * servant,
				      CORBA_Environment * ev)
{
	return(servant->attr_def_kind);
}

void impl_CORBA_AttributeDef_destroy(impl_POA_CORBA_AttributeDef * servant,
				     CORBA_Environment * ev)
{
}

CORBA_RepositoryId
impl_CORBA_AttributeDef__get_id(impl_POA_CORBA_AttributeDef * servant,
				CORBA_Environment * ev)
{
	return(CORBA_string_dup(servant->attr_id));
}

void impl_CORBA_AttributeDef__set_id(impl_POA_CORBA_AttributeDef * servant,
				     CORBA_RepositoryId value,
				     CORBA_Environment * ev)
{
}

CORBA_Identifier
impl_CORBA_AttributeDef__get_name(impl_POA_CORBA_AttributeDef * servant,
				  CORBA_Environment * ev)
{
	return(CORBA_string_dup(servant->attr_name));
}

void impl_CORBA_AttributeDef__set_name(impl_POA_CORBA_AttributeDef * servant,
				       CORBA_Identifier value,
				       CORBA_Environment * ev)
{
}

CORBA_VersionSpec
impl_CORBA_AttributeDef__get_version(impl_POA_CORBA_AttributeDef * servant,
				     CORBA_Environment * ev)
{
	return(CORBA_string_dup(servant->attr_version));
}

void impl_CORBA_AttributeDef__set_version(impl_POA_CORBA_AttributeDef * servant,
					  CORBA_VersionSpec value,
					  CORBA_Environment * ev)
{
}

CORBA_Container
impl_CORBA_AttributeDef__get_defined_in(impl_POA_CORBA_AttributeDef * servant,
					CORBA_Environment * ev)
{
	return(CORBA_Object_duplicate(servant->attr_defined_in, ev));
}

CORBA_ScopedName
impl_CORBA_AttributeDef__get_absolute_name(impl_POA_CORBA_AttributeDef * servant,
					   CORBA_Environment * ev)
{
	CORBA_ScopedName retval;

	return retval;
}

CORBA_Repository
impl_CORBA_AttributeDef__get_containing_repository(impl_POA_CORBA_AttributeDef * servant,
						   CORBA_Environment * ev)
{
	return(CORBA_Object_duplicate(repo, ev));
}

CORBA_Contained_Description *
 impl_CORBA_AttributeDef_describe(impl_POA_CORBA_AttributeDef * servant,
				  CORBA_Environment * ev)
{
	CORBA_Contained_Description *retval;

	return retval;
}

void impl_CORBA_AttributeDef_move(impl_POA_CORBA_AttributeDef * servant,
				  CORBA_Container new_container,
				  CORBA_Identifier new_name,
				  CORBA_VersionSpec new_version,
				  CORBA_Environment * ev)
{
}

static CORBA_OperationDef impl_CORBA_OperationDef__create(PortableServer_POA poa, CORBA_Environment * ev)
{
	CORBA_OperationDef retval;
	impl_POA_CORBA_OperationDef *newservant;
	PortableServer_ObjectId *objid;

	newservant = g_new0(impl_POA_CORBA_OperationDef, 1);
	newservant->servant.vepv = &impl_CORBA_OperationDef_vepv;
	newservant->poa = poa;

	newservant->attr_def_kind=CORBA_dk_Operation;

	POA_CORBA_OperationDef__init((PortableServer_Servant) newservant, ev);
	objid = PortableServer_POA_activate_object(poa, newservant, ev);
	CORBA_free(objid);
	retval = PortableServer_POA_servant_to_reference(poa, newservant, ev);

	return retval;
}

/* You shouldn't call this routine directly without first deactivating the servant... */
static void impl_CORBA_OperationDef__destroy(impl_POA_CORBA_OperationDef * servant, CORBA_Environment * ev)
{

	POA_CORBA_OperationDef__fini((PortableServer_Servant) servant, ev);
	g_free(servant);
}

CORBA_TypeCode
impl_CORBA_OperationDef__get_result(impl_POA_CORBA_OperationDef * servant,
				    CORBA_Environment * ev)
{
	CORBA_TypeCode retval;

	return retval;
}

CORBA_IDLType
impl_CORBA_OperationDef__get_result_def(impl_POA_CORBA_OperationDef * servant,
					CORBA_Environment * ev)
{
	return(CORBA_Object_duplicate(servant->attr_result_def, ev));
}

void impl_CORBA_OperationDef__set_result_def(impl_POA_CORBA_OperationDef * servant,
					     CORBA_IDLType value,
					     CORBA_Environment * ev)
{
}

CORBA_ParDescriptionSeq *
 impl_CORBA_OperationDef__get_params(impl_POA_CORBA_OperationDef * servant,
				     CORBA_Environment * ev)
{
	CORBA_ParDescriptionSeq *retval;

	return retval;
}

void impl_CORBA_OperationDef__set_params(impl_POA_CORBA_OperationDef * servant,
					 CORBA_ParDescriptionSeq * value,
					 CORBA_Environment * ev)
{
}

CORBA_OperationMode
impl_CORBA_OperationDef__get_mode(impl_POA_CORBA_OperationDef * servant,
				  CORBA_Environment * ev)
{
	return(servant->attr_mode);
}

void impl_CORBA_OperationDef__set_mode(impl_POA_CORBA_OperationDef * servant,
				       CORBA_OperationMode value,
				       CORBA_Environment * ev)
{
}

CORBA_ContextIdSeq *
 impl_CORBA_OperationDef__get_contexts(impl_POA_CORBA_OperationDef * servant,
				       CORBA_Environment * ev)
{
	CORBA_ContextIdSeq *retval;

	return retval;
}

void impl_CORBA_OperationDef__set_contexts(impl_POA_CORBA_OperationDef * servant,
					   CORBA_ContextIdSeq * value,
					   CORBA_Environment * ev)
{
}

CORBA_ExceptionDefSeq *
 impl_CORBA_OperationDef__get_exceptions(impl_POA_CORBA_OperationDef * servant,
					 CORBA_Environment * ev)
{
	CORBA_ExceptionDefSeq *retval;

	return retval;
}

void impl_CORBA_OperationDef__set_exceptions(impl_POA_CORBA_OperationDef * servant,
					   CORBA_ExceptionDefSeq * value,
					     CORBA_Environment * ev)
{
}

CORBA_DefinitionKind
impl_CORBA_OperationDef__get_def_kind(impl_POA_CORBA_OperationDef * servant,
				      CORBA_Environment * ev)
{
	return(servant->attr_def_kind);
}

void impl_CORBA_OperationDef_destroy(impl_POA_CORBA_OperationDef * servant,
				     CORBA_Environment * ev)
{
}

CORBA_RepositoryId
impl_CORBA_OperationDef__get_id(impl_POA_CORBA_OperationDef * servant,
				CORBA_Environment * ev)
{
	return(CORBA_string_dup(servant->attr_id));
}

void impl_CORBA_OperationDef__set_id(impl_POA_CORBA_OperationDef * servant,
				     CORBA_RepositoryId value,
				     CORBA_Environment * ev)
{
}

CORBA_Identifier
impl_CORBA_OperationDef__get_name(impl_POA_CORBA_OperationDef * servant,
				  CORBA_Environment * ev)
{
	return(CORBA_string_dup(servant->attr_name));
}

void impl_CORBA_OperationDef__set_name(impl_POA_CORBA_OperationDef * servant,
				       CORBA_Identifier value,
				       CORBA_Environment * ev)
{
}

CORBA_VersionSpec
impl_CORBA_OperationDef__get_version(impl_POA_CORBA_OperationDef * servant,
				     CORBA_Environment * ev)
{
	return(CORBA_string_dup(servant->attr_version));
}

void impl_CORBA_OperationDef__set_version(impl_POA_CORBA_OperationDef * servant,
					  CORBA_VersionSpec value,
					  CORBA_Environment * ev)
{
}

CORBA_Container
impl_CORBA_OperationDef__get_defined_in(impl_POA_CORBA_OperationDef * servant,
					CORBA_Environment * ev)
{
	return(CORBA_Object_duplicate(servant->attr_defined_in, ev));
}

CORBA_ScopedName
impl_CORBA_OperationDef__get_absolute_name(impl_POA_CORBA_OperationDef * servant,
					   CORBA_Environment * ev)
{
	CORBA_ScopedName retval;

	return retval;
}

CORBA_Repository
impl_CORBA_OperationDef__get_containing_repository(impl_POA_CORBA_OperationDef * servant,
						   CORBA_Environment * ev)
{
	return(CORBA_Object_duplicate(repo, ev));
}

CORBA_Contained_Description *
 impl_CORBA_OperationDef_describe(impl_POA_CORBA_OperationDef * servant,
				  CORBA_Environment * ev)
{
	CORBA_Contained_Description *retval;

	return retval;
}

void impl_CORBA_OperationDef_move(impl_POA_CORBA_OperationDef * servant,
				  CORBA_Container new_container,
				  CORBA_Identifier new_name,
				  CORBA_VersionSpec new_version,
				  CORBA_Environment * ev)
{
}

static CORBA_InterfaceDef impl_CORBA_InterfaceDef__create(PortableServer_POA poa,
	CORBA_RepositoryId id, CORBA_Identifier name,
	CORBA_VersionSpec version, CORBA_InterfaceDefSeq *base_interfaces,
	CORBA_Container defined_in, CORBA_Environment * ev)
{
	CORBA_InterfaceDef retval;
	impl_POA_CORBA_InterfaceDef *newservant;
	PortableServer_ObjectId *objid;

	newservant = g_new0(impl_POA_CORBA_InterfaceDef, 1);
	newservant->servant.vepv = &impl_CORBA_InterfaceDef_vepv;
	newservant->poa = poa;

	newservant->attr_def_kind=CORBA_dk_Interface;
	newservant->contents=NULL;

	newservant->attr_id=CORBA_string_dup(id);
	newservant->attr_name=CORBA_string_dup(name);
	newservant->attr_version=CORBA_string_dup(version);
	newservant->attr_base_interfaces=base_interfaces;
	newservant->attr_defined_in=CORBA_Object_duplicate(defined_in, ev);

	POA_CORBA_InterfaceDef__init((PortableServer_Servant) newservant, ev);
	objid = PortableServer_POA_activate_object(poa, newservant, ev);
	CORBA_free(objid);
	retval = PortableServer_POA_servant_to_reference(poa, newservant, ev);

	return retval;
}

/* You shouldn't call this routine directly without first deactivating the servant... */
static void impl_CORBA_InterfaceDef__destroy(impl_POA_CORBA_InterfaceDef * servant, CORBA_Environment * ev)
{

	POA_CORBA_InterfaceDef__fini((PortableServer_Servant) servant, ev);
	g_free(servant);
}

CORBA_InterfaceDefSeq *
 impl_CORBA_InterfaceDef__get_base_interfaces(impl_POA_CORBA_InterfaceDef * servant,
					      CORBA_Environment * ev)
{
	CORBA_InterfaceDefSeq *retval;

	return retval;
}

void impl_CORBA_InterfaceDef__set_base_interfaces(impl_POA_CORBA_InterfaceDef * servant,
					   CORBA_InterfaceDefSeq * value,
						  CORBA_Environment * ev)
{
}

CORBA_boolean
impl_CORBA_InterfaceDef_is_a(impl_POA_CORBA_InterfaceDef * servant,
			     CORBA_RepositoryId interface_id,
			     CORBA_Environment * ev)
{
	CORBA_boolean retval;

	return retval;
}

CORBA_InterfaceDef_FullInterfaceDescription *
 impl_CORBA_InterfaceDef_describe_interface(impl_POA_CORBA_InterfaceDef * servant,
					    CORBA_Environment * ev)
{
	CORBA_InterfaceDef_FullInterfaceDescription *retval;

	return retval;
}

CORBA_AttributeDef
impl_CORBA_InterfaceDef_create_attribute(impl_POA_CORBA_InterfaceDef * servant,
					 CORBA_RepositoryId id,
					 CORBA_Identifier name,
					 CORBA_VersionSpec version,
					 CORBA_IDLType type,
					 CORBA_AttributeMode mode,
					 CORBA_Environment * ev)
{
	CORBA_AttributeDef retval;

	retval=impl_CORBA_AttributeDef__create(servant->poa, id, name, version, type, mode, PortableServer_POA_servant_to_reference(servant->poa, servant, ev), ev);
	/* Add to contents list */
	g_slist_append(servant->contents, retval);
	
	return(CORBA_Object_duplicate(retval, ev));
}

CORBA_OperationDef
impl_CORBA_InterfaceDef_create_operation(impl_POA_CORBA_InterfaceDef * servant,
					 CORBA_RepositoryId id,
					 CORBA_Identifier name,
					 CORBA_VersionSpec version,
					 CORBA_IDLType result,
					 CORBA_OperationMode mode,
					 CORBA_ParDescriptionSeq * params,
					 CORBA_ExceptionDefSeq * exceptions,
					 CORBA_ContextIdSeq * contexts,
					 CORBA_Environment * ev)
{
	CORBA_OperationDef retval;

	return retval;
}

CORBA_DefinitionKind
impl_CORBA_InterfaceDef__get_def_kind(impl_POA_CORBA_InterfaceDef * servant,
				      CORBA_Environment * ev)
{
	return(servant->attr_def_kind);
}

void impl_CORBA_InterfaceDef_destroy(impl_POA_CORBA_InterfaceDef * servant,
				     CORBA_Environment * ev)
{
}

CORBA_Contained
impl_CORBA_InterfaceDef_lookup(impl_POA_CORBA_InterfaceDef * servant,
			       CORBA_ScopedName search_name,
			       CORBA_Environment * ev)
{
	CORBA_Contained retval;

	return retval;
}

CORBA_ContainedSeq *
 impl_CORBA_InterfaceDef_contents(impl_POA_CORBA_InterfaceDef * servant,
				  CORBA_DefinitionKind limit_type,
				  CORBA_boolean exclude_inherited,
				  CORBA_Environment * ev)
{
	CORBA_ContainedSeq *retval;

	return retval;
}

CORBA_ContainedSeq *
 impl_CORBA_InterfaceDef_lookup_name(impl_POA_CORBA_InterfaceDef * servant,
				     CORBA_Identifier search_name,
				     CORBA_long levels_to_search,
				     CORBA_DefinitionKind limit_type,
				     CORBA_boolean exclude_inherited,
				     CORBA_Environment * ev)
{
	CORBA_ContainedSeq *retval;

	return retval;
}

CORBA_Container_DescriptionSeq *
 impl_CORBA_InterfaceDef_describe_contents(impl_POA_CORBA_InterfaceDef * servant,
					 CORBA_DefinitionKind limit_type,
					 CORBA_boolean exclude_inherited,
					   CORBA_long max_returned_objs,
					   CORBA_Environment * ev)
{
	CORBA_Container_DescriptionSeq *retval;

	return retval;
}

CORBA_ModuleDef
impl_CORBA_InterfaceDef_create_module(impl_POA_CORBA_InterfaceDef * servant,
				      CORBA_RepositoryId id,
				      CORBA_Identifier name,
				      CORBA_VersionSpec version,
				      CORBA_Environment * ev)
{
	CORBA_ModuleDef retval;

	retval=impl_CORBA_ModuleDef__create(servant->poa, id, name, version, PortableServer_POA_servant_to_reference(servant->poa, servant, ev), ev);
	/* Add to contents list */
	g_slist_append(servant->contents, retval);
	
	return(CORBA_Object_duplicate(retval, ev));
}

CORBA_ConstantDef
impl_CORBA_InterfaceDef_create_constant(impl_POA_CORBA_InterfaceDef * servant,
					CORBA_RepositoryId id,
					CORBA_Identifier name,
					CORBA_VersionSpec version,
					CORBA_IDLType type,
					CORBA_any * value,
					CORBA_Environment * ev)
{
	CORBA_ConstantDef retval;

	retval=impl_CORBA_ConstantDef__create(servant->poa, id, name, version, type, value, PortableServer_POA_servant_to_reference(servant->poa, servant, ev), ev);
	/* Add to contents list */
	g_slist_append(servant->contents, retval);
	
	return(CORBA_Object_duplicate(retval, ev));
}

CORBA_StructDef
impl_CORBA_InterfaceDef_create_struct(impl_POA_CORBA_InterfaceDef * servant,
				      CORBA_RepositoryId id,
				      CORBA_Identifier name,
				      CORBA_VersionSpec version,
				      CORBA_StructMemberSeq * members,
				      CORBA_Environment * ev)
{
	CORBA_StructDef retval;

	retval=impl_CORBA_StructDef__create(servant->poa, id, name, version, members, PortableServer_POA_servant_to_reference(servant->poa, servant, ev), ev);
	/* Add to contents list */
	g_slist_append(servant->contents, retval);
	
	return(CORBA_Object_duplicate(retval, ev));
}

CORBA_UnionDef
impl_CORBA_InterfaceDef_create_union(impl_POA_CORBA_InterfaceDef * servant,
				     CORBA_RepositoryId id,
				     CORBA_Identifier name,
				     CORBA_VersionSpec version,
				     CORBA_IDLType discriminator_type,
				     CORBA_UnionMemberSeq * members,
				     CORBA_Environment * ev)
{
	CORBA_UnionDef retval;

	retval=impl_CORBA_UnionDef__create(servant->poa, id, name, version, discriminator_type, members, PortableServer_POA_servant_to_reference(servant->poa, servant, ev), ev);
	/* Add to contents list */
	g_slist_append(servant->contents, retval);
	
	return(CORBA_Object_duplicate(retval, ev));
}

CORBA_EnumDef
impl_CORBA_InterfaceDef_create_enum(impl_POA_CORBA_InterfaceDef * servant,
				    CORBA_RepositoryId id,
				    CORBA_Identifier name,
				    CORBA_VersionSpec version,
				    CORBA_EnumMemberSeq * members,
				    CORBA_Environment * ev)
{
	CORBA_EnumDef retval;

	retval=impl_CORBA_EnumDef__create(servant->poa, id, name, version, members, PortableServer_POA_servant_to_reference(servant->poa, servant, ev), ev);
	/* Add to contents list */
	g_slist_append(servant->contents, retval);
	
	return(CORBA_Object_duplicate(retval, ev));
}

CORBA_AliasDef
impl_CORBA_InterfaceDef_create_alias(impl_POA_CORBA_InterfaceDef * servant,
				     CORBA_RepositoryId id,
				     CORBA_Identifier name,
				     CORBA_VersionSpec version,
				     CORBA_IDLType original_type,
				     CORBA_Environment * ev)
{
	CORBA_AliasDef retval;

	retval=impl_CORBA_AliasDef__create(servant->poa, id, name, version, original_type, PortableServer_POA_servant_to_reference(servant->poa, servant, ev), ev);
	/* Add to contents list */
	g_slist_append(servant->contents, retval);
	
	return(CORBA_Object_duplicate(retval, ev));
}

CORBA_InterfaceDef
impl_CORBA_InterfaceDef_create_interface(impl_POA_CORBA_InterfaceDef * servant,
					 CORBA_RepositoryId id,
					 CORBA_Identifier name,
					 CORBA_VersionSpec version,
					 CORBA_InterfaceDefSeq * base_interfaces,
					 CORBA_Environment * ev)
{
	CORBA_InterfaceDef retval;

	retval=impl_CORBA_InterfaceDef__create(servant->poa, id, name, version, base_interfaces, PortableServer_POA_servant_to_reference(servant->poa, servant, ev), ev);
	/* Add to contents list */
	g_slist_append(servant->contents, retval);
	
	return(CORBA_Object_duplicate(retval, ev));
}

CORBA_ExceptionDef
impl_CORBA_InterfaceDef_create_exception(impl_POA_CORBA_InterfaceDef * servant,
					 CORBA_RepositoryId id,
					 CORBA_Identifier name,
					 CORBA_VersionSpec version,
					 CORBA_StructMemberSeq * members,
					 CORBA_Environment * ev)
{
	CORBA_ExceptionDef retval;

	retval=impl_CORBA_ExceptionDef__create(servant->poa, id, name, version, members, PortableServer_POA_servant_to_reference(servant->poa, servant, ev), ev);
	/* Add to contents list */
	g_slist_append(servant->contents, retval);
	
	return(CORBA_Object_duplicate(retval, ev));
}

CORBA_RepositoryId
impl_CORBA_InterfaceDef__get_id(impl_POA_CORBA_InterfaceDef * servant,
				CORBA_Environment * ev)
{
	return(CORBA_string_dup(servant->attr_id));
}

void impl_CORBA_InterfaceDef__set_id(impl_POA_CORBA_InterfaceDef * servant,
				     CORBA_RepositoryId value,
				     CORBA_Environment * ev)
{
}

CORBA_Identifier
impl_CORBA_InterfaceDef__get_name(impl_POA_CORBA_InterfaceDef * servant,
				  CORBA_Environment * ev)
{
	return(CORBA_string_dup(servant->attr_name));
}

void impl_CORBA_InterfaceDef__set_name(impl_POA_CORBA_InterfaceDef * servant,
				       CORBA_Identifier value,
				       CORBA_Environment * ev)
{
}

CORBA_VersionSpec
impl_CORBA_InterfaceDef__get_version(impl_POA_CORBA_InterfaceDef * servant,
				     CORBA_Environment * ev)
{
	return(CORBA_string_dup(servant->attr_version));
}

void impl_CORBA_InterfaceDef__set_version(impl_POA_CORBA_InterfaceDef * servant,
					  CORBA_VersionSpec value,
					  CORBA_Environment * ev)
{
}

CORBA_Container
impl_CORBA_InterfaceDef__get_defined_in(impl_POA_CORBA_InterfaceDef * servant,
					CORBA_Environment * ev)
{
	return(CORBA_Object_duplicate(servant->attr_defined_in, ev));
}

CORBA_ScopedName
impl_CORBA_InterfaceDef__get_absolute_name(impl_POA_CORBA_InterfaceDef * servant,
					   CORBA_Environment * ev)
{
	CORBA_ScopedName retval;

	return retval;
}

CORBA_Repository
impl_CORBA_InterfaceDef__get_containing_repository(impl_POA_CORBA_InterfaceDef * servant,
						   CORBA_Environment * ev)
{
	return(CORBA_Object_duplicate(repo, ev));
}

CORBA_Contained_Description *
 impl_CORBA_InterfaceDef_describe(impl_POA_CORBA_InterfaceDef * servant,
				  CORBA_Environment * ev)
{
	CORBA_Contained_Description *retval;

	return retval;
}

void impl_CORBA_InterfaceDef_move(impl_POA_CORBA_InterfaceDef * servant,
				  CORBA_Container new_container,
				  CORBA_Identifier new_name,
				  CORBA_VersionSpec new_version,
				  CORBA_Environment * ev)
{
}

CORBA_TypeCode
impl_CORBA_InterfaceDef__get_type(impl_POA_CORBA_InterfaceDef * servant,
				  CORBA_Environment * ev)
{
	CORBA_TypeCode retval;

	return retval;
}

int main(int argc, char **argv)
{
	PortableServer_POA poa;
	CORBA_Environment ev;
	char *retval;
	CORBA_ORB orb;

	CORBA_exception_init(&ev);
	orb = CORBA_ORB_init(&argc, argv, "orbit-local-orb", &ev);

	poa = (PortableServer_POA)CORBA_ORB_resolve_initial_references(orb, "RootPOA", &ev);
	PortableServer_POAManager_activate(PortableServer_POA__get_the_POAManager(poa, &ev), &ev);

	repo = impl_CORBA_Repository__create(poa, &ev);
	if(!repo) {
		g_print("Cannot get object reference for Interface Repository\n");
		exit(-1);
	}

	/* Create the primitive objects */
	prim_null = impl_CORBA_PrimitiveDef__create(poa, CORBA_pk_null, &ev);
	prim_void = impl_CORBA_PrimitiveDef__create(poa, CORBA_pk_void, &ev);
	prim_short = impl_CORBA_PrimitiveDef__create(poa, CORBA_pk_short, &ev);
	prim_long = impl_CORBA_PrimitiveDef__create(poa, CORBA_pk_long, &ev);
	prim_ushort = impl_CORBA_PrimitiveDef__create(poa, CORBA_pk_ushort, &ev);
	prim_ulong = impl_CORBA_PrimitiveDef__create(poa, CORBA_pk_ulong, &ev);
	prim_float = impl_CORBA_PrimitiveDef__create(poa, CORBA_pk_float, &ev);
	prim_double = impl_CORBA_PrimitiveDef__create(poa, CORBA_pk_double, &ev);
	prim_boolean = impl_CORBA_PrimitiveDef__create(poa, CORBA_pk_boolean, &ev);
	prim_char = impl_CORBA_PrimitiveDef__create(poa, CORBA_pk_char, &ev);
	prim_octet = impl_CORBA_PrimitiveDef__create(poa, CORBA_pk_octet, &ev);
	prim_any = impl_CORBA_PrimitiveDef__create(poa, CORBA_pk_any, &ev);
	prim_TypeCode = impl_CORBA_PrimitiveDef__create(poa, CORBA_pk_TypeCode, &ev);
	prim_Principal = impl_CORBA_PrimitiveDef__create(poa, CORBA_pk_Principal, &ev);
	prim_string = impl_CORBA_PrimitiveDef__create(poa, CORBA_pk_string, &ev);
	prim_objref = impl_CORBA_PrimitiveDef__create(poa, CORBA_pk_objref, &ev);
	prim_longlong = impl_CORBA_PrimitiveDef__create(poa, CORBA_pk_longlong, &ev);
	prim_ulonglong = impl_CORBA_PrimitiveDef__create(poa, CORBA_pk_ulonglong, &ev);
	prim_longdouble = impl_CORBA_PrimitiveDef__create(poa, CORBA_pk_longdouble, &ev);
	prim_wchar = impl_CORBA_PrimitiveDef__create(poa, CORBA_pk_wchar, &ev);
	prim_wstring = impl_CORBA_PrimitiveDef__create(poa, CORBA_pk_wstring, &ev);
	
	retval = CORBA_ORB_object_to_string(orb, repo, &ev);
	g_print("%s\n", retval);
	fflush(stdout);
	CORBA_free(retval);

	CORBA_ORB_run(orb, &ev);

	exit(0);
}
